/*
 * Decompiled with CFR 0.152.
 */
package com.jthomas.util;

import com.jthomas.util.GrayFilter;
import com.jthomas.util.ImageLabel;
import java.awt.Color;
import java.awt.Event;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.FilteredImageSource;
import java.net.URL;

public class ImageButton
extends ImageLabel {
    protected static final int defaultBorderWidth = 4;
    protected static final Color defaultBorderColor = new Color(160, 160, 160);
    protected Image grayImage;
    public int darkness = -5263441;
    private boolean mouseIsDown = false;

    public ImageButton() {
        this.setDefaults();
    }

    public ImageButton(String imageURLString) {
        super(imageURLString);
        this.setDefaults();
    }

    public ImageButton(URL imageURL) {
        super(imageURL);
        this.setDefaults();
    }

    public ImageButton(Image image) {
        super(image);
        this.setDefaults();
    }

    public void setBorderWidth(int borderWidth) {
        this.margin = borderWidth;
    }

    public int getBorderWidth() {
        return this.margin;
    }

    public void setBorderColor(Color borderColor) {
        this.marginColor = borderColor;
    }

    public Color getBorderColor() {
        return this.marginColor;
    }

    public void paint(Graphics g) {
        super.paint(g);
        if (this.grayImage == null) {
            this.createGrayImage(g);
        }
        this.drawBorder(true);
    }

    public boolean mouseDown(Event event, int x, int y) {
        this.mouseIsDown = true;
        Graphics g = this.getGraphics();
        if (this.explicitSize) {
            g.drawImage(this.grayImage, this.margin, this.margin, this.width - 2 * this.margin, this.height - 2 * this.margin, this);
        } else {
            g.drawImage(this.grayImage, this.margin, this.margin, this);
        }
        this.drawBorder(false);
        return true;
    }

    public boolean mouseUp(Event event, int x, int y) {
        this.mouseIsDown = false;
        if (this.contains(x, y)) {
            this.paint(this.getGraphics());
            event.id = 1001;
            event.arg = this.image;
            return this.action(event, event.arg);
        }
        return false;
    }

    public boolean action(Event event, Object arg) {
        this.debug("Clicked on button for " + this.imageString + ".");
        return false;
    }

    public boolean mouseExit(Event event, int x, int y) {
        if (this.mouseIsDown) {
            this.paint(this.getGraphics());
        }
        return true;
    }

    private void drawBorder(boolean isUp) {
        Graphics g = this.getGraphics();
        g.setColor(this.marginColor);
        int left = 0;
        int top = 0;
        int width = this.width;
        int height = this.height;
        int i = 0;
        while (i < this.margin) {
            g.draw3DRect(left, top, width, height, isUp);
            ++left;
            ++top;
            width -= 2;
            height -= 2;
            ++i;
        }
    }

    private void setDefaults() {
        this.margin = 4;
        this.marginColor = defaultBorderColor;
    }

    private void createGrayImage(Graphics g) {
        GrayFilter filter = new GrayFilter(this.darkness);
        FilteredImageSource producer = new FilteredImageSource(this.image.getSource(), filter);
        this.grayImage = this.createImage(producer);
        if (this.explicitSize) {
            g.drawImage(this.grayImage, this.margin, this.margin, this.width - 2 * this.margin, this.height - 2 * this.margin, this);
        } else {
            g.drawImage(this.grayImage, this.margin, this.margin, this);
        }
        super.paint(g);
    }
}

