/*
 * Decompiled with CFR 0.152.
 */
package starwave.util.regexp;

import java.io.FileInputStream;
import starwave.util.regexp.CharArrayState;
import starwave.util.regexp.Multi;
import starwave.util.regexp.RegexpCompiler;
import starwave.util.regexp.Result;
import starwave.util.regexp.State;
import starwave.util.regexp.StringState;
import starwave.util.regexp.SuccessRegexp;

public class Regexp {
    static final boolean debug = false;
    static Regexp success = new SuccessRegexp(null);
    Regexp next;
    Regexp prev;

    public static Regexp compile(String expr) {
        return Regexp.compile(expr, false);
    }

    public static Regexp compile(String expr, boolean mapCase) {
        return RegexpCompiler.compile(expr, mapCase);
    }

    Regexp(Regexp prev) {
        this.prev = prev;
        if (prev != null) {
            prev.next = this;
        }
    }

    Regexp advance(State state) {
        return this.next;
    }

    void backup(State state) {
        --state.offset;
    }

    int firstCharacter() {
        return -1;
    }

    Regexp makeMulti(int kind) {
        return new Multi(this.prev, this, kind);
    }

    protected boolean match(State state) {
        Regexp reg = this;
        int offset = state.offset;
        try {
            Regexp next;
            while ((next = reg.advance(state)) != null) {
                if (next == success) {
                    return true;
                }
                reg = next;
            }
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {}
        state.offset = offset;
        return false;
    }

    boolean canStar() {
        return true;
    }

    public Result match(String data, int offset) {
        StringState s = new StringState(data, offset);
        if (this.match(s)) {
            return new Result(s);
        }
        return null;
    }

    public Result match(char[] data, int offset, int length) {
        CharArrayState s = new CharArrayState(data, offset, length);
        if (this.match(s)) {
            return new Result(s);
        }
        return null;
    }

    public final Result searchForward(String data, int offset) {
        StringState state = new StringState(data, offset);
        return this.searchForward(state);
    }

    public final Result searchForward(char[] data, int offset, int length) {
        CharArrayState state = new CharArrayState(data, offset, length);
        return this.searchForward(state);
    }

    private final Result searchForward(State state) {
        int firstc = this.firstCharacter();
        if (firstc != -1) {
            int i;
            while ((i = state.indexOf(firstc, state.offset)) != -1) {
                state.offset = i;
                if (this.match(state)) {
                    return new Result(state);
                }
                state.offset = i + 1;
            }
        } else {
            int limit = state.getLimit();
            while (state.offset < limit) {
                if (this.match(state)) {
                    return new Result(state);
                }
                ++state.offset;
            }
        }
        return null;
    }

    public Result searchBackward(String data, int offset) {
        StringState state = new StringState(data, offset);
        return this.searchBackward(state);
    }

    public Result searchBackward(char[] data, int offset, int length) {
        CharArrayState state = new CharArrayState(data, offset, length);
        return this.searchBackward(state);
    }

    private final Result searchBackward(State state) {
        int firstc = this.firstCharacter();
        if (firstc != -1) {
            int i;
            while (--state.offset >= 0 && (i = state.lastIndexOf(firstc, state.offset)) != -1) {
                state.offset = i;
                if (!this.match(state)) continue;
                return new Result(state);
            }
        } else {
            int limit = state.getLimit();
            while (--state.offset >= 0) {
                if (!this.match(state)) continue;
                return new Result(state);
            }
        }
        return null;
    }

    public static void main(String[] args) throws Exception {
        FileInputStream fin = new FileInputStream(args[0]);
        byte[] bytes = new byte[fin.available()];
        if (fin.read(bytes) != bytes.length) {
            System.out.println("Huh?");
        }
        fin.close();
        String data = new String(bytes, 0);
        boolean reverse = false;
        boolean timeit = false;
        boolean mapCase = false;
        int arg = 1;
        while (args[arg].charAt(0) == '-') {
            if (args[arg].equals("-time")) {
                timeit = true;
            } else if (args[arg].equals("-reverse")) {
                reverse = true;
            } else if (args[arg].equals("-ignore")) {
                mapCase = true;
            } else {
                System.out.println("Unknown option: " + args[arg]);
            }
            ++arg;
        }
        Regexp reg = Regexp.compile(args[arg], mapCase);
        System.out.println("Processing " + args[arg] + " = " + reg.toString());
        ++arg;
        if (reg.firstCharacter() != -1) {
            System.out.println("First Character: " + new Character((char)reg.firstCharacter()));
        }
        if (timeit) {
            int count = 50;
            long start = System.currentTimeMillis();
            int i = 0;
            while (i < count) {
                if (reg.searchForward(data, 0) == null) break;
                ++i;
            }
            System.out.println(String.valueOf((float)(1000.0 * (double)count / (double)(System.currentTimeMillis() - start))) + " per second.");
        } else {
            Result r;
            int which = Integer.parseInt(args[arg]);
            int pos = 0;
            while ((r = reg.searchForward(data, pos)) != null) {
                pos = r.getMatchEnd(0);
                System.out.println("Match = " + r + " match " + which + " = " + r.getMatch(which));
            }
        }
    }

    public final String toString() {
        if (this.next != null && this.next != success) {
            return String.valueOf(this.toStringThis()) + this.next.toString();
        }
        return this.toStringThis();
    }

    public String toStringThis() {
        return this == success ? "<!>" : "";
    }
}

