/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import javax.swing.text.DefaultHighlighter;

public class Disassembler {
    Assembler asm;

    public Disassembler(Assembler obj) {
        this.asm = obj;
    }

    Disassembler() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void loadDisassembler() {
        this.asm.jTextAreaDisassembler.getHighlighter().removeAllHighlights();
        String s = this.asm.jTextAreaDisassembler.getText();
        String line = "";
        int selectIndex = 0;
        try {
            while (s.indexOf(":", selectIndex) != -1) {
                line = s.substring(s.indexOf(":", selectIndex) + 1, s.indexOf("\n", selectIndex) == -1 ? s.length() : s.indexOf("\n", selectIndex));
                selectIndex = line.length() + selectIndex + 2;
                if (!this.CRC8(line).equalsIgnoreCase("00")) {
                    this.asm.jTextAreaDisassembler.getHighlighter().addHighlight(selectIndex - line.length() - 2, selectIndex, new DefaultHighlighter.DefaultHighlightPainter(Color.RED));
                }
                if (!line.substring(6, 8).equalsIgnoreCase("00")) continue;
                for (int i = 0; i < line.substring(8, line.length() - 2).length() / 2; ++i) {
                    this.asm.matrix.memory[this.asm.engine.convertToNum((String)line.substring((int)2, (int)6)) + i] = this.asm.engine.convertToNum(line.substring(8 + i * 2, 10 + i * 2));
                }
            }
            this.disasemble();
        }
        catch (Exception e) {
            try {
                this.asm.jTextAreaDisassembler.getHighlighter().addHighlight(selectIndex - line.length(), selectIndex, new DefaultHighlighter.DefaultHighlightPainter(Color.RED));
            }
            catch (Exception exception) {
                // empty catch block
            }
            System.out.println(e);
        }
    }

    public void disasemble() {
        String s = "";
        String opcode = "";
        String temp = "";
        boolean gap = false;
        int bytes = 0;
        int tempAddr = 0;
        int j = 0;
        for (int i = 0; i < 65535; ++i) {
            if (this.asm.matrix.memory[i] != 0) {
                if (gap) {
                    gap = false;
                    s = s + "# ORG " + this.asm.engine.Dec2Hex(i) + "\n";
                }
                if ((bytes = this.asm.engine.getBytesFromMnemonics(opcode = this.asm.engine.S[this.asm.matrix.memory[i]])) == 1) {
                    s = s + "\t" + this.asm.engine.HexToMnemonic(this.asm.matrix.memory[i], 0, 0) + "\n";
                } else if (bytes == 2) {
                    s = s + "\t" + this.asm.engine.HexToMnemonic(this.asm.matrix.memory[i], this.asm.matrix.memory[i + 1], 0) + "\n";
                } else if (bytes == 3) {
                    tempAddr = this.asm.matrix.memory[i + 2] * 256 + this.asm.matrix.memory[i + 1] & 0xFFFF;
                    if (this.asm.matrix.memory[tempAddr] == 0) {
                        s = s + "\t" + this.asm.engine.HexToMnemonic(this.asm.matrix.memory[i], this.asm.matrix.memory[i + 1], this.asm.matrix.memory[i + 2]) + "\n";
                    } else {
                        temp = this.asm.engine.HexToMnemonic(this.asm.matrix.memory[i], this.asm.matrix.memory[i + 1], this.asm.matrix.memory[i + 2]);
                        temp = temp.substring(0, temp.length() - 4);
                        if (this.asm.matrix.label[tempAddr].equalsIgnoreCase("")) {
                            s = s + "\t" + temp + "LABEL" + j + "\n";
                            this.asm.matrix.label[tempAddr] = "LABEL" + j;
                            ++j;
                        } else {
                            s = s + "\t" + temp + this.asm.matrix.label[tempAddr] + "\n";
                        }
                    }
                }
                i = i + bytes - 1;
                continue;
            }
            gap = true;
        }
        for (int i = 0; i < this.asm.matrix.label.length; ++i) {
            if (this.asm.matrix.label[i].equalsIgnoreCase("")) continue;
            temp = "\t" + this.asm.engine.HexToMnemonicWithLabel(this.asm.matrix.memory[i], this.asm.matrix.memory[i + 1], this.asm.matrix.memory[i + 2]) + "\n";
            tempAddr = i + this.asm.engine.getBytesFromMnemonics(this.asm.engine.S[this.asm.matrix.memory[i]]);
            if (s.indexOf(temp = temp + "\t" + this.asm.engine.HexToMnemonicWithLabel(this.asm.matrix.memory[tempAddr], this.asm.matrix.memory[tempAddr + 1], this.asm.matrix.memory[tempAddr + 2]) + "\n") > 0) {
                String temp1 = s.substring(0, s.indexOf(temp));
                String temp2 = s.substring(s.indexOf(temp), s.length());
                s = temp1 + this.asm.matrix.label[i].toUpperCase() + ":" + temp2;
                continue;
            }
            s = s + "\n# " + this.asm.matrix.label[i].toUpperCase() + " EQU " + this.asm.engine.Dec2Hex(i);
        }
        this.asm.jTextAreaAssemblyLanguageEditor.setText(s);
    }

    public String saveDisassembler() {
        int lastnonZero = 256;
        String s = "";
        String temp = "";
        for (int i = 0; i <= 65535; i += 16) {
            int j;
            lastnonZero = 256;
            for (j = 0; j < 16; ++j) {
                if (this.asm.matrix.memory[i + j] == 0) continue;
                lastnonZero = j;
            }
            if (lastnonZero == 256) continue;
            temp = "10" + this.asm.engine.Dec2Hex(i) + "00";
            for (j = 0; j < 16; ++j) {
                temp = temp + this.asm.engine.Dec2Hex2digit(this.asm.matrix.memory[i + j]);
            }
            s = s + ":" + temp + this.CRC8(temp) + "\r\n";
            temp = "";
        }
        if (s.length() > 0) {
            s = s + ":00000001FF";
        }
        return s;
    }

    public String CRC8(String HEXVALUES) {
        String CRC = "00";
        int crc8 = 0;
        if (HEXVALUES == null) {
            return CRC;
        }
        if (HEXVALUES.length() % 2 != 0) {
            return CRC;
        }
        for (int i = 0; i < HEXVALUES.length() - 1; i += 2) {
            crc8 += this.asm.engine.Hex2Dec(HEXVALUES.substring(i, i + 2));
        }
        crc8 = 255 - (crc8 & 0xFF) + 1;
        return this.asm.engine.Dec2Hex2digit(crc8);
    }

    public static void main(String[] args) {
        Assembler asm = new Assembler();
        Disassembler dis = new Disassembler(asm);
        dis.loadDisassembler();
    }
}

