/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.PrintWriter;

public class Matrix {
    int beginAddress = 0;
    int stopAddress = 65535;
    int A;
    int B;
    int C;
    int D;
    int E;
    int F;
    int H;
    int L;
    int SP;
    int PC = 0;
    int D1;
    int SOD;
    int SDE;
    int SID;
    int R75;
    int R65;
    int R55;
    int MSE;
    int RR75;
    int M75;
    int M65;
    int M55;
    int IE;
    int INTR;
    int _INTA;
    int TRAP;
    int HOLD;
    int _HOLDA;
    int _RESETIN = 1;
    int RESETOUT;
    int IO_M;
    int _RD;
    int _WR;
    long clockCycleCounter;
    long instructionCounter;
    int temp = 0;
    int[] memory;
    int[] port;
    int select = 0;
    String[] label;
    String[][] preLabel;
    AssemblerEngine engine;
    Assembler o;

    public Matrix(Assembler o) {
        this.o = o;
        this.memory = new int[65536];
        this.port = new int[256];
        this.label = new String[65536];
        this.preLabel = new String[500][2];
        this.engine = new AssemblerEngine(this);
        for (int i = 0; i < 65536; ++i) {
            this.label[i] = "";
        }
    }

    public String comment(int i) {
        i = 7;
        switch (i) {
            case 0: {
                return "No Operation Performed";
            }
            case 1: {
                return "Register pair BC = " + this.engine.Dec2Hex(256 * this.memory[this.PC + 2] + this.memory[this.PC + 1]) + " H";
            }
            case 2: {
                return "Contents of Accumulator " + this.engine.Dec2Hex(this.A) + "H are copied to memory location " + this.engine.Dec2Hex(this.memory[this.B << 8 + this.C]) + "H specified by Register Pair BC";
            }
            case 3: {
                return "Increment resister pair BC  by 1";
            }
            case 4: {
                return "Register B = Register B + 1";
            }
            case 5: {
                return "Register B = Register B - 1";
            }
            case 6: {
                return "Register B = " + this.engine.Dec2Hex2digit(this.memory[this.PC + 1]);
            }
            case 7: {
                return "";
            }
            case 8: {
                return "";
            }
            case 9: {
                return "";
            }
            case 10: {
                return "";
            }
            case 11: {
                return "Decrement resister pair BC by 1";
            }
            case 12: {
                return "Register C = Register C + 1";
            }
            case 13: {
                return "Register C = Register C + 1";
            }
            case 14: {
                return "Register C = " + this.engine.Dec2Hex2digit(this.memory[this.PC + 1]);
            }
            case 15: {
                return "";
            }
            case 16: {
                return "";
            }
            case 17: {
                return "Register pair DE = " + this.engine.Dec2Hex(256 * this.memory[this.PC + 2] + this.memory[this.PC + 1]);
            }
            case 18: {
                return "";
            }
            case 19: {
                return "Increment resister pair DE by 1";
            }
            case 20: {
                return "Register D = Register D + 1";
            }
            case 21: {
                return "Register D = Register D - 1";
            }
            case 22: {
                return "Register D = " + this.engine.Dec2Hex2digit(this.memory[this.PC + 1]);
            }
            case 23: {
                return "";
            }
            case 24: {
                return "";
            }
            case 25: {
                return "";
            }
            case 26: {
                return "";
            }
            case 27: {
                return "Decrement resister pair DE by 1";
            }
            case 28: {
                return "Register E = Register E + 1";
            }
            case 29: {
                return "Register E = Register E - 1";
            }
            case 30: {
                return "Register E = " + this.engine.Dec2Hex2digit(this.memory[this.PC + 1]);
            }
            case 31: {
                return "";
            }
            case 32: {
                return "";
            }
            case 33: {
                return "Register pair HL = " + this.engine.Dec2Hex(256 * this.memory[this.PC + 2] + this.memory[this.PC + 1]);
            }
            case 34: {
                return "";
            }
            case 35: {
                return "Increment resister pair HL by 1";
            }
            case 36: {
                return "Register H = Register H + 1";
            }
            case 37: {
                return "Register H = Register H - 1";
            }
            case 38: {
                return "Register H = " + this.engine.Dec2Hex2digit(this.memory[this.PC + 1]);
            }
            case 39: {
                return "Decimal Adjust Accumulator";
            }
            case 40: {
                return "";
            }
            case 41: {
                return "";
            }
            case 42: {
                return "";
            }
            case 43: {
                return "Decrement resister pair HL by 1";
            }
            case 44: {
                return "Register L = Register L + 1";
            }
            case 45: {
                return "Register L = Register L - 1";
            }
            case 46: {
                return "Register L = " + this.engine.Dec2Hex2digit(this.memory[this.PC + 1]);
            }
            case 47: {
                return "";
            }
            case 48: {
                return "";
            }
            case 49: {
                return "Stack Pointer(SP) = " + this.engine.Dec2Hex(256 * this.memory[this.PC + 2] + this.memory[this.PC + 1]);
            }
            case 50: {
                return "";
            }
            case 51: {
                return "";
            }
            case 52: {
                return "Memory Content = Memory Content + 1";
            }
            case 53: {
                return "Memory Content = Memory Content - 1";
            }
            case 54: {
                return "Memory location (" + this.engine.Dec2Hex(256 * this.H + this.L) + ") = " + this.engine.Dec2Hex2digit(this.memory[this.PC + 1]);
            }
            case 55: {
                return "";
            }
            case 56: {
                return "";
            }
            case 57: {
                return "";
            }
            case 58: {
                return "";
            }
            case 59: {
                return "";
            }
            case 60: {
                return "Accumulator = Accumulator + 1";
            }
            case 61: {
                return "Accumulator = Accumulator - 1";
            }
            case 62: {
                return "Accumulator = " + this.engine.Dec2Hex2digit(this.memory[this.PC + 1]);
            }
            case 63: {
                return "";
            }
            case 64: {
                return "Register B = Register B";
            }
            case 65: {
                return "Register B = Register C";
            }
            case 66: {
                return "Register B = Register D";
            }
            case 67: {
                return "Register B = Register E";
            }
            case 68: {
                return "Register B = Register H";
            }
            case 69: {
                return "Register B = Register L";
            }
            case 70: {
                return "Register B = " + this.memory[256 * this.H + this.L] + " (Content at memory location " + this.engine.Dec2Hex(256 * this.H + this.L) + ")";
            }
            case 71: {
                return "Register B = Accumulator";
            }
            case 72: {
                return "Register C = Register B";
            }
            case 73: {
                return "Register C = Register C";
            }
            case 74: {
                return "Register C = Register D";
            }
            case 75: {
                return "Register C = Register E";
            }
            case 76: {
                return "Register C = Register H";
            }
            case 77: {
                return "Register C = Register L";
            }
            case 78: {
                return "Register C = " + this.memory[256 * this.H + this.L] + " (Content at memory location " + this.engine.Dec2Hex(256 * this.H + this.L) + ")";
            }
            case 79: {
                return "Register C = Accumulator";
            }
            case 80: {
                return "Register D = Register B";
            }
            case 81: {
                return "Register D = Register C";
            }
            case 82: {
                return "Register D = Register D";
            }
            case 83: {
                return "Register D = Register E";
            }
            case 84: {
                return "Register D = Register H";
            }
            case 85: {
                return "Register D = Register L";
            }
            case 86: {
                return "Register D = " + this.memory[256 * this.H + this.L] + " (Content at memory location " + this.engine.Dec2Hex(256 * this.H + this.L) + ")";
            }
            case 87: {
                return "Register D = Accumulator";
            }
            case 88: {
                return "Register E = Register B";
            }
            case 89: {
                return "Register E = Register C";
            }
            case 90: {
                return "Register E = Register D";
            }
            case 91: {
                return "Register E = Register E";
            }
            case 92: {
                return "Register E = Register H";
            }
            case 93: {
                return "Register E = Register L";
            }
            case 94: {
                return "Register E = " + this.memory[256 * this.H + this.L] + " (Content at memory location " + this.engine.Dec2Hex(256 * this.H + this.L) + ")";
            }
            case 95: {
                return "Register E = Accumulator";
            }
            case 96: {
                return "Register H = Register B";
            }
            case 97: {
                return "Register H = Register C";
            }
            case 98: {
                return "Register H = Register D";
            }
            case 99: {
                return "Register H = Register E";
            }
            case 100: {
                return "Register H = Register H";
            }
            case 101: {
                return "Register H = Register L";
            }
            case 102: {
                return "Register H = " + this.memory[256 * this.H + this.L] + " (Content at memory location " + this.engine.Dec2Hex(256 * this.H + this.L) + ")";
            }
            case 103: {
                return "Register H = Accumulator";
            }
            case 104: {
                return "Register L = Register B";
            }
            case 105: {
                return "Register L = Register C";
            }
            case 106: {
                return "Register L = Register D";
            }
            case 107: {
                return "Register L = Register E";
            }
            case 108: {
                return "Register L = Register H";
            }
            case 109: {
                return "Register L = Register L";
            }
            case 110: {
                return "Register L = " + this.memory[256 * this.H + this.L] + " (Content at memory location " + this.engine.Dec2Hex(256 * this.H + this.L) + ")";
            }
            case 111: {
                return "Register L = Accumulator";
            }
            case 112: {
                return "Memory location (" + this.engine.Dec2Hex(256 * this.H + this.L) + ") = Register B";
            }
            case 113: {
                return "Memory location (" + this.engine.Dec2Hex(256 * this.H + this.L) + ") = Register C";
            }
            case 114: {
                return "Memory location (" + this.engine.Dec2Hex(256 * this.H + this.L) + ") = Register D";
            }
            case 115: {
                return "Memory location (" + this.engine.Dec2Hex(256 * this.H + this.L) + ") = Register E";
            }
            case 116: {
                return "Memory location (" + this.engine.Dec2Hex(256 * this.H + this.L) + ") = Register H";
            }
            case 117: {
                return "Memory location (" + this.engine.Dec2Hex(256 * this.H + this.L) + ") = Register L";
            }
            case 118: {
                return "Halt";
            }
            case 119: {
                return "Memory location (" + this.engine.Dec2Hex(256 * this.H + this.L) + ") = Accumulator";
            }
            case 120: {
                return "Accumulator = Register B";
            }
            case 121: {
                return "Accumulator = Register C";
            }
            case 122: {
                return "Accumulator = Register D";
            }
            case 123: {
                return "Accumulator = Register E";
            }
            case 124: {
                return "Accumulator = Register H";
            }
            case 125: {
                return "Accumulator = Register L";
            }
            case 126: {
                return "Accumulator = " + this.memory[256 * this.H + this.L] + " (Content at memory location " + this.engine.Dec2Hex(256 * this.H + this.L) + ")";
            }
            case 127: {
                return "Accumulator = Accumulator";
            }
            case 128: {
                return "Accumulator=Accumulator + Register B";
            }
            case 129: {
                return "Accumulator=Accumulator + Register C";
            }
            case 130: {
                return "Accumulator=Accumulator + Register D";
            }
            case 131: {
                return "Accumulator=Accumulator + Register E";
            }
            case 132: {
                return "Accumulator=Accumulator + Register H";
            }
            case 133: {
                return "Accumulator=Accumulator + Register L";
            }
            case 134: {
                return "Accumulator=Accumulator + " + this.memory[256 * this.H + this.L] + " (Content at memory location " + this.engine.Dec2Hex(256 * this.H + this.L) + ")";
            }
            case 135: {
                return "Accumulator=Accumulator + Accumulator";
            }
            case 136: {
                return "Accumulator=Accumulator + Register B + Carry";
            }
            case 137: {
                return "Accumulator=Accumulator + Register C + Carry";
            }
            case 138: {
                return "Accumulator=Accumulator + Register D + Carry";
            }
            case 139: {
                return "Accumulator=Accumulator + Register E + Carry";
            }
            case 140: {
                return "Accumulator=Accumulator + Register H + Carry";
            }
            case 141: {
                return "Accumulator=Accumulator + Register L + Carry";
            }
            case 142: {
                return "Accumulator=Accumulator + " + this.memory[256 * this.H + this.L] + " (Content at memory location " + this.engine.Dec2Hex(256 * this.H + this.L) + ") + Carry";
            }
            case 143: {
                return "Accumulator=Accumulator + Accumulator + Carry";
            }
            case 144: {
                return "";
            }
            case 145: {
                return "";
            }
            case 146: {
                return "";
            }
            case 147: {
                return "";
            }
            case 148: {
                return "";
            }
            case 149: {
                return "";
            }
            case 150: {
                return "";
            }
            case 151: {
                return "";
            }
            case 152: {
                return "";
            }
            case 153: {
                return "";
            }
            case 154: {
                return "";
            }
            case 155: {
                return "";
            }
            case 156: {
                return "";
            }
            case 157: {
                return "";
            }
            case 158: {
                return "";
            }
            case 159: {
                return "";
            }
            case 160: {
                return "Lgically AND the contents of register B with the contents of Accumulator";
            }
            case 161: {
                return "";
            }
            case 162: {
                return "";
            }
            case 163: {
                return "";
            }
            case 164: {
                return "";
            }
            case 165: {
                return "";
            }
            case 166: {
                return "";
            }
            case 167: {
                return "";
            }
            case 168: {
                return "";
            }
            case 169: {
                return "";
            }
            case 170: {
                return "";
            }
            case 171: {
                return "";
            }
            case 172: {
                return "";
            }
            case 173: {
                return "";
            }
            case 174: {
                return "";
            }
            case 175: {
                return "";
            }
            case 176: {
                return "";
            }
            case 177: {
                return "";
            }
            case 178: {
                return "";
            }
            case 179: {
                return "";
            }
            case 180: {
                return "";
            }
            case 181: {
                return "";
            }
            case 182: {
                return "";
            }
            case 183: {
                return "";
            }
            case 184: {
                return "";
            }
            case 185: {
                return "";
            }
            case 186: {
                return "";
            }
            case 187: {
                return "";
            }
            case 188: {
                return "";
            }
            case 189: {
                return "";
            }
            case 190: {
                return "";
            }
            case 191: {
                return "";
            }
            case 192: {
                return "";
            }
            case 193: {
                return "";
            }
            case 194: {
                return "Jump on No Zero to memory location " + this.engine.Dec2Hex(this.memory[this.PC + 2] * 256 + this.memory[this.PC + 1]) + " [zero = " + (this.F & 0x40) / 64 + "]";
            }
            case 195: {
                return "Jump to memory location " + this.engine.Dec2Hex(this.memory[this.PC + 2] * 256 + this.memory[this.PC + 1]);
            }
            case 196: {
                return "";
            }
            case 197: {
                return "";
            }
            case 198: {
                return "Add " + this.engine.Dec2Hex2digit(this.memory[this.PC + 1]) + " to Accumulator";
            }
            case 199: {
                return "Restart from memory address " + this.engine.Dec2Hex(this.beginAddress + 0) + " [Interrupt = " + (this.o.stopAtIndex == 199) + "]";
            }
            case 200: {
                return "";
            }
            case 201: {
                return "";
            }
            case 202: {
                return "Jump on Zero to memory location " + this.engine.Dec2Hex(this.memory[this.PC + 2] * 256 + this.memory[this.PC + 1]) + " [zero = " + (this.F & 0x40) / 64 + "]";
            }
            case 203: {
                return "";
            }
            case 204: {
                return "";
            }
            case 205: {
                return "";
            }
            case 206: {
                return "";
            }
            case 207: {
                return "Restart from memory address " + this.engine.Dec2Hex(this.beginAddress + 8) + " [Interrupt = " + (this.o.stopAtIndex == 207) + "]";
            }
            case 208: {
                return "";
            }
            case 209: {
                return "";
            }
            case 210: {
                return "Jump on No Carry to memory location " + this.engine.Dec2Hex(this.memory[this.PC + 2] * 256 + this.memory[this.PC + 1]) + " [carry = " + (this.F & 1) + "]";
            }
            case 211: {
                return "";
            }
            case 212: {
                return "";
            }
            case 213: {
                return "";
            }
            case 214: {
                return "";
            }
            case 215: {
                return "Restart from memory address " + this.engine.Dec2Hex(this.beginAddress + 16) + " [Interrupt = " + (this.o.stopAtIndex == 215) + "]";
            }
            case 216: {
                return "";
            }
            case 217: {
                return "";
            }
            case 218: {
                return "Jump on Carry to memory location " + this.engine.Dec2Hex(this.memory[this.PC + 2] * 256 + this.memory[this.PC + 1]) + " [carry = " + (this.F & 1) + "]";
            }
            case 219: {
                return "";
            }
            case 220: {
                return "";
            }
            case 221: {
                return "";
            }
            case 222: {
                return "";
            }
            case 223: {
                return "Restart from memory address " + this.engine.Dec2Hex(this.beginAddress + 24) + " [Interrupt = " + (this.o.stopAtIndex == 223) + "]";
            }
            case 224: {
                return "";
            }
            case 225: {
                return "";
            }
            case 226: {
                return "Jump on Parity Odd to memory location " + this.engine.Dec2Hex(this.memory[this.PC + 2] * 256 + this.memory[this.PC + 1]) + " [parity = " + (this.F & 4) / 4 + "]";
            }
            case 227: {
                return "";
            }
            case 228: {
                return "";
            }
            case 229: {
                return "";
            }
            case 230: {
                return "";
            }
            case 231: {
                return "Restart from memory address " + this.engine.Dec2Hex(this.beginAddress + 32) + " [Interrupt = " + (this.o.stopAtIndex == 231) + "]";
            }
            case 232: {
                return "";
            }
            case 233: {
                return "";
            }
            case 234: {
                return "Jump on Parity Even to memory location " + this.engine.Dec2Hex(this.memory[this.PC + 2] * 256 + this.memory[this.PC + 1]) + " [parity = " + (this.F & 4) / 4 + "]";
            }
            case 235: {
                return "";
            }
            case 236: {
                return "";
            }
            case 237: {
                return "";
            }
            case 238: {
                return "";
            }
            case 239: {
                return "Restart from memory address " + this.engine.Dec2Hex(this.beginAddress + 40) + " [Interrupt = " + (this.o.stopAtIndex == 239) + "]";
            }
            case 240: {
                return "";
            }
            case 241: {
                return "";
            }
            case 242: {
                return "Jump on Positive to memory location " + this.engine.Dec2Hex(this.memory[this.PC + 2] * 256 + this.memory[this.PC + 1]) + " [sign = " + (this.F & 0x80) / 128 + "]";
            }
            case 243: {
                return "";
            }
            case 244: {
                return "";
            }
            case 245: {
                return "";
            }
            case 246: {
                return "";
            }
            case 247: {
                return "Restart from memory address " + this.engine.Dec2Hex(this.beginAddress + 48) + " [Interrupt = " + (this.o.stopAtIndex == 247) + "]";
            }
            case 248: {
                return "";
            }
            case 249: {
                return "";
            }
            case 250: {
                return "Jump on Negative to memory location " + this.engine.Dec2Hex(this.memory[this.PC + 2] * 256 + this.memory[this.PC + 1]) + " [sign = " + (this.F & 0x80) / 128 + "]";
            }
            case 251: {
                return "";
            }
            case 252: {
                return "";
            }
            case 253: {
                return "";
            }
            case 254: {
                return "";
            }
            case 255: {
                return "Restart from memory address " + this.engine.Dec2Hex(this.beginAddress + 56) + " [Interrupt = " + (this.o.stopAtIndex == 255) + "]";
            }
        }
        return "";
    }

    public String tstates(int n) {
        switch (n) {
            case 0: {
                return "F";
            }
            case 1: {
                return "FRR";
            }
            case 2: {
                return "FW";
            }
            case 3: {
                return "S";
            }
            case 4: {
                return "F";
            }
            case 5: {
                return "F";
            }
            case 6: {
                return "FR";
            }
            case 7: {
                return "F";
            }
            case 8: {
                return "F";
            }
            case 9: {
                return "FBB";
            }
            case 10: {
                return "FR";
            }
            case 11: {
                return "S";
            }
            case 12: {
                return "F";
            }
            case 13: {
                return "F";
            }
            case 14: {
                return "FR";
            }
            case 15: {
                return "F";
            }
            case 16: {
                return "F";
            }
            case 17: {
                return "FRR";
            }
            case 18: {
                return "FW";
            }
            case 19: {
                return "S";
            }
            case 20: {
                return "F";
            }
            case 21: {
                return "F";
            }
            case 22: {
                return "FR";
            }
            case 23: {
                return "F";
            }
            case 24: {
                return "F";
            }
            case 25: {
                return "FBB";
            }
            case 26: {
                return "FR";
            }
            case 27: {
                return "S";
            }
            case 28: {
                return "F";
            }
            case 29: {
                return "F";
            }
            case 30: {
                return "FR";
            }
            case 31: {
                return "F";
            }
            case 32: {
                return "F";
            }
            case 33: {
                return "FRR";
            }
            case 34: {
                return "FRRWW";
            }
            case 35: {
                return "S";
            }
            case 36: {
                return "F";
            }
            case 37: {
                return "F";
            }
            case 38: {
                return "FR";
            }
            case 39: {
                return "F";
            }
            case 40: {
                return "F";
            }
            case 41: {
                return "FBB";
            }
            case 42: {
                return "FRRRR";
            }
            case 43: {
                return "S";
            }
            case 44: {
                return "F";
            }
            case 45: {
                return "F";
            }
            case 46: {
                return "FR";
            }
            case 47: {
                return "F";
            }
            case 48: {
                return "F";
            }
            case 49: {
                return "FRR";
            }
            case 50: {
                return "FRRW";
            }
            case 51: {
                return "S";
            }
            case 52: {
                return "FRW";
            }
            case 53: {
                return "FRW";
            }
            case 54: {
                return "FRW";
            }
            case 55: {
                return "F";
            }
            case 56: {
                return "F";
            }
            case 57: {
                return "FBB";
            }
            case 58: {
                return "FRRR";
            }
            case 59: {
                return "S";
            }
            case 60: {
                return "F";
            }
            case 61: {
                return "F";
            }
            case 62: {
                return "FR";
            }
            case 63: {
                return "F";
            }
            case 64: {
                return "F";
            }
            case 65: {
                return "F";
            }
            case 66: {
                return "F";
            }
            case 67: {
                return "F";
            }
            case 68: {
                return "F";
            }
            case 69: {
                return "F";
            }
            case 70: {
                return "FR";
            }
            case 71: {
                return "F";
            }
            case 72: {
                return "F";
            }
            case 73: {
                return "F";
            }
            case 74: {
                return "F";
            }
            case 75: {
                return "F";
            }
            case 76: {
                return "F";
            }
            case 77: {
                return "F";
            }
            case 78: {
                return "FR";
            }
            case 79: {
                return "F";
            }
            case 80: {
                return "F";
            }
            case 81: {
                return "F";
            }
            case 82: {
                return "F";
            }
            case 83: {
                return "F";
            }
            case 84: {
                return "F";
            }
            case 85: {
                return "F";
            }
            case 86: {
                return "FR";
            }
            case 87: {
                return "F";
            }
            case 88: {
                return "F";
            }
            case 89: {
                return "F";
            }
            case 90: {
                return "F";
            }
            case 91: {
                return "F";
            }
            case 92: {
                return "F";
            }
            case 93: {
                return "F";
            }
            case 94: {
                return "FR";
            }
            case 95: {
                return "F";
            }
            case 96: {
                return "F";
            }
            case 97: {
                return "F";
            }
            case 98: {
                return "F";
            }
            case 99: {
                return "F";
            }
            case 100: {
                return "F";
            }
            case 101: {
                return "F";
            }
            case 102: {
                return "FR";
            }
            case 103: {
                return "F";
            }
            case 104: {
                return "F";
            }
            case 105: {
                return "F";
            }
            case 106: {
                return "F";
            }
            case 107: {
                return "F";
            }
            case 108: {
                return "F";
            }
            case 109: {
                return "F";
            }
            case 110: {
                return "FR";
            }
            case 111: {
                return "F";
            }
            case 112: {
                return "FW";
            }
            case 113: {
                return "FW";
            }
            case 114: {
                return "FW";
            }
            case 115: {
                return "FW";
            }
            case 116: {
                return "FW";
            }
            case 117: {
                return "FW";
            }
            case 118: {
                return "FB";
            }
            case 119: {
                return "FW";
            }
            case 120: {
                return "F";
            }
            case 121: {
                return "F";
            }
            case 122: {
                return "F";
            }
            case 123: {
                return "F";
            }
            case 124: {
                return "F";
            }
            case 125: {
                return "F";
            }
            case 126: {
                return "FR";
            }
            case 127: {
                return "F";
            }
            case 128: {
                return "F";
            }
            case 129: {
                return "F";
            }
            case 130: {
                return "F";
            }
            case 131: {
                return "F";
            }
            case 132: {
                return "F";
            }
            case 133: {
                return "F";
            }
            case 134: {
                return "FR";
            }
            case 135: {
                return "F";
            }
            case 136: {
                return "F";
            }
            case 137: {
                return "F";
            }
            case 138: {
                return "F";
            }
            case 139: {
                return "F";
            }
            case 140: {
                return "F";
            }
            case 141: {
                return "F";
            }
            case 142: {
                return "FR";
            }
            case 143: {
                return "F";
            }
            case 144: {
                return "F";
            }
            case 145: {
                return "F";
            }
            case 146: {
                return "F";
            }
            case 147: {
                return "F";
            }
            case 148: {
                return "F";
            }
            case 149: {
                return "F";
            }
            case 150: {
                return "FR";
            }
            case 151: {
                return "F";
            }
            case 152: {
                return "F";
            }
            case 153: {
                return "F";
            }
            case 154: {
                return "F";
            }
            case 155: {
                return "F";
            }
            case 156: {
                return "F";
            }
            case 157: {
                return "F";
            }
            case 158: {
                return "FR";
            }
            case 159: {
                return "F";
            }
            case 160: {
                return "F";
            }
            case 161: {
                return "F";
            }
            case 162: {
                return "F";
            }
            case 163: {
                return "F";
            }
            case 164: {
                return "F";
            }
            case 165: {
                return "F";
            }
            case 166: {
                return "FR";
            }
            case 167: {
                return "F";
            }
            case 168: {
                return "F";
            }
            case 169: {
                return "F";
            }
            case 170: {
                return "F";
            }
            case 171: {
                return "F";
            }
            case 172: {
                return "F";
            }
            case 173: {
                return "F";
            }
            case 174: {
                return "FR";
            }
            case 175: {
                return "F";
            }
            case 176: {
                return "F";
            }
            case 177: {
                return "F";
            }
            case 178: {
                return "F";
            }
            case 179: {
                return "F";
            }
            case 180: {
                return "F";
            }
            case 181: {
                return "F";
            }
            case 182: {
                return "FR";
            }
            case 183: {
                return "F";
            }
            case 184: {
                return "F";
            }
            case 185: {
                return "F";
            }
            case 186: {
                return "F";
            }
            case 187: {
                return "F";
            }
            case 188: {
                return "F";
            }
            case 189: {
                return "F";
            }
            case 190: {
                return "FR";
            }
            case 191: {
                return "F";
            }
            case 192: {
                return "SRR";
            }
            case 193: {
                return "FRR";
            }
            case 194: {
                return "FRR";
            }
            case 195: {
                return "FRR";
            }
            case 196: {
                return "SRRWW";
            }
            case 197: {
                return "SWW";
            }
            case 198: {
                return "FR";
            }
            case 199: {
                return "SWW";
            }
            case 200: {
                return "SRR";
            }
            case 201: {
                return "SRR";
            }
            case 202: {
                return "FRR";
            }
            case 203: {
                return "F";
            }
            case 204: {
                return "SRRWW";
            }
            case 205: {
                return "SRRWW";
            }
            case 206: {
                return "FR";
            }
            case 207: {
                return "SWW";
            }
            case 208: {
                return "SRR";
            }
            case 209: {
                return "FRR";
            }
            case 210: {
                return "FRR";
            }
            case 211: {
                return "FRO";
            }
            case 212: {
                return "SRRWW";
            }
            case 213: {
                return "SWW";
            }
            case 214: {
                return "FR";
            }
            case 215: {
                return "SWW";
            }
            case 216: {
                return "SRR";
            }
            case 217: {
                return "F";
            }
            case 218: {
                return "FRR";
            }
            case 219: {
                return "FRI";
            }
            case 220: {
                return "SRRWW";
            }
            case 221: {
                return "F";
            }
            case 222: {
                return "FR";
            }
            case 223: {
                return "SWW";
            }
            case 224: {
                return "SRR";
            }
            case 225: {
                return "FRR";
            }
            case 226: {
                return "FRR";
            }
            case 227: {
                return "FRRWW";
            }
            case 228: {
                return "SRRWW";
            }
            case 229: {
                return "SWW";
            }
            case 230: {
                return "FR";
            }
            case 231: {
                return "SWW";
            }
            case 232: {
                return "SRR";
            }
            case 233: {
                return "S";
            }
            case 234: {
                return "FRR";
            }
            case 235: {
                return "F";
            }
            case 236: {
                return "SRRWW";
            }
            case 237: {
                return "F";
            }
            case 238: {
                return "FR";
            }
            case 239: {
                return "SWW";
            }
            case 240: {
                return "SRR";
            }
            case 241: {
                return "FRR";
            }
            case 242: {
                return "FRR";
            }
            case 243: {
                return "F";
            }
            case 244: {
                return "SRRWW";
            }
            case 245: {
                return "SWW";
            }
            case 246: {
                return "FR";
            }
            case 247: {
                return "SWW";
            }
            case 248: {
                return "SRR";
            }
            case 249: {
                return "S";
            }
            case 250: {
                return "FRR";
            }
            case 251: {
                return "F";
            }
            case 252: {
                return "SRRWW";
            }
            case 253: {
                return "F";
            }
            case 254: {
                return "FR";
            }
            case 255: {
                return "SWW";
            }
        }
        return "0";
    }

    public void createCopy(Matrix x) {
        try {
            int i;
            File f = new File("cache");
            f.mkdir();
            PrintWriter out = new PrintWriter(new BufferedWriter(new FileWriter("cache" + this.o.fileSeparator + this.o.oIndex + ".tmp")));
            out.println(x.A);
            out.println(x.F);
            out.println(x.B);
            out.println(x.C);
            out.println(x.D);
            out.println(x.E);
            out.println(x.H);
            out.println(x.L);
            out.println(x.SP);
            out.println(x.PC);
            out.println(x.D1);
            out.println(x.clockCycleCounter);
            out.println(x.instructionCounter);
            out.println(x.SOD);
            out.println(x.SDE);
            out.println(x.SID);
            out.println(x.R75);
            out.println(x.R65);
            out.println(x.R55);
            out.println(x.MSE);
            out.println(x.M75);
            out.println(x.M65);
            out.println(x.M55);
            out.println(x.IE);
            out.println(x.INTR);
            out.println(x._INTA);
            out.println(x.TRAP);
            out.println(x.beginAddress);
            out.println(x.stopAddress);
            for (i = 0; i < 65536; ++i) {
                out.println(x.memory[i]);
                out.println(x.label[i]);
            }
            for (i = 0; i < 256; ++i) {
                out.println(x.port[i]);
            }
            out.println(x.select);
            out.close();
        }
        catch (Exception e) {
            Popup.show("Unable to create backward step instances.");
        }
    }

    public void readCopy(Matrix x) {
        try {
            int i;
            BufferedReader in = new BufferedReader(new FileReader("cache" + this.o.fileSeparator + this.o.oIndex + ".tmp"));
            x.A = Integer.parseInt(in.readLine());
            x.F = Integer.parseInt(in.readLine());
            x.B = Integer.parseInt(in.readLine());
            x.C = Integer.parseInt(in.readLine());
            x.D = Integer.parseInt(in.readLine());
            x.E = Integer.parseInt(in.readLine());
            x.H = Integer.parseInt(in.readLine());
            x.L = Integer.parseInt(in.readLine());
            x.SP = Integer.parseInt(in.readLine());
            x.PC = Integer.parseInt(in.readLine());
            x.D1 = Integer.parseInt(in.readLine());
            x.clockCycleCounter = Integer.parseInt(in.readLine());
            x.instructionCounter = Integer.parseInt(in.readLine());
            x.SOD = Integer.parseInt(in.readLine());
            x.SDE = Integer.parseInt(in.readLine());
            x.SID = Integer.parseInt(in.readLine());
            x.R75 = Integer.parseInt(in.readLine());
            x.R65 = Integer.parseInt(in.readLine());
            x.R55 = Integer.parseInt(in.readLine());
            x.MSE = Integer.parseInt(in.readLine());
            x.M75 = Integer.parseInt(in.readLine());
            x.M65 = Integer.parseInt(in.readLine());
            x.M55 = Integer.parseInt(in.readLine());
            x.IE = Integer.parseInt(in.readLine());
            x.INTR = Integer.parseInt(in.readLine());
            x._INTA = Integer.parseInt(in.readLine());
            x.TRAP = Integer.parseInt(in.readLine());
            x.beginAddress = Integer.parseInt(in.readLine());
            x.stopAddress = Integer.parseInt(in.readLine());
            for (i = 0; i < 65536; ++i) {
                x.memory[i] = Integer.parseInt(in.readLine());
                x.label[i] = in.readLine();
            }
            for (i = 0; i < 256; ++i) {
                x.port[i] = Integer.parseInt(in.readLine());
            }
            x.select = Integer.parseInt(in.readLine());
            in.close();
        }
        catch (Exception e) {
            this.o.jButtonBackward.setEnabled(false);
        }
    }

    public void functionRun(int index) {
        ++this.PC;
        if (this.o.stopAtIndex == index) {
            this.o.stop = true;
        }
        switch (index) {
            case 0: {
                break;
            }
            case 1: {
                this.C = this.memory[this.PC++];
                this.B = this.memory[this.PC++];
                break;
            }
            case 2: {
                this.memory[this.B << 8 + this.C] = this.A;
                break;
            }
            case 3: {
                this.temp = this.B << 8 | this.C;
                ++this.temp;
                this.B = this.temp >> 8 & 0xFF;
                this.C = this.temp & 0xFF;
                break;
            }
            case 4: {
                this.F = this.getFlagADD(this.B, 1) & 0xFE | this.F & 1;
                this.B = this.B + 1 & 0xFF;
                break;
            }
            case 5: {
                this.F = this.getFlagADD(this.B, 255) & 0xFE | this.F & 1;
                this.B = this.B - 1 & 0xFF;
                break;
            }
            case 6: {
                this.B = this.memory[this.PC++];
                break;
            }
            case 7: {
                this.temp = this.A / 128;
                this.A = this.A % 128 * 2 + this.temp;
                this.F = this.F & 0xFE ^ this.temp;
                break;
            }
            case 8: {
                break;
            }
            case 9: {
                this.H += this.B;
                this.L += this.C;
                if (this.L > 255) {
                    this.H += this.L / 256;
                    this.L %= 256;
                }
                if (this.H <= 255) break;
                this.F = this.F & 0xFE ^ 1;
                this.H %= 256;
                break;
            }
            case 10: {
                this.A = this.memory[256 * this.B + this.C];
                break;
            }
            case 11: {
                --this.C;
                if (this.B * 256 + this.C < 0) {
                    this.B = 255;
                    this.C = 255;
                }
                if (this.C >= 0) break;
                this.C = 255;
                --this.B;
                break;
            }
            case 12: {
                this.F = this.getFlagADD(this.C, 1) & 0xFE | this.F & 1;
                this.C = this.C + 1 & 0xFF;
                break;
            }
            case 13: {
                this.F = this.getFlagADD(this.C, 255) & 0xFE | this.F & 1;
                this.C = this.C - 1 & 0xFF;
                break;
            }
            case 14: {
                this.C = this.memory[this.PC++];
                break;
            }
            case 15: {
                this.temp = this.A % 2;
                this.A = this.A / 2 + this.temp * 128;
                this.F = this.F & 0xFE ^ this.temp;
                break;
            }
            case 16: {
                break;
            }
            case 17: {
                this.E = this.memory[this.PC++];
                this.D = this.memory[this.PC++];
                break;
            }
            case 18: {
                this.memory[256 * this.D + this.E] = this.A;
                break;
            }
            case 19: {
                this.temp = this.D << 8 | this.E;
                ++this.temp;
                this.D = this.temp >> 8 & 0xFF;
                this.E = this.temp & 0xFF;
                break;
            }
            case 20: {
                this.F = this.getFlagADD(this.D, 1) & 0xFE | this.F & 1;
                this.D = this.D + 1 & 0xFF;
                break;
            }
            case 21: {
                this.F = this.getFlagADD(this.D, 255) & 0xFE | this.F & 1;
                this.D = this.D - 1 & 0xFF;
                break;
            }
            case 22: {
                this.D = this.memory[this.PC++];
                break;
            }
            case 23: {
                this.temp = this.A / 128;
                this.A = this.A % 128 * 2 + (this.F & 1);
                this.F = this.F & 0xFE ^ this.temp;
                break;
            }
            case 24: {
                break;
            }
            case 25: {
                this.H += this.D;
                this.L += this.E;
                if (this.L > 255) {
                    this.H += this.L / 256;
                    this.L %= 256;
                }
                if (this.H <= 255) break;
                this.F = this.F & 0xFE ^ 1;
                this.H %= 256;
                break;
            }
            case 26: {
                this.A = this.memory[256 * this.D + this.E];
                break;
            }
            case 27: {
                --this.E;
                if (this.D * 256 + this.E < 0) {
                    this.D = 255;
                    this.E = 255;
                }
                if (this.E >= 0) break;
                this.E = 255;
                --this.D;
                break;
            }
            case 28: {
                this.F = this.getFlagADD(this.E, 1) & 0xFE | this.F & 1;
                this.E = this.E + 1 & 0xFF;
                break;
            }
            case 29: {
                this.F = this.getFlagADD(this.E, 255) & 0xFE | this.F & 1;
                this.E = this.E - 1 & 0xFF;
                break;
            }
            case 30: {
                this.E = this.memory[this.PC++];
                break;
            }
            case 31: {
                this.temp = this.A % 2;
                this.A = this.A / 2 + (this.F & 1) * 128;
                this.F = this.F & 0xFE ^ this.temp;
                break;
            }
            case 32: {
                this.A = this.SID * 128 + this.R75 * 64 + this.R65 * 32 + this.R55 * 16 + this.IE * 8 + this.M75 * 4 + this.M65 * 2 + this.M55;
                break;
            }
            case 33: {
                this.L = this.memory[this.PC++];
                this.H = this.memory[this.PC++];
                break;
            }
            case 34: {
                this.temp = this.memory[this.PC++] + this.memory[this.PC++] * 256;
                this.memory[this.temp] = this.L;
                this.memory[this.temp + 1] = this.H;
                break;
            }
            case 35: {
                this.temp = this.H << 8 | this.L;
                ++this.temp;
                this.H = this.temp >> 8 & 0xFF;
                this.L = this.temp & 0xFF;
                break;
            }
            case 36: {
                this.F = this.getFlagADD(this.H, 1) & 0xFE | this.F & 1;
                this.H = this.H + 1 & 0xFF;
                break;
            }
            case 37: {
                this.F = this.getFlagADD(this.H, 255) & 0xFE | this.F & 1;
                this.H = this.H - 1 & 0xFF;
                break;
            }
            case 38: {
                this.H = this.memory[this.PC++];
                break;
            }
            case 39: {
                this.temp = 0;
                if ((this.A & 0xF) > 9 || (this.F & 0x10) == 16) {
                    this.temp = 6;
                }
                if ((this.A & 0xF0) > 144 || (this.F & 1) == 1) {
                    this.temp += 96;
                }
                this.F = this.getFlagADD(this.A, this.temp) & 0xFF ^ this.F & 1;
                this.A += this.temp;
                this.A &= 0xFF;
                break;
            }
            case 40: {
                break;
            }
            case 41: {
                this.H += this.H;
                this.L += this.L;
                if (this.L > 255) {
                    this.H += this.L / 256;
                    this.L %= 256;
                }
                if (this.H <= 255) break;
                this.F = this.F & 0xFE ^ 1;
                this.H %= 256;
                break;
            }
            case 42: {
                this.temp = this.memory[this.PC++] + this.memory[this.PC++] * 256;
                this.L = this.memory[this.temp];
                this.H = this.memory[this.temp + 1];
                break;
            }
            case 43: {
                --this.L;
                if (this.H * 256 + this.L < 0) {
                    this.H = 255;
                    this.L = 255;
                }
                if (this.L >= 0) break;
                this.L = 255;
                --this.H;
                break;
            }
            case 44: {
                this.F = this.getFlagADD(this.L, 1) & 0xFE | this.F & 1;
                this.L = this.L + 1 & 0xFF;
                break;
            }
            case 45: {
                this.F = this.getFlagADD(this.L, 255) & 0xFE | this.F & 1;
                this.L = this.L - 1 & 0xFF;
                break;
            }
            case 46: {
                this.L = this.memory[this.PC++];
                break;
            }
            case 47: {
                this.A = 255 - this.A;
                break;
            }
            case 48: {
                this.SOD = this.A / 128;
                this.SDE = this.A % 128 / 64;
                this.D1 = this.A % 64 / 32;
                this.RR75 = this.A % 32 / 16;
                this.MSE = this.A % 16 / 8;
                this.M75 = this.A % 8 / 4;
                this.M65 = this.A % 4 / 2;
                this.M55 = this.A % 2;
                break;
            }
            case 49: {
                this.SP = this.memory[this.PC++] + this.memory[this.PC++] * 256;
                break;
            }
            case 50: {
                this.memory[this.memory[this.PC++] + this.memory[this.PC++] * 256] = this.A;
                break;
            }
            case 51: {
                this.SP = this.SP + 1 & 0xFFFF;
                break;
            }
            case 52: {
                this.F = this.getFlagADD(this.memory[256 * this.H + this.L], 1) & 0xFE | this.F & 1;
                this.memory[256 * this.H + this.L] = this.memory[256 * this.H + this.L] + 1 & 0xFF;
                break;
            }
            case 53: {
                this.F = this.getFlagADD(this.memory[256 * this.H + this.L], 255) & 0xFE | this.F & 1;
                this.memory[256 * this.H + this.L] = this.memory[256 * this.H + this.L] - 1 & 0xFF;
                break;
            }
            case 54: {
                this.memory[256 * this.H + this.L] = this.memory[this.PC++];
                break;
            }
            case 55: {
                this.F |= 1;
                break;
            }
            case 56: {
                break;
            }
            case 57: {
                this.H += this.SP & 0xF0;
                this.L += this.SP & 0xF;
                if (this.L > 255) {
                    this.H += this.L / 256;
                    this.L %= 256;
                }
                if (this.H <= 255) break;
                this.F = this.F & 0xFE ^ 1;
                this.H %= 256;
                break;
            }
            case 58: {
                this.A = this.memory[this.memory[this.PC++] + this.memory[this.PC++] * 256];
                break;
            }
            case 59: {
                --this.SP;
                if (this.SP >= 0) break;
                this.SP = this.stopAddress;
                break;
            }
            case 60: {
                this.F = this.getFlagADD(this.A, 1) & 0xFE | this.F & 1;
                this.A = this.A + 1 & 0xFF;
                break;
            }
            case 61: {
                this.F = this.getFlagADD(this.A, 255) & 0xFE | this.F & 1;
                this.A = this.A - 1 & 0xFF;
                break;
            }
            case 62: {
                this.A = this.memory[this.PC++];
                break;
            }
            case 63: {
                this.F ^= 1;
                break;
            }
            case 64: {
                this.B = this.B;
                break;
            }
            case 65: {
                this.B = this.C;
                break;
            }
            case 66: {
                this.B = this.D;
                break;
            }
            case 67: {
                this.B = this.E;
                break;
            }
            case 68: {
                this.B = this.H;
                break;
            }
            case 69: {
                this.B = this.L;
                break;
            }
            case 70: {
                this.B = this.memory[256 * this.H + this.L];
                break;
            }
            case 71: {
                this.B = this.A;
                break;
            }
            case 72: {
                this.C = this.B;
                break;
            }
            case 73: {
                this.C = this.C;
                break;
            }
            case 74: {
                this.C = this.D;
                break;
            }
            case 75: {
                this.C = this.E;
                break;
            }
            case 76: {
                this.C = this.H;
                break;
            }
            case 77: {
                this.C = this.L;
                break;
            }
            case 78: {
                this.C = this.memory[256 * this.H + this.L];
                break;
            }
            case 79: {
                this.C = this.A;
                break;
            }
            case 80: {
                this.D = this.B;
                break;
            }
            case 81: {
                this.D = this.C;
                break;
            }
            case 82: {
                this.D = this.D;
                break;
            }
            case 83: {
                this.D = this.E;
                break;
            }
            case 84: {
                this.D = this.H;
                break;
            }
            case 85: {
                this.D = this.L;
                break;
            }
            case 86: {
                this.D = this.memory[256 * this.H + this.L];
                break;
            }
            case 87: {
                this.D = this.A;
                break;
            }
            case 88: {
                this.E = this.B;
                break;
            }
            case 89: {
                this.E = this.C;
                break;
            }
            case 90: {
                this.E = this.D;
                break;
            }
            case 91: {
                this.E = this.E;
                break;
            }
            case 92: {
                this.E = this.H;
                break;
            }
            case 93: {
                this.E = this.L;
                break;
            }
            case 94: {
                this.E = this.memory[256 * this.H + this.L];
                break;
            }
            case 95: {
                this.E = this.A;
                break;
            }
            case 96: {
                this.H = this.B;
                break;
            }
            case 97: {
                this.H = this.C;
                break;
            }
            case 98: {
                this.H = this.D;
                break;
            }
            case 99: {
                this.H = this.E;
                break;
            }
            case 100: {
                this.H = this.H;
                break;
            }
            case 101: {
                this.H = this.L;
                break;
            }
            case 102: {
                this.H = this.memory[256 * this.H + this.L];
                break;
            }
            case 103: {
                this.H = this.A;
                break;
            }
            case 104: {
                this.L = this.B;
                break;
            }
            case 105: {
                this.L = this.C;
                break;
            }
            case 106: {
                this.L = this.D;
                break;
            }
            case 107: {
                this.L = this.E;
                break;
            }
            case 108: {
                this.L = this.H;
                break;
            }
            case 109: {
                this.L = this.L;
                break;
            }
            case 110: {
                this.L = this.memory[256 * this.H + this.L];
                break;
            }
            case 111: {
                this.L = this.A;
                break;
            }
            case 112: {
                this.memory[256 * this.H + this.L] = this.B;
                break;
            }
            case 113: {
                this.memory[256 * this.H + this.L] = this.C;
                break;
            }
            case 114: {
                this.memory[256 * this.H + this.L] = this.D;
                break;
            }
            case 115: {
                this.memory[256 * this.H + this.L] = this.E;
                break;
            }
            case 116: {
                this.memory[256 * this.H + this.L] = this.H;
                break;
            }
            case 117: {
                this.memory[256 * this.H + this.L] = this.L;
                break;
            }
            case 118: {
                this.o.stop = true;
                --this.PC;
                break;
            }
            case 119: {
                this.memory[256 * this.H + this.L] = this.A;
                break;
            }
            case 120: {
                this.A = this.B;
                break;
            }
            case 121: {
                this.A = this.C;
                break;
            }
            case 122: {
                this.A = this.D;
                break;
            }
            case 123: {
                this.A = this.E;
                break;
            }
            case 124: {
                this.A = this.H;
                break;
            }
            case 125: {
                this.A = this.L;
                break;
            }
            case 126: {
                this.A = this.memory[256 * this.H + this.L];
                break;
            }
            case 127: {
                this.A = this.A;
                break;
            }
            case 128: {
                this.F = this.getFlagADD(this.A, this.B);
                this.A += this.B;
                if (this.A / 256 < 1) break;
                this.A %= 256;
                break;
            }
            case 129: {
                this.F = this.getFlagADD(this.A, this.C);
                this.A += this.C;
                if (this.A / 256 < 1) break;
                this.A %= 256;
                break;
            }
            case 130: {
                this.F = this.getFlagADD(this.A, this.D);
                this.A += this.D;
                if (this.A / 256 < 1) break;
                this.A %= 256;
                break;
            }
            case 131: {
                this.F = this.getFlagADD(this.A, this.E);
                this.A += this.E;
                if (this.A / 256 < 1) break;
                this.A %= 256;
                break;
            }
            case 132: {
                this.F = this.getFlagADD(this.A, this.H);
                this.A += this.H;
                if (this.A / 256 < 1) break;
                this.A %= 256;
                break;
            }
            case 133: {
                this.F = this.getFlagADD(this.A, this.L);
                this.A += this.L;
                if (this.A / 256 < 1) break;
                this.A %= 256;
                break;
            }
            case 134: {
                this.F = this.getFlagADD(this.A, this.memory[this.H * 256 + this.L]);
                this.A += this.memory[this.H * 256 + this.L];
                if (this.A / 256 < 1) break;
                this.A %= 256;
                break;
            }
            case 135: {
                this.F = this.getFlagADD(this.A, this.A);
                this.A += this.A;
                if (this.A / 256 < 1) break;
                this.A %= 256;
                break;
            }
            case 136: {
                this.temp = this.F & 1;
                this.F = this.getFlagADD(this.A, this.B + this.temp);
                this.A = this.A + this.B + this.temp;
                if (this.A / 256 < 1) break;
                this.A %= 256;
                break;
            }
            case 137: {
                this.temp = this.F & 1;
                this.F = this.getFlagADD(this.A, this.C + this.temp);
                this.A = this.A + this.C + this.temp;
                if (this.A / 256 < 1) break;
                this.A %= 256;
                break;
            }
            case 138: {
                this.temp = this.F & 1;
                this.F = this.getFlagADD(this.A, this.D + this.temp);
                this.A = this.A + this.D + this.temp;
                if (this.A / 256 < 1) break;
                this.A %= 256;
                break;
            }
            case 139: {
                this.temp = this.F & 1;
                this.F = this.getFlagADD(this.A, this.E + this.temp);
                this.A = this.A + this.E + this.temp;
                if (this.A / 256 < 1) break;
                this.A %= 256;
                break;
            }
            case 140: {
                this.temp = this.F & 1;
                this.F = this.getFlagADD(this.A, this.H + this.temp);
                this.A = this.A + this.H + this.temp;
                if (this.A / 256 < 1) break;
                this.A %= 256;
                break;
            }
            case 141: {
                this.temp = this.F & 1;
                this.F = this.getFlagADD(this.A, this.L + this.temp);
                this.A = this.A + this.L + this.temp;
                if (this.A / 256 < 1) break;
                this.A %= 256;
                break;
            }
            case 142: {
                this.temp = this.F & 1;
                this.F = this.getFlagADD(this.A, this.memory[this.H * 256 + this.L] + this.temp);
                this.A = this.A + this.memory[this.H * 256 + this.L] + this.temp;
                if (this.A / 256 < 1) break;
                this.A %= 256;
                break;
            }
            case 143: {
                this.temp = this.F & 1;
                this.F = this.getFlagADD(this.A, this.A + this.temp);
                this.A = this.A + this.A + this.temp;
                if (this.A / 256 < 1) break;
                this.A %= 256;
                break;
            }
            case 144: {
                this.temp = this._2sCompliment(this.B);
                this.F = this.getFlagADD(this.A, this.temp);
                this.F ^= 1;
                this.A = this.A + this.temp & 0xFF;
                break;
            }
            case 145: {
                this.temp = this._2sCompliment(this.C);
                this.F = this.getFlagADD(this.A, this.temp);
                this.F ^= 1;
                this.A = this.A + this.temp & 0xFF;
                break;
            }
            case 146: {
                this.temp = this._2sCompliment(this.D);
                this.F = this.getFlagADD(this.A, this.temp);
                this.F ^= 1;
                this.A = this.A + this.temp & 0xFF;
                break;
            }
            case 147: {
                this.temp = this._2sCompliment(this.E);
                this.F = this.getFlagADD(this.A, this.temp);
                this.F ^= 1;
                this.A = this.A + this.temp & 0xFF;
                break;
            }
            case 148: {
                this.temp = this._2sCompliment(this.H);
                this.F = this.getFlagADD(this.A, this.temp);
                this.F ^= 1;
                this.A = this.A + this.temp & 0xFF;
                break;
            }
            case 149: {
                this.temp = this._2sCompliment(this.L);
                this.F = this.getFlagADD(this.A, this.temp);
                this.F ^= 1;
                this.A = this.A + this.temp & 0xFF;
                break;
            }
            case 150: {
                this.temp = this._2sCompliment(this.memory[this.H * 256 + this.L]);
                this.F = this.getFlagADD(this.A, this.temp);
                this.F ^= 1;
                this.A = this.A + this.temp & 0xFF;
                break;
            }
            case 151: {
                this.temp = this._2sCompliment(this.A);
                this.F = this.getFlagADD(this.A, this.temp);
                this.F ^= 1;
                this.A = this.A + this.temp & 0xFF;
                break;
            }
            case 152: {
                this.temp = this.B + (this.F & 1);
                this.temp = this._2sCompliment(this.temp);
                this.F = this.getFlagADD(this.A, this.temp);
                this.F ^= 1;
                this.A = this.A + this.temp & 0xFF;
                break;
            }
            case 153: {
                this.temp = this.C + (this.F & 1);
                this.temp = this._2sCompliment(this.temp);
                this.F = this.getFlagADD(this.A, this.temp);
                this.F ^= 1;
                this.A = this.A + this.temp & 0xFF;
                break;
            }
            case 154: {
                this.temp = this.D + (this.F & 1);
                this.temp = this._2sCompliment(this.temp);
                this.F = this.getFlagADD(this.A, this.temp);
                this.F ^= 1;
                this.A = this.A + this.temp & 0xFF;
                break;
            }
            case 155: {
                this.temp = this.E + (this.F & 1);
                this.temp = this._2sCompliment(this.temp);
                this.F = this.getFlagADD(this.A, this.temp);
                this.F ^= 1;
                this.A = this.A + this.temp & 0xFF;
                break;
            }
            case 156: {
                this.temp = this.H + (this.F & 1);
                this.temp = this._2sCompliment(this.temp);
                this.F = this.getFlagADD(this.A, this.temp);
                this.F ^= 1;
                this.A = this.A + this.temp & 0xFF;
                break;
            }
            case 157: {
                this.temp = this.L + (this.F & 1);
                this.temp = this._2sCompliment(this.temp);
                this.F = this.getFlagADD(this.A, this.temp);
                this.F ^= 1;
                this.A = this.A + this.temp & 0xFF;
                break;
            }
            case 158: {
                this.temp = this.memory[this.H * 256 + this.L] + (this.F & 1);
                this.temp = this._2sCompliment(this.temp);
                this.F = this.getFlagADD(this.A, this.temp);
                this.F ^= 1;
                this.A = this.A + this.temp & 0xFF;
                break;
            }
            case 159: {
                this.temp = this.A + (this.F & 1);
                this.temp = this._2sCompliment(this.temp);
                this.F = this.getFlagADD(this.A, this.temp);
                this.F ^= 1;
                this.A = this.A + this.temp & 0xFF;
                break;
            }
            case 160: {
                this.A &= this.B;
                this.F = this.getFlagForLogic(this.A, 1, 0);
                break;
            }
            case 161: {
                this.A &= this.C;
                this.F = this.getFlagForLogic(this.A, 1, 0);
                break;
            }
            case 162: {
                this.A &= this.D;
                this.F = this.getFlagForLogic(this.A, 1, 0);
                break;
            }
            case 163: {
                this.A &= this.E;
                this.F = this.getFlagForLogic(this.A, 1, 0);
                break;
            }
            case 164: {
                this.A &= this.H;
                this.F = this.getFlagForLogic(this.A, 1, 0);
                break;
            }
            case 165: {
                this.A &= this.L;
                this.F = this.getFlagForLogic(this.A, 1, 0);
                break;
            }
            case 166: {
                this.A &= this.memory[this.H * 256 + this.L];
                this.F = this.getFlagForLogic(this.A, 1, 0);
                break;
            }
            case 167: {
                this.A &= this.A;
                this.F = this.getFlagForLogic(this.A, 1, 0);
                break;
            }
            case 168: {
                this.A ^= this.B;
                this.F = this.getFlagForLogic(this.A, 0, 0);
                break;
            }
            case 169: {
                this.A ^= this.C;
                this.F = this.getFlagForLogic(this.A, 0, 0);
                break;
            }
            case 170: {
                this.A ^= this.D;
                this.F = this.getFlagForLogic(this.A, 0, 0);
                break;
            }
            case 171: {
                this.A ^= this.E;
                this.F = this.getFlagForLogic(this.A, 0, 0);
                break;
            }
            case 172: {
                this.A ^= this.H;
                this.F = this.getFlagForLogic(this.A, 0, 0);
                break;
            }
            case 173: {
                this.A ^= this.L;
                this.F = this.getFlagForLogic(this.A, 0, 0);
                break;
            }
            case 174: {
                this.A ^= this.memory[this.H * 256 + this.L];
                this.F = this.getFlagForLogic(this.A, 0, 0);
                break;
            }
            case 175: {
                this.A ^= this.A;
                this.F = this.getFlagForLogic(this.A, 0, 0);
                break;
            }
            case 176: {
                this.A |= this.B;
                this.F = this.getFlagForLogic(this.A, 0, 0);
                break;
            }
            case 177: {
                this.A |= this.C;
                this.F = this.getFlagForLogic(this.A, 0, 0);
                break;
            }
            case 178: {
                this.A |= this.D;
                this.F = this.getFlagForLogic(this.A, 0, 0);
                break;
            }
            case 179: {
                this.A |= this.E;
                this.F = this.getFlagForLogic(this.A, 0, 0);
                break;
            }
            case 180: {
                this.A |= this.H;
                this.F = this.getFlagForLogic(this.A, 0, 0);
                break;
            }
            case 181: {
                this.A |= this.L;
                this.F = this.getFlagForLogic(this.A, 0, 0);
                break;
            }
            case 182: {
                this.A |= this.memory[this.H * 256 + this.L];
                this.F = this.getFlagForLogic(this.A, 0, 0);
                break;
            }
            case 183: {
                this.A |= this.A;
                this.F = this.getFlagForLogic(this.A, 0, 0);
                break;
            }
            case 184: {
                this.temp = this._2sCompliment(this.B);
                this.F = this.getFlagADD(this.A, this.temp);
                this.F ^= 1;
                break;
            }
            case 185: {
                this.temp = this._2sCompliment(this.C);
                this.F = this.getFlagADD(this.A, this.temp);
                this.F ^= 1;
                break;
            }
            case 186: {
                this.temp = this._2sCompliment(this.D);
                this.F = this.getFlagADD(this.A, this.temp);
                this.F ^= 1;
                break;
            }
            case 187: {
                this.temp = this._2sCompliment(this.E);
                this.F = this.getFlagADD(this.A, this.temp);
                this.F ^= 1;
                break;
            }
            case 188: {
                this.temp = this._2sCompliment(this.H);
                this.F = this.getFlagADD(this.A, this.temp);
                this.F ^= 1;
                break;
            }
            case 189: {
                this.temp = this._2sCompliment(this.L);
                this.F = this.getFlagADD(this.A, this.temp);
                this.F ^= 1;
                break;
            }
            case 190: {
                this.temp = this._2sCompliment(this.memory[this.H * 256 + this.L]);
                this.F = this.getFlagADD(this.A, this.temp);
                this.F ^= 1;
                break;
            }
            case 191: {
                this.temp = this._2sCompliment(this.A);
                this.F = this.getFlagADD(this.A, this.temp);
                this.F ^= 1;
                break;
            }
            case 192: {
                if ((this.F & 0x40) != 0) break;
                int[] n = this.popInStack();
                this.PC = n[0] * 256 + n[1];
                break;
            }
            case 193: {
                int[] no = this.popInStack();
                this.B = no[0];
                this.C = no[1];
                break;
            }
            case 194: {
                if ((this.F & 0x40) == 0) {
                    this.PC = this.memory[this.PC++] + this.memory[this.PC++] * 256;
                    break;
                }
                this.PC += 2;
                this.clockCycleCounter -= 3L;
                break;
            }
            case 195: {
                this.PC = this.memory[this.PC++] + this.memory[this.PC++] * 256;
                break;
            }
            case 196: {
                if ((this.F & 0x40) == 0) {
                    this.temp = this.PC + 2;
                    this.pushInStack(this.temp / 256, this.temp % 256);
                    this.PC = this.memory[this.PC++] + this.memory[this.PC++] * 256;
                    break;
                }
                this.PC += 2;
                break;
            }
            case 197: {
                this.pushInStack(this.B, this.C);
                break;
            }
            case 198: {
                this.F = this.getFlagADD(this.A, this.memory[this.PC]);
                this.A += this.memory[this.PC++];
                if (this.A / 256 < 1) break;
                this.A %= 256;
                break;
            }
            case 199: {
                this.pushInStack(this.PC / 256, this.PC % 256);
                this.PC = this.beginAddress;
                break;
            }
            case 200: {
                if ((this.F & 0x40) != 64) break;
                int[] n = this.popInStack();
                this.PC = n[0] * 256 + n[1];
                break;
            }
            case 201: {
                int[] n = this.popInStack();
                this.PC = n[0] * 256 + n[1];
                break;
            }
            case 202: {
                if ((this.F & 0x40) == 64) {
                    this.PC = this.memory[this.PC++] + this.memory[this.PC++] * 256;
                    break;
                }
                this.PC += 2;
                this.clockCycleCounter -= 3L;
                break;
            }
            case 203: {
                break;
            }
            case 204: {
                if ((this.F & 0x40) == 64) {
                    this.temp = this.PC + 2;
                    this.pushInStack(this.temp / 256, this.temp % 256);
                    this.PC = this.memory[this.PC++] + this.memory[this.PC++] * 256;
                    break;
                }
                this.PC += 2;
                break;
            }
            case 205: {
                this.temp = this.PC + 2;
                this.pushInStack(this.temp / 256, this.temp % 256);
                this.PC = this.memory[this.PC++] + this.memory[this.PC++] * 256;
                break;
            }
            case 206: {
                this.temp = this.F & 1;
                this.F = this.getFlagADD(this.A, this.memory[this.PC] + this.temp);
                this.A = this.A + this.memory[this.PC++] + this.temp;
                if (this.A / 256 < 1) break;
                this.A %= 256;
                break;
            }
            case 207: {
                this.pushInStack(this.PC / 256, this.PC % 256);
                this.PC = this.beginAddress + 8;
                break;
            }
            case 208: {
                if ((this.F & 1) != 0) break;
                int[] n = this.popInStack();
                this.PC = n[0] * 256 + n[1];
                break;
            }
            case 209: {
                int[] no = this.popInStack();
                this.D = no[0];
                this.E = no[1];
                break;
            }
            case 210: {
                if ((this.F & 1) == 0) {
                    this.PC = this.memory[this.PC++] + this.memory[this.PC++] * 256;
                    break;
                }
                this.PC += 2;
                this.clockCycleCounter -= 3L;
                break;
            }
            case 211: {
                this.port[this.memory[this.PC++]] = this.A;
                break;
            }
            case 212: {
                if ((this.F & 1) == 0) {
                    this.temp = this.PC + 2;
                    this.pushInStack(this.temp / 256, this.temp % 256);
                    this.PC = this.memory[this.PC++] + this.memory[this.PC++] * 256;
                    break;
                }
                this.PC += 2;
                break;
            }
            case 213: {
                this.pushInStack(this.D, this.E);
                break;
            }
            case 214: {
                this.temp = this.memory[this.PC++];
                this.temp = this._2sCompliment(this.temp);
                this.F = this.getFlagADD(this.A, this.temp);
                this.F ^= 1;
                this.A = this.A + this.temp & 0xFF;
                break;
            }
            case 215: {
                this.pushInStack(this.PC / 256, this.PC % 256);
                this.PC = this.beginAddress + 16;
                break;
            }
            case 216: {
                if ((this.F & 1) != 1) break;
                int[] n = this.popInStack();
                this.PC = n[0] * 256 + n[1];
                break;
            }
            case 217: {
                break;
            }
            case 218: {
                if ((this.F & 1) == 1) {
                    this.PC = this.memory[this.PC++] + this.memory[this.PC++] * 256;
                    break;
                }
                this.PC += 2;
                this.clockCycleCounter -= 3L;
                break;
            }
            case 219: {
                this.A = this.port[this.memory[this.PC++]];
                break;
            }
            case 220: {
                if ((this.F & 1) == 1) {
                    this.temp = this.PC + 2;
                    this.pushInStack(this.temp / 256, this.temp % 256);
                    this.PC = this.memory[this.PC++] + this.memory[this.PC++] * 256;
                    break;
                }
                this.PC += 2;
                break;
            }
            case 221: {
                break;
            }
            case 222: {
                this.temp = this.memory[this.PC++] + (this.F & 1);
                this.temp = this._2sCompliment(this.temp);
                this.F = this.getFlagADD(this.A, this.temp);
                this.F ^= 1;
                this.A = this.A + this.temp & 0xFF;
                break;
            }
            case 223: {
                this.pushInStack(this.PC / 256, this.PC % 256);
                this.PC = this.beginAddress + 24;
                break;
            }
            case 224: {
                if ((this.F & 4) != 0) break;
                int[] n = this.popInStack();
                this.PC = n[0] * 256 + n[1];
                break;
            }
            case 225: {
                int[] no = this.popInStack();
                this.H = no[0];
                this.L = no[1];
                break;
            }
            case 226: {
                if ((this.F & 4) == 0) {
                    this.PC = this.memory[this.PC++] + this.memory[this.PC++] * 256;
                    break;
                }
                this.PC += 2;
                this.clockCycleCounter -= 3L;
                break;
            }
            case 227: {
                int temp1 = this.H;
                int temp2 = this.L;
                this.H = this.memory[this.SP + 1] & 0xFF;
                this.L = this.memory[this.SP] & 0xFF;
                this.memory[this.SP + 1] = temp1;
                this.memory[this.SP] = temp2;
                break;
            }
            case 228: {
                if ((this.F & 4) == 0) {
                    this.temp = this.PC + 2;
                    this.pushInStack(this.temp / 256, this.temp % 256);
                    this.PC = this.memory[this.PC++] + this.memory[this.PC++] * 256;
                    break;
                }
                this.PC += 2;
                break;
            }
            case 229: {
                this.pushInStack(this.H, this.L);
                break;
            }
            case 230: {
                this.A &= this.memory[this.PC++];
                this.F = this.getFlagForLogic(this.A, 1, 0);
                break;
            }
            case 231: {
                this.pushInStack(this.PC / 256, this.PC % 256);
                this.PC = this.beginAddress + 32;
                break;
            }
            case 232: {
                if ((this.F & 4) != 4) break;
                int[] n = this.popInStack();
                this.PC = n[0] * 256 + n[1];
                break;
            }
            case 233: {
                this.PC = this.H * 256 + this.L;
                break;
            }
            case 234: {
                if ((this.F & 4) == 4) {
                    this.PC = this.memory[this.PC++] + this.memory[this.PC++] * 256;
                    break;
                }
                this.PC += 2;
                this.clockCycleCounter -= 3L;
                break;
            }
            case 235: {
                this.temp = this.D;
                this.D = this.H;
                this.H = this.temp;
                this.temp = this.E;
                this.E = this.L;
                this.L = this.temp;
                break;
            }
            case 236: {
                if ((this.F & 4) == 4) {
                    this.temp = this.PC + 2;
                    this.pushInStack(this.temp / 256, this.temp % 256);
                    this.PC = this.memory[this.PC++] + this.memory[this.PC++] * 256;
                    break;
                }
                this.PC += 2;
                break;
            }
            case 237: {
                break;
            }
            case 238: {
                this.A ^= this.memory[this.PC++];
                this.F = this.getFlagForLogic(this.A, 0, 0);
                break;
            }
            case 239: {
                this.pushInStack(this.PC / 256, this.PC % 256);
                this.PC = this.beginAddress + 40;
                break;
            }
            case 240: {
                if ((this.F & 0x80) != 0) break;
                int[] n = this.popInStack();
                this.PC = n[0] * 256 + n[1];
                break;
            }
            case 241: {
                int[] no = this.popInStack();
                this.A = no[0];
                this.F = no[1];
                break;
            }
            case 242: {
                if ((this.F & 0x80) == 0) {
                    this.PC = this.memory[this.PC++] + this.memory[this.PC++] * 256;
                    break;
                }
                this.PC += 2;
                this.clockCycleCounter -= 3L;
                break;
            }
            case 243: {
                this.IE = 0;
                break;
            }
            case 244: {
                if ((this.F & 0x80) == 0) {
                    this.temp = this.PC + 2;
                    this.pushInStack(this.temp / 256, this.temp % 256);
                    this.PC = this.memory[this.PC++] + this.memory[this.PC++] * 256;
                    break;
                }
                this.PC += 2;
                break;
            }
            case 245: {
                this.pushInStack(this.A, this.F);
                break;
            }
            case 246: {
                this.A |= this.memory[this.PC++];
                this.F = this.getFlagForLogic(this.A, 0, 0);
                break;
            }
            case 247: {
                this.pushInStack(this.PC / 256, this.PC % 256);
                this.PC = this.beginAddress + 48;
                break;
            }
            case 248: {
                if ((this.F & 0x80) != 128) break;
                int[] n = this.popInStack();
                this.PC = n[0] * 256 + n[1];
                break;
            }
            case 249: {
                this.SP = this.H * 256 + this.L;
                break;
            }
            case 250: {
                if ((this.F & 0x80) == 128) {
                    this.PC = this.memory[this.PC++] + this.memory[this.PC++] * 256;
                    break;
                }
                this.PC += 2;
                this.clockCycleCounter -= 3L;
                break;
            }
            case 251: {
                this.IE = 1;
                break;
            }
            case 252: {
                if ((this.F & 0x80) == 128) {
                    this.temp = this.PC + 2;
                    this.pushInStack(this.temp / 256, this.temp % 256);
                    this.PC = this.memory[this.PC++] + this.memory[this.PC++] * 256;
                    break;
                }
                this.PC += 2;
                break;
            }
            case 253: {
                break;
            }
            case 254: {
                this.temp = this._2sCompliment(this.memory[this.PC++]);
                this.F = this.getFlagADD(this.A, this.temp);
                this.F ^= 1;
                break;
            }
            case 255: {
                this.pushInStack(this.PC / 256, this.PC % 256);
                this.PC = this.beginAddress + 56;
            }
        }
        this.clockCycleCounter += (long)this.engine.I[index][2];
        ++this.instructionCounter;
        if (this.stopAddress < this.PC || this.beginAddress > this.PC) {
            this.o.jButtonStop.doClick();
            this.o.jLabelErrorHang.setText("You have exceeded the memory range");
            this.o.jLabelErrorHang.setVisible(true);
            this.PC = this.beginAddress;
        }
        this.interruptProcess();
    }

    public void pushInStack(int b, int c) {
        if (this.SP == this.beginAddress || this.SP == 0) {
            this.SP = this.stopAddress + 1;
        }
        this.memory[--this.SP] = b;
        this.memory[--this.SP] = c;
    }

    public int[] popInStack() {
        int[] no = new int[2];
        if (this.SP == this.stopAddress) {
            this.SP = 0;
        }
        no[1] = this.memory[this.SP++];
        no[0] = this.memory[this.SP++];
        if (this.SP - 1 == this.stopAddress) {
            this.SP = this.beginAddress;
        }
        return no;
    }

    public void interruptProcess() {
        if (this._RESETIN == 0) {
            this.IE = 0;
        }
        if (this.IE == 1 && this.TRAP == 1) {
            this.IE = 0;
            this._INTA = 0;
            this.PC = 36;
        }
        if (!(this.IE != 1 || this.R75 != 1 || this.RR75 != 0 && this._RESETIN != 0 || this.M75 == 1 && this.MSE == 1)) {
            this.IE = 0;
            this._INTA = 0;
            this.PC = 60;
        }
        if (this.IE == 1 && this.R65 == 1 && (this.M65 != 1 || this.MSE != 1)) {
            this.IE = 0;
            this._INTA = 0;
            this.PC = 52;
        }
        if (this.IE == 1 && this.R55 == 1 && (this.M55 != 1 || this.MSE != 1)) {
            this.IE = 0;
            this._INTA = 0;
            this.PC = 44;
        }
        if (this.IE == 1 && this.INTR == 1) {
            this.IE = 0;
            this._INTA = 0;
            this.PC = 8;
        }
    }

    public int getFlagADD(int b, int c) {
        int S = 0;
        int Z = 0;
        int AC = 0;
        int P = 0;
        int CY = 0;
        int t = 0;
        t = b + c;
        AC = (b & 0xF) + (c & 0xF) > 15 ? 1 : 0;
        Z = (t & 0xFF) == 0 ? 1 : 0;
        S = (t & 0x80) == 128 ? 1 : 0;
        CY = (t & 0x100) == 256 ? 1 : 0;
        P = this.getParity(t & 0xFF);
        return S << 7 | Z << 6 | AC << 4 | P << 2 | CY;
    }

    public int getFlagINR(int b, int CY) {
        int S = 0;
        int Z = 0;
        int AC = 0;
        int P = 0;
        int t = 0;
        t = b + 1;
        AC = (b & 0xF) + 1 > 15 ? 1 : 0;
        Z = (t & 0xFF) == 0 ? 1 : 0;
        S = (t & 0x80) == 128 ? 1 : 0;
        P = this.getParity(t & 0xFF);
        return S << 7 | Z << 6 | AC << 4 | P << 2 | CY;
    }

    public int getFlagForLogic(int b, int ac, int c) {
        int S = 0;
        int Z = 0;
        int d2 = 0;
        int AC = 0;
        int d1 = 0;
        int P = 0;
        int d0 = 0;
        int CY = 0;
        if (b > 127) {
            S = 1;
        }
        if (b == c) {
            Z = 1;
        }
        AC = ac;
        CY = c;
        P = b / 128 ^ b / 64 % 2 ^ b / 32 % 2 ^ b / 16 % 2 ^ b / 8 % 2 ^ b / 4 % 2 ^ b / 2 % 2 ^ b % 2 ^ 1;
        return S * 128 + Z * 64 + d2 * 32 + AC * 16 + d1 * 8 + P * 4 + d0 * 2 + CY;
    }

    int getParity(int num) {
        int parity = num & 0xFF;
        parity ^= parity >> 4;
        parity ^= parity >> 2;
        return ((parity ^= parity >> 1) & 1) == 0 ? 1 : 0;
    }

    int _2sCompliment(int num) {
        return (num & 0xFF ^ 0xFF) + 1 & 0xFF;
    }

    public static void main(String[] args) {
        Assembler a = new Assembler();
        Matrix matrix = new Matrix(a);
        matrix.PC = 90;
        matrix.functionRun(195);
        System.out.println(matrix.engine.Dec2Bin(240));
        System.out.println(Integer.toBinaryString(matrix.getFlagADD(18, 18)));
        System.out.println(1);
        System.out.println(matrix.getParity(255));
        System.out.println("0x" + Integer.toHexString(4080));
        System.out.println("0x" + Integer.toHexString(15));
        System.out.println("0x" + Integer.toHexString(15));
        System.out.println("0x" + Integer.toHexString(132));
        System.out.println("0x" + Integer.toHexString(4660));
        a.dispose();
    }
}

