/*
 * Decompiled with CFR 0.152.
 */
package cottage;

import cottage.CottageDriver;
import java.awt.Graphics;
import java.awt.event.KeyEvent;
import java.net.URL;
import jef.machine.Machine;
import jef.util.Config;
import jef.util.Throttle;
import jef.video.BitMap;
import jef.video.Console;
import jef.video.GfxProducer;

public class Cottage
extends GfxProducer {
    public static final String VERSION = "1.0 beta";
    public static final String RELEASE_DATE = "20-10-2005";
    public static int[] pixel;
    public static Cottage main;
    URL base_URL;
    boolean showFPS = false;
    boolean showTXT = false;
    boolean paused = false;
    boolean doubled = false;
    boolean scale2x = false;
    boolean scanlines = false;
    boolean sound = true;
    Machine m;

    protected void processKeyEvent(KeyEvent e) {
        int code = e.getKeyCode();
        block0 : switch (e.getID()) {
            case 401: {
                switch (code) {
                    case 80: {
                        this.paused = !this.paused;
                        break block0;
                    }
                    case 27: {
                        this.m.reset(false);
                        break block0;
                    }
                    case 55: {
                        if (Throttle.getFrameSkip() > 0) {
                            Throttle.setFrameSkip(Throttle.getFrameSkip() - 1);
                            Throttle.enableAutoFrameSkip(false);
                            break block0;
                        }
                        Throttle.enableAutoFrameSkip(true);
                        break block0;
                    }
                    case 56: {
                        if (Throttle.isAutoFrameSkip()) {
                            Throttle.enableAutoFrameSkip(false);
                            Throttle.setFrameSkip(0);
                            break block0;
                        }
                        if (Throttle.getFrameSkip() >= 12) break block0;
                        Throttle.setFrameSkip(Throttle.getFrameSkip() + 1);
                        Throttle.enableAutoFrameSkip(false);
                        break block0;
                    }
                    case 57: {
                        Throttle.enable(!Throttle.isEnabled());
                        break block0;
                    }
                    case 48: {
                        this.showFPS = !this.showFPS;
                        break block0;
                    }
                }
                this.m.keyPress(code);
                break;
            }
            case 402: {
                this.m.keyRelease(code);
            }
        }
    }

    public void main(int w, int h) {
        String driver = "";
        System.out.println("CottAGE version 1.0 beta using JEF version 1.0 Beta 4.");
        try {
            this.base_URL = this.getDocumentBase();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            driver = this.getParameter("DRIVER");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.doubled = this.getParameter("DOUBLE").equals("Yes");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.scale2x = this.getParameter("SCALE2X").equals("Yes");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.sound = !this.getParameter("SOUND").equals("No");
        }
        catch (Exception exception) {
            // empty catch block
        }
        int sLineBuf = this.getPar("LINEBUFFER");
        if (sLineBuf == -1) {
            sLineBuf = 4096;
        }
        Config.SOUND_BUFFER_SIZE = sLineBuf;
        int sSampFrq = this.getPar("SAMPLINGRATE");
        if (sSampFrq == -1) {
            sSampFrq = 22050;
        }
        Config.SOUND_SAMPLING_FREQ = sSampFrq;
        main = this;
        CottageDriver d = new CottageDriver();
        Console.init(w, h, this);
        pixel = new int[w * h];
        this.update(pixel);
        this.showTXT = true;
        this.m = d.getMachine(this.base_URL, driver);
        this.showTXT = false;
        pixel = null;
        Console.init(w, h, this);
        this.m.setSound(this.sound);
        pixel = new int[this.m.refresh(true).getPixels().length * 4];
        pixel = !this.doubled && !this.scale2x ? this.m.refresh(true).getPixels() : new int[this.m.refresh(true).getPixels().length * 4];
        this.enableEvents(8L);
        this.requestFocus();
        System.out.println("Running...");
        Throttle.init(this.m.getProperty(0), this.getThread());
        while (true) {
            if (!this.paused) {
                this.update(this.m.refresh(true));
            }
            Throttle.throttle();
        }
    }

    private final int dimColor(int col) {
        return col >> 1 & 0x7F7F7F;
    }

    private int[] getDisplay(BitMap bm) {
        block12: {
            block11: {
                int[] pix = bm.getPixels();
                if (!this.doubled && !this.scale2x) {
                    if (this.paused) {
                        int ofs = 0;
                        while (ofs < pix.length) {
                            pix[ofs] = this.dimColor(pix[ofs]);
                            ++ofs;
                        }
                    } else if (this.showFPS) {
                        int ofs = 0;
                        while (ofs < this.getWidth() * 16) {
                            pix[ofs] = this.dimColor(pix[ofs]);
                            ++ofs;
                        }
                    }
                    return pix;
                }
                if (this.doubled) {
                    pixel = bm.getScaledBitMap(2, 1).getPixels();
                } else if (this.scale2x) {
                    pixel = bm.getScaledBitMap(2, 2).getPixels();
                }
                if (!this.paused) break block11;
                int ofs = 0;
                while (ofs < pixel.length) {
                    Cottage.pixel[ofs] = this.dimColor(pixel[ofs]);
                    ++ofs;
                }
                break block12;
            }
            if (!this.showFPS) break block12;
            int offs = 0;
            while (offs < this.getWidth() * 16) {
                Cottage.pixel[offs] = this.dimColor(pixel[offs]);
                ++offs;
            }
        }
        return pixel;
    }

    public void postPaint(Graphics g) {
        if (this.paused) {
            String text = "GAME PAUSED";
            Console.drawTextLine(g, this.getWidth() / 2 - 6 * text.length() / 2, this.getHeight() / 2 + 6, text);
        } else if (this.showFPS) {
            StringBuffer buf = new StringBuffer();
            String fs = Integer.toString(Throttle.getFrameSkip());
            String afs = Float.toString(Throttle.getAverageFPS());
            if (Throttle.isAutoFrameSkip()) {
                fs = "AUTO(" + fs + ")";
            }
            buf.append(Throttle.getFPS()).append("/").append(Throttle.getTargetFPS()).append("/").append(afs);
            buf.append("  thr:").append(Throttle.isEnabled());
            buf.append("  sl:").append(Throttle.getSleep());
            buf.append("  fs:").append(fs);
            Console.drawTextLine(g, 1, 12, buf.toString());
        } else if (this.showTXT) {
            Console.drawText(g);
        }
    }

    private final int getPar(String parStr) {
        int returnValue = -1;
        try {
            parStr = this.getParameter(parStr);
            if (parStr != null) {
                returnValue = Integer.parseInt(parStr);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return returnValue;
    }
}

