/*
 * Decompiled with CFR 0.152.
 */
package cottage.mame;

import jef.machine.MachineDriver;
import jef.map.ReadHandler;
import jef.map.WriteHandler;
import jef.video.BitMap;
import jef.video.BitMapImpl;
import jef.video.Eof_callback;
import jef.video.Get_tile_info;
import jef.video.GfxDecodeInfo;
import jef.video.GfxManager;
import jef.video.TileMap;
import jef.video.Vh_convert_color_proms;
import jef.video.Vh_refresh;
import jef.video.Vh_start;
import jef.video.Vh_stop;
import jef.video.VideoEmulator;

public class MAMEVideo
implements VideoEmulator,
Vh_convert_color_proms,
Eof_callback,
Vh_start,
Vh_stop,
Vh_refresh {
    public int[] pixels;
    public BitMap backBuffer;
    public int width;
    public int height;
    public int[] visible;
    protected int[] cliprect;
    public GfxDecodeInfo[] gdi;
    public GfxManager[] gfxMan;
    public int total_colors;
    public int color;
    public int rot;
    public int vX;
    public int vY;
    private int[] palette;
    protected int[][] color_table;
    protected boolean videoModifiesPalette;
    public BitMap bitmap;
    public BitMap tmpbitmap;
    public int Machine_drv_total_colors;
    public int[] Machine_pens;
    public int[] Machine_gfx;
    public int Machine_visible_area;
    public int Machine_visible_area_min_x;
    public int Machine_visible_area_max_x;
    public int Machine_visible_area_min_y;
    public int Machine_visible_area_max_y;
    public static int videoram;
    public static int colorram;
    public static int spriteram;
    public static int spriteram_2;
    public static int spriteram_3;
    public static int paletteram;
    public static int paletteram_2;
    public static int videoram_size;
    public static int spriteram_size;
    public static int spriteram_2_size;
    public static int spriteram_3_size;
    public boolean[] dirtybuffer;
    protected int[] RAM;
    protected int[] PROM;
    protected int[][] GFX_REGIONS;
    protected int[] color_prom;
    public static final int TILEMAP_OPAQUE = 0;
    public static final int TILEMAP_TRANSPARENT = 1;
    public int[] buffered_spriteram;
    public static final int tilemap_scan_rows = 0;
    static int curgfx;
    static int curcode;
    static int curcolor;
    static int curflags;
    private MachineDriver md;
    protected int[] palette_used_colors;
    protected static final int PALETTE_COLOR_UNUSED = 0;
    protected static final int PALETTE_COLOR_VISIBLE = 1;
    protected static final int PALETTE_COLOR_CACHED = 2;
    protected static final int PALETTE_COLOR_TRANSPARENT_FLAG = 4;
    protected static final int PALETTE_COLOR_USED = 3;
    protected static final int PALETTE_COLOR_TRANSPARENT = 7;

    protected MachineDriver getMachineDriver() {
        return this.md;
    }

    public final boolean[] bauto_malloc(int size) {
        return new boolean[size];
    }

    public final void memset(boolean[] buffer, int value, int size) {
        boolean bval = value != 0;
        int i = 0;
        while (i < size) {
            buffer[i] = bval;
            ++i;
        }
    }

    protected void memset(int[] array, int v, int s) {
        int i = 0;
        while (i < s) {
            array[i] = v;
            ++i;
        }
    }

    protected void memcpy(int[] dst, int[] src, int nbytes) {
        System.arraycopy(src, 0, dst, 0, nbytes);
    }

    protected int[] malloc(int size) {
        return new int[size];
    }

    public void SET_TILE_INFO(int gfx, int code, int color, int flags) {
        curgfx = gfx;
        curcode = code;
        curcolor = color;
        curflags = flags;
    }

    public TileMap tilemap_create(Get_tile_info tile_get_info, int get_memory_offset, int type, int tile_width, int tile_height, int num_cols, int num_rows) {
        return new TileMap(tile_get_info, get_memory_offset, type, tile_width, tile_height, num_cols, num_rows);
    }

    public void tilemap_set_transparent_pen(TileMap tilemap, int pen) {
        tilemap.pen = pen;
    }

    public void tilemap_mark_tile_dirty(TileMap tilemap, int memory_offset) {
    }

    public void tilemap_mark_all_tiles_dirty(TileMap tilemap) {
    }

    public void tilemap_draw(BitMap dest, int[] cliprect, TileMap tilemap, int flags, int priority) {
        int nbtiles_per_row = tilemap.cols;
        int tile_width = tilemap.width;
        int tile_height = tilemap.height;
        boolean transparent = (tilemap.type & 1) != 0;
        int pen = 0;
        if (transparent) {
            pen = tilemap.pen;
        }
        int row_start = this.visible[2] / tile_height;
        int row_end = (this.visible[3] + 1) / tile_height;
        int col_start = this.visible[0] / tile_width;
        int col_end = (this.visible[1] + 1) / tile_width;
        int yofs = 0;
        int j = row_start;
        while (j < row_end) {
            int xofs = 0;
            int i = col_start;
            while (i < col_end) {
                int tile_data;
                int l;
                int k;
                int tile_index = nbtiles_per_row * j + i;
                tilemap.tile_info.get_tile_info(tile_index);
                int[] GFX = this.GFX_REGIONS[curgfx];
                int tile_code = curcode * (this.gdi[MAMEVideo.curgfx].gfx.bytes >> 3);
                int tile_color = curcolor << this.gdi[MAMEVideo.curgfx].gfx.planes;
                int ofs = yofs + xofs;
                if (transparent) {
                    k = 0;
                    while (k < tile_height) {
                        l = 0;
                        while (l < tile_width) {
                            int tdata;
                            if ((tdata = (tile_data = GFX[tile_code++]) >> 4 & 0xF) != pen) {
                                this.pixels[ofs + l] = this.palette[tile_color + tdata];
                            }
                            ++l;
                            tdata = tile_data & 0xF;
                            if (tdata != pen) {
                                this.pixels[ofs + l] = this.palette[tile_color + tdata];
                            }
                            ++l;
                        }
                        ofs += this.width;
                        ++k;
                    }
                } else {
                    k = 0;
                    while (k < tile_height) {
                        l = 0;
                        while (l < tile_width) {
                            tile_data = GFX[tile_code++];
                            this.pixels[ofs + l] = this.palette[tile_color + (tile_data >> 4 & 0xF)];
                            this.pixels[ofs + ++l] = this.palette[tile_color + (tile_data & 0xF)];
                            ++l;
                        }
                        ofs += this.width;
                        ++k;
                    }
                }
                xofs += tile_width;
                ++i;
            }
            yofs += this.width * tile_height;
            ++j;
        }
    }

    public ReadHandler paletteram_r() {
        return new Paletteram_r();
    }

    public WriteHandler videoram_w() {
        return new Videoram_w();
    }

    public WriteHandler colorram_w() {
        return new Colorram_w();
    }

    public Vh_convert_color_proms RRRR_GGGG_BBBB() {
        return new RRRR_GGGG_BBBB_pi();
    }

    public Vh_convert_color_proms BBBB_GGGG_RRRR() {
        return new BBBB_GGGG_RRRR_pi();
    }

    public WriteHandler paletteram_RRRRGGGGBBBBxxxx_split1_w() {
        return new Paletteram_RRRRGGGGBBBBxxxx_split1_w();
    }

    public WriteHandler paletteram_RRRRGGGGBBBBxxxx_split2_w() {
        return new Paletteram_RRRRGGGGBBBBxxxx_split2_w();
    }

    public void changecolor_xBBBBBGGGGGRRRRR(int color, int data) {
        int r = data >> 0 & 0x1F;
        int g = data >> 5 & 0x1F;
        int b = data >> 10 & 0x1F;
        this.palette_set_color(color, r <<= 3, g <<= 3, b <<= 3);
    }

    public void changecolor_xxxxRRRRGGGGBBBB(int color, int data) {
        int r = data >> 8 & 0xF;
        int g = data >> 4 & 0xF;
        int b = data >> 0 & 0xF;
        r = r << 4 | r;
        g = g << 4 | g;
        b = b << 4 | b;
        this.palette_set_color(color, r, g, b);
    }

    public WriteHandler paletteram_xxxxRRRRGGGGBBBB_swap_w() {
        return new Paletteram_xxxxRRRRGGGGBBBB_swap_w();
    }

    public void changecolor_RRRRGGGGBBBBxxxx(int color, int data) {
        int r = data >> 12 & 0xF;
        int g = data >> 8 & 0xF;
        int b = data >> 4 & 0xF;
        r = r << 4 | r;
        g = g << 4 | g;
        b = b << 4 | b;
        this.palette_set_color(color, r, g, b);
    }

    public WriteHandler paletteram_RRRRGGGGBBBBxxxx_swap_w() {
        return new Paletteram_RRRRGGGGBBBBxxxx_swap_w();
    }

    public void init_bis(MachineDriver md) {
        this.md = md;
        this.RAM = md.REGIONS[0];
        this.PROM = md.REGIONS[16];
        this.GFX_REGIONS = new int[8][];
        this.GFX_REGIONS[0] = md.REGIONS[8];
        this.GFX_REGIONS[1] = md.REGIONS[9];
        this.GFX_REGIONS[2] = md.REGIONS[10];
        this.GFX_REGIONS[3] = md.REGIONS[11];
        this.GFX_REGIONS[4] = md.REGIONS[12];
        this.GFX_REGIONS[5] = md.REGIONS[13];
        this.GFX_REGIONS[6] = md.REGIONS[14];
        this.GFX_REGIONS[7] = md.REGIONS[15];
        this.color_prom = md.REGIONS[16];
        this.dirtybuffer = new boolean[videoram_size];
        int j = 0;
        while (j < videoram_size) {
            this.dirtybuffer[j] = true;
            ++j;
        }
        this.Machine_drv_total_colors = md.pal;
        this.Machine_gfx = new int[8];
        int i = 0;
        while (i < 8) {
            this.Machine_gfx[i] = i;
            ++i;
        }
        this.Machine_visible_area = 1;
        this.Machine_visible_area_min_x = md.visible[0];
        this.Machine_visible_area_max_x = md.visible[1];
        this.Machine_visible_area_min_y = md.visible[2];
        this.Machine_visible_area_max_y = md.visible[3];
    }

    public void init(MachineDriver md) {
        this.md = md;
        this.width = md.w;
        this.height = md.h;
        this.visible = md.visible;
        this.cliprect = md.visible;
        this.gdi = md.gfx;
        this.total_colors = md.pal;
        this.palette = new int[this.total_colors];
        this.palette_used_colors = new int[7 * md.pal];
        this.Machine_pens = this.palette;
        this.color = md.col;
        this.rot = md.ROT;
        this.pixels = new int[(this.visible[1] + 1 - this.visible[0]) * (this.visible[3] + 1 - this.visible[2])];
        boolean bl = this.videoModifiesPalette = (md.videoFlags & 4) != 0;
        if ((md.videoFlags & 0x10) != 0) {
            this.buffered_spriteram = new int[spriteram_size];
        }
        this.vX = -this.visible[0];
        this.vY = -this.visible[2];
        switch (this.rot) {
            case 0: {
                this.vX = -this.visible[0];
                this.vY = -this.visible[2];
            }
            case 2: {
                this.backBuffer = new BitMapImpl(this.visible[1] + 1 - this.visible[0], this.visible[3] + 1 - this.visible[2], this.pixels);
                break;
            }
            case 1: {
                this.vX = -this.visible[0];
                this.vY = -this.visible[2];
            }
            case 3: {
                this.backBuffer = new BitMapImpl(this.visible[3] + 1 - this.visible[2], this.visible[1] + 1 - this.visible[0], this.pixels);
            }
        }
        this.bitmap = this.backBuffer;
        this.tmpbitmap = new BitMapImpl(this.backBuffer.getWidth(), this.backBuffer.getHeight());
        try {
            this.gfxMan = new GfxManager[this.gdi.length];
            this.color_table = new int[this.gdi.length][];
            int i = 0;
            while (i < this.gdi.length) {
                this.color_table[i] = new int[this.gdi[i].numberOfColors << this.gdi[i].gfx.planes];
                int n = 0;
                while (n < this.color_table[i].length) {
                    this.color_table[i][n] = n + this.gdi[i].colorOffset;
                    ++n;
                }
                this.gfxMan[i] = new GfxManager();
                this.gfxMan[i].init(this.gdi[i], this.palette, this.color_table[i], 0, this.rot, md.videoFlags);
                ++i;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void palette_set_color(int c, int r, int g, int b) {
        int rgb = r << 16 | g << 8 | b;
        if (this.palette_get_color(c) != rgb) {
            this.palette_set_color(c, rgb);
        }
    }

    public void palette_set_color(int c, int rgb) {
        this.palette[c] = rgb;
        if (this.videoModifiesPalette) {
            int i = 0;
            while (i < this.gfxMan.length) {
                this.gfxMan[i].changePalette(c, rgb);
                ++i;
            }
        }
    }

    public void palette_change_color(int c, int r, int g, int b) {
        this.palette_set_color(c, r, g, b);
    }

    public int palette_get_color(int c) {
        return this.palette[c];
    }

    public void palette_init() {
    }

    public void eof_callback() {
    }

    public int vh_start() {
        return 0;
    }

    public void vh_stop() {
    }

    public BitMap video_update() {
        return this.bitmap;
    }

    public void video_post_update() {
        if (this.videoModifiesPalette) {
            int i = 0;
            while (i < this.gfxMan.length) {
                this.gfxMan[i].refresh();
                ++i;
            }
        }
    }

    protected int TOTAL_COLORS(int i) {
        return this.gdi[i].numberOfColors << this.gdi[i].gfx.planes;
    }

    protected void COLOR(int p, int i, int col) {
        this.color_table[p][i] = col;
    }

    protected int color_granularity(int i) {
        return 1 << this.gdi[i].gfx.planes;
    }

    protected void drawgfx(BitMap target, int type, int tile, int color, boolean flipx, boolean flipy, int x, int y, int transparency, int transcolor) {
        switch (this.rot) {
            case 0: {
                this.gfxMan[type].drawTile(target, tile, color, flipx, flipy, x + this.vX, y + this.vY, transparency, transcolor);
                break;
            }
            case 1: {
                this.gfxMan[type].drawTile(target, tile, color, flipy, flipx, x + this.vX, y + this.vY, transparency, transcolor);
                break;
            }
            case 2: {
                this.gfxMan[type].drawTile(target, tile, color, flipx, flipy, x + this.vX, y + this.vY, transparency, transcolor);
                break;
            }
            case 3: {
                this.gfxMan[type].drawTile(target, tile, color, flipy, flipx, x + this.vX, y + this.vY, transparency, transcolor);
            }
        }
    }

    protected void drawgfx(BitMap target, int type, int tile, int color, int flipx, int flipy, int x, int y, int transparency, int transcolor) {
        switch (this.rot) {
            case 0: {
                this.gfxMan[type].drawTile(target, tile, color, flipx != 0, flipy != 0, x + this.vX, y + this.vY, transparency, transcolor);
                break;
            }
            case 1: {
                this.gfxMan[type].drawTile(target, tile, color, flipy != 0, flipx != 0, x + this.vX, y + this.vY, transparency, transcolor);
                break;
            }
            case 2: {
                this.gfxMan[type].drawTile(target, tile, color, flipx != 0, flipy != 0, x + this.vX, y + this.vY, transparency, transcolor);
                break;
            }
            case 3: {
                this.gfxMan[type].drawTile(target, tile, color, flipy != 0, flipx != 0, x + this.vX, y + this.vY, transparency, transcolor);
            }
        }
    }

    protected void drawgfx(BitMap target, int type, int tile, int color, int flipx, int flipy, int x, int y, int area, int transparency, int transcolor) {
        if (area == 1) {
            x += this.vX;
            y += this.vY;
        }
        switch (this.rot) {
            case 0: {
                this.gfxMan[type].drawTile(target, tile, color, flipx != 0, flipy != 0, x, y, transparency, transcolor);
                break;
            }
            case 1: {
                this.gfxMan[type].drawTile(target, tile, color, flipy != 0, flipx != 0, x, y, transparency, transcolor);
                break;
            }
            case 2: {
                this.gfxMan[type].drawTile(target, tile, color, flipx != 0, flipy != 0, x, y, transparency, transcolor);
                break;
            }
            case 3: {
                this.gfxMan[type].drawTile(target, tile, color, flipy != 0, flipx != 0, x, y, transparency, transcolor);
            }
        }
    }

    protected void plot_pixel(BitMap dest, int x, int y, int color) {
        dest.setPixelFast(x, y, color);
    }

    protected int read_pixel(BitMap bm, int x, int y) {
        return bm.getPixel(x, y);
    }

    protected void copybitmap(BitMap dest, BitMap src, int rows, int rowscroll, int cols, int colscroll, int area, int transparency, int transcolor) {
        src.toPixels(this.pixels);
    }

    protected int get_black_pen() {
        return 0;
    }

    protected int[] visible_area() {
        return this.visible;
    }

    protected void fillbitmap(BitMap dest, int rgb, int[] area) {
        try {
            int i = 0;
            while (true) {
                this.pixels[i] = rgb;
                ++i;
            }
        }
        catch (Exception exception) {
            return;
        }
    }

    protected void fillbitmap(BitMap dest, int rgb, int s) {
        try {
            int i = 0;
            while (true) {
                this.pixels[i] = rgb;
                ++i;
            }
        }
        catch (Exception exception) {
            return;
        }
    }

    public void buffer_spriteram_w(int offset, int data) {
        int ofs = spriteram;
        int i = 0;
        while (i < spriteram_size) {
            this.buffered_spriteram[i] = this.RAM[ofs++];
            ++i;
        }
    }

    protected void copyscrollbitmap(BitMap dest, BitMap src, int rows, int rowscroll, int cols, int colscroll, int transparency, int transcolor) {
        if (rows == 1 && cols == 1) {
            int h;
            int w;
            int sh;
            int sw;
            if ((this.rot & 1) == 0) {
                sw = src.getWidth();
                sh = src.getHeight();
                rowscroll &= sw - 1;
                colscroll &= sh - 1;
                w = dest.getWidth();
                h = dest.getHeight();
            } else {
                sh = src.getWidth();
                sw = src.getHeight();
                int r = rowscroll;
                int c = colscroll;
                colscroll = r & sw - 1;
                rowscroll = c & sh - 1;
                w = dest.getWidth();
                h = dest.getHeight();
            }
            if (rowscroll + w <= sw && colscroll + h <= sh) {
                src.toBitMap(dest, 0, 0, rowscroll, colscroll, w, h);
            } else if (rowscroll + w > sw && colscroll + h <= sh) {
                src.toBitMap(dest, 0, 0, rowscroll, colscroll, sw - rowscroll, h);
                src.toBitMap(dest, sw - rowscroll, 0, rowscroll + (sw - rowscroll), colscroll, w - (sw - rowscroll), h);
            } else if (rowscroll + w <= sw && colscroll + h > sh) {
                src.toBitMap(dest, 0, 0, rowscroll, colscroll, w, h - (colscroll + h - sh));
                src.toBitMap(dest, 0, h - (colscroll + h - sh), rowscroll, 0, w, colscroll + h - sh);
            } else {
                src.toBitMap(dest, sw - rowscroll, sh - colscroll, 0, 0, rowscroll + w - sw, colscroll + h - sh);
                src.toBitMap(dest, 0, sh - colscroll, rowscroll, 0, sw - rowscroll, colscroll + h - sh);
                src.toBitMap(dest, sw - rowscroll, 0, 0, colscroll, rowscroll + w - sw, sh - colscroll);
                src.toBitMap(dest, 0, 0, rowscroll, colscroll, sw - rowscroll, sh - colscroll);
            }
        }
    }

    protected final void copyscrollbitmap(BitMap target, BitMap src, int rows, int[] scroll, int cols, int colscroll, int[] clip, int transparency, int transcolor) {
        block12: {
            if (cols != 0 || colscroll != 0) break block12;
            int sw = src.getWidth();
            int sh = src.getHeight();
            if ((this.rot & 1) == 0) {
                int tt = transparency == 2 ? transcolor : -1;
                int tw = target.getWidth() + (clip[0] << 1);
                int th = target.getHeight();
                int rowheight = sh / rows;
                int ydst = 0;
                int ysrc = clip[2];
                int i = 0;
                if (clip[2] >= rowheight) {
                    i = clip[2] / rowheight;
                }
                while (i < rows) {
                    int x = -scroll[i] + clip[0];
                    if (x < 0) {
                        x += sw;
                    }
                    if (x + target.getWidth() <= sw) {
                        src.toBitMap(target, 0, ydst, x, ysrc, target.getWidth(), rowheight, tt);
                    } else {
                        src.toBitMap(target, 0, ydst, x, ysrc, sw - x, rowheight, tt);
                        src.toBitMap(target, sw - x, ydst, 0, ysrc, target.getWidth() - (sw - x), rowheight, tt);
                    }
                    ysrc += rowheight;
                    ydst += rowheight;
                    ++i;
                }
            } else {
                int tw = target.getWidth() + (clip[2] << 1);
                int th = target.getHeight() + (clip[0] << 1);
                int rowheight = tw / rows;
                int i = 0;
                while (i < rows) {
                    int y = i * rowheight;
                    int yt = y - (clip[2] << 1);
                    if (yt >= 0 && yt < target.getWidth()) {
                        int x = -scroll[i - 2] + th;
                        if (x < 0) {
                            x += sh;
                        }
                        if (x + target.getHeight() <= sh) {
                            src.toBitMap(target, yt, 0, y, x, rowheight, target.getHeight());
                        } else {
                            src.toBitMap(target, yt, 0, y, x, rowheight, sh - x);
                            src.toBitMap(target, yt, sh - x, y, 0, rowheight, target.getHeight() - (sh - x));
                        }
                    }
                    ++i;
                }
            }
        }
    }

    protected final void copyscrollbitmap(BitMap target, BitMap src, int cols, int colscroll, int rows, int[] scroll, int[] clip, int transparency, int transcolor) {
        block12: {
            if (cols != 0 || colscroll != 0) break block12;
            int sw = src.getWidth();
            int sh = src.getHeight();
            if ((this.rot & 1) == 1) {
                int tw = target.getWidth() + (clip[0] << 1);
                int th = target.getHeight();
                int rowheight = th / rows;
                int i = 0;
                while (i < rows) {
                    int y = i * rowheight;
                    if (y >= 0 && y < target.getHeight()) {
                        int x = -scroll[i] + clip[2];
                        if (x < 0) {
                            x += sw;
                        }
                        if (x + target.getWidth() <= sw) {
                            src.toBitMap(target, 0, y, x, y, target.getWidth(), rowheight);
                        } else {
                            src.toBitMap(target, 0, y, x, y, sw - x, rowheight);
                            src.toBitMap(target, sw - x, y, 0, y, target.getWidth() - (sw - x), rowheight);
                        }
                    }
                    ++i;
                }
            } else {
                int tw = target.getWidth() + (clip[2] << 1);
                int th = target.getHeight() + (clip[0] << 1);
                int rowheight = tw / rows;
                int i = 0;
                while (i < rows) {
                    int y = i * rowheight;
                    int yt = y - (clip[2] << 1);
                    if (yt >= 0 && yt < target.getWidth()) {
                        int x = -scroll[i - 2] + th;
                        if (x < 0) {
                            x += sh;
                        }
                        if (x + target.getHeight() <= sh) {
                            src.toBitMap(target, yt, 0, y, x, rowheight, target.getHeight());
                        } else {
                            src.toBitMap(target, yt, 0, y, x, rowheight, sh - x);
                            src.toBitMap(target, yt, sh - x, y, 0, rowheight, target.getHeight() - (sh - x));
                        }
                    }
                    ++i;
                }
            }
        }
    }

    public class Paletteram_r
    implements ReadHandler {
        public int read(int offset) {
            return MAMEVideo.this.RAM[offset];
        }
    }

    public class Videoram_w
    implements WriteHandler {
        public void write(int offset, int data) {
            if (MAMEVideo.this.RAM[offset] != data) {
                MAMEVideo.this.dirtybuffer[offset - MAMEVideo.videoram] = true;
                MAMEVideo.this.RAM[offset] = data;
            }
        }
    }

    public class Colorram_w
    implements WriteHandler {
        public void write(int offset, int data) {
            if (MAMEVideo.this.RAM[offset] != data) {
                MAMEVideo.this.dirtybuffer[offset - MAMEVideo.colorram] = true;
                MAMEVideo.this.RAM[offset] = data;
            }
        }
    }

    public class RRRR_GGGG_BBBB_pi
    implements Vh_convert_color_proms {
        public void palette_init() {
            System.out.println("Machine_drv_total_colors " + MAMEVideo.this.Machine_drv_total_colors);
            int i = 0;
            while (i < MAMEVideo.this.Machine_drv_total_colors) {
                int bit0 = MAMEVideo.this.color_prom[i] >> 0 & 1;
                int bit1 = MAMEVideo.this.color_prom[i] >> 1 & 1;
                int bit2 = MAMEVideo.this.color_prom[i] >> 2 & 1;
                int bit3 = MAMEVideo.this.color_prom[i] >> 3 & 1;
                int r = 14 * bit0 + 31 * bit1 + 67 * bit2 + 143 * bit3;
                bit0 = MAMEVideo.this.color_prom[i + MAMEVideo.this.Machine_drv_total_colors] >> 0 & 1;
                bit1 = MAMEVideo.this.color_prom[i + MAMEVideo.this.Machine_drv_total_colors] >> 1 & 1;
                bit2 = MAMEVideo.this.color_prom[i + MAMEVideo.this.Machine_drv_total_colors] >> 2 & 1;
                bit3 = MAMEVideo.this.color_prom[i + MAMEVideo.this.Machine_drv_total_colors] >> 3 & 1;
                int g = 14 * bit0 + 31 * bit1 + 67 * bit2 + 143 * bit3;
                bit0 = MAMEVideo.this.color_prom[i + 2 * MAMEVideo.this.Machine_drv_total_colors] >> 0 & 1;
                bit1 = MAMEVideo.this.color_prom[i + 2 * MAMEVideo.this.Machine_drv_total_colors] >> 1 & 1;
                bit2 = MAMEVideo.this.color_prom[i + 2 * MAMEVideo.this.Machine_drv_total_colors] >> 2 & 1;
                bit3 = MAMEVideo.this.color_prom[i + 2 * MAMEVideo.this.Machine_drv_total_colors] >> 3 & 1;
                int b = 14 * bit0 + 31 * bit1 + 67 * bit2 + 143 * bit3;
                MAMEVideo.this.palette_set_color(i, r, g, b);
                ++i;
            }
        }
    }

    public class BBBB_GGGG_RRRR_pi
    implements Vh_convert_color_proms {
        public void palette_init() {
            int i = 0;
            while (i < MAMEVideo.this.Machine_drv_total_colors) {
                int bit0 = MAMEVideo.this.color_prom[i] >> 0 & 1;
                int bit1 = MAMEVideo.this.color_prom[i] >> 1 & 1;
                int bit2 = MAMEVideo.this.color_prom[i] >> 2 & 1;
                int bit3 = MAMEVideo.this.color_prom[i] >> 3 & 1;
                int r = 14 * bit0 + 31 * bit1 + 67 * bit2 + 143 * bit3;
                bit0 = MAMEVideo.this.color_prom[i + MAMEVideo.this.Machine_drv_total_colors] >> 0 & 1;
                bit1 = MAMEVideo.this.color_prom[i + MAMEVideo.this.Machine_drv_total_colors] >> 1 & 1;
                bit2 = MAMEVideo.this.color_prom[i + MAMEVideo.this.Machine_drv_total_colors] >> 2 & 1;
                bit3 = MAMEVideo.this.color_prom[i + MAMEVideo.this.Machine_drv_total_colors] >> 3 & 1;
                int g = 14 * bit0 + 31 * bit1 + 67 * bit2 + 143 * bit3;
                bit0 = MAMEVideo.this.color_prom[i + 2 * MAMEVideo.this.Machine_drv_total_colors] >> 0 & 1;
                bit1 = MAMEVideo.this.color_prom[i + 2 * MAMEVideo.this.Machine_drv_total_colors] >> 1 & 1;
                bit2 = MAMEVideo.this.color_prom[i + 2 * MAMEVideo.this.Machine_drv_total_colors] >> 2 & 1;
                bit3 = MAMEVideo.this.color_prom[i + 2 * MAMEVideo.this.Machine_drv_total_colors] >> 3 & 1;
                int b = 14 * bit0 + 31 * bit1 + 67 * bit2 + 143 * bit3;
                MAMEVideo.this.palette_set_color(i, r, g, b);
                ++i;
            }
        }
    }

    public class Paletteram_RRRRGGGGBBBBxxxx_split1_w
    implements WriteHandler {
        public void write(int address, int data) {
            MAMEVideo.this.RAM[address] = data;
            MAMEVideo.this.changecolor_RRRRGGGGBBBBxxxx(address - paletteram, MAMEVideo.this.RAM[address] | MAMEVideo.this.RAM[address - paletteram + paletteram_2] << 8);
        }
    }

    public class Paletteram_RRRRGGGGBBBBxxxx_split2_w
    implements WriteHandler {
        public void write(int address, int data) {
            MAMEVideo.this.RAM[address] = data;
            MAMEVideo.this.changecolor_RRRRGGGGBBBBxxxx(address - paletteram_2, MAMEVideo.this.RAM[address - paletteram_2 + paletteram] | MAMEVideo.this.RAM[address] << 8);
        }
    }

    public class Paletteram_xxxxRRRRGGGGBBBB_swap_w
    implements WriteHandler {
        public void write(int address, int data) {
            MAMEVideo.this.RAM[address] = data;
            MAMEVideo.this.changecolor_xxxxRRRRGGGGBBBB(address - paletteram >> 1, MAMEVideo.this.RAM[address | 1] | MAMEVideo.this.RAM[address & 0xFFFFFFFE] << 8);
        }
    }

    public class Paletteram_RRRRGGGGBBBBxxxx_swap_w
    implements WriteHandler {
        public void write(int address, int data) {
            MAMEVideo.this.RAM[address] = data;
            MAMEVideo.this.changecolor_RRRRGGGGBBBBxxxx(address - paletteram >> 1, MAMEVideo.this.RAM[address | 1] | MAMEVideo.this.RAM[address & 0xFFFFFFFE] << 8);
        }
    }
}

