/*
 * Decompiled with CFR 0.152.
 */
package jef.cpu;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import jef.cpu.Cpu;
import jef.cpuboard.CpuBoard;

public final class I8080
implements Cpu {
    public int A;
    public int F;
    public int B;
    public int C;
    public int D;
    public int E;
    public int H;
    public int L;
    public int I;
    public int R;
    public int A1;
    public int F1;
    public int B1;
    public int C1;
    public int D1;
    public int E1;
    public int H1;
    public int L1;
    public int PC;
    public int SP;
    private CpuBoard ram;
    public boolean state_HALT = false;
    private boolean state_INIT = false;
    public int IM = 0;
    public boolean IFF0 = false;
    public boolean IFF1 = false;
    public int I_Vector = 0;
    public boolean IRQ = false;
    public boolean NMI = false;
    private boolean goingToirq = false;
    public int cycles_left = 0;
    private int CurInstr = 0;
    private int PPC = 0;
    public String logFile = "I8080.log";
    public int debugLevel = 0;
    public int debugFrom;
    public int debugSkipped = 0;
    public int debugUntil;
    public int debugMemLoc = 0;
    public int debugMemVal = 0;
    public int ignoreBreakpoint = 0;
    public boolean debugDisabled = true;
    public boolean debugSelectMemEqVal = false;
    public boolean debugSelectStart = false;
    private DataOutputStream log;
    private DataInputStream opcodeReader;
    private String[] opcodes1;
    private String[] opcodes2;
    private String[] opcodes3;
    private int opcgroup;
    public int error = 0;
    private static final boolean[] parity = new boolean[256];
    private static final int[] SZ = new int[256];
    private static final int[] SZP = new int[256];
    private static final int[] SZHV_inc = new int[256];
    private static final int[] SZHV_dec = new int[256];
    private static final int[] SZHVC_add = new int[131072];
    private static final int[] SZHVC_sub = new int[131072];
    private static final int INTERRUPT_IRQ = 0;
    private static final int INTERRUPT_NMI = 1;
    private String tag;

    static {
        int p = 0;
        int i = 0;
        while (i < 256) {
            boolean bp = true;
            int j = 0;
            while (j < 8) {
                if ((i & 1 << j) != 0) {
                    bp = !bp;
                }
                ++j;
            }
            I8080.parity[i] = bp;
            p = 0;
            if ((i & 1) != 0) {
                ++p;
            }
            if ((i & 2) != 0) {
                ++p;
            }
            if ((i & 4) != 0) {
                ++p;
            }
            if ((i & 8) != 0) {
                ++p;
            }
            if ((i & 0x10) != 0) {
                ++p;
            }
            if ((i & 0x20) != 0) {
                ++p;
            }
            if ((i & 0x40) != 0) {
                ++p;
            }
            if ((i & 0x80) != 0) {
                ++p;
            }
            I8080.SZ[i] = i != 0 ? i & 0x80 : 64;
            int n = i;
            SZ[n] = SZ[n] | i & 0x28;
            I8080.SZP[i] = SZ[i] | ((p & 1) != 0 ? 0 : 4);
            I8080.SZHV_inc[i] = SZ[i];
            if (i == 128) {
                int n2 = i;
                SZHV_inc[n2] = SZHV_inc[n2] | 4;
            }
            if ((i & 0xF) == 0) {
                int n3 = i;
                SZHV_inc[n3] = SZHV_inc[n3] | 0x10;
            }
            I8080.SZHV_dec[i] = SZ[i] | 2;
            if (i == 127) {
                int n4 = i;
                SZHV_dec[n4] = SZHV_dec[n4] | 4;
            }
            if ((i & 0xF) == 15) {
                int n5 = i;
                SZHV_dec[n5] = SZHV_dec[n5] | 0x10;
            }
            ++i;
        }
        int SF = 128;
        int ZF = 64;
        int YF = 32;
        int HF = 16;
        int XF = 8;
        int VF = 4;
        int NF = 2;
        int CF = 1;
        int padd = 0;
        int padc = 65536;
        int psub = 0;
        int psbc = 65536;
        int oldval = 0;
        while (oldval < 256) {
            int newval = 0;
            while (newval < 256) {
                int val = newval - oldval;
                I8080.SZHVC_add[padd] = newval != 0 ? ((newval & 0x80) != 0 ? SF : 0) : ZF;
                int n = padd;
                SZHVC_add[n] = SZHVC_add[n] | newval & (YF | XF);
                if ((newval & 0xF) < (oldval & 0xF)) {
                    int n6 = padd;
                    SZHVC_add[n6] = SZHVC_add[n6] | HF;
                }
                if (newval < oldval) {
                    int n7 = padd;
                    SZHVC_add[n7] = SZHVC_add[n7] | CF;
                }
                if (((val ^ oldval ^ 0x80) & (val ^ newval) & 0x80) != 0) {
                    int n8 = padd;
                    SZHVC_add[n8] = SZHVC_add[n8] | VF;
                }
                ++padd;
                val = newval - oldval - 1;
                I8080.SZHVC_add[padc] = newval != 0 ? ((newval & 0x80) != 0 ? SF : 0) : ZF;
                int n9 = padc;
                SZHVC_add[n9] = SZHVC_add[n9] | newval & (YF | XF);
                if ((newval & 0xF) <= (oldval & 0xF)) {
                    int n10 = padc;
                    SZHVC_add[n10] = SZHVC_add[n10] | HF;
                }
                if (newval <= oldval) {
                    int n11 = padc;
                    SZHVC_add[n11] = SZHVC_add[n11] | CF;
                }
                if (((val ^ oldval ^ 0x80) & (val ^ newval) & 0x80) != 0) {
                    int n12 = padc;
                    SZHVC_add[n12] = SZHVC_add[n12] | VF;
                }
                ++padc;
                val = oldval - newval;
                I8080.SZHVC_sub[psub] = newval != 0 ? ((newval & 0x80) != 0 ? NF | SF : NF) : NF | ZF;
                int n13 = psub;
                SZHVC_sub[n13] = SZHVC_sub[n13] | newval & (YF | XF);
                if ((newval & 0xF) > (oldval & 0xF)) {
                    int n14 = psub;
                    SZHVC_sub[n14] = SZHVC_sub[n14] | HF;
                }
                if (newval > oldval) {
                    int n15 = psub;
                    SZHVC_sub[n15] = SZHVC_sub[n15] | CF;
                }
                if (((val ^ oldval) & (oldval ^ newval) & 0x80) != 0) {
                    int n16 = psub;
                    SZHVC_sub[n16] = SZHVC_sub[n16] | VF;
                }
                ++psub;
                val = oldval - newval - 1;
                I8080.SZHVC_sub[psbc] = newval != 0 ? ((newval & 0x80) != 0 ? NF | SF : NF) : NF | ZF;
                int n17 = psbc;
                SZHVC_sub[n17] = SZHVC_sub[n17] | newval & (YF | XF);
                if ((newval & 0xF) >= (oldval & 0xF)) {
                    int n18 = psbc;
                    SZHVC_sub[n18] = SZHVC_sub[n18] | HF;
                }
                if (newval >= oldval) {
                    int n19 = psbc;
                    SZHVC_sub[n19] = SZHVC_sub[n19] | CF;
                }
                if (((val ^ oldval) & (oldval ^ newval) & 0x80) != 0) {
                    int n20 = psbc;
                    SZHVC_sub[n20] = SZHVC_sub[n20] | VF;
                }
                ++psbc;
                ++newval;
            }
            ++oldval;
        }
    }

    public void setTag(String tag) {
        this.tag = tag;
    }

    public String getTag() {
        return this.tag;
    }

    public boolean init(CpuBoard ram, int debug) {
        this.ram = ram;
        return true;
    }

    public final long getInstruction() {
        return this.CurInstr;
    }

    public final void interrupt(int type, boolean irq) {
        if (type == 1) {
            this.NMI = true;
        } else {
            this.IRQ = true;
        }
    }

    public final void reset() {
        this.SP = 65536;
        this.PC = 0;
        this.A = 0;
        this.F = 0;
        this.B = 0;
        this.C = 0;
        this.D = 0;
        this.E = 0;
        this.H = 0;
        this.L = 0;
        this.I = 0;
        this.R = 0;
        this.cycles_left = 0;
        this.A1 = 0;
        this.F1 = 0;
        this.B1 = 0;
        this.C1 = 0;
        this.D1 = 0;
        this.E1 = 0;
        this.H1 = 0;
        this.L1 = 0;
    }

    public final void exec(int num_cycles) {
        this.cycles_left += num_cycles;
        int _error = this.error;
        boolean _NMI = this.NMI;
        boolean _IRQ = this.IRQ;
        boolean _IFF0 = this.IFF0;
        boolean _IFF1 = this.IFF1;
        int instruction = this.CurInstr;
        int _PC = this.PC;
        int _PPC = this.PPC;
        int _SP = this.SP;
        int _B = this.B;
        int _C = this.C;
        int _D = this.D;
        int _E = this.E;
        int _H = this.H;
        int _L = this.L;
        int _A = this.A;
        CpuBoard ram = this.ram;
        while (this.cycles_left > 0 && _error == 0) {
            if (_NMI || this.IFF0 && this.IRQ) {
                if (_NMI) {
                    if (!this.goingToirq) {
                        this.state_HALT = false;
                        _IFF1 = _IFF0;
                        _IFF0 = false;
                        _NMI = false;
                        ram.write16fast(_SP -= 2, _PC);
                        _PC = 16;
                        this.cycles_left -= 13;
                    } else {
                        this.goingToirq = false;
                    }
                }
                if (_IFF0 && _IRQ) {
                    if (!this.goingToirq) {
                        this.state_HALT = false;
                        _IFF0 = false;
                        _IRQ = false;
                        ram.write16fast(_SP -= 2, _PC);
                        _PC = 8;
                        this.cycles_left -= 13;
                    } else {
                        this.goingToirq = false;
                    }
                }
            }
            instruction = ram.read8opc(_PC);
            _PPC = _PC;
            _PC = _PC + 1 & 0xFFFF;
            switch (instruction) {
                case 0: {
                    this.cycles_left -= 4;
                    break;
                }
                case 1: {
                    this.cycles_left -= 10;
                    _B = ram.read8(_PC + 1);
                    _C = ram.read8arg(_PC);
                    _PC += 2;
                    break;
                }
                case 2: {
                    this.cycles_left -= 7;
                    ram.write8(_B << 8 | _C, _A);
                    break;
                }
                case 3: {
                    this.cycles_left -= 6;
                    int Reg1 = (_B << 8 | _C) + 1 & 0xFFFF;
                    _B = Reg1 >> 8;
                    _C = Reg1 & 0xFF;
                    break;
                }
                case 4: {
                    this.cycles_left -= 4;
                    _B = this.inc8(_B);
                    break;
                }
                case 5: {
                    this.cycles_left -= 4;
                    _B = this.dec8(_B);
                    break;
                }
                case 6: {
                    this.cycles_left -= 7;
                    _B = ram.read8arg(_PC++);
                    break;
                }
                case 7: {
                    this.cycles_left -= 4;
                    _A = this.rlc_A(_A);
                    break;
                }
                case 8: {
                    this.cycles_left -= 4;
                    int Reg1 = _A;
                    _A = this.A1;
                    this.A1 = Reg1;
                    Reg1 = this.F;
                    this.F = this.F1;
                    this.F1 = Reg1;
                    break;
                }
                case 9: {
                    this.cycles_left -= 11;
                    int Reg1 = this.add16(_H << 8 | _L, _B << 8 | _C);
                    _L = Reg1 & 0xFF;
                    _H = Reg1 >> 8;
                    break;
                }
                case 10: {
                    this.cycles_left -= 7;
                    _A = ram.read8(_B << 8 | _C);
                    break;
                }
                case 11: {
                    this.cycles_left -= 6;
                    int Reg1 = (_B << 8 | _C) - 1 & 0xFFFF;
                    _B = Reg1 >> 8;
                    _C = Reg1 & 0xFF;
                    break;
                }
                case 12: {
                    this.cycles_left -= 4;
                    _C = this.inc8(_C);
                    break;
                }
                case 13: {
                    this.cycles_left -= 4;
                    _C = this.dec8(_C);
                    break;
                }
                case 14: {
                    this.cycles_left -= 7;
                    _C = ram.read8arg(_PC++);
                    break;
                }
                case 15: {
                    this.cycles_left -= 4;
                    _A = this.rrc_A(_A);
                    break;
                }
                case 16: {
                    int Reg1;
                    _B = _B - 1 & 0xFF;
                    if (_B != 0) {
                        Reg1 = ram.read8arg(_PC++);
                        this.cycles_left -= 13;
                        _PC += Reg1 - ((Reg1 & 0x80) << 1);
                        break;
                    }
                    ++_PC;
                    this.cycles_left -= 8;
                    break;
                }
                case 17: {
                    this.cycles_left -= 10;
                    _D = ram.read8(_PC + 1);
                    _E = ram.read8arg(_PC);
                    _PC += 2;
                    break;
                }
                case 18: {
                    this.cycles_left -= 7;
                    ram.write8(_D << 8 | _E, _A);
                    break;
                }
                case 19: {
                    this.cycles_left -= 6;
                    int Reg1 = (_D << 8 | _E) + 1 & 0xFFFF;
                    _D = Reg1 >> 8;
                    _E = Reg1 & 0xFF;
                    break;
                }
                case 20: {
                    this.cycles_left -= 4;
                    _D = this.inc8(_D);
                    break;
                }
                case 21: {
                    this.cycles_left -= 4;
                    _D = this.dec8(_D);
                    break;
                }
                case 22: {
                    this.cycles_left -= 7;
                    _D = ram.read8arg(_PC++);
                    break;
                }
                case 23: {
                    this.cycles_left -= 4;
                    _A = this.rl_A(_A);
                    break;
                }
                case 24: {
                    this.cycles_left -= 12;
                    int Reg1 = ram.read8arg(_PC++);
                    _PC += Reg1 - ((Reg1 & 0x80) << 1);
                    break;
                }
                case 25: {
                    this.cycles_left -= 11;
                    int Reg1 = this.add16(_H << 8 | _L, _D << 8 | _E);
                    _L = Reg1 & 0xFF;
                    _H = Reg1 >> 8;
                    break;
                }
                case 26: {
                    this.cycles_left -= 7;
                    _A = ram.read8(_D << 8 | _E);
                    break;
                }
                case 27: {
                    this.cycles_left -= 6;
                    int Reg1 = (_D << 8 | _E) - 1 & 0xFFFF;
                    _D = Reg1 >> 8;
                    _E = Reg1 & 0xFF;
                    break;
                }
                case 28: {
                    this.cycles_left -= 4;
                    _E = this.inc8(_E);
                    break;
                }
                case 29: {
                    this.cycles_left -= 4;
                    _E = this.dec8(_E);
                    break;
                }
                case 30: {
                    this.cycles_left -= 7;
                    _E = ram.read8arg(_PC++);
                    break;
                }
                case 31: {
                    this.cycles_left -= 4;
                    _A = this.rr_A(_A);
                    break;
                }
                case 32: {
                    int Reg1;
                    if ((this.F & 0x40) == 0) {
                        Reg1 = ram.read8arg(_PC++);
                        this.cycles_left -= 12;
                        _PC += Reg1 - ((Reg1 & 0x80) << 1);
                        break;
                    }
                    ++_PC;
                    this.cycles_left -= 7;
                    break;
                }
                case 33: {
                    this.cycles_left -= 10;
                    _H = ram.read8(_PC + 1);
                    _L = ram.read8arg(_PC);
                    _PC += 2;
                    break;
                }
                case 34: {
                    this.cycles_left -= 16;
                    ram.write16(ram.read16arg(_PC), _H << 8 | _L);
                    _PC += 2;
                    break;
                }
                case 35: {
                    this.cycles_left -= 6;
                    int Reg1 = (_H << 8 | _L) + 1 & 0xFFFF;
                    _H = Reg1 >> 8;
                    _L = Reg1 & 0xFF;
                    break;
                }
                case 36: {
                    this.cycles_left -= 4;
                    _H = this.inc8(_H);
                    break;
                }
                case 37: {
                    this.cycles_left -= 4;
                    _H = this.dec8(_H);
                    break;
                }
                case 38: {
                    this.cycles_left -= 7;
                    _H = ram.read8arg(_PC++);
                    break;
                }
                case 39: {
                    int Reg3;
                    this.cycles_left -= 4;
                    int Reg1 = _A;
                    int Reg2 = 0;
                    int c = Reg3 = this.F & 1;
                    if ((this.F & 0x10) != 0 || (Reg1 & 0xF) > 9) {
                        Reg2 |= 6;
                    }
                    if (Reg3 == 1 || Reg1 > 159 || Reg1 > 143 && (Reg1 & 0xF) > 9) {
                        Reg2 |= 0x60;
                        c = 1;
                    }
                    if (Reg1 > 153) {
                        c = 1;
                    }
                    if ((this.F & 2) != 0) {
                        this.cycles_left -= 4;
                        _A = this.subA_8(Reg2, _A);
                    } else {
                        this.cycles_left -= 4;
                        _A = this.addA_8(Reg2, _A);
                    }
                    this.F = this.F & 0xFE | c;
                    if (parity[_A]) {
                        this.F = this.F & 0xFB | 4;
                        break;
                    }
                    this.F &= 0xFB;
                    break;
                }
                case 40: {
                    int Reg1;
                    if ((this.F & 0x40) != 0) {
                        Reg1 = ram.read8arg(_PC++);
                        this.cycles_left -= 12;
                        _PC += Reg1 - ((Reg1 & 0x80) << 1);
                        break;
                    }
                    ++_PC;
                    this.cycles_left -= 7;
                    break;
                }
                case 41: {
                    this.cycles_left -= 11;
                    int Reg1 = this.add16(_H << 8 | _L, _H << 8 | _L);
                    _L = Reg1 & 0xFF;
                    _H = Reg1 >> 8;
                    break;
                }
                case 42: {
                    this.cycles_left -= 16;
                    _H = ram.read8(ram.read16arg(_PC) + 1);
                    _L = ram.read8(ram.read16arg(_PC));
                    _PC += 2;
                    break;
                }
                case 43: {
                    this.cycles_left -= 6;
                    int Reg1 = (_H << 8 | _L) - 1 & 0xFFFF;
                    _H = Reg1 >> 8;
                    _L = Reg1 & 0xFF;
                    break;
                }
                case 44: {
                    this.cycles_left -= 4;
                    _L = this.inc8(_L);
                    break;
                }
                case 45: {
                    this.cycles_left -= 4;
                    _L = this.dec8(_L);
                    break;
                }
                case 46: {
                    this.cycles_left -= 7;
                    _L = ram.read8arg(_PC++);
                    break;
                }
                case 47: {
                    this.cycles_left -= 4;
                    this.F = this.F & 0xC5 | 0x12 | (_A ^= 0xFF) & 0x28;
                    break;
                }
                case 48: {
                    int Reg1;
                    if ((this.F & 1) == 0) {
                        Reg1 = ram.read8arg(_PC++);
                        this.cycles_left -= 12;
                        _PC += Reg1 - ((Reg1 & 0x80) << 1);
                        break;
                    }
                    ++_PC;
                    this.cycles_left -= 7;
                    break;
                }
                case 49: {
                    this.cycles_left -= 10;
                    _SP = ram.read16(_PC);
                    _PC += 2;
                    break;
                }
                case 50: {
                    this.cycles_left -= 13;
                    ram.write8(ram.read16arg(_PC), _A);
                    _PC += 2;
                    break;
                }
                case 51: {
                    this.cycles_left -= 6;
                    _SP = _SP + 1 & 0xFFFF;
                    break;
                }
                case 52: {
                    this.cycles_left -= 11;
                    int Reg1 = _H << 8 | _L;
                    ram.write8(Reg1, this.inc8(ram.read8(Reg1)));
                    break;
                }
                case 53: {
                    this.cycles_left -= 11;
                    int Reg1 = _H << 8 | _L;
                    ram.write8(Reg1, this.dec8(ram.read8(Reg1)));
                    break;
                }
                case 54: {
                    this.cycles_left -= 10;
                    ram.write8(_H << 8 | _L, ram.read8arg(_PC++));
                    break;
                }
                case 55: {
                    this.cycles_left -= 4;
                    this.F = this.F & 0xC4 | 1 | _A & 0x28;
                    break;
                }
                case 56: {
                    int Reg1;
                    if ((this.F & 1) != 0) {
                        Reg1 = ram.read8arg(_PC++);
                        this.cycles_left -= 12;
                        _PC += Reg1 - ((Reg1 & 0x80) << 1);
                        break;
                    }
                    ++_PC;
                    this.cycles_left -= 7;
                    break;
                }
                case 57: {
                    this.cycles_left -= 11;
                    int Reg1 = this.add16(_H << 8 | _L, _SP);
                    _L = Reg1 & 0xFF;
                    _H = Reg1 >> 8;
                    break;
                }
                case 58: {
                    this.cycles_left -= 13;
                    _A = ram.read8(ram.read16arg(_PC));
                    _PC += 2;
                    break;
                }
                case 59: {
                    this.cycles_left -= 6;
                    _SP = _SP - 1 & 0xFFFF;
                    break;
                }
                case 60: {
                    this.cycles_left -= 4;
                    _A = this.inc8(_A);
                    break;
                }
                case 61: {
                    this.cycles_left -= 4;
                    _A = this.dec8(_A);
                    break;
                }
                case 62: {
                    this.cycles_left -= 7;
                    _A = ram.read8arg(_PC++);
                    break;
                }
                case 63: {
                    this.cycles_left -= 4;
                    this.F = (this.F & 0xC5 | (this.F & 1) << 4 | _A & 0x28) ^ 1;
                    break;
                }
                case 64: {
                    this.cycles_left -= 4;
                    break;
                }
                case 65: {
                    this.cycles_left -= 4;
                    _B = _C;
                    break;
                }
                case 66: {
                    this.cycles_left -= 4;
                    _B = _D;
                    break;
                }
                case 67: {
                    this.cycles_left -= 4;
                    _B = _E;
                    break;
                }
                case 68: {
                    this.cycles_left -= 4;
                    _B = _H;
                    break;
                }
                case 69: {
                    this.cycles_left -= 4;
                    _B = _L;
                    break;
                }
                case 70: {
                    this.cycles_left -= 7;
                    _B = ram.read8(_H << 8 | _L);
                    break;
                }
                case 71: {
                    this.cycles_left -= 4;
                    _B = _A;
                    break;
                }
                case 72: {
                    this.cycles_left -= 4;
                    _C = _B;
                    break;
                }
                case 73: {
                    this.cycles_left -= 4;
                    break;
                }
                case 74: {
                    this.cycles_left -= 4;
                    _C = _D;
                    break;
                }
                case 75: {
                    this.cycles_left -= 4;
                    _C = _E;
                    break;
                }
                case 76: {
                    this.cycles_left -= 4;
                    _C = _H;
                    break;
                }
                case 77: {
                    this.cycles_left -= 4;
                    _C = _L;
                    break;
                }
                case 78: {
                    this.cycles_left -= 7;
                    _C = ram.read8(_H << 8 | _L);
                    break;
                }
                case 79: {
                    this.cycles_left -= 4;
                    _C = _A;
                    break;
                }
                case 80: {
                    this.cycles_left -= 4;
                    _D = _B;
                    break;
                }
                case 81: {
                    this.cycles_left -= 4;
                    _D = _C;
                    break;
                }
                case 82: {
                    this.cycles_left -= 4;
                    break;
                }
                case 83: {
                    this.cycles_left -= 4;
                    _D = _E;
                    break;
                }
                case 84: {
                    this.cycles_left -= 4;
                    _D = _H;
                    break;
                }
                case 85: {
                    this.cycles_left -= 4;
                    _D = _L;
                    break;
                }
                case 86: {
                    this.cycles_left -= 7;
                    _D = ram.read8(_H << 8 | _L);
                    break;
                }
                case 87: {
                    this.cycles_left -= 4;
                    _D = _A;
                    break;
                }
                case 88: {
                    this.cycles_left -= 4;
                    _E = _B;
                    break;
                }
                case 89: {
                    this.cycles_left -= 4;
                    _E = _C;
                    break;
                }
                case 90: {
                    this.cycles_left -= 4;
                    _E = _D;
                    break;
                }
                case 91: {
                    this.cycles_left -= 4;
                    break;
                }
                case 92: {
                    this.cycles_left -= 4;
                    _E = _H;
                    break;
                }
                case 93: {
                    this.cycles_left -= 4;
                    _E = _L;
                    break;
                }
                case 94: {
                    this.cycles_left -= 7;
                    _E = ram.read8(_H << 8 | _L);
                    break;
                }
                case 95: {
                    this.cycles_left -= 4;
                    _E = _A;
                    break;
                }
                case 96: {
                    this.cycles_left -= 4;
                    _H = _B;
                    break;
                }
                case 97: {
                    this.cycles_left -= 4;
                    _H = _C;
                    break;
                }
                case 98: {
                    this.cycles_left -= 4;
                    _H = _D;
                    break;
                }
                case 99: {
                    this.cycles_left -= 4;
                    _H = _E;
                    break;
                }
                case 100: {
                    this.cycles_left -= 4;
                    break;
                }
                case 101: {
                    this.cycles_left -= 4;
                    _H = _L;
                    break;
                }
                case 102: {
                    this.cycles_left -= 7;
                    _H = ram.read8(_H << 8 | _L);
                    break;
                }
                case 103: {
                    this.cycles_left -= 4;
                    _H = _A;
                    break;
                }
                case 104: {
                    this.cycles_left -= 4;
                    _L = _B;
                    break;
                }
                case 105: {
                    this.cycles_left -= 4;
                    _L = _C;
                    break;
                }
                case 106: {
                    this.cycles_left -= 4;
                    _L = _D;
                    break;
                }
                case 107: {
                    this.cycles_left -= 4;
                    _L = _E;
                    break;
                }
                case 108: {
                    this.cycles_left -= 4;
                    _L = _H;
                    break;
                }
                case 109: {
                    this.cycles_left -= 4;
                    break;
                }
                case 110: {
                    this.cycles_left -= 7;
                    _L = ram.read8(_H << 8 | _L);
                    break;
                }
                case 111: {
                    this.cycles_left -= 4;
                    _L = _A;
                    break;
                }
                case 112: {
                    this.cycles_left -= 7;
                    ram.write8(_H << 8 | _L, _B);
                    break;
                }
                case 113: {
                    this.cycles_left -= 7;
                    ram.write8(_H << 8 | _L, _C);
                    break;
                }
                case 114: {
                    this.cycles_left -= 7;
                    ram.write8(_H << 8 | _L, _D);
                    break;
                }
                case 115: {
                    this.cycles_left -= 7;
                    ram.write8(_H << 8 | _L, _E);
                    break;
                }
                case 116: {
                    this.cycles_left -= 7;
                    ram.write8(_H << 8 | _L, _H);
                    break;
                }
                case 117: {
                    this.cycles_left -= 7;
                    ram.write8(_H << 8 | _L, _L);
                    break;
                }
                case 118: {
                    this.cycles_left -= 4;
                    this.state_HALT = true;
                    --_PC;
                    this.cycles_left = 0;
                    break;
                }
                case 119: {
                    this.cycles_left -= 7;
                    ram.write8(_H << 8 | _L, _A);
                    break;
                }
                case 120: {
                    this.cycles_left -= 4;
                    _A = _B;
                    break;
                }
                case 121: {
                    this.cycles_left -= 4;
                    _A = _C;
                    break;
                }
                case 122: {
                    this.cycles_left -= 4;
                    _A = _D;
                    break;
                }
                case 123: {
                    this.cycles_left -= 4;
                    _A = _E;
                    break;
                }
                case 124: {
                    this.cycles_left -= 4;
                    _A = _H;
                    break;
                }
                case 125: {
                    this.cycles_left -= 4;
                    _A = _L;
                    break;
                }
                case 126: {
                    this.cycles_left -= 7;
                    _A = ram.read8(_H << 8 | _L);
                    break;
                }
                case 127: {
                    this.cycles_left -= 4;
                    break;
                }
                case 128: {
                    this.cycles_left -= 4;
                    _A = this.addA_8(_B, _A);
                    break;
                }
                case 129: {
                    this.cycles_left -= 4;
                    _A = this.addA_8(_C, _A);
                    break;
                }
                case 130: {
                    this.cycles_left -= 4;
                    _A = this.addA_8(_D, _A);
                    break;
                }
                case 131: {
                    this.cycles_left -= 4;
                    _A = this.addA_8(_E, _A);
                    break;
                }
                case 132: {
                    this.cycles_left -= 4;
                    _A = this.addA_8(_H, _A);
                    break;
                }
                case 133: {
                    this.cycles_left -= 4;
                    _A = this.addA_8(_L, _A);
                    break;
                }
                case 134: {
                    this.cycles_left -= 7;
                    _A = this.addA_8(ram.read8(_H << 8 | _L), _A);
                    break;
                }
                case 135: {
                    this.cycles_left -= 4;
                    _A = this.addA_8(_A, _A);
                    break;
                }
                case 136: {
                    this.cycles_left -= 4;
                    _A = this.adcA_8(_B, _A);
                    break;
                }
                case 137: {
                    this.cycles_left -= 4;
                    _A = this.adcA_8(_C, _A);
                    break;
                }
                case 138: {
                    this.cycles_left -= 4;
                    _A = this.adcA_8(_D, _A);
                    break;
                }
                case 139: {
                    this.cycles_left -= 4;
                    _A = this.adcA_8(_E, _A);
                    break;
                }
                case 140: {
                    this.cycles_left -= 4;
                    _A = this.adcA_8(_H, _A);
                    break;
                }
                case 141: {
                    this.cycles_left -= 4;
                    _A = this.adcA_8(_L, _A);
                    break;
                }
                case 142: {
                    this.cycles_left -= 7;
                    _A = this.adcA_8(ram.read8(_H << 8 | _L), _A);
                    break;
                }
                case 143: {
                    this.cycles_left -= 4;
                    _A = this.adcA_8(_A, _A);
                    break;
                }
                case 144: {
                    this.cycles_left -= 4;
                    _A = this.subA_8(_B, _A);
                    break;
                }
                case 145: {
                    this.cycles_left -= 4;
                    _A = this.subA_8(_C, _A);
                    break;
                }
                case 146: {
                    this.cycles_left -= 4;
                    _A = this.subA_8(_D, _A);
                    break;
                }
                case 147: {
                    this.cycles_left -= 4;
                    _A = this.subA_8(_E, _A);
                    break;
                }
                case 148: {
                    this.cycles_left -= 4;
                    _A = this.subA_8(_H, _A);
                    break;
                }
                case 149: {
                    this.cycles_left -= 4;
                    _A = this.subA_8(_L, _A);
                    break;
                }
                case 150: {
                    this.cycles_left -= 7;
                    _A = this.subA_8(ram.read8(_H << 8 | _L), _A);
                    break;
                }
                case 151: {
                    this.cycles_left -= 4;
                    _A = this.subA_8(_A, _A);
                    break;
                }
                case 152: {
                    this.cycles_left -= 4;
                    _A = this.sbcA_8(_B, _A);
                    break;
                }
                case 153: {
                    this.cycles_left -= 4;
                    _A = this.sbcA_8(_C, _A);
                    break;
                }
                case 154: {
                    this.cycles_left -= 4;
                    _A = this.sbcA_8(_D, _A);
                    break;
                }
                case 155: {
                    this.cycles_left -= 4;
                    _A = this.sbcA_8(_E, _A);
                    break;
                }
                case 156: {
                    this.cycles_left -= 4;
                    _A = this.sbcA_8(_H, _A);
                    break;
                }
                case 157: {
                    this.cycles_left -= 4;
                    _A = this.sbcA_8(_L, _A);
                    break;
                }
                case 158: {
                    this.cycles_left -= 7;
                    _A = this.sbcA_8(ram.read8(_H << 8 | _L), _A);
                    break;
                }
                case 159: {
                    this.cycles_left -= 4;
                    _A = this.sbcA_8(_A, _A);
                    break;
                }
                case 160: {
                    this.cycles_left -= 4;
                    _A = this.andA(_B, _A);
                    break;
                }
                case 161: {
                    this.cycles_left -= 4;
                    _A = this.andA(_C, _A);
                    break;
                }
                case 162: {
                    this.cycles_left -= 4;
                    _A = this.andA(_D, _A);
                    break;
                }
                case 163: {
                    this.cycles_left -= 4;
                    _A = this.andA(_E, _A);
                    break;
                }
                case 164: {
                    this.cycles_left -= 4;
                    _A = this.andA(_H, _A);
                    break;
                }
                case 165: {
                    this.cycles_left -= 4;
                    _A = this.andA(_L, _A);
                    break;
                }
                case 166: {
                    this.cycles_left -= 7;
                    _A = this.andA(ram.read8(_H << 8 | _L), _A);
                    break;
                }
                case 167: {
                    this.cycles_left -= 4;
                    _A = this.andA(_A, _A);
                    break;
                }
                case 168: {
                    this.cycles_left -= 4;
                    _A = this.xorA(_B, _A);
                    break;
                }
                case 169: {
                    this.cycles_left -= 4;
                    _A = this.xorA(_C, _A);
                    break;
                }
                case 170: {
                    this.cycles_left -= 4;
                    _A = this.xorA(_D, _A);
                    break;
                }
                case 171: {
                    this.cycles_left -= 4;
                    _A = this.xorA(_E, _A);
                    break;
                }
                case 172: {
                    this.cycles_left -= 4;
                    _A = this.xorA(_H, _A);
                    break;
                }
                case 173: {
                    this.cycles_left -= 4;
                    _A = this.xorA(_L, _A);
                    break;
                }
                case 174: {
                    this.cycles_left -= 7;
                    _A = this.xorA(ram.read8(_H << 8 | _L), _A);
                    break;
                }
                case 175: {
                    this.cycles_left -= 4;
                    _A = this.xorA(_A, _A);
                    break;
                }
                case 176: {
                    this.cycles_left -= 4;
                    _A = this.orA(_B, _A);
                    break;
                }
                case 177: {
                    this.cycles_left -= 4;
                    _A = this.orA(_C, _A);
                    break;
                }
                case 178: {
                    this.cycles_left -= 4;
                    _A = this.orA(_D, _A);
                    break;
                }
                case 179: {
                    this.cycles_left -= 4;
                    _A = this.orA(_E, _A);
                    break;
                }
                case 180: {
                    this.cycles_left -= 4;
                    _A = this.orA(_H, _A);
                    break;
                }
                case 181: {
                    this.cycles_left -= 4;
                    _A = this.orA(_L, _A);
                    break;
                }
                case 182: {
                    this.cycles_left -= 7;
                    _A = this.orA(ram.read8(_H << 8 | _L), _A);
                    break;
                }
                case 183: {
                    this.cycles_left -= 4;
                    _A = this.orA(_A, _A);
                    break;
                }
                case 184: {
                    this.cycles_left -= 4;
                    this.cpA_8(_B, _A);
                    break;
                }
                case 185: {
                    this.cycles_left -= 4;
                    this.cpA_8(_C, _A);
                    break;
                }
                case 186: {
                    this.cycles_left -= 4;
                    this.cpA_8(_D, _A);
                    break;
                }
                case 187: {
                    this.cycles_left -= 4;
                    this.cpA_8(_E, _A);
                    break;
                }
                case 188: {
                    this.cycles_left -= 4;
                    this.cpA_8(_H, _A);
                    break;
                }
                case 189: {
                    this.cycles_left -= 4;
                    this.cpA_8(_L, _A);
                    break;
                }
                case 190: {
                    this.cycles_left -= 7;
                    this.cpA_8(ram.read8(_H << 8 | _L), _A);
                    break;
                }
                case 191: {
                    this.cycles_left -= 4;
                    this.cpA_8(_A, _A);
                    break;
                }
                case 192: {
                    if ((this.F & 0x40) == 0) {
                        this.cycles_left -= 11;
                        _PC = ram.read16arg(_SP);
                        _SP += 2;
                        break;
                    }
                    this.cycles_left -= 5;
                    break;
                }
                case 193: {
                    this.cycles_left -= 10;
                    _B = ram.read8(_SP + 1);
                    _C = ram.read8(_SP);
                    _SP += 2;
                    break;
                }
                case 194: {
                    this.cycles_left -= 10;
                    if ((this.F & 0x40) == 0) {
                        _PC = ram.read16arg(_PC);
                        break;
                    }
                    _PC += 2;
                    break;
                }
                case 195: {
                    this.cycles_left -= 10;
                    _PC = ram.read16arg(_PC);
                    break;
                }
                case 196: {
                    if ((this.F & 0x40) == 0) {
                        ram.write16fast(_SP -= 2, _PC + 2);
                        this.cycles_left -= 17;
                        _PC = ram.read16arg(_PC);
                        break;
                    }
                    _PC += 2;
                    this.cycles_left -= 10;
                    break;
                }
                case 197: {
                    this.cycles_left -= 11;
                    ram.write16(_SP - 2, _B << 8 | _C);
                    _SP -= 2;
                    break;
                }
                case 198: {
                    this.cycles_left -= 7;
                    _A = this.addA_8(ram.read8(_PC++), _A);
                    break;
                }
                case 199: {
                    this.cycles_left -= 11;
                    ram.write16fast(_SP -= 2, _PC);
                    _PC = 0;
                    break;
                }
                case 200: {
                    if ((this.F & 0x40) != 0) {
                        this.cycles_left -= 11;
                        _PC = ram.read16arg(_SP);
                        _SP += 2;
                        break;
                    }
                    this.cycles_left -= 5;
                    break;
                }
                case 201: {
                    this.cycles_left -= 10;
                    _PC = ram.read16arg(_SP);
                    _SP += 2;
                    break;
                }
                case 202: {
                    this.cycles_left -= 10;
                    if ((this.F & 0x40) != 0) {
                        _PC = ram.read16arg(_PC);
                        break;
                    }
                    _PC += 2;
                    break;
                }
                case 204: {
                    if ((this.F & 0x40) != 0) {
                        ram.write16fast(_SP -= 2, _PC + 2);
                        this.cycles_left -= 17;
                        _PC = ram.read16arg(_PC);
                        break;
                    }
                    this.cycles_left -= 10;
                    _PC += 2;
                    break;
                }
                case 205: {
                    this.cycles_left -= 17;
                    ram.write8fast((_SP -= 2) + 1, _PC + 2 >> 8);
                    ram.write8fast(_SP, _PC + 2 & 0xFF);
                    _PC = ram.read16arg(_PC);
                    break;
                }
                case 206: {
                    this.cycles_left -= 7;
                    _A = this.adcA_8(ram.read8arg(_PC++), _A);
                    break;
                }
                case 207: {
                    this.cycles_left -= 11;
                    ram.write16fast(_SP -= 2, _PC);
                    _PC = 8;
                    break;
                }
                case 208: {
                    if ((this.F & 1) == 0) {
                        this.cycles_left -= 11;
                        _PC = ram.read16arg(_SP);
                        _SP += 2;
                        break;
                    }
                    this.cycles_left -= 5;
                    break;
                }
                case 209: {
                    this.cycles_left -= 10;
                    _D = ram.read8(_SP + 1);
                    _E = ram.read8(_SP);
                    _SP += 2;
                    break;
                }
                case 210: {
                    this.cycles_left -= 10;
                    if ((this.F & 1) == 0) {
                        _PC = ram.read16arg(_PC);
                        break;
                    }
                    _PC += 2;
                    break;
                }
                case 211: {
                    this.cycles_left -= 11;
                    this.out(ram.read8arg(_PC++), _A);
                    break;
                }
                case 212: {
                    if ((this.F & 1) == 0) {
                        ram.write16fast(_SP -= 2, _PC + 2);
                        this.cycles_left -= 17;
                        _PC = ram.read16arg(_PC);
                        break;
                    }
                    this.cycles_left -= 10;
                    _PC += 2;
                    break;
                }
                case 213: {
                    this.cycles_left -= 11;
                    ram.write16(_SP - 2, _D << 8 | _E);
                    _SP -= 2;
                    break;
                }
                case 214: {
                    this.cycles_left -= 7;
                    _A = this.subA_8(ram.read8arg(_PC++), _A);
                    break;
                }
                case 215: {
                    this.cycles_left -= 11;
                    ram.write16fast(_SP -= 2, _PC);
                    _PC = 16;
                    break;
                }
                case 216: {
                    if ((this.F & 1) != 0) {
                        this.cycles_left -= 11;
                        _PC = ram.read16arg(_SP);
                        _SP += 2;
                        break;
                    }
                    this.cycles_left -= 5;
                    break;
                }
                case 217: {
                    this.cycles_left -= 4;
                    int Reg1 = _B;
                    _B = this.B1;
                    this.B1 = Reg1;
                    Reg1 = _C;
                    _C = this.C1;
                    this.C1 = Reg1;
                    Reg1 = _D;
                    _D = this.D1;
                    this.D1 = Reg1;
                    Reg1 = _E;
                    _E = this.E1;
                    this.E1 = Reg1;
                    Reg1 = _H;
                    _H = this.H1;
                    this.H1 = Reg1;
                    Reg1 = _L;
                    _L = this.L1;
                    this.L1 = Reg1;
                    break;
                }
                case 218: {
                    this.cycles_left -= 10;
                    if ((this.F & 1) != 0) {
                        _PC = ram.read16arg(_PC);
                        break;
                    }
                    _PC += 2;
                    break;
                }
                case 219: {
                    this.cycles_left -= 11;
                    _A = this.in(ram.read8arg(_PC++), _A);
                    break;
                }
                case 220: {
                    if ((this.F & 1) != 0) {
                        ram.write16fast(_SP -= 2, _PC + 2);
                        this.cycles_left -= 17;
                        _PC = ram.read16arg(_PC);
                        break;
                    }
                    this.cycles_left -= 10;
                    _PC += 2;
                    break;
                }
                case 222: {
                    this.cycles_left -= 7;
                    _A = this.sbcA_8(ram.read8arg(_PC++), _A);
                    break;
                }
                case 223: {
                    this.cycles_left -= 11;
                    ram.write16fast(_SP -= 2, _PC);
                    _PC = 24;
                    break;
                }
                case 224: {
                    if ((this.F & 4) == 0) {
                        this.cycles_left -= 11;
                        _PC = ram.read16arg(_SP);
                        _SP += 2;
                        break;
                    }
                    this.cycles_left -= 5;
                    break;
                }
                case 225: {
                    this.cycles_left -= 10;
                    _H = ram.read8(_SP + 1);
                    _L = ram.read8(_SP);
                    _SP += 2;
                    break;
                }
                case 226: {
                    this.cycles_left -= 10;
                    if ((this.F & 4) == 0) {
                        _PC = ram.read16arg(_PC);
                        break;
                    }
                    _PC += 2;
                    break;
                }
                case 227: {
                    this.cycles_left -= 19;
                    int Reg1 = ram.read8(_SP + 1);
                    ram.write8(_SP + 1, _H);
                    _H = Reg1;
                    Reg1 = ram.read8(_SP);
                    ram.write8(_SP, _L);
                    _L = Reg1;
                    break;
                }
                case 228: {
                    this.cycles_left -= 10;
                    if ((this.F & 4) == 0) {
                        ram.write16fast(_SP -= 2, _PC + 2);
                        this.cycles_left -= 17;
                        _PC = ram.read16arg(_PC);
                        break;
                    }
                    _PC += 2;
                    break;
                }
                case 229: {
                    this.cycles_left -= 11;
                    ram.write16(_SP - 2, _H << 8 | _L);
                    _SP -= 2;
                    break;
                }
                case 230: {
                    this.cycles_left -= 7;
                    _A = this.andA(ram.read8arg(_PC++), _A);
                    break;
                }
                case 231: {
                    this.cycles_left -= 11;
                    ram.write16fast(_SP -= 2, _PC);
                    _PC = 32;
                    break;
                }
                case 232: {
                    if ((this.F & 4) != 0) {
                        this.cycles_left -= 11;
                        _PC = ram.read16arg(_SP);
                        _SP += 2;
                        break;
                    }
                    this.cycles_left -= 5;
                    break;
                }
                case 233: {
                    this.cycles_left -= 4;
                    _PC = _H << 8 | _L;
                    break;
                }
                case 234: {
                    this.cycles_left -= 10;
                    if ((this.F & 4) != 0) {
                        _PC = ram.read16arg(_PC);
                        break;
                    }
                    _PC += 2;
                    break;
                }
                case 235: {
                    this.cycles_left -= 4;
                    int Reg1 = _D;
                    _D = _H;
                    _H = Reg1;
                    Reg1 = _E;
                    _E = _L;
                    _L = Reg1;
                    break;
                }
                case 236: {
                    this.cycles_left -= 10;
                    if ((this.F & 4) != 0) {
                        ram.write16fast(_SP -= 2, _PC + 2);
                        this.cycles_left -= 17;
                        _PC = ram.read16arg(_PC);
                        break;
                    }
                    _PC += 2;
                    break;
                }
                case 238: {
                    this.cycles_left -= 7;
                    _A = this.xorA(ram.read8arg(_PC++), _A);
                    break;
                }
                case 239: {
                    this.cycles_left -= 11;
                    ram.write16fast(_SP -= 2, _PC);
                    _PC = 40;
                    break;
                }
                case 240: {
                    if ((this.F & 0x80) == 0) {
                        this.cycles_left -= 11;
                        _PC = ram.read16arg(_SP);
                        _SP += 2;
                        break;
                    }
                    this.cycles_left -= 5;
                    break;
                }
                case 241: {
                    this.cycles_left -= 10;
                    _A = ram.read8(_SP + 1);
                    this.F = ram.read8(_SP);
                    _SP += 2;
                    break;
                }
                case 242: {
                    this.cycles_left -= 10;
                    if ((this.F & 0x80) == 0) {
                        _PC = ram.read16arg(_PC);
                        break;
                    }
                    _PC += 2;
                    break;
                }
                case 243: {
                    this.cycles_left -= 4;
                    _IFF1 = false;
                    _IFF0 = false;
                    break;
                }
                case 244: {
                    this.cycles_left -= 10;
                    if ((this.F & 0x80) == 0) {
                        ram.write16fast(_SP -= 2, _PC + 2);
                        this.cycles_left -= 17;
                        _PC = ram.read16arg(_PC);
                        break;
                    }
                    _PC += 2;
                    break;
                }
                case 245: {
                    this.cycles_left -= 11;
                    ram.write16(_SP - 2, _A << 8 | this.F);
                    _SP -= 2;
                    break;
                }
                case 246: {
                    this.cycles_left -= 7;
                    _A = this.orA(ram.read8arg(_PC++), _A);
                    break;
                }
                case 247: {
                    this.cycles_left -= 11;
                    ram.write16fast(_SP -= 2, _PC);
                    _PC = 48;
                    break;
                }
                case 248: {
                    if ((this.F & 0x80) != 0) {
                        this.cycles_left -= 11;
                        _PC = ram.read16arg(_SP);
                        _SP += 2;
                        break;
                    }
                    this.cycles_left -= 5;
                    break;
                }
                case 249: {
                    this.cycles_left -= 6;
                    _SP = _H << 8 | _L;
                    break;
                }
                case 250: {
                    this.cycles_left -= 10;
                    if ((this.F & 0x80) != 0) {
                        _PC = ram.read16arg(_PC);
                        break;
                    }
                    _PC += 2;
                    break;
                }
                case 251: {
                    this.cycles_left -= 4;
                    _IFF1 = true;
                    _IFF0 = true;
                    this.goingToirq = true;
                    break;
                }
                case 252: {
                    this.cycles_left -= 10;
                    if ((this.F & 0x80) != 0) {
                        ram.write16fast(_SP -= 2, _PC + 2);
                        this.cycles_left -= 17;
                        _PC = ram.read16arg(_PC);
                        break;
                    }
                    _PC += 2;
                    break;
                }
                case 254: {
                    this.cycles_left -= 7;
                    this.cpA_8(ram.read8arg(_PC++), _A);
                    break;
                }
                case 255: {
                    this.cycles_left -= 11;
                    ram.write16fast(_SP -= 2, _PC);
                    _PC = 56;
                    break;
                }
                default: {
                    _error = instruction;
                }
            }
        }
        this.CurInstr = instruction;
        this.IRQ = _IRQ;
        this.NMI = _NMI;
        this.IFF0 = _IFF0;
        this.IFF1 = _IFF1;
        this.PC = _PC;
        this.PPC = _PPC;
        this.SP = _SP;
        this.B = _B;
        this.C = _C;
        this.D = _D;
        this.E = _E;
        this.H = _H;
        this.L = _L;
        this.A = _A;
    }

    private final int addA_8(int value, int A) {
        int result = A + value & 0xFF;
        this.F = SZHVC_add[A << 8 | result];
        return result;
    }

    private final int adcA_8(int value, int A) {
        int c = this.F & 1;
        int result = A + value + c & 0xFF;
        this.F = SZHVC_add[c << 16 | A << 8 | result];
        return result;
    }

    private final int inc8(int value) {
        value = value + 1 & 0xFF;
        this.F = this.F & 1 | SZHV_inc[value];
        return value;
    }

    private final int dec8(int value) {
        value = value - 1 & 0xFF;
        this.F = this.F & 1 | SZHV_dec[value];
        return value;
    }

    private final void cpA_8(int value, int A) {
        int result = A - value & 0xFF;
        this.F = SZHVC_sub[A << 8 | result];
    }

    private final int subA_8(int value, int A) {
        int result = A - value & 0xFF;
        this.F = SZHVC_sub[A << 8 | result];
        return result;
    }

    private final int sbcA_8(int value, int A) {
        int c = this.F & 1;
        int result = A - value - c & 0xFF;
        this.F = SZHVC_sub[c << 16 | A << 8 | result];
        return result;
    }

    private final int add16(int a, int b) {
        int result = a + b;
        this.F = this.F & 0xC4 | (a ^ result ^ b) >> 8 & 0x10 | result >> 16 & 1;
        return result & 0xFFFF;
    }

    private final int rl_A(int A) {
        int old = A;
        A = (A << 1 | this.F & 1) & 0xFF;
        this.F = this.F & 0xEC | old >> 7;
        return A;
    }

    private final int rr_A(int A) {
        int old = A;
        A = (A >> 1 | (this.F & 1) << 7) & 0xFF;
        this.F = this.F & 0xEC | old & 1;
        return A;
    }

    private final int rlc_A(int A) {
        this.F = this.F & 0xEC | A >> 7;
        return (A << 1) + ((A & 0x80) >> 7) & 0xFF;
    }

    private final int rrc_A(int A) {
        this.F = this.F & 0xEC | A & 0x29;
        return (A >> 1) + ((A & 1) << 7) & 0xFF;
    }

    private final int andA(int value, int A) {
        this.F = SZP[A &= value] | 0x10;
        return A;
    }

    private final int orA(int value, int A) {
        this.F = SZP[A |= value];
        return A;
    }

    private final int xorA(int value, int A) {
        this.F = SZP[A ^= value];
        return A;
    }

    private final void out(int port, int value) {
        this.ram.out(port, value);
    }

    private final int in(int port, int A) {
        int in = this.ram.in(port);
        this.F = this.F & 1 | SZP[A];
        return in;
    }

    public final void setDebug(int debugLevel) {
        if (!this.debugDisabled) {
            this.debugLevel = debugLevel;
        }
    }

    public final int getDebug() {
        return this.debugLevel;
    }

    public final void setProperty(int property, int value) {
    }

    public int getCyclesLeft() {
        return this.cycles_left;
    }
}

