/*
 * Decompiled with CFR 0.152.
 */
package jef.map;

import jef.map.WriteHandler;
import jef.map.WriteMap;

public class MemoryWriteAddress
implements WriteMap {
    private int size;
    public WriteHandler[] writeMap;
    private UndefinedWrite defwrite = new UndefinedWrite();
    private WriteHandler RAM;
    private WriteHandler ROM;
    public int[] mem;
    static final boolean debug = false;
    public MEMWriteBanked[] BANKS = new MEMWriteBanked[8];

    public MemoryWriteAddress(int[] mem) {
        this.mem = mem;
        this.RAM = new RAMwrite();
        this.ROM = new ROMwrite();
        this.writeMap = new WriteHandler[mem.length];
        this.set(0, mem.length - 1, this.defwrite);
    }

    public MemoryWriteAddress(int size) {
        this.size = size;
        this.writeMap = new WriteHandler[size];
        this.set(0, size - 1, this.defwrite);
    }

    public void set(int from, int until, WriteHandler memWrite) {
        int i = from;
        while (i <= until) {
            this.writeMap[i] = memWrite;
            ++i;
        }
    }

    public void setMW(int from, int until, int type) {
        WriteHandler wh = null;
        switch (type) {
            case 0: {
                wh = this.RAM;
                break;
            }
            case 1: 
            case 2: {
                wh = this.ROM;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                MEMWriteBanked mEMWriteBanked = new MEMWriteBanked(from);
                this.BANKS[type - 3] = mEMWriteBanked;
                wh = mEMWriteBanked;
            }
        }
        int i = from;
        while (i <= until) {
            this.writeMap[i] = wh;
            ++i;
        }
    }

    public int getSize() {
        return this.mem.length;
    }

    public void write(int address, int data) {
        this.writeMap[address].write(address, data);
    }

    public class UndefinedWrite
    implements WriteHandler {
        public void write(int address, int value) {
        }
    }

    public class RAMwrite
    implements WriteHandler {
        public void write(int address, int value) {
            MemoryWriteAddress.this.mem[address] = value;
        }
    }

    public class ROMwrite
    implements WriteHandler {
        public void write(int address, int value) {
        }
    }

    public class MEMWriteBanked
    implements WriteHandler {
        int startArea;
        int bank_address;

        public MEMWriteBanked(int startArea) {
            this.startArea = startArea;
        }

        public void setBankAdr(int adr) {
            this.bank_address = adr - this.startArea;
        }

        public void write(int address, int value) {
            MemoryWriteAddress.this.mem[address + this.bank_address] = value;
        }
    }
}

