/*
 * Decompiled with CFR 0.152.
 */
package jef.map;

import java.util.HashMap;
import java.util.Map;
import jef.map.WriteHandler;
import jef.map.WriteMap;

public class MemoryWriteAddressMap
implements WriteMap {
    private int[] mem;
    private Map map = new HashMap();
    private WriteHandler RAM = new RAMwrite();
    private WriteHandler ROM = new ROMwrite();
    private MEMWriteBanked[] BANKS = new MEMWriteBanked[8];

    public MemoryWriteAddressMap(int[] region_cpu1) {
        this.mem = region_cpu1;
    }

    public void set(int from, int until, WriteHandler memWrite) {
        int i = from;
        while (i <= until) {
            Integer key = new Integer(i);
            this.map.put(key, memWrite);
            ++i;
        }
    }

    public void setMW(int from, int until, int type) {
        int i = from;
        while (i <= until) {
            switch (type) {
                case 1: 
                case 2: {
                    this.map.put(new Integer(i), this.ROM);
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: {
                    MEMWriteBanked mEMWriteBanked = new MEMWriteBanked(from);
                    this.BANKS[type - 3] = mEMWriteBanked;
                    MEMWriteBanked wh = mEMWriteBanked;
                    this.map.put(new Integer(i), wh);
                }
            }
            ++i;
        }
    }

    public int getSize() {
        return 0;
    }

    public void write(int address, int data) {
        WriteHandler wh = (WriteHandler)this.map.get(new Integer(address));
        if (wh == null) {
            this.RAM.write(address, data);
        } else {
            wh.write(address, data);
        }
    }

    public class RAMwrite
    implements WriteHandler {
        public void write(int address, int value) {
            ((MemoryWriteAddressMap)MemoryWriteAddressMap.this).mem[address] = value;
        }
    }

    public class ROMwrite
    implements WriteHandler {
        public void write(int address, int value) {
        }
    }

    public class MEMWriteBanked
    implements WriteHandler {
        int startArea;
        int bank_address;

        public MEMWriteBanked(int startArea) {
            this.startArea = startArea;
        }

        public void setBankAdr(int adr) {
            this.bank_address = adr - this.startArea;
        }

        public void write(int address, int value) {
            ((MemoryWriteAddressMap)MemoryWriteAddressMap.this).mem[address + this.bank_address] = value;
        }
    }
}

