/*
 * Decompiled with CFR 0.152.
 */
package jef.sound;

import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.SourceDataLine;
import jef.sound.SoundChipEmulator;

public final class HiFiSound {
    protected SourceDataLine m_line;
    int samfreq;
    int LINE_BUF_SIZE;
    int WRITE_BUF_SIZE;
    boolean running;
    SoundChipEmulator sc;
    static /* synthetic */ Class class$0;

    public HiFiSound(SoundChipEmulator sc, int LINE_BUFSIZE, int write_buf_size, int SAMPLE_FREQUENCY) {
        this.sc = sc;
        this.LINE_BUF_SIZE = LINE_BUFSIZE;
        this.WRITE_BUF_SIZE = write_buf_size;
        this.samfreq = SAMPLE_FREQUENCY;
    }

    public void terminate() {
        if (this.m_line != null) {
            this.m_line.stop();
            this.m_line.close();
            this.m_line = null;
            this.running = false;
        }
    }

    public void finalize() {
        this.terminate();
        try {
            super.finalize();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void init() {
        DataLine.Info info;
        AudioFormat format = new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, this.samfreq, 16, 1, 2, this.samfreq, true);
        System.out.println("frameSize " + format.getFrameSize());
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("javax.sound.sampled.SourceDataLine");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (!AudioSystem.isLineSupported(info = new DataLine.Info(clazz, format, this.LINE_BUF_SIZE))) {
            System.err.println("Unsupported audio: " + format);
            return;
        }
        try {
            this.m_line = (SourceDataLine)AudioSystem.getLine(info);
            this.m_line.open(format);
        }
        catch (LineUnavailableException lue) {
            System.err.println("Unavailable data line");
            return;
        }
        this.m_line.start();
        System.out.println("Sound initialized successfully.");
        this.running = true;
    }

    public void update() {
        this.sc.writeBuffer();
        if (this.m_line.available() > this.m_line.getBufferSize() - this.WRITE_BUF_SIZE * 16) {
            this.m_line.write(this.sc.getByteStream(), 0, this.WRITE_BUF_SIZE * 2);
        }
    }
}

