/*
 * Decompiled with CFR 0.152.
 */
package jef.sound;

import jef.sound.HiFiSound;
import jef.sound.LoFiSound;
import jef.sound.SoundChipEmulator;

public abstract class SoundChip
implements SoundChipEmulator {
    public int SUN_BUFSIZE = 4096;
    public int LINE_BUFSIZE = 4096;
    public int JAVAX_BUFSIZE = 128;
    public int SAMPLE_FREQUENCY = 22050;
    protected int[] linBuffer;
    protected byte[] muBuffer;
    protected byte[] linByteStream;
    protected boolean enabled = true;
    protected boolean useJavaxSound;
    private LoFiSound lofi;
    private HiFiSound hifi;
    private int fps;

    public void init(boolean useJavaxSound, int freq, int linbuflen, int fps) {
        this.LINE_BUFSIZE = linbuflen;
        this.useJavaxSound = useJavaxSound;
        this.fps = fps;
        if (useJavaxSound) {
            this.SAMPLE_FREQUENCY = freq;
            this.JAVAX_BUFSIZE = this.SAMPLE_FREQUENCY / fps;
            this.linBuffer = new int[this.JAVAX_BUFSIZE];
            this.linByteStream = new byte[this.JAVAX_BUFSIZE * 2];
            this.hifi = new HiFiSound(this, this.LINE_BUFSIZE, this.JAVAX_BUFSIZE, this.SAMPLE_FREQUENCY);
            this.hifi.init();
        } else {
            this.linBuffer = new int[this.SUN_BUFSIZE];
            this.muBuffer = new byte[this.SUN_BUFSIZE];
            this.SAMPLE_FREQUENCY = 8000;
            this.lofi = new LoFiSound();
            this.lofi.init(this.linBuffer, this.muBuffer);
        }
        System.out.println("SoundChip " + this.toString() + " initialized.");
    }

    public void enable() {
        if (!this.enabled) {
            this.enabled = true;
            this.init(this.useJavaxSound, this.SAMPLE_FREQUENCY, this.JAVAX_BUFSIZE, this.fps);
        }
    }

    public void disable() {
        if (this.enabled) {
            this.enabled = false;
            if (!this.useJavaxSound) {
                this.lofi.disable();
            } else {
                this.hifi.terminate();
            }
        }
    }

    public void update() {
        if (this.enabled) {
            if (!this.useJavaxSound) {
                this.writeBuffer();
                this.lofi.convertBufferToMuLaw();
            } else {
                this.hifi.update();
            }
        }
    }

    public abstract void writeBuffer();

    public int getSampFreq() {
        return this.SAMPLE_FREQUENCY;
    }

    public int getBufferLength() {
        return this.linBuffer.length;
    }

    public byte[] getByteStream() {
        int i = 0;
        while (i < this.linBuffer.length) {
            this.linByteStream[i << 1] = (byte)(this.linBuffer[i] >> 8);
            this.linByteStream[(i << 1) + 1] = (byte)(this.linBuffer[i] & 0xFF);
            ++i;
        }
        return this.linByteStream;
    }

    protected void writeLinBuffer(int index, int value) {
        this.linBuffer[index] = value;
    }

    protected int readLinBuffer(int index) {
        return this.linBuffer[index];
    }

    public void clearBuffer() {
        int i = 0;
        while (i < this.linBuffer.length) {
            this.linBuffer[i] = 0;
            ++i;
        }
    }
}

