/*
 * Decompiled with CFR 0.152.
 */
package jef.video;

import jef.video.BitMap;
import jef.video.BitMapImpl;
import jef.video.GfxDecodeInfo;
import jef.video.VideoConstants;

public class GfxManager
implements VideoConstants {
    protected int[] GFX;
    protected GfxDecodeInfo gdi;
    protected int w;
    protected int h;
    protected static final int[] bit = new int[]{1, 2, 4, 8, 16, 32, 64, 128};
    protected int tileTotal;
    protected int tileColors;
    protected int tileMameOff;
    protected int[] palette;
    protected int[] colorLookUp;
    protected boolean[] colorChanged;
    protected BitMap[] tileImg;
    protected boolean[] valid;
    protected int[] tileColor;
    protected int flip;
    protected int rot;
    protected boolean colorsChanged;
    protected int offset;
    protected int videoFlags;
    protected boolean videoModifiesPalette;
    protected boolean videoSupportsDirty;
    protected boolean owTrans = false;

    public final void init(GfxDecodeInfo gdi, int[] palette, int[] colorLookUp, int flip, int rot, int videoFlags) {
        this.videoFlags = videoFlags;
        this.videoModifiesPalette = (videoFlags & 4) != 0;
        this.videoSupportsDirty = (videoFlags & 2) != 0;
        this.gdi = gdi;
        this.tileTotal = gdi.gfx.total;
        this.tileImg = new BitMap[this.tileTotal];
        this.tileColor = new int[this.tileTotal];
        this.offset = gdi.offset;
        this.colorLookUp = colorLookUp;
        this.tileColors = 1 << gdi.gfx.planes;
        this.palette = palette;
        this.colorChanged = new boolean[colorLookUp.length];
        this.valid = new boolean[gdi.gfx.total];
        this.flip = flip;
        this.rot = rot;
        this.GFX = gdi.mem;
        this.w = gdi.gfx.w - 1;
        this.h = gdi.gfx.h - 1;
        int n = 0;
        while (n <= this.w) {
            if ((gdi.gfx.offsX[n] & 7) > this.tileMameOff) {
                this.tileMameOff = gdi.gfx.offsX[n] & 7;
            }
            ++n;
        }
    }

    public void setTransparencyOverwrite(boolean b) {
        this.owTrans = b;
    }

    public boolean getTransparencyOverwrite() {
        return this.owTrans;
    }

    public BitMap getTile(int tile, int color, int trans, int transcol) {
        if (this.tileColor[tile %= this.tileTotal] != color) {
            this.tileColor[tile] = color;
            this.valid[tile] = false;
        }
        try {
            if (!this.valid[tile] || this.colorChanged[color]) {
                if (this.tileImg[tile] == null) {
                    this.tileImg[tile] = new BitMapImpl(this.w + 1, this.h + 1);
                }
                this.tileImg[tile] = this.decode(tile, color, this.tileImg[tile], this.rot, this.flip, trans, transcol);
                this.valid[tile] = true;
            }
        }
        catch (Exception e) {
            System.out.println("tile " + tile + " , color " + color);
        }
        return this.tileImg[tile];
    }

    public void drawTile(BitMap target, int tile, int color, boolean flipx, boolean flipy, int x, int y, int transparency, int transcolor) {
        switch (this.rot) {
            case 0: {
                this.getTile(tile, color, transparency, transcolor).toBitMap(target, x, y, flipx, flipy, this.owTrans);
                break;
            }
            case 1: {
                this.getTile(tile, color, transparency, transcolor).toBitMap(target, target.getWidth() - this.w - 1 - y, x, flipx, flipy, this.owTrans);
                break;
            }
            case 2: {
                this.getTile(tile, color, transparency, transcolor).toBitMap(target, target.getWidth() - this.w - 1 - x, target.getHeight() - this.h - 1 - y, flipx, flipy, this.owTrans);
                break;
            }
            case 3: {
                this.getTile(tile, color, transparency, transcolor).toBitMap(target, y, target.getHeight() - this.h - 1 - x, flipx, flipy, this.owTrans);
            }
        }
    }

    public void changeColorLookUp(int color, int argb) {
        if (this.colorLookUp[color] != argb) {
            this.colorLookUp[color] = argb;
            this.colorChanged[color >> this.gdi.gfx.planes] = true;
            this.colorsChanged = true;
        }
    }

    public void changePalette(int paletteIndex, int argb) {
        this.palette[paletteIndex] = argb;
        try {
            this.colorChanged[paletteIndex - this.gdi.colorOffset >> this.gdi.gfx.planes] = true;
            this.colorsChanged = true;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public boolean colorCodeHasChanged(int color) {
        return this.colorChanged[color];
    }

    public boolean refresh() {
        if (this.colorsChanged) {
            int c = 0;
            while (c < this.colorChanged.length) {
                if (this.colorChanged[c]) {
                    this.colorChanged[c] = false;
                    int n = 0;
                    while (n < this.gdi.gfx.total) {
                        this.valid[n] = this.tileColor[n] == c && this.tileImg[n] != null;
                        ++n;
                    }
                }
                ++c;
            }
            this.colorsChanged = false;
            return true;
        }
        return false;
    }

    public boolean flush() {
        int c = 0;
        while (c < this.colorChanged.length) {
            this.colorChanged[c] = true;
            ++c;
        }
        this.colorsChanged = true;
        return true;
    }

    protected final BitMap decode(int tile, int col, BitMap tileImg, int rot, int flip, int trans, int transcol) {
        int colorGroup = col * this.tileColors;
        int charAddress = this.offset + tile % this.gdi.gfx.total * (this.gdi.gfx.bytes >> 3);
        int indexSelect = rot << 2 | flip;
        int colorIndex = 0;
        boolean index = false;
        int cc = 0;
        int y = 0;
        while (y <= this.h) {
            int x = 0;
            while (x <= this.w) {
                int byteOffset = this.gdi.gfx.offsX[x] & 0xFFFFF8;
                int bitOffset = this.gdi.gfx.offsX[x] & 7;
                int realXOffset = byteOffset + (this.tileMameOff - bitOffset);
                colorIndex = 0;
                try {
                    int p = 0;
                    while (p < this.gdi.gfx.planes) {
                        byteOffset = (realXOffset + this.gdi.gfx.offsY[y] + this.gdi.gfx.offsPlane[p]) / 8;
                        bitOffset = realXOffset + this.gdi.gfx.offsY[y] + this.gdi.gfx.offsPlane[p] & 7;
                        if ((this.GFX[charAddress + byteOffset] & bit[bitOffset]) != 0) {
                            colorIndex |= 1 << p;
                        }
                        ++p;
                    }
                    cc = this.colorLookUp[colorGroup + colorIndex];
                    cc = trans == -1 ? this.palette[cc] : (trans == 1 && colorIndex == transcol || trans == 2 && cc == transcol ? -1 : this.palette[cc]);
                    switch (indexSelect) {
                        case 0: {
                            tileImg.setPixelFast(x, y, cc);
                            break;
                        }
                        case 4: {
                            tileImg.setPixelFast(this.h - y, x, cc);
                            break;
                        }
                        case 8: {
                            tileImg.setPixelFast(this.w - x, this.h - y, cc);
                            break;
                        }
                        case 12: {
                            tileImg.setPixelFast(y, this.w - x, cc);
                        }
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                ++x;
            }
            ++y;
        }
        return tileImg;
    }
}

