/*
 * Decompiled with CFR 0.152.
 */
package j51;

import j51.J51Panel;
import j51.swing.JFactory;
import j51.swing.JHexByte;
import j51.swing.JHexField;
import j51.swing.JHexWord;
import j51.util.Hex;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JLabel;

abstract class JData
extends J51Panel {
    private int top;
    private int bottom;
    private int base;
    private int row;
    protected JHexByte[] bytes = new JHexByte[256];
    private JLabel[] address = new JLabel[16];
    private JHexField add;
    private boolean scrollable = false;
    private JHexWord jtop;

    JData(String string, int n, int n2) {
        super(string, false);
        int n3;
        this.top = n2;
        this.bottom = n;
        for (int i = 0; i < 256; ++i) {
            this.bytes[i] = new JHexByte();
            this.bytes[i].setToolTipText(Hex.bin2byte(i));
        }
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(1, 1, 1, 1);
        gridBagConstraints.anchor = 17;
        this.row = (this.top - this.bottom) / 16;
        if (this.row > 16) {
            this.scrollable = true;
            this.row = 16;
            this.add = new JHexWord(true);
            this.add((Component)new JLabel("Base"), gridBagConstraints);
            ++gridBagConstraints.gridx;
            gridBagConstraints.gridwidth = 3;
            this.add((Component)this.add, gridBagConstraints);
            gridBagConstraints.gridx += 3;
            this.add((Component)new JLabel("Bottom"), gridBagConstraints);
            gridBagConstraints.gridx += 3;
            this.add((Component)new JHexWord(this.bottom, true), gridBagConstraints);
            gridBagConstraints.gridx += 3;
            this.add((Component)new JLabel("Top"), gridBagConstraints);
            gridBagConstraints.gridx += 3;
            this.jtop = new JHexWord(this.top - 1, true);
            this.add((Component)this.jtop, gridBagConstraints);
            ++gridBagConstraints.gridy;
            this.add.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    try {
                        int n = JData.this.add.getValue();
                        if (n < JData.this.bottom) {
                            n = JData.this.bottom;
                        }
                        if (n + 256 > JData.this.top) {
                            n = JData.this.top - 256;
                        }
                        JData.this.setAddress(n);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            });
        } else {
            this.add = null;
        }
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 1;
        for (n3 = 0; n3 < 16; ++n3) {
            ++gridBagConstraints.gridx;
            JLabel jLabel = new JLabel(Hex.bin2byte(n3));
            JFactory.setBox(jLabel);
            this.add((Component)jLabel, gridBagConstraints);
            this.address[n3] = new JLabel(Hex.bin2word(n3 * 16));
            JFactory.setBox(this.address[n3]);
        }
        ++gridBagConstraints.gridy;
        for (n3 = 0; n3 < this.row; ++n3) {
            gridBagConstraints.gridx = 0;
            this.add((Component)this.address[n3], gridBagConstraints);
            for (int i = 0; i < 16; ++i) {
                ++gridBagConstraints.gridx;
                this.add((Component)this.bytes[n3 * 16 + i], gridBagConstraints);
            }
            ++gridBagConstraints.gridy;
        }
        this.setAddress(this.bottom);
    }

    @Override
    public void setEmulation(boolean bl) {
        if (this.add != null) {
            this.add.setEditable(!bl);
        }
    }

    void setAddress(int n) {
        this.base = n;
        for (int i = 0; i < this.row; ++i) {
            this.address[i].setText(Hex.bin2word(n + 16 * i));
        }
        this.update(false);
    }

    @Override
    public void update(boolean bl) {
        for (int i = 0; i < this.row; ++i) {
            for (int j = 0; j < 16; ++j) {
                this.bytes[i * 16 + j].setValue(this.getByte(this.base + i * 16 + j));
            }
        }
    }

    public void setTop(int n) {
        this.top = n;
        this.jtop.setValue(n - 1);
    }

    public abstract int getByte(int var1);
}

