/*
 * Decompiled with CFR 0.152.
 */
package j51.bt;

import j51.atmel.AT89C51RD2Constants;
import j51.intel.MCS51;
import j51.intel.MCS51Peripheral;
import j51.intel.SfrWriteListener;
import j51.lcd.JLcd;

class LCD2x16
extends JLcd
implements MCS51Peripheral,
AT89C51RD2Constants,
SfrWriteListener {
    MCS51 cpu;
    int oldP5;
    public final int DISPLAY_RS = 1;
    public final int DISPLAY_RW = 2;
    public final int DISPLAY_EN = 4;
    public final int DISPLAY_RD = 128;

    public LCD2x16() {
        super(2, 16, 2);
    }

    @Override
    public void registerCpu(MCS51 mCS51) {
        this.cpu = mCS51;
        mCS51.addSfrWriteListener(232, this);
        mCS51.addSfrWriteListener(192, this);
        this.oldP5 = 0;
    }

    @Override
    public void sfrWrite(int n, int n2) {
        if (n == 192) {
            if (this.cpu.sfrIsSet(232, 6)) {
                this.cpu.sfrReset(192, 128);
            }
            return;
        }
        if (this.cpu.sfrIsSet(232, 4)) {
            if (this.cpu.sfrIsSet(232, 2)) {
                this.cpu.sfrReset(192, 128);
            } else if ((this.oldP5 & 4) == 0) {
                int n3 = this.cpu.sfr(192);
                if (this.cpu.sfrIsSet(232, 1)) {
                    this.data(n3);
                } else {
                    this.cmd(n3);
                }
            }
        }
        this.oldP5 = n2;
    }
}

