/*
 * Decompiled with CFR 0.152.
 */
package j51.diseqc;

import j51.atmel.Atmel24C16;
import j51.diseqc.DiseqcPeripheral;
import j51.i2c.I2cBus;
import j51.intel.OpenCollectorMemoryBit;
import j51.philips.LPC764Base;
import j51.philips.LPC764Ports;

public class Diseqc
extends LPC764Base {
    Atmel24C16 eeprom;
    I2cBus i2c;
    OpenCollectorMemoryBit scl;
    OpenCollectorMemoryBit sda;

    public Diseqc() throws Exception {
        super("DISEQC");
        this.setOscillator(11059200);
        this.scl = this.createSfrBitOc(128, 6);
        this.sda = this.createSfrBitOc(128, 7);
        this.eeprom = new Atmel24C16();
        this.i2c = new I2cBus(this.scl, this.sda);
        this.i2c.addSlave(this.eeprom);
        this.addPeripheral(new DiseqcPeripheral());
        this.addPeripheral(this.i2c);
        this.addPeripheral(new LPC764Ports());
    }

    public int eeprom(int n) {
        int n2 = this.eeprom.read(n *= 2) << 8;
        return n2 |= this.eeprom.read(n + 1);
    }

    @Override
    public String toString() {
        return "Diseqc 1.2 $Id: Diseqc.java 62 2010-06-29 22:06:12Z mviara $";
    }
}

