/*
 * Decompiled with CFR 0.152.
 */
package napkin;

import java.awt.FontMetrics;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import napkin.DrawnCubicLineGenerator;
import napkin.DrawnQuadLineGenerator;
import napkin.DrawnShapeGenerator;
import napkin.DrawnShapeHolder;
import napkin.NapkinConstants;

public class DrawnLineHolder
extends DrawnShapeHolder
implements NapkinConstants {
    private Rectangle rect;
    private FontMetrics metrics;
    private final Endpoints endpoints;
    private static boolean DEBUG = false;
    static final Endpoints HORIZ_LINE = new Endpoints(){

        public Rectangle getEndpoints(Rectangle bounds) {
            return new Rectangle(bounds.x, bounds.y, bounds.width, 0);
        }
    };
    static final Endpoints VERTICAL_LINE = new Endpoints(){

        public Rectangle getEndpoints(Rectangle bounds) {
            return new Rectangle(bounds.x, bounds.y, 0, bounds.height);
        }
    };
    static final Endpoints SLASH_UP = new Endpoints(){

        public Rectangle getEndpoints(Rectangle bounds) {
            return new Rectangle(bounds.x, bounds.y + bounds.height, bounds.width, -bounds.height);
        }
    };
    static /* synthetic */ Class class$napkin$DrawnCubicLineGenerator;

    public DrawnLineHolder(DrawnShapeGenerator gen) {
        this(gen, false);
    }

    public DrawnLineHolder(DrawnShapeGenerator gen, boolean vertical) {
        this(gen, vertical ? VERTICAL_LINE : HORIZ_LINE);
    }

    public DrawnLineHolder(DrawnShapeGenerator gen, Endpoints endpoints) {
        super(gen);
        this.endpoints = endpoints;
    }

    public DrawnLineHolder(double len, boolean vertical) {
        this(DrawnLineHolder.generatorFor(len), vertical);
    }

    public DrawnLineHolder(double len, Endpoints endpoints) {
        this(DrawnLineHolder.generatorFor(len), endpoints);
    }

    private static DrawnShapeGenerator generatorFor(double len) {
        Class type = DrawnShapeGenerator.defaultLineType(len);
        if (type == (class$napkin$DrawnCubicLineGenerator == null ? (class$napkin$DrawnCubicLineGenerator = DrawnLineHolder.class$("napkin.DrawnCubicLineGenerator")) : class$napkin$DrawnCubicLineGenerator)) {
            return new DrawnCubicLineGenerator();
        }
        return new DrawnQuadLineGenerator();
    }

    void shapeUpToDate(Rectangle cRect, FontMetrics cMetrics) {
        boolean sameMetrics = false;
        if (this.metrics == null == (cMetrics == null)) {
            sameMetrics = true;
        } else if (this.metrics != null && this.metrics.equals(cMetrics)) {
            sameMetrics = true;
        }
        if (sameMetrics && this.rect != null && this.rect.equals(cRect)) {
            return;
        }
        this.rect = (Rectangle)cRect.clone();
        this.metrics = cMetrics;
        Rectangle ends = this.endpoints.getEndpoints(this.rect);
        double x1 = ends.getX();
        double y1 = ends.getY();
        double x2 = x1 + ends.getWidth();
        double y2 = y1 + ends.getHeight();
        if (cMetrics != null) {
            double below = Math.max((double)cMetrics.getDescent() / 10.0, 2.0);
            double yAdj = (double)(cRect.y + cMetrics.getAscent()) + below;
            y1 += yAdj;
            y2 += yAdj;
            x1 -= below;
            x2 += below;
        }
        double xDelta = x2 - x1;
        double yDelta = y2 - y1;
        double len = Math.sqrt(xDelta * xDelta + yDelta * yDelta);
        double angle = Math.atan2(yDelta, xDelta);
        AffineTransform matrix = new AffineTransform();
        matrix.translate(x1, y1);
        matrix.rotate(angle);
        if (DEBUG) {
            System.out.println("");
            System.out.println("1: (" + x1 + " , " + y1 + ")");
            System.out.println("2: (" + x2 + " , " + y2 + ")");
            System.out.println("rot = " + angle);
            System.out.println("angle = " + angle);
            System.out.println("xDelta = " + xDelta);
            System.out.println("yDelta = " + yDelta);
            System.out.println("len = " + len);
        }
        double xScale = len / 100.0;
        matrix.scale(xScale, 1.0);
        this.shape = this.gen.generate(matrix);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static interface Endpoints {
        public Rectangle getEndpoints(Rectangle var1);
    }
}

