/*
 * Decompiled with CFR 0.152.
 */
package napkin;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.net.URL;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import napkin.SubIcon;

public class NapkinBackground {
    private final String name;
    private final ImageIcon icon;
    private final Image image;
    private final int iconW;
    private final int iconH;
    private final Icon tlCorner;
    private final Icon tSide;
    private final Icon trCorner;
    private final Icon rSide;
    private final Icon middle;
    private final Icon lSide;
    private final Icon blCorner;
    private final Icon bSide;
    private final Icon brCorner;
    private static final Insets NO_INSETS = new Insets(0, 0, 0, 0);

    public NapkinBackground(String name) {
        this(name, null);
    }

    public NapkinBackground(String name, int top, int left, int bottom, int right) {
        this(name, new Insets(top, left, bottom, right));
    }

    public NapkinBackground(String name, Insets insets) {
        this.name = name;
        URL resource = this.getClass().getResource(name);
        this.image = Toolkit.getDefaultToolkit().getImage(resource);
        this.icon = new ImageIcon(this.image);
        this.iconW = this.icon.getIconWidth();
        this.iconH = this.icon.getIconHeight();
        if (insets == null) {
            insets = NO_INSETS;
        }
        int rX = this.iconW - insets.right;
        int bY = this.iconH - insets.bottom;
        int midW = rX - insets.left;
        int midH = bY - insets.top;
        this.tlCorner = new SubIcon(this.icon, 0, 0, insets.left, insets.top);
        this.tSide = new SubIcon(this.icon, insets.left, 0, midW, insets.top);
        this.trCorner = new SubIcon(this.icon, rX, 0, insets.right, insets.top);
        this.lSide = new SubIcon(this.icon, 0, insets.top, insets.left, midH);
        this.middle = new SubIcon(this.icon, insets.left, insets.top, midW, midH);
        this.rSide = new SubIcon(this.icon, rX, insets.top, insets.right, midH);
        this.blCorner = new SubIcon(this.icon, 0, bY, insets.left, insets.bottom);
        this.bSide = new SubIcon(this.icon, insets.left, bY, midW, insets.bottom);
        this.brCorner = new SubIcon(this.icon, rX, bY, insets.right, insets.bottom);
    }

    public ImageIcon getIcon() {
        return this.icon;
    }

    public String toString() {
        return "NapkinBackground(\"" + this.name + "\")";
    }

    public void paint(Component c, Graphics g, Rectangle paper, Rectangle comp, Insets cInsets) {
        int topH = this.tlCorner.getIconHeight();
        int topY = 0;
        int botH = this.blCorner.getIconHeight();
        int botY = paper.height - botH;
        int midH = paper.height - (topH + botH);
        int midY = topH;
        NapkinBackground.paintSliceAcross(c, g, paper, comp, cInsets, topY, topH, this.tlCorner, this.tSide, this.trCorner);
        NapkinBackground.paintSliceAcross(c, g, paper, comp, cInsets, midY, midH, this.lSide, this.middle, this.rSide);
        NapkinBackground.paintSliceAcross(c, g, paper, comp, cInsets, botY, botH, this.blCorner, this.bSide, this.brCorner);
    }

    private static void paintSliceAcross(Component c, Graphics g, Rectangle paper, Rectangle comp, Insets cInsets, int bandY, int bandH, Icon lftIcon, Icon midIcon, Icon rgtIcon) {
        if (bandH == 0) {
            return;
        }
        if (comp.y + comp.height < bandY) {
            return;
        }
        if (comp.y >= bandY + bandH) {
            return;
        }
        int lftW = lftIcon.getIconWidth();
        int lftX = 0;
        int midW = paper.width - (lftW + rgtIcon.getIconWidth());
        int midX = lftW;
        int rgtW = rgtIcon.getIconWidth();
        int rgtX = paper.width - rgtW;
        NapkinBackground.paintArea(c, g, comp, lftX, bandY, lftW, bandH, lftIcon, cInsets);
        NapkinBackground.paintArea(c, g, comp, midX, bandY, midW, bandH, midIcon, cInsets);
        NapkinBackground.paintArea(c, g, comp, rgtX, bandY, rgtW, bandH, rgtIcon, cInsets);
    }

    private static void paintArea(Component c, Graphics g, Rectangle comp, int atX, int atY, int w, int h, Icon icon, Insets cInsets) {
        if (w == 0 || h == 0) {
            return;
        }
        if (comp.x + comp.width < atX) {
            return;
        }
        if (comp.x >= atX + w) {
            return;
        }
        Rectangle cZeroed = new Rectangle(-cInsets.left, -cInsets.top, comp.width, comp.height);
        int endX = (atX -= comp.x + cInsets.left) + w;
        int endY = (atY -= comp.y + cInsets.top) + h;
        int iw = icon.getIconWidth();
        int ih = icon.getIconHeight();
        Rectangle area = new Rectangle(atX, atY, w, h);
        area.x = atX;
        while (area.x < endX) {
            if (area.x + iw >= 0) {
                area.y = atY;
                while (area.y < endY) {
                    if (area.intersects(cZeroed)) {
                        icon.paintIcon(c, g, area.x, area.y);
                    }
                    area.y += ih;
                }
            }
            area.x += iw;
        }
    }
}

