/*
 * Decompiled with CFR 0.152.
 */
package napkin;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontFormatException;
import java.io.IOException;
import java.io.InputStream;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import javax.swing.plaf.FontUIResource;
import javax.swing.plaf.UIResource;
import napkin.AlphaColorUIResource;
import napkin.NapkinBackground;

public class NapkinTheme {
    private final String name;
    private final String description;
    private final Color[] colors = new Color[5];
    private final Font textFont;
    private final Font boldTextFont;
    private final Font fixedFont;
    private final NapkinBackground paper;
    private final NapkinBackground erasure;
    private NapkinTheme[] themes = new NapkinTheme[2];
    public static final int PEN_COLOR = 0;
    public static final int CHECK_COLOR = 1;
    public static final int RADIO_COLOR = 2;
    public static final int HIGHLIGHT_COLOR = 3;
    public static final int SELECTION_COLOR = 4;
    public static final int BASIC_THEME = 0;
    public static final int POPUP_THEME = 1;
    static /* synthetic */ Class class$napkin$NapkinLookAndFeel;

    public NapkinTheme(String name, String description, Color penColor, Color checkColor, Color radioColor, Color highlightColor, Color selectionColor, Font textFont, Font boldTextFont, Font fixedFont, NapkinBackground paper, NapkinBackground erasure, NapkinBackground popupPaper) {
        this(name, description, penColor, checkColor, radioColor, highlightColor, selectionColor, textFont, boldTextFont, fixedFont, paper, erasure, new NapkinTheme(name + "Popup", description + " (popup)", penColor, checkColor, radioColor, highlightColor, selectionColor, textFont, boldTextFont, fixedFont, popupPaper, erasure, (NapkinTheme)null));
    }

    public NapkinTheme(String name, String description, Color penColor, Color checkColor, Color radioColor, Color highlightColor, Color selectionColor, Font textFont, Font boldTextFont, Font fixedFont, NapkinBackground paper, NapkinBackground erasure, NapkinTheme popupTheme) {
        this.name = name;
        this.description = description;
        this.colors[0] = this.uiResource(penColor);
        this.colors[1] = this.uiResource(checkColor);
        this.colors[2] = this.uiResource(radioColor);
        this.colors[3] = this.uiResource(highlightColor);
        this.colors[4] = this.uiResource(selectionColor);
        this.textFont = this.uiResource(textFont);
        this.boldTextFont = this.uiResource(boldTextFont);
        this.fixedFont = this.uiResource(fixedFont);
        this.paper = paper;
        this.erasure = erasure;
        this.themes[0] = this;
        this.themes[1] = popupTheme;
        if (popupTheme != null) {
            popupTheme.themes = this.themes;
        }
    }

    private Color uiResource(Color color) {
        if (color instanceof UIResource) {
            return color;
        }
        return new AlphaColorUIResource(color);
    }

    private Font uiResource(Font font) {
        if (font instanceof UIResource) {
            return font;
        }
        return new FontUIResource(font);
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public Color getPenColor() {
        return this.colors[0];
    }

    public Color getCheckColor() {
        return this.colors[1];
    }

    public Color getRadioColor() {
        return this.colors[2];
    }

    public Color getHighlightColor() {
        return this.colors[3];
    }

    public Color getSelectionColor() {
        return this.colors[4];
    }

    public Color getColor(int which) {
        return this.colors[which];
    }

    public Font getTextFont() {
        return this.textFont;
    }

    public Font getBoldTextFont() {
        return this.boldTextFont;
    }

    public Font getFixedFont() {
        return this.fixedFont;
    }

    public NapkinBackground getPaper() {
        return this.paper;
    }

    public NapkinBackground getErasureMask() {
        return this.erasure;
    }

    public NapkinTheme getPopupTheme() {
        return this.getTheme(1);
    }

    public NapkinTheme getBasicTheme() {
        return this.getTheme(0);
    }

    public NapkinTheme getTheme(int which) {
        return this.themes[which];
    }

    public String toString() {
        return this.name;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static class Manager {
        private static final Map themes;
        private static NapkinTheme currentTheme;
        private static final String DEFAULT_THEME = "napkin";
        private static final Class THIS_CLASS;
        private static final Logger LOG;

        public static String[] themeNames() {
            return themes.keySet().toArray(new String[themes.size()]);
        }

        public static NapkinTheme getTheme(String name) {
            return (NapkinTheme)themes.get(name);
        }

        public static NapkinTheme getDefaultTheme() {
            return Manager.getTheme(DEFAULT_THEME);
        }

        public static NapkinTheme getCurrentTheme() {
            return currentTheme;
        }

        public static void setCurrentTheme(NapkinTheme theme) {
            currentTheme = theme != null ? theme : Manager.getDefaultTheme();
        }

        public static void setCurrentTheme(String themeName) {
            NapkinTheme theme = Manager.getTheme(themeName);
            if (theme == null) {
                throw new IllegalArgumentException("unknown theme");
            }
            Manager.setCurrentTheme(theme);
        }

        public static void addTheme(NapkinTheme theme) {
            themes.put(theme.getName(), theme);
        }

        private static Font tryToLoadFont(String fontName) {
            try {
                ClassLoader cl = (class$napkin$NapkinLookAndFeel == null ? (class$napkin$NapkinLookAndFeel = NapkinTheme.class$("napkin.NapkinLookAndFeel")) : class$napkin$NapkinLookAndFeel).getClassLoader();
                String fontRes = "napkin/resources/" + fontName;
                InputStream fontDef = cl.getResourceAsStream(fontRes);
                if (fontDef != null) {
                    return Font.createFont(0, fontDef);
                }
                System.err.println("Could not find font " + fontName);
            }
            catch (FontFormatException e) {
                LOG.log(Level.WARNING, "getting font " + fontName, e);
            }
            catch (IOException e) {
                LOG.log(Level.WARNING, "getting font " + fontName, e);
            }
            return null;
        }

        static {
            String themeName;
            themes = new HashMap();
            THIS_CLASS = class$napkin$NapkinLookAndFeel == null ? (class$napkin$NapkinLookAndFeel = NapkinTheme.class$("napkin.NapkinLookAndFeel")) : class$napkin$NapkinLookAndFeel;
            LOG = LogManager.getLogManager().getLogger(THIS_CLASS.getName());
            Font scrawl = Manager.tryToLoadFont("FeltTipRoman.ttf");
            Font scrawlBold = Manager.tryToLoadFont("FeltTipRoman-Bold.ttf");
            Font fixed = Manager.tryToLoadFont("1942.ttf");
            Font augie = Manager.tryToLoadFont("augie.ttf");
            Color checkGreen = Color.GREEN.darker();
            NapkinTheme def = new NapkinTheme(DEFAULT_THEME, "Default theme", Color.BLACK, checkGreen, new Color(0xF50000), new Color(0, 255, 255, 127), checkGreen, scrawl.deriveFont(0, 15.0f), scrawlBold.deriveFont(1, 15.0f), fixed.deriveFont(0, 15.0f), new NapkinBackground("resources/napkin.jpg"), new NapkinBackground("resources/erasure.png"), new NapkinBackground("resources/postit01.jpg", 15, 15, 38, 32));
            Manager.addTheme(def);
            Manager.addTheme(new NapkinTheme("debug", "Debug theme", def.getPenColor(), def.getCheckColor(), def.getRadioColor(), def.getHighlightColor(), def.getSelectionColor(), def.getTextFont(), def.getBoldTextFont(), def.getFixedFont(), new NapkinBackground("resources/testPaper.jpg", 0, 0, 10, 10), def.getErasureMask(), new NapkinBackground("resources/testPostit.jpg", 0, 0, 10, 10)));
            Color blueprintInk = new Color(15199730);
            Color blueprintHighlight = new Color(9025005);
            Font blueFont = augie.deriveFont(0, 13.0f);
            Manager.addTheme(new NapkinTheme("blueprint", "Blueprint", Color.white, blueprintInk, blueprintInk, blueprintHighlight, blueprintInk, blueFont, blueFont, def.getFixedFont(), new NapkinBackground("resources/blueprint-bg.jpg"), def.getErasureMask(), def.getPopupTheme()));
            try {
                themeName = (String)AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        return System.getProperty("napkin.theme", "napkin");
                    }
                });
            }
            catch (SecurityException e) {
                themeName = null;
            }
            if (themeName == null) {
                themeName = DEFAULT_THEME;
            }
            if ((currentTheme = Manager.getTheme(themeName)) == null) {
                currentTheme = Manager.getTheme(DEFAULT_THEME);
            }
        }
    }
}

