/*
 * Decompiled with CFR 0.152.
 */
package ants.p2p;

import ants.p2p.Ant;
import ants.p2p.CompressedByteArray;
import ants.p2p.DataBandwidthFilterOut;
import ants.p2p.Message;
import ants.p2p.Neighbour;
import ants.p2p.NetModificationAlert;
import ants.p2p.Prober;
import ants.p2p.QueryBandwidthFilterOut;
import ants.p2p.SenderThread;
import ants.p2p.http.HttpInterruptTransferMessage;
import ants.p2p.http.HttpRequestMessage;
import ants.p2p.http.HttpResponsePartMessage;
import ants.p2p.http.HttpTransferEndControlMessage;
import ants.p2p.messages.ControlMessage;
import ants.p2p.messages.FileInfosPullErrorControlMessage;
import ants.p2p.messages.FileInfosPullMessage;
import ants.p2p.messages.FileInfosPushMessage;
import ants.p2p.messages.FilePartMessage;
import ants.p2p.messages.FilePullMessage;
import ants.p2p.messages.FilePushMessage;
import ants.p2p.messages.FileSizePullErrorControlMessage;
import ants.p2p.messages.FileSizePullMessage;
import ants.p2p.messages.FileSizePushMessage;
import ants.p2p.messages.FileTransferEndControlMessage;
import ants.p2p.messages.FileTransferErrorControlMessage;
import ants.p2p.messages.NetProbeMessage;
import ants.p2p.messages.PrivateChatMessage;
import ants.p2p.messages.SecureConnectionErrorControlMessage;
import ants.p2p.messages.SecurityRequestMessage;
import ants.p2p.messages.SecurityResponseMessage;
import ants.p2p.query.QueryMessage;
import ants.p2p.utils.net.BandwidthFilterIn;
import ants.p2p.utils.net.BandwidthFilterOut;
import com.jcraft.jzlib.ZInputStream;
import com.jcraft.jzlib.ZOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.util.Date;
import javax.crypto.Cipher;
import org.apache.log4j.Logger;

public class NeighbourAnt
extends Thread
implements Neighbour {
    Ant local;
    String ip;
    int port;
    int remoteServerPort;
    Cipher enc;
    Cipher dec;
    Socket s;
    BandwidthFilterIn bfIn;
    BandwidthFilterOut bfOut;
    long queuedMessages = 0L;
    boolean failure = false;
    boolean terminate = false;
    boolean isRequirer;
    long timeElapsed;
    long lastProbedAt;
    long lastActiveUploadTime = System.currentTimeMillis();
    long lastActiveDownloadTime = System.currentTimeMillis();
    final int pingSize = 32;
    long queryInCheckpoint = 0L;
    long floodInCheckpoint = 0L;
    long floodOutCheckpoint = 0L;
    int receivedQueries = 0;
    int receivedFloods = 0;
    int routedQueries = 0;
    int routedFloods = 0;
    public static int bandwidthLimit = 30720;
    public static int queryBandwidthLimit = 10240;
    public static final int maxQueryRatePerMinute = 60;
    Prober prober;
    public static double totalCompressedSizeOut;
    public static double totalUncompressionSizeOut;
    public static double totalCompressedSizeIn;
    public static double totalUncompressionSizeIn;
    public static double totalQueryCompressedSizeOut;
    public static double totalQueryCompressedSizeIn;
    public static double totalDataCompressedSizeOut;
    public static double totalDataCompressedSizeIn;
    public static double totalControlCompressedSizeOut;
    public static double totalControlCompressedSizeIn;
    public static double totalDownloaded;
    public static double totalUploaded;
    static Logger _logger;
    private Object socketLock = new Object();

    public NeighbourAnt(Ant local, String ip, int port, int remoteServerPort, Cipher enc, Cipher dec, Socket s, boolean isRequirer, long timeElapsed) throws IOException {
        this.s = s;
        this.ip = ip;
        this.port = port;
        this.remoteServerPort = remoteServerPort;
        this.enc = enc;
        this.dec = dec;
        this.local = local;
        this.isRequirer = isRequirer;
        this.timeElapsed = timeElapsed;
        this.lastProbedAt = System.currentTimeMillis();
        _logger.info((Object)(this.getIdent() + ": Net probe done at " + new Date(this.lastProbedAt) + "[" + this.timeElapsed + "]"));
        this.bfIn = new BandwidthFilterIn(s.getInputStream());
        this.bfOut = new BandwidthFilterOut(s.getOutputStream());
        this.setPriority(10);
    }

    public void incQueuedMessages() {
        this.modifyQueuedMessages(1);
    }

    public void decQueuedMessages() {
        this.modifyQueuedMessages(-1);
    }

    public long getQueuedMessages() {
        return this.queuedMessages;
    }

    private synchronized void modifyQueuedMessages(int modifier) {
        this.queuedMessages += (long)modifier;
    }

    public long getTimeElapsed() {
        return this.timeElapsed;
    }

    public long getLastProbedAt() {
        return this.lastProbedAt;
    }

    public long getLastActiveDownloadTime() {
        return this.lastActiveDownloadTime;
    }

    public long getLastActiveUploadTime() {
        return this.lastActiveUploadTime;
    }

    public void setLastActiveDownloadTime() {
        this.lastActiveDownloadTime = System.currentTimeMillis();
    }

    public void setLastActiveUploadTime() {
        this.lastActiveUploadTime = System.currentTimeMillis();
    }

    public boolean isConnected() {
        if (!this.terminate && this.s != null) {
            return !this.s.isClosed();
        }
        return false;
    }

    public boolean isRequirer() {
        return this.isRequirer;
    }

    public void terminate() {
        try {
            this.terminate = true;
            _logger.info((Object)("Terminating neighbour " + this.getIdent() + "  socket: " + this.s));
            if (this.s != null) {
                _logger.info((Object)("Closing " + this.getIdent() + "  socket: " + this.s));
                this.s.close();
                _logger.info((Object)("Neighbour terminated [" + this.s.isClosed() + "] " + this.getIdent()));
            } else {
                _logger.info((Object)("Neighbour terminated (null socket) " + this.getIdent()));
            }
        }
        catch (Exception ex) {
            _logger.error((Object)"Neighbour terminate error", (Throwable)ex);
        }
    }

    public String getIdent() {
        if (this.ip.startsWith("/")) {
            this.ip = this.ip.substring(1);
        }
        return this.ip + "  " + this.port;
    }

    public Ant getAnt() {
        return this.local;
    }

    public String getRemoteId() {
        if (this.ip.startsWith("/")) {
            this.ip = this.ip.substring(1);
        }
        return this.ip + "  " + this.remoteServerPort;
    }

    public boolean equals(Object o) {
        if (o instanceof NeighbourAnt) {
            String idThis = this.isRequirer() ? this.getIdent() : this.getRemoteId();
            String idO = ((NeighbourAnt)o).isRequirer() ? ((NeighbourAnt)o).getIdent() : ((NeighbourAnt)o).getRemoteId();
            return idThis.equals(idO);
        }
        return o == this;
    }

    public SenderThread route(Message m) {
        SenderThread st = new SenderThread(m, this);
        st.start();
        return st;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void send(Message m) throws Exception {
        try {
            SenderThread curThread;
            if (this.terminate || this.s.isClosed()) {
                if (!(m instanceof NetProbeMessage || m instanceof NetModificationAlert || m instanceof QueryMessage)) {
                    _logger.info((Object)(this.getIdent() + ": Neighbour terminated, routing message to a different direction. " + m));
                    this.local.activateNewRouterProcess(m, this.getIdent());
                }
                return;
            }
            CompressedByteArray cba = null;
            ByteArrayOutputStream byteArrayOut = null;
            if (m instanceof NetProbeMessage) {
                Object object = this.socketLock;
                synchronized (object) {
                    ObjectOutputStream soos = new ObjectOutputStream(this.bfOut);
                    _logger.info((Object)(this.getIdent() + ": Sending probe message at " + new Date(System.currentTimeMillis())));
                    soos.writeObject(m);
                    soos.writeObject(new byte[this.pingSize]);
                    _logger.info((Object)(this.getIdent() + ": Sent probe message at " + new Date(System.currentTimeMillis())));
                    return;
                }
            }
            _logger.debug((Object)(this.getIdent() + ": Routing message: ID " + m.getAck_Id() + " Type: " + m.getType() + " From: " + " To: " + m.getDest()));
            _logger.debug((Object)(this.getIdent() + ": Message sending [" + this.getQueuedMessages() + "]" + m.getType() + " " + m));
            byteArrayOut = new ByteArrayOutputStream();
            ZOutputStream zOut = new ZOutputStream((OutputStream)byteArrayOut, 9);
            ObjectOutputStream zOOs = new ObjectOutputStream((OutputStream)zOut);
            zOOs.writeObject(m);
            totalUncompressionSizeOut += (double)zOut.getTotalIn();
            zOut.close();
            totalCompressedSizeOut += (double)byteArrayOut.toByteArray().length;
            NeighbourAnt.updateOutStats(m, byteArrayOut.toByteArray().length);
            cba = new CompressedByteArray(byteArrayOut.toByteArray());
            if (m instanceof QueryMessage) {
                QueryBandwidthFilterOut.getInstance().writeQuery(byteArrayOut.toByteArray().length);
            } else {
                DataBandwidthFilterOut.getInstance().writeData(byteArrayOut.toByteArray().length);
            }
            if (Thread.currentThread() instanceof SenderThread && !(curThread = (SenderThread)Thread.currentThread()).mustSend()) {
                return;
            }
            if (this.terminate || this.s.isClosed()) {
                if (!(m instanceof NetProbeMessage)) {
                    _logger.info((Object)(this.getIdent() + ": Neighbour terminated, routing message to a different direction. " + m));
                    this.local.activateNewRouterProcess(m, this.getIdent());
                }
                return;
            }
            Object object = this.socketLock;
            synchronized (object) {
                ObjectOutputStream oos = new ObjectOutputStream(this.bfOut);
                oos.writeObject(cba);
                _logger.debug((Object)(this.getIdent() + ": Message sent [" + this.getQueuedMessages() + "]" + m.getType() + " " + m));
            }
        }
        catch (Exception e) {
            _logger.info((Object)(this.getIdent() + ": Socket is closed with neighbour: " + this.getIdent()), (Throwable)e);
            try {
                if (this.s != null) {
                    this.s.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void updateOutStats(Message m, long size) {
        if (m instanceof ControlMessage || m instanceof FileTransferEndControlMessage || m instanceof FileTransferErrorControlMessage || m instanceof FileSizePullErrorControlMessage || m instanceof FileInfosPullErrorControlMessage || m instanceof HttpTransferEndControlMessage || m instanceof HttpInterruptTransferMessage || m instanceof SecureConnectionErrorControlMessage || m instanceof NetModificationAlert) {
            totalControlCompressedSizeOut += (double)size;
        } else if (m instanceof SecurityRequestMessage || m instanceof SecurityResponseMessage || m instanceof FilePullMessage || m instanceof FilePushMessage || m instanceof FileInfosPullMessage || m instanceof FileInfosPushMessage || m instanceof HttpRequestMessage) {
            totalControlCompressedSizeOut += (double)size;
        } else if (m instanceof FileSizePullMessage || m instanceof FileSizePushMessage) {
            totalControlCompressedSizeOut += (double)size;
        } else if (m instanceof PrivateChatMessage) {
            totalControlCompressedSizeOut += (double)size;
        } else if (m instanceof QueryMessage) {
            totalQueryCompressedSizeOut += (double)size;
        } else if (m instanceof HttpResponsePartMessage) {
            totalDataCompressedSizeOut += (double)size;
        } else if (m instanceof FilePartMessage) {
            totalDataCompressedSizeOut += (double)size;
        } else if (m instanceof Message) {
            totalDataCompressedSizeOut += (double)size;
        }
    }

    public static void updateInStats(Message m, long size) {
        if (m instanceof ControlMessage || m instanceof FileTransferEndControlMessage || m instanceof FileTransferErrorControlMessage || m instanceof FileSizePullErrorControlMessage || m instanceof FileInfosPullErrorControlMessage || m instanceof HttpTransferEndControlMessage || m instanceof HttpInterruptTransferMessage || m instanceof SecureConnectionErrorControlMessage || m instanceof NetModificationAlert) {
            totalControlCompressedSizeIn += (double)size;
        } else if (m instanceof SecurityRequestMessage || m instanceof SecurityResponseMessage || m instanceof FilePullMessage || m instanceof FilePushMessage || m instanceof FileInfosPullMessage || m instanceof FileInfosPushMessage || m instanceof HttpRequestMessage) {
            totalControlCompressedSizeIn += (double)size;
        } else if (m instanceof FileSizePullMessage || m instanceof FileSizePushMessage) {
            totalControlCompressedSizeIn += (double)size;
        } else if (m instanceof PrivateChatMessage) {
            totalControlCompressedSizeIn += (double)size;
        } else if (m instanceof QueryMessage) {
            totalQueryCompressedSizeIn += (double)size;
        } else if (m instanceof HttpResponsePartMessage) {
            totalDataCompressedSizeIn += (double)size;
        } else if (m instanceof FilePartMessage) {
            totalDataCompressedSizeIn += (double)size;
        } else if (m instanceof Message) {
            totalDataCompressedSizeIn += (double)size;
        }
    }

    public void run() {
        block18: {
            try {
                this.prober = new Prober(this);
                this.prober.start();
                while (!this.local.isDisconnected() && !this.terminate) {
                    Message m = null;
                    ObjectInputStream ois = new ObjectInputStream(this.bfIn);
                    Object obj = ois.readObject();
                    long size = 0L;
                    if (obj instanceof CompressedByteArray) {
                        CompressedByteArray cba = (CompressedByteArray)obj;
                        ByteArrayInputStream in = new ByteArrayInputStream(cba.getArray());
                        ZInputStream zIn = new ZInputStream((InputStream)in);
                        ObjectInputStream objIn = new ObjectInputStream((InputStream)zIn);
                        obj = objIn.readObject();
                        totalCompressedSizeIn += (double)zIn.getTotalIn();
                        totalUncompressionSizeIn += (double)zIn.getTotalOut();
                        size += zIn.getTotalIn();
                    } else {
                        if (obj instanceof NetProbeMessage) {
                            long startProbe = System.currentTimeMillis();
                            ois.readObject();
                            this.timeElapsed = System.currentTimeMillis() - startProbe;
                            this.lastProbedAt = System.currentTimeMillis();
                            _logger.info((Object)(this.getIdent() + ": Net probe done at " + new Date(this.lastProbedAt) + "[" + this.timeElapsed + "]"));
                            continue;
                        }
                        _logger.debug((Object)obj.toString());
                        continue;
                    }
                    if (obj instanceof NetModificationAlert && ((NetModificationAlert)obj).getVersion().equals(Ant.getProtocolVersion())) {
                        this.local.processNetModificationAlert((NetModificationAlert)obj, this);
                        continue;
                    }
                    if (obj instanceof Message && ((Message)obj).getVersion().equals(Ant.getProtocolVersion())) {
                        m = (Message)obj;
                        NeighbourAnt.updateInStats(m, size);
                        _logger.debug((Object)(this.getIdent() + ": Message received ID " + m.getAck_Id().substring(0, 10) + " From: " + (m.getSource().length() > 10 ? m.getSource().substring(0, 10) : m.getSource()) + " To: " + (m.getDest().length() > 10 ? m.getDest().substring(0, 10) : m.getDest())));
                        if (m.getType() == 2) {
                            long now = System.currentTimeMillis();
                            if (now - this.queryInCheckpoint > 60000L) {
                                this.queryInCheckpoint = now;
                                this.receivedQueries = 0;
                            } else {
                                ++this.receivedQueries;
                                if (this.receivedQueries > 60) {
                                    _logger.info((Object)(this + " Query flood detected. Discarding... " + m));
                                    continue;
                                }
                            }
                        }
                        this.local.activateNewRouterProcess(m, this.getIdent());
                        continue;
                    }
                    _logger.debug((Object)obj.toString());
                }
                if (this.failure) break block18;
                this.failure = true;
                _logger.info((Object)(this.local.getShortId() + ": 1Closed connection with neighbour: " + this.getIdent()));
                try {
                    if (this.s != null) {
                        this.s.close();
                    }
                }
                catch (IOException ex) {
                    // empty catch block
                }
                this.local.removeNeighbour(this);
                this.local.propertyChangeSupport.firePropertyChange("removedNeighbour", null, this);
            }
            catch (Exception e) {
                if (this.failure) break block18;
                this.failure = true;
                _logger.info((Object)(this.local.getShortId() + ": 2Closed connection with neighbour: " + this.getIdent()), (Throwable)e);
                _logger.debug((Object)"NeighbourAnt connection failed", (Throwable)e);
                try {
                    if (this.s != null) {
                        this.s.close();
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                this.local.removeNeighbour(this);
                this.local.propertyChangeSupport.firePropertyChange("removedNeighbour", null, this);
            }
        }
    }

    public void setFailure() {
        this.failure = true;
    }

    public String toString() {
        return this.getIdent() + " [" + this.getTimeElapsed() + "ms][" + this.queuedMessages + "]";
    }

    public static int getTotalCompressionGainOut() {
        return (int)Math.ceil((1.0 - totalCompressedSizeOut / totalUncompressionSizeOut) * 100.0);
    }

    public static int getTotalCompressionGainIn() {
        return (int)Math.ceil((1.0 - totalCompressedSizeIn / totalUncompressionSizeIn) * 100.0);
    }

    static {
        totalDownloaded = 0.0;
        totalUploaded = 0.0;
        _logger = Logger.getLogger((String)NeighbourAnt.class.getName());
    }
}

