/*
 * Decompiled with CFR 0.152.
 */
package ants.p2p.messages;

import ants.p2p.Message;
import java.math.BigInteger;
import java.security.KeyFactory;
import java.security.PublicKey;
import javax.crypto.interfaces.DHPublicKey;
import javax.crypto.spec.DHPublicKeySpec;

public class SecurityRequestMessage
extends Message {
    private String skip1024Modulus;
    private String skip1024Base;
    private String requirerPubKeyY;
    private String requirerPubKeyP;
    private String requirerPubKeyG;

    public SecurityRequestMessage(Message m, BigInteger skip1024Modulus, BigInteger skip1024Base, PublicKey requirerPubKey) {
        super(m);
        this.skip1024Base = skip1024Base.toString();
        this.skip1024Modulus = skip1024Modulus.toString();
        this.requirerPubKeyY = ((DHPublicKey)requirerPubKey).getY().toString();
    }

    public SecurityRequestMessage(BigInteger skip1024Modulus, BigInteger skip1024Base, PublicKey requirerPubKey) {
        this.skip1024Base = skip1024Base.toString();
        this.skip1024Modulus = skip1024Modulus.toString();
        this.requirerPubKeyY = ((DHPublicKey)requirerPubKey).getY().toString();
    }

    public BigInteger getG() {
        return new BigInteger(this.skip1024Base);
    }

    public BigInteger getP() {
        return new BigInteger(this.skip1024Modulus);
    }

    public PublicKey getRequirerPubkey() throws Exception {
        DHPublicKeySpec requirerPubKeySpec = new DHPublicKeySpec(new BigInteger(this.requirerPubKeyY), this.getG(), this.getP());
        return KeyFactory.getInstance("DH").generatePublic(requirerPubKeySpec);
    }
}

