/*
 * Decompiled with CFR 0.152.
 */
package ants.p2p.messages;

import ants.p2p.Message;
import java.math.BigInteger;
import java.security.KeyFactory;
import java.security.PublicKey;
import javax.crypto.interfaces.DHPublicKey;
import javax.crypto.spec.DHPublicKeySpec;

public class SecurityResponseMessage
extends Message {
    private String peerPubKeyY;
    private Message requestMessage;
    private String g;
    private String p;

    public SecurityResponseMessage(Message m, PublicKey peerPubKey, Message requestMessage) throws Exception {
        super(m);
        this.peerPubKeyY = ((DHPublicKey)peerPubKey).getY().toString();
        DHPublicKeySpec peerPubKeySpec = (DHPublicKeySpec)KeyFactory.getInstance("DH").getKeySpec(peerPubKey, Class.forName("javax.crypto.spec.DHPublicKeySpec"));
        this.g = peerPubKeySpec.getG().toString();
        this.p = peerPubKeySpec.getP().toString();
        this.requestMessage = requestMessage;
    }

    public SecurityResponseMessage(PublicKey peerPubKey, Message requestMessage) throws Exception {
        this.peerPubKeyY = ((DHPublicKey)peerPubKey).getY().toString();
        DHPublicKeySpec peerPubKeySpec = (DHPublicKeySpec)KeyFactory.getInstance("DH").getKeySpec(peerPubKey, Class.forName("javax.crypto.spec.DHPublicKeySpec"));
        this.g = peerPubKeySpec.getG().toString();
        this.p = peerPubKeySpec.getP().toString();
        this.requestMessage = requestMessage;
    }

    public Message getRequestMessage() {
        return this.requestMessage;
    }

    private BigInteger getG() {
        return new BigInteger(this.g);
    }

    private BigInteger getP() {
        return new BigInteger(this.p);
    }

    public PublicKey getPeerPubkey() throws Exception {
        DHPublicKeySpec peerPubKeySpec = new DHPublicKeySpec(new BigInteger(this.peerPubKeyY), this.getP(), this.getG());
        return KeyFactory.getInstance("DH").generatePublic(peerPubKeySpec);
    }
}

