/*
 * Decompiled with CFR 0.152.
 */
package ants.p2p.utils.addresses;

import ants.p2p.filesharing.WarriorAnt;
import ants.p2p.gui.FrameAnt;
import ants.p2p.query.ServerInfo;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.log4j.Logger;

public class InetAddressEngine
extends Thread
implements PropertyChangeListener {
    static Logger _logger = Logger.getLogger((String)InetAddressEngine.class.getName());
    public static int refreshRate = 120000;
    public static int peersToMemorize = 10;
    public static int peersToSendback = 3;
    public static int broadcastTimeToLive = 1000;
    public static InetAddressEngine instance = null;
    public static File trustedPeersFile = new File(WarriorAnt.workingPath + "/trustedPeers.ant");
    public static File peersFile = new File(WarriorAnt.workingPath + "/peers.ant");
    boolean terminate = false;
    WarriorAnt warriorAnt;
    static ArrayList peersWithFreeSlots = new ArrayList();
    static ArrayList trustedPeers = new ArrayList();
    static ArrayList instantMessengersPeers = new ArrayList();

    public static InetAddressEngine getInstance(WarriorAnt owner) {
        try {
            instance = new InetAddressEngine(owner);
            instance.setPriority(1);
            instance.start();
            return instance;
        }
        catch (Exception ex) {
            _logger.error((Object)"", (Throwable)ex);
            return null;
        }
    }

    public static InetAddressEngine getInstance() {
        return instance;
    }

    private InetAddressEngine(WarriorAnt warriorAnt) {
        this.warriorAnt = warriorAnt;
        this.warriorAnt.propertyChangeSupport.addPropertyChangeListener(this);
    }

    public static boolean contains(int[] indexes, int val) {
        for (int x = 0; x < indexes.length; ++x) {
            if (indexes[x] != val) continue;
            return true;
        }
        return false;
    }

    public static ArrayList getRandomIMPeersWithFreeSlots(int howMany) {
        int[] indexes = new int[howMany];
        Arrays.fill(indexes, -1);
        for (int x = 0; x < howMany && x < instantMessengersPeers.size(); ++x) {
            int index = (int)Math.floor(Math.random() * (double)instantMessengersPeers.size());
            while (InetAddressEngine.contains(indexes, index)) {
                index = (int)Math.floor(Math.random() * (double)instantMessengersPeers.size());
            }
            indexes[x] = index;
        }
        ArrayList sendBack = new ArrayList();
        for (int x = 0; x < howMany && x < instantMessengersPeers.size(); ++x) {
            sendBack.add(instantMessengersPeers.get(indexes[x]));
        }
        return sendBack;
    }

    public static ArrayList getRandomPeersWithFreeSlots(int howMany, boolean sendMyAddress) {
        int[] indexes = new int[howMany];
        Arrays.fill(indexes, -1);
        for (int x = 0; x < howMany && x < peersWithFreeSlots.size(); ++x) {
            int index = (int)Math.floor(Math.random() * (double)peersWithFreeSlots.size());
            while (InetAddressEngine.contains(indexes, index)) {
                index = (int)Math.floor(Math.random() * (double)peersWithFreeSlots.size());
            }
            indexes[x] = index;
        }
        ArrayList sendBack = new ArrayList();
        for (int x = 0; x < howMany && x < peersWithFreeSlots.size(); ++x) {
            ServerInfo peer = (ServerInfo)peersWithFreeSlots.get(indexes[x]);
            if (!sendMyAddress && peer.getAddress().getHostAddress().equals(FrameAnt.getInstance(null).getGuiAnt().getConnectionAntPanel().getLocalInetAddress().getHostAddress()) && peer.getPort().intValue() == FrameAnt.getInstance(null).getGuiAnt().getConnectionAntPanel().warriorAnt.getServerPort()) continue;
            sendBack.add(peersWithFreeSlots.get(indexes[x]));
        }
        _logger.debug((Object)("Sending back " + sendBack.size() + " peers[" + peersWithFreeSlots.size() + "]"));
        return sendBack;
    }

    public static ArrayList getPeersWithFreeSlots(boolean sendMyAddress) {
        ArrayList sendBack = InetAddressEngine.getRandomPeersWithFreeSlots(peersToSendback, sendMyAddress);
        return sendBack;
    }

    public static void removeDeadPeer(ServerInfo s) {
        if (s != null) {
            peersWithFreeSlots.remove(s);
            InetAddressEngine.storePeers();
            _logger.error((Object)("Dead peer found in list: " + s.getAddress()));
        } else {
            _logger.error((Object)("No dead peer found in list: " + s.getAddress()));
        }
    }

    public static ArrayList getTrustedPeers() {
        return trustedPeers;
    }

    private static void storeTrustedPeers() {
        try {
            ObjectOutputStream oos = new ObjectOutputStream(new FileOutputStream(trustedPeersFile));
            oos.writeObject(trustedPeers);
            oos.close();
        }
        catch (IOException e) {
            _logger.error((Object)"Cannot store trusted peers", (Throwable)e);
        }
    }

    private static void storePeers() {
        try {
            ObjectOutputStream oos = new ObjectOutputStream(new FileOutputStream(peersFile));
            oos.writeObject(peersWithFreeSlots);
            oos.close();
        }
        catch (IOException e) {
            _logger.error((Object)"Cannot store peers", (Throwable)e);
        }
    }

    private static void loadTrustedPeers() {
        try {
            ObjectInputStream ois = new ObjectInputStream(new FileInputStream(trustedPeersFile));
            trustedPeers = (ArrayList)ois.readObject();
            ois.close();
        }
        catch (Exception e) {
            _logger.error((Object)"Cannot load trusted peers");
        }
    }

    private static void loadPeers() {
        try {
            ObjectInputStream ois = new ObjectInputStream(new FileInputStream(peersFile));
            peersWithFreeSlots = (ArrayList)ois.readObject();
            ois.close();
        }
        catch (Exception e) {
            _logger.error((Object)"Cannot load peers");
        }
    }

    public static void removeTrustedPeer(ServerInfo sInfo) {
        trustedPeers.remove(sInfo);
        InetAddressEngine.storeTrustedPeers();
    }

    public static void addTrustedPeer(String inetAddr, int port) {
        ServerInfo sInfo = new ServerInfo("", inetAddr, new Integer(port), "");
        if (!trustedPeers.contains(sInfo)) {
            trustedPeers.add(sInfo);
            InetAddressEngine.storeTrustedPeers();
        }
    }

    public void run() {
        int counter = 0;
        while (!this.warriorAnt.isDisconnected() && !this.terminate) {
            try {
                _logger.info((Object)"InetAddress engine Search...");
                if (counter == 0) {
                    this.warriorAnt.getServersWithFreeSlots();
                }
                this.warriorAnt.getALanServer();
                InetAddressEngine.sleep(refreshRate);
                counter = (counter + 1) % 3;
            }
            catch (Exception e) {
                _logger.error((Object)"", (Throwable)e);
            }
        }
        _logger.info((Object)"InetAddressEngine Terminated");
        this.warriorAnt.propertyChangeSupport.removePropertyChangeListener(this);
        this.warriorAnt = null;
    }

    public void terminate() {
        this.terminate = true;
    }

    public void propertyChange(PropertyChangeEvent e) {
        if (e.getPropertyName().equals("inetAddressQueryCompleted")) {
            ArrayList result = (ArrayList)e.getNewValue();
            _logger.debug((Object)("Adding peers: " + result.size()));
            for (int x = 0; x < result.size(); ++x) {
                if (!peersWithFreeSlots.contains(result.get(x))) {
                    _logger.debug((Object)("Added peer: " + result.get(x)));
                    peersWithFreeSlots.add(0, result.get(x));
                    continue;
                }
                _logger.debug((Object)("Replaced peer: " + result.get(x)));
                peersWithFreeSlots.remove(result.get(x));
                peersWithFreeSlots.add(0, result.get(x));
            }
            while (true) {
                if (peersWithFreeSlots.size() <= peersToMemorize) break;
                peersWithFreeSlots.remove(peersWithFreeSlots.size() - 1);
            }
            InetAddressEngine.storePeers();
        }
        if (e.getPropertyName().equals("updateInstantMessengerPeer")) {
            try {
                ServerInfo si = new ServerInfo("", (String)e.getOldValue(), new Integer((String)e.getNewValue()), "masked");
                instantMessengersPeers.add(si);
                _logger.info((Object)("Received instant messenger peer address " + e.getOldValue() + ":" + e.getNewValue()));
            }
            catch (Exception ex) {
                _logger.error((Object)"Error updating peer from IM", (Throwable)ex);
            }
        }
        if (e.getPropertyName().equals("removeInstantMessengerPeer")) {
            try {
                int x = 0;
                while (true) {
                    if (x >= instantMessengersPeers.size()) break;
                    ServerInfo si = (ServerInfo)instantMessengersPeers.get(x);
                    if (si.getAddress().equals(InetAddress.getByName((String)e.getOldValue()))) {
                        instantMessengersPeers.remove(e.getOldValue());
                    }
                    ++x;
                }
                _logger.info((Object)("Removed instant messenger peer address " + e.getOldValue()));
            }
            catch (Exception ex) {
                _logger.error((Object)"Error removing peer from IM", (Throwable)ex);
            }
        }
    }

    static {
        if (trustedPeersFile.exists()) {
            InetAddressEngine.loadTrustedPeers();
        }
        if (peersFile.exists()) {
            InetAddressEngine.loadPeers();
        }
    }
}

