/*
 * Decompiled with CFR 0.152.
 */
package ants.p2p.utils.indexer;

import ants.p2p.filesharing.MultipleSourcesDownloadManager;
import ants.p2p.filesharing.WarriorAnt;
import ants.p2p.utils.encoding.Base16;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.io.FileInputStream;
import java.security.MessageDigest;
import java.util.ArrayList;

public class DigestManager {
    Object[] digests;
    private static final int chunkSize = WarriorAnt.blockSizeInDownload * MultipleSourcesDownloadManager.blocksPerSource;
    public static final String hashName = "MD5";
    File f;
    static ArrayList propertyChangeListeners = new ArrayList();
    public PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);

    public DigestManager() {
        for (int x = 0; x < propertyChangeListeners.size(); ++x) {
            this.propertyChangeSupport.addPropertyChangeListener((PropertyChangeListener)propertyChangeListeners.get(x));
        }
    }

    static void addPropertyChangeListener(PropertyChangeListener pcl) {
        propertyChangeListeners.add(pcl);
    }

    static void removePropertyChangeListener(PropertyChangeListener pcl) {
        propertyChangeListeners.remove(pcl);
    }

    private Object[] computeDigests(File f) throws Exception {
        this.f = f;
        FileInputStream fis = new FileInputStream(f);
        long index = 0L;
        this.propertyChangeSupport.firePropertyChange("fileIndexingInProgress", "[ANts2k] " + f.getName(), new Integer(0));
        this.digests = new Object[(int)Math.ceil((double)f.length() / ((double)(WarriorAnt.blockSizeInDownload * MultipleSourcesDownloadManager.blocksPerSource) * 1.0))];
        int counter = 0;
        while (fis.available() > 0) {
            MessageDigest md = MessageDigest.getInstance(hashName);
            byte[] block = fis.available() >= WarriorAnt.blockSizeInDownload * MultipleSourcesDownloadManager.blocksPerSource ? new byte[WarriorAnt.blockSizeInDownload * MultipleSourcesDownloadManager.blocksPerSource] : new byte[fis.available()];
            md.update(block);
            this.digests[counter++] = md.digest();
            int progress = (int)Math.floor((double)(index += (long)fis.read(block)) * 1.0 / (double)f.length() * 100.0);
            this.propertyChangeSupport.firePropertyChange("fileIndexingInProgress", "[ANts2k] " + f.getName(), new Integer(progress));
            Thread.currentThread();
            Thread.sleep(100L);
        }
        return this.digests;
    }

    public Object[] getDigests(File f) throws Exception {
        if (this.digests != null && this.f.equals(f)) {
            return this.digests;
        }
        this.computeDigests(f);
        for (int x = 0; x < propertyChangeListeners.size(); ++x) {
            this.propertyChangeSupport.removePropertyChangeListener((PropertyChangeListener)propertyChangeListeners.get(x));
        }
        return this.digests;
    }

    public String getDigest(File f) throws Exception {
        this.f = f;
        MessageDigest md = MessageDigest.getInstance(hashName);
        FileInputStream fis = new FileInputStream(f);
        while (fis.available() > 0) {
            byte[] block = fis.available() >= WarriorAnt.blockSizeInDownload * MultipleSourcesDownloadManager.blocksPerSource ? new byte[WarriorAnt.blockSizeInDownload * MultipleSourcesDownloadManager.blocksPerSource] : new byte[fis.available()];
            fis.read(block);
            md.update(block);
            Thread.currentThread();
            Thread.sleep(100L);
        }
        return Base16.toHexString(md.digest());
    }

    public String getDigest(String s) throws Exception {
        MessageDigest md = MessageDigest.getInstance(hashName);
        md.update(s.getBytes());
        byte[] dig = md.digest();
        return Base16.toHexString(dig);
    }

    public String getDigest(Object[] hashes) throws Exception {
        MessageDigest md = MessageDigest.getInstance(hashName);
        for (int x = 0; x < hashes.length; ++x) {
            md.update((byte[])hashes[x]);
        }
        byte[] dig = md.digest();
        return Base16.toHexString(dig);
    }
}

