/*
 * Decompiled with CFR 0.152.
 */
package helliker.id3;

import helliker.id3.ID3Tag;
import helliker.id3.ID3v2ExtendedHeader;
import helliker.id3.ID3v2Footer;
import helliker.id3.ID3v2FormatException;
import helliker.id3.ID3v2Frame;
import helliker.id3.ID3v2Frames;
import helliker.id3.ID3v2Header;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;

public class ID3v2Tag
implements ID3Tag,
Serializable {
    private final String ENC_TYPE = "ISO-8859-1";
    private final String MP3EXT_BADID = "MP3e";
    private final int NEWTAG_LIMIT = 16000;
    private boolean exists;
    private ID3v2ExtendedHeader ext_head = null;
    private ID3v2Footer foot = null;
    private ID3v2Frames frames = null;
    private ID3v2Header head = null;
    private File mp3 = null;
    private long mpegOffset;
    private int padding;
    private int writtenPadding;
    private int writtenTagSize;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ID3v2Tag(File mp3, long mpegOffset) throws FileNotFoundException, IOException, ID3v2FormatException {
        this.mp3 = mp3;
        this.mpegOffset = mpegOffset;
        this.frames = new ID3v2Frames();
        this.head = new ID3v2Header(mp3);
        this.padding = 0;
        this.exists = this.head.headerExists();
        if (this.exists) {
            block7: {
                if (this.head.getExtendedHeader()) {
                    this.ext_head = new ID3v2ExtendedHeader(mp3);
                }
                if (this.head.getFooter()) {
                    this.foot = new ID3v2Footer(mp3, this.head.getTagSize() + this.head.getHeaderSize());
                }
                RandomAccessFile in = null;
                try {
                    in = new RandomAccessFile(mp3, "r");
                    if (this.head.getMajorVersion() >= 3) {
                        this.parseFrames(in);
                    }
                    Object var6_4 = null;
                    if (in == null) break block7;
                }
                catch (Throwable throwable) {
                    Object var6_5 = null;
                    if (in != null) {
                        in.close();
                    }
                    throw throwable;
                }
                in.close();
            }
            this.writtenTagSize = this.head.getTagSize();
            this.writtenPadding = this.padding;
        }
    }

    public void copyFrom(ID3Tag tag) {
    }

    public byte[] getBytes() {
        byte[] b = new byte[this.getTotalSize()];
        int bytesCopied = 0;
        int length = 0;
        this.padding = this.getUpdatedPadding();
        length = this.head.getHeaderSize();
        System.arraycopy(this.head.getBytes(), 0, b, bytesCopied, length);
        bytesCopied += length;
        if (this.head.getExtendedHeader()) {
            length = this.ext_head.getSize();
            System.arraycopy(this.ext_head.getBytes(), 0, b, bytesCopied, length);
            bytesCopied += length;
        }
        length = this.frames.getLength();
        System.arraycopy(this.frames.getBytes(), 0, b, bytesCopied, length);
        bytesCopied += length;
        if (this.padding > 0) {
            System.arraycopy(new byte[this.padding], 0, b, bytesCopied, this.padding);
            bytesCopied += this.padding;
        }
        if (this.head.getFooter()) {
            length = this.foot.getFooterSize();
            System.arraycopy(this.foot.getBytes(), 0, b, bytesCopied, length);
            bytesCopied += length;
        }
        return b;
    }

    public byte[] getFrameData(String id) {
        byte[] b = new byte[]{};
        if (this.frames.containsKey(id)) {
            b = ((ID3v2Frame)this.frames.get(id)).getFrameData();
        }
        return b;
    }

    public String getFrameDataString(String id) throws ID3v2FormatException {
        String str = new String();
        if (this.frames.containsKey(id)) {
            str = ((ID3v2Frame)this.frames.get(id)).getDataString();
        }
        return str;
    }

    public int getPadding() {
        return this.padding;
    }

    public int getSize() {
        int size = this.frames.getLength();
        int sizeDiff = 0;
        if (this.head.getExtendedHeader()) {
            size += this.ext_head.getSize();
        }
        sizeDiff = (size += this.padding) - this.writtenTagSize;
        if (this.padding == this.writtenPadding && sizeDiff != 0 && (sizeDiff < 0 || sizeDiff <= this.padding)) {
            size = this.head.getTagSize();
        }
        return size;
    }

    public int getTotalSize() {
        int size = this.getSize();
        size += this.head.getHeaderSize();
        if (this.head.getFooter()) {
            size += this.foot.getFooterSize();
        }
        return size;
    }

    private int getUpdatedPadding() {
        int pad = this.padding;
        int size = this.frames.getLength();
        int sizeDiff = 0;
        if (this.head.getExtendedHeader()) {
            size += this.ext_head.getSize();
        }
        sizeDiff = (size += this.padding) - this.writtenTagSize;
        if (this.padding == this.writtenPadding && sizeDiff != 0 && this.exists) {
            if (sizeDiff < 0) {
                pad += Math.abs(sizeDiff);
            } else if (sizeDiff <= this.padding) {
                pad -= sizeDiff;
            } else {
                int newTagSize = 2 * this.writtenTagSize;
                while (newTagSize < size) {
                    newTagSize += this.writtenTagSize;
                }
                pad = newTagSize <= 16000 ? newTagSize - size : 0;
            }
        }
        return pad;
    }

    private void parseFrames(RandomAccessFile raf) throws IOException, ID3v2FormatException {
        int offset = this.head.getHeaderSize();
        int framesLength = this.head.getTagSize();
        int bytesRead = 0;
        int curLength = 0;
        ID3v2Frame frame = null;
        String id = null;
        boolean done = false;
        if (this.head.getExtendedHeader()) {
            framesLength -= this.ext_head.getSize();
            offset += this.ext_head.getSize();
        }
        raf.seek(offset);
        while (bytesRead < framesLength && !done) {
            byte[] buf = new byte[4];
            bytesRead += raf.read(buf);
            id = new String(buf);
            if (!id.equals("MP3e") && id.indexOf(0) == -1) {
                curLength = raf.readInt();
                if (curLength < 0 || curLength > framesLength - (bytesRead += 4)) {
                    throw new ID3v2FormatException("ID3v2Tag.parseFrames: Invalid frame size");
                }
                byte[] flags = new byte[2];
                bytesRead += raf.read(flags);
                buf = new byte[curLength];
                bytesRead += raf.read(buf);
                frame = new ID3v2Frame(id, flags, buf);
                this.frames.put(id, frame);
                continue;
            }
            done = true;
            bytesRead -= buf.length;
        }
        Long tmp = new Long(this.mpegOffset - (long)offset - (long)bytesRead);
        this.padding = tmp.intValue();
    }

    public void removeFrame(String id) {
        this.frames.remove(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void removeTag() throws FileNotFoundException, IOException {
        if (this.exists) {
            block6: {
                RandomAccessFile raf = null;
                int fullTagSize = this.writtenTagSize + this.head.getHeaderSize();
                if (this.head.getFooter()) {
                    fullTagSize += this.foot.getFooterSize();
                }
                try {
                    Long bufSize = new Long(this.mp3.length() - (long)fullTagSize);
                    byte[] buf = new byte[bufSize.intValue()];
                    raf = new RandomAccessFile(this.mp3, "rw");
                    raf.seek(fullTagSize);
                    if (raf.read(buf) != buf.length) {
                        throw new IOException("ID3v2Tag.removeTag: unexpected end of file encountered");
                    }
                    raf.setLength(bufSize);
                    raf.seek(0L);
                    raf.write(buf);
                    raf.close();
                    Object var6_5 = null;
                    if (raf == null) break block6;
                }
                catch (Throwable throwable) {
                    Object var6_6 = null;
                    if (raf != null) {
                        raf.close();
                    }
                    throw throwable;
                }
                raf.close();
            }
            this.exists = false;
        }
    }

    public void setCommentFrame(String description, String comment) {
        try {
            byte[] b = new byte[description.length() + comment.length() + 5];
            int bytesCopied = 0;
            b[bytesCopied++] = 0;
            b[bytesCopied++] = 101;
            b[bytesCopied++] = 110;
            b[bytesCopied++] = 103;
            System.arraycopy(description.getBytes("ISO-8859-1"), 0, b, bytesCopied, description.length());
            bytesCopied += description.length();
            b[bytesCopied++] = 0;
            System.arraycopy(comment.getBytes("ISO-8859-1"), 0, b, bytesCopied, comment.length());
            bytesCopied += comment.length();
            this.updateFrameData(ID3v2Frames.COMMENTS, b);
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
    }

    public void setPadding(int pad) {
        if (!this.head.getFooter() && pad >= 0) {
            this.padding = pad;
        }
    }

    public void setTextFrame(String id, String data) {
        if (id.charAt(0) == 'T' && !id.equals(ID3v2Frames.USER_DEFINED_TEXT_INFO)) {
            try {
                byte[] b = new byte[data.length() + 1];
                b[0] = 0;
                System.arraycopy(data.getBytes("ISO-8859-1"), 0, b, 1, data.length());
                this.updateFrameData(id, b);
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
        }
    }

    public void setURLFrame(String id, String data) {
        if (id.charAt(0) == 'W' && !id.equals(ID3v2Frames.USER_DEFINED_URL)) {
            this.updateFrameData(id, data.getBytes());
        }
    }

    public void setUserDefinedTextFrame(String description, String value) {
        try {
            byte[] b = new byte[description.length() + value.length() + 2];
            int bytesCopied = 0;
            b[bytesCopied++] = 0;
            System.arraycopy(description.getBytes("ISO-8859-1"), 0, b, bytesCopied, description.length());
            bytesCopied += description.length();
            b[bytesCopied++] = 0;
            System.arraycopy(value.getBytes("ISO-8859-1"), 0, b, bytesCopied, value.length());
            bytesCopied += value.length();
            this.updateFrameData(ID3v2Frames.USER_DEFINED_TEXT_INFO, b);
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
    }

    public void setUserDefinedURLFrame(String description, String value) {
        try {
            byte[] b = new byte[description.length() + value.length() + 2];
            int bytesCopied = 0;
            b[bytesCopied++] = 0;
            System.arraycopy(description.getBytes("ISO-8859-1"), 0, b, bytesCopied, description.length());
            bytesCopied += description.length();
            b[bytesCopied++] = 0;
            System.arraycopy(value.getBytes(), 0, b, bytesCopied, value.length());
            bytesCopied += value.length();
            this.updateFrameData(ID3v2Frames.USER_DEFINED_URL, b);
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
    }

    public boolean tagExists() {
        return this.exists;
    }

    public String toString() {
        String str = this.head.toString();
        str = str + "\nPadding:\t\t\t" + this.getPadding() + " bytes" + "\nTotalSize:\t\t\t" + this.getTotalSize() + " bytes";
        if (this.head.getExtendedHeader()) {
            str = str + "\n" + this.ext_head.toString();
        }
        str = str + "\n" + this.frames.toString();
        if (this.head.getFooter()) {
            str = str + this.foot.toString();
        }
        return str;
    }

    public void updateFrameData(String id, byte[] data) {
        if (this.frames.containsKey(id)) {
            ((ID3v2Frame)this.frames.get(id)).setFrameData(data);
        } else {
            ID3v2Frame frame = new ID3v2Frame(id, data);
            this.frames.put(id, frame);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void writeTag() throws FileNotFoundException, IOException {
        int curSize;
        block6: {
            RandomAccessFile raf = null;
            curSize = this.getTotalSize();
            this.head.setTagSize(this.getSize());
            try {
                raf = new RandomAccessFile(this.mp3, "rw");
                if (this.mpegOffset >= (long)curSize) {
                    byte[] out = this.getBytes();
                    raf.seek(0L);
                    raf.write(out);
                } else {
                    byte[] id3 = this.getBytes();
                    long size = raf.length() - this.mpegOffset;
                    byte[] previous_file = new byte[(int)size];
                    raf.seek(this.mpegOffset);
                    if (raf.read(previous_file) != previous_file.length) {
                        throw new IOException("ID3v2Tag.removeTag: unexpected end of file encountered");
                    }
                    raf.setLength(size + (long)id3.length);
                    raf.seek(0L);
                    raf.write(id3);
                    raf.write(previous_file);
                }
                Object var8_7 = null;
                if (raf == null) break block6;
            }
            catch (Throwable throwable) {
                Object var8_8 = null;
                if (raf != null) {
                    raf.close();
                }
                throw throwable;
            }
            raf.close();
        }
        this.writtenTagSize = curSize;
        this.writtenPadding = this.padding;
        this.exists = true;
    }
}

