/*
 * Decompiled with CFR 0.152.
 */
package com.birosoft.liquid;

import com.birosoft.liquid.LiquidLookAndFeel;
import com.birosoft.liquid.skin.Skin;
import com.birosoft.liquid.skin.SkinToggleButtonIndexModel;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JToggleButton;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicButtonUI;

public class LiquidButtonUI
extends BasicButtonUI {
    public static final boolean HINT_DO_NOT_PAINT_TOOLBARBUTTON_IF_NO_MOUSE_OVER = true;
    SkinToggleButtonIndexModel buttonIndexModel = new SkinToggleButtonIndexModel(true);
    private static final LiquidButtonUI buttonUI = new LiquidButtonUI();
    static BasicStroke focusStroke = new BasicStroke(1.0f, 0, 2, 1.0f, new float[]{1.0f, 1.0f}, 1.0f);
    static Skin skinButton;
    private static Skin skinSmallButton;
    private static Skin skinToolbar;
    SkinToggleButtonIndexModel toolbarIndexModel = new SkinToggleButtonIndexModel();

    public static ComponentUI createUI(final JComponent c) {
        JButton b = (JButton)c;
        b.setRolloverEnabled(true);
        c.setOpaque(false);
        c.addPropertyChangeListener("opaque", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                c.setOpaque(false);
            }
        });
        return buttonUI;
    }

    public Skin getSkinButton() {
        if (skinButton == null) {
            skinButton = new Skin("button.png", 5, 10, 10, 12, 12);
            skinButton.colourImage();
        }
        return skinButton;
    }

    public Skin getSkinSmallButton() {
        if (skinSmallButton == null) {
            skinSmallButton = new Skin("toolbar-nonflatted.png", 8, 4, 13, 4, 10);
        }
        return skinSmallButton;
    }

    public Skin getSkinToolbar() {
        if (skinToolbar == null) {
            skinToolbar = LiquidLookAndFeel.toolbarFlattedButtons ? new Skin("toolbar.png", 8, 4, 13, 4, 10) : new Skin("toolbar-nonflatted.png", 8, 4, 13, 4, 10);
        }
        return skinToolbar;
    }

    public void installDefaults(AbstractButton b) {
        super.installDefaults(b);
    }

    public void paint(Graphics g, JComponent c) {
        if (c instanceof JToggleButton) {
            super.paint(g, c);
            return;
        }
        AbstractButton button = (AbstractButton)c;
        if (button.getClientProperty("JToolBar.isToolbarButton") == Boolean.TRUE) {
            this.toolbarIndexModel.setButton(button);
            int index = this.toolbarIndexModel.getIndexForState();
            if (button.hasFocus() && index == 0) {
                index = 1;
            }
            this.getSkinToolbar().draw(g, index, button.getWidth(), button.getHeight());
        } else {
            this.buttonIndexModel.setButton(button);
            this.buttonIndexModel.setCheckForDefaultButton(button instanceof JButton);
            int index = this.buttonIndexModel.getIndexForState();
            if (index > 3) {
                index -= 4;
            }
            if (button.hasFocus() && index == 0) {
                index = 1;
            }
            if (button.getHeight() < 21 || button.getWidth() < 21) {
                this.getSkinSmallButton().draw(g, index, button.getWidth(), button.getHeight());
                button.setFocusPainted(false);
            } else {
                this.getSkinButton().draw(g, index, button.getWidth(), button.getHeight());
            }
            if (index == 4 && button.isFocusPainted()) {
                Rectangle bounds = button.getBounds();
                this.paintFocus(g, bounds.height / 2 - 5);
            }
        }
        super.paint(g, c);
    }

    protected void paintButtonPressed(Graphics g, AbstractButton b) {
    }

    public void paintFocus(Graphics g, int offset) {
        Graphics2D g2d = (Graphics2D)g;
        g.setColor(new Color(196, 195, 194));
        g2d.drawLine(6, offset, 11, offset + 5);
        g.setColor(new Color(175, 174, 174));
        g2d.drawLine(6, offset + 1, 6, offset + 11);
        g2d.drawLine(6, offset + 11, 11, offset + 6);
    }

    protected void paintFocus(Graphics g, AbstractButton b, Rectangle viewRect, Rectangle textRect, Rectangle iconRect) {
        Rectangle bounds = b.getBounds();
        int offset = bounds.height / 2 - 5;
        if (this.buttonIndexModel.getIndexForState() == 2) {
            return;
        }
        if (b.getClientProperty("JToolBar.isToolbarButton") != Boolean.TRUE && b.isFocusPainted()) {
            this.paintFocus(g, offset);
        }
    }

    public void uninstallDefaults(AbstractButton b) {
        super.uninstallDefaults(b);
    }

    public void update(Graphics g, JComponent c) {
        this.paint(g, c);
    }
}

