/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1;

import java.io.IOException;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DEROutputStream;

public class DERUnknownTag
extends DERObject {
    byte[] data;
    int tag;

    public DERUnknownTag(int tag, byte[] data) {
        this.tag = tag;
        this.data = data;
    }

    void encode(DEROutputStream out) throws IOException {
        out.writeEncoded(this.tag, this.data);
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof DERUnknownTag)) {
            return false;
        }
        DERUnknownTag other = (DERUnknownTag)o;
        if (this.tag != other.tag) {
            return false;
        }
        if (this.data.length != other.data.length) {
            return false;
        }
        int i = 0;
        while (i < this.data.length) {
            if (this.data[i] != other.data[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public byte[] getData() {
        return this.data;
    }

    public int getTag() {
        return this.tag;
    }

    public int hashCode() {
        byte[] b = this.getData();
        int value = 0;
        int i = 0;
        while (i != b.length) {
            value ^= (b[i] & 0xFF) << i % 4;
            ++i;
        }
        return value ^ this.getTag();
    }
}

