/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1.cms;

import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.DERGeneralizedTime;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.cms.OtherKeyAttribute;

public class RecipientKeyIdentifier
extends ASN1Encodable {
    private DERGeneralizedTime date;
    private OtherKeyAttribute other;
    private ASN1OctetString subjectKeyIdentifier;

    public RecipientKeyIdentifier(ASN1Sequence seq) {
        this.subjectKeyIdentifier = ASN1OctetString.getInstance(seq.getObjectAt(0));
        switch (seq.size()) {
            case 1: {
                break;
            }
            case 2: {
                if (seq.getObjectAt(1) instanceof DERGeneralizedTime) {
                    this.date = (DERGeneralizedTime)seq.getObjectAt(1);
                    break;
                }
                this.other = OtherKeyAttribute.getInstance(seq.getObjectAt(2));
                break;
            }
            case 3: {
                this.date = (DERGeneralizedTime)seq.getObjectAt(1);
                this.other = OtherKeyAttribute.getInstance(seq.getObjectAt(2));
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid KEKIdentifier");
            }
        }
    }

    public RecipientKeyIdentifier(ASN1OctetString subjectKeyIdentifier, DERGeneralizedTime date, OtherKeyAttribute other) {
        this.subjectKeyIdentifier = subjectKeyIdentifier;
        this.date = date;
        this.other = other;
    }

    public DERGeneralizedTime getDate() {
        return this.date;
    }

    public static RecipientKeyIdentifier getInstance(Object _obj) {
        if (_obj == null || _obj instanceof RecipientKeyIdentifier) {
            return (RecipientKeyIdentifier)_obj;
        }
        if (_obj instanceof ASN1Sequence) {
            return new RecipientKeyIdentifier((ASN1Sequence)_obj);
        }
        throw new IllegalArgumentException("Invalid RecipientKeyIdentifier: " + _obj.getClass().getName());
    }

    public static RecipientKeyIdentifier getInstance(ASN1TaggedObject _ato, boolean _explicit) {
        return RecipientKeyIdentifier.getInstance(ASN1Sequence.getInstance(_ato, _explicit));
    }

    public OtherKeyAttribute getOtherKeyAttribute() {
        return this.other;
    }

    public ASN1OctetString getSubjectKeyIdentifier() {
        return this.subjectKeyIdentifier;
    }

    public DERObject toASN1Object() {
        ASN1EncodableVector v = new ASN1EncodableVector();
        v.add(this.subjectKeyIdentifier);
        if (this.date != null) {
            v.add(this.date);
        }
        if (this.other != null) {
            v.add(this.other);
        }
        return new DERSequence(v);
    }
}

