/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1.test;

import org.bouncycastle.asn1.x509.KeyUsage;
import org.bouncycastle.util.test.SimpleTestResult;
import org.bouncycastle.util.test.Test;
import org.bouncycastle.util.test.TestResult;

public class BitStringTest
implements Test {
    public String getName() {
        return "BitString";
    }

    public static void main(String[] args) {
        BitStringTest test = new BitStringTest();
        TestResult result = test.perform();
        System.out.println(result);
    }

    public TestResult perform() {
        KeyUsage k = new KeyUsage(128);
        if (k.getBytes()[0] != -128 || k.getPadBits() != 7) {
            return new SimpleTestResult(false, this.getName() + ": failed digitalSignature");
        }
        k = new KeyUsage(64);
        if (k.getBytes()[0] != 64 || k.getPadBits() != 6) {
            return new SimpleTestResult(false, this.getName() + ": failed nonRepudiation");
        }
        k = new KeyUsage(32);
        if (k.getBytes()[0] != 32 || k.getPadBits() != 5) {
            return new SimpleTestResult(false, this.getName() + ": failed keyEncipherment");
        }
        k = new KeyUsage(2);
        if (k.getBytes()[0] != 2 || k.getPadBits() != 1) {
            return new SimpleTestResult(false, this.getName() + ": failed cRLSign");
        }
        k = new KeyUsage(32768);
        if (k.getBytes()[1] != -128 || k.getPadBits() != 7) {
            return new SimpleTestResult(false, this.getName() + ": failed decipherOnly");
        }
        return new SimpleTestResult(true, this.getName() + ": Okay");
    }
}

