/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.test;

import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.StreamCipher;
import org.bouncycastle.util.encoders.Hex;
import org.bouncycastle.util.test.SimpleTestResult;
import org.bouncycastle.util.test.Test;
import org.bouncycastle.util.test.TestResult;

public class StreamCipherVectorTest
implements Test {
    StreamCipher cipher;
    int id;
    byte[] input;
    byte[] output;
    CipherParameters param;

    public StreamCipherVectorTest(int id, StreamCipher cipher, CipherParameters param, String input, String output) {
        this.id = id;
        this.cipher = cipher;
        this.param = param;
        this.input = Hex.decode(input);
        this.output = Hex.decode(output);
    }

    public String getName() {
        return this.cipher.getAlgorithmName() + " Vector Test " + this.id;
    }

    private boolean isEqualArray(byte[] a, byte[] b) {
        if (a.length != b.length) {
            return false;
        }
        int i = 0;
        while (i != a.length) {
            if (a[i] != b[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public TestResult perform() {
        this.cipher.init(true, this.param);
        byte[] out = new byte[this.input.length];
        this.cipher.processBytes(this.input, 0, this.input.length, out, 0);
        if (!this.isEqualArray(out, this.output)) {
            return new SimpleTestResult(false, this.getName() + ": failed - " + "expected " + new String(Hex.encode(this.output)) + " got " + new String(Hex.encode(out)));
        }
        this.cipher.init(false, this.param);
        this.cipher.processBytes(this.output, 0, this.output.length, out, 0);
        if (!this.isEqualArray(this.input, out)) {
            return new SimpleTestResult(false, this.getName() + ": failed reversal");
        }
        return new SimpleTestResult(true, this.getName() + ": OKAY");
    }
}

