/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.core.buffer;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.CharsetDecoder;
import org.apache.mina.core.buffer.IoBufferAllocator;
import org.apache.mina.core.buffer.SimpleBufferAllocator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class IoBuffer
implements Comparable<IoBuffer> {
    private static IoBufferAllocator allocator = new SimpleBufferAllocator();
    private static boolean useDirectBuffer = false;

    public static IoBufferAllocator getAllocator() {
        return allocator;
    }

    public static void setAllocator(IoBufferAllocator ioBufferAllocator) {
        if (ioBufferAllocator == null) {
            throw new IllegalArgumentException("allocator");
        }
        IoBufferAllocator ioBufferAllocator2 = allocator;
        allocator = ioBufferAllocator;
        if (null != ioBufferAllocator2) {
            ioBufferAllocator2.dispose();
        }
    }

    public static IoBuffer allocate(int n) {
        return IoBuffer.allocate(n, useDirectBuffer);
    }

    public static IoBuffer allocate(int n, boolean bl) {
        if (n < 0) {
            throw new IllegalArgumentException("capacity: " + n);
        }
        return allocator.allocate(n, bl);
    }

    public static IoBuffer wrap(ByteBuffer byteBuffer) {
        return allocator.wrap(byteBuffer);
    }

    public static IoBuffer wrap(byte[] byArray) {
        return IoBuffer.wrap(ByteBuffer.wrap(byArray));
    }

    protected static int normalizeCapacity(int n) {
        int n2;
        if (n < 0) {
            return Integer.MAX_VALUE;
        }
        return (n2 <<= (n2 = Integer.highestOneBit(n)) < n ? 1 : 0) < 0 ? Integer.MAX_VALUE : n2;
    }

    protected IoBuffer() {
    }

    public abstract void free();

    public abstract ByteBuffer buf();

    public abstract int capacity();

    public abstract boolean isAutoExpand();

    public abstract IoBuffer setAutoExpand(boolean var1);

    public abstract int position();

    public abstract IoBuffer position(int var1);

    public abstract int limit();

    public abstract IoBuffer limit(int var1);

    public abstract IoBuffer mark();

    public abstract IoBuffer reset();

    public abstract IoBuffer clear();

    public abstract IoBuffer flip();

    public abstract IoBuffer rewind();

    public abstract int remaining();

    public abstract boolean hasRemaining();

    public abstract boolean hasArray();

    public abstract byte[] array();

    public abstract int arrayOffset();

    public abstract byte get();

    public abstract IoBuffer put(byte var1);

    public abstract byte get(int var1);

    public abstract IoBuffer get(byte[] var1, int var2, int var3);

    public abstract IoBuffer get(byte[] var1);

    public abstract IoBuffer put(IoBuffer var1);

    public abstract IoBuffer put(byte[] var1, int var2, int var3);

    public abstract IoBuffer put(byte[] var1);

    public abstract IoBuffer compact();

    public abstract ByteOrder order();

    public abstract IoBuffer order(ByteOrder var1);

    public abstract short getShort();

    public abstract IoBuffer putShort(short var1);

    public abstract int getInt();

    public abstract IoBuffer putInt(int var1);

    public abstract double getDouble();

    public abstract IoBuffer putDouble(double var1);

    public abstract String getHexDump();

    public abstract String getString(CharsetDecoder var1) throws CharacterCodingException;
}

