/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.core.future;

import java.util.ArrayList;
import java.util.List;
import org.apache.mina.core.future.CloseFuture;
import org.apache.mina.core.future.ConnectFuture;
import org.apache.mina.core.future.IoFuture;
import org.apache.mina.core.future.IoFutureListener;
import org.apache.mina.core.future.ReadFuture;
import org.apache.mina.core.future.WriteFuture;
import org.apache.mina.core.polling.AbstractPollingIoProcessor;
import org.apache.mina.core.service.IoProcessor;
import org.apache.mina.core.session.IoSession;
import org.apache.mina.util.ExceptionMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultIoFuture
implements IoFuture {
    private final IoSession session;
    private final Object lock;
    private IoFutureListener<?> firstListener;
    private List<IoFutureListener<?>> otherListeners;
    private Object result;
    private boolean ready;
    private int waiters;

    public DefaultIoFuture(IoSession ioSession) {
        this.session = ioSession;
        this.lock = this;
    }

    @Override
    public IoSession getSession() {
        return this.session;
    }

    public IoFuture awaitUninterruptibly() {
        try {
            this.await0(Long.MAX_VALUE, false);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean await0(long l, boolean bl) throws InterruptedException {
        long l2 = System.currentTimeMillis() + l;
        if (l2 < 0L) {
            l2 = Long.MAX_VALUE;
        }
        Object object = this.lock;
        synchronized (object) {
            if (this.ready) {
                return this.ready;
            }
            if (l <= 0L) {
                return this.ready;
            }
            ++this.waiters;
            try {
                do {
                    block13: {
                        try {
                            long l3 = Math.min(l, 5000L);
                            this.lock.wait(l3);
                        }
                        catch (InterruptedException interruptedException) {
                            if (!bl) break block13;
                            throw interruptedException;
                        }
                    }
                    if (!this.ready) continue;
                    boolean bl2 = true;
                    return bl2;
                } while (l2 >= System.currentTimeMillis());
                boolean bl3 = this.ready;
                return bl3;
            }
            finally {
                --this.waiters;
                if (!this.ready) {
                    this.checkDeadLock();
                }
            }
        }
    }

    private void checkDeadLock() {
        StackTraceElement[] stackTraceElementArray;
        if (!(this instanceof CloseFuture || this instanceof WriteFuture || this instanceof ReadFuture || this instanceof ConnectFuture)) {
            return;
        }
        for (StackTraceElement stackTraceElement : stackTraceElementArray = Thread.currentThread().getStackTrace()) {
            if (!AbstractPollingIoProcessor.class.getName().equals(stackTraceElement.getClassName())) continue;
            IllegalStateException illegalStateException = new IllegalStateException("t");
            illegalStateException.getStackTrace();
            throw new IllegalStateException("DEAD LOCK: " + IoFuture.class.getSimpleName() + ".await() was invoked from an I/O processor thread.  " + "Please use " + IoFutureListener.class.getSimpleName() + " or configure a proper thread model alternatively.");
        }
        for (StackTraceElement stackTraceElement : stackTraceElementArray) {
            try {
                Class<?> clazz = DefaultIoFuture.class.getClassLoader().loadClass(stackTraceElement.getClassName());
                if (!IoProcessor.class.isAssignableFrom(clazz)) continue;
                throw new IllegalStateException("DEAD LOCK: " + IoFuture.class.getSimpleName() + ".await() was invoked from an I/O processor thread.  " + "Please use " + IoFutureListener.class.getSimpleName() + " or configure a proper thread model alternatively.");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isDone() {
        Object object = this.lock;
        synchronized (object) {
            return this.ready;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setValue(Object object) {
        Object object2 = this.lock;
        synchronized (object2) {
            if (this.ready) {
                return;
            }
            this.result = object;
            this.ready = true;
            if (this.waiters > 0) {
                this.lock.notifyAll();
            }
        }
        this.notifyListeners();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object getValue() {
        Object object = this.lock;
        synchronized (object) {
            return this.result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IoFuture addListener(IoFutureListener<?> ioFutureListener) {
        if (ioFutureListener == null) {
            throw new IllegalArgumentException("listener");
        }
        boolean bl = false;
        Object object = this.lock;
        synchronized (object) {
            if (this.ready) {
                bl = true;
            } else if (this.firstListener == null) {
                this.firstListener = ioFutureListener;
            } else {
                if (this.otherListeners == null) {
                    this.otherListeners = new ArrayList(1);
                }
                this.otherListeners.add(ioFutureListener);
            }
        }
        if (bl) {
            this.notifyListener(ioFutureListener);
        }
        return this;
    }

    private void notifyListeners() {
        if (this.firstListener != null) {
            this.notifyListener(this.firstListener);
            this.firstListener = null;
            if (this.otherListeners != null) {
                for (IoFutureListener<?> ioFutureListener : this.otherListeners) {
                    this.notifyListener(ioFutureListener);
                }
                this.otherListeners = null;
            }
        }
    }

    private void notifyListener(IoFutureListener ioFutureListener) {
        try {
            ioFutureListener.operationComplete(this);
        }
        catch (Throwable throwable) {
            ExceptionMonitor.getInstance().exceptionCaught(throwable);
        }
    }
}

