/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.filter.codec;

import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.apache.mina.core.buffer.IoBuffer;
import org.apache.mina.filter.codec.ProtocolEncoderOutput;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractProtocolEncoderOutput
implements ProtocolEncoderOutput {
    private final Queue<Object> messageQueue = new ConcurrentLinkedQueue<Object>();
    private boolean buffersOnly = true;

    public Queue<Object> getMessageQueue() {
        return this.messageQueue;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void write(Object object) {
        if (object instanceof IoBuffer) {
            IoBuffer ioBuffer = (IoBuffer)object;
            if (!ioBuffer.hasRemaining()) throw new IllegalArgumentException("buf is empty. Forgot to call flip()?");
            this.messageQueue.offer(ioBuffer);
            return;
        } else {
            this.messageQueue.offer(object);
            this.buffersOnly = false;
        }
    }
}

