/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.proxy.handlers.http.digest;

import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import javax.security.sasl.AuthenticationException;
import org.apache.mina.core.session.IoSession;
import org.apache.mina.proxy.session.ProxyIoSession;
import org.apache.mina.proxy.utils.ByteUtilities;
import org.apache.mina.proxy.utils.StringUtilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DigestUtilities {
    public static final String SESSION_HA1 = DigestUtilities.class + ".SessionHA1";
    private static MessageDigest md5;
    public static final String[] SUPPORTED_QOPS;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static String computeResponseValue(IoSession ioSession, HashMap<String, String> hashMap, String string, String string2, String string3, String string4) throws AuthenticationException, UnsupportedEncodingException {
        MessageDigest messageDigest;
        byte[] byArray;
        Object object;
        Object object2;
        String string5;
        StringBuilder stringBuilder;
        boolean bl = "md5-sess".equalsIgnoreCase(StringUtilities.getDirectiveValue(hashMap, "algorithm", false));
        if (!bl || ioSession.getAttribute(SESSION_HA1) == null) {
            stringBuilder = new StringBuilder();
            stringBuilder.append(StringUtilities.stringTo8859_1(StringUtilities.getDirectiveValue(hashMap, "username", true))).append(':');
            string5 = StringUtilities.stringTo8859_1(StringUtilities.getDirectiveValue(hashMap, "realm", false));
            if (string5 != null) {
                stringBuilder.append(string5);
            }
            stringBuilder.append(':').append(string2);
            if (bl) {
                object2 = md5;
                // MONITORENTER : object2
                md5.reset();
                object = md5.digest(stringBuilder.toString().getBytes(string3));
                // MONITOREXIT : object2
                stringBuilder = new StringBuilder();
                stringBuilder.append(ByteUtilities.asHex((byte[])object));
                stringBuilder.append(':').append(StringUtilities.stringTo8859_1(StringUtilities.getDirectiveValue(hashMap, "nonce", true)));
                stringBuilder.append(':').append(StringUtilities.stringTo8859_1(StringUtilities.getDirectiveValue(hashMap, "cnonce", true)));
                object2 = md5;
                // MONITORENTER : object2
                md5.reset();
                byArray = md5.digest(stringBuilder.toString().getBytes(string3));
                // MONITOREXIT : object2
                ioSession.setAttribute(SESSION_HA1, byArray);
            } else {
                object = md5;
                // MONITORENTER : object
                md5.reset();
                byArray = md5.digest(stringBuilder.toString().getBytes(string3));
                // MONITOREXIT : object
            }
        } else {
            byArray = (byte[])ioSession.getAttribute(SESSION_HA1);
        }
        stringBuilder = new StringBuilder(string);
        stringBuilder.append(':');
        stringBuilder.append(StringUtilities.getDirectiveValue(hashMap, "uri", false));
        string5 = StringUtilities.getDirectiveValue(hashMap, "qop", false);
        if ("auth-int".equalsIgnoreCase(string5)) {
            object = (ProxyIoSession)ioSession.getAttribute(ProxyIoSession.PROXY_SESSION);
            messageDigest = md5;
            // MONITORENTER : messageDigest
            md5.reset();
            object2 = md5.digest(string4.getBytes(((ProxyIoSession)object).getCharsetName()));
            // MONITOREXIT : messageDigest
            stringBuilder.append(':').append(object2);
        }
        object2 = md5;
        // MONITORENTER : object2
        md5.reset();
        object = md5.digest(stringBuilder.toString().getBytes(string3));
        // MONITOREXIT : object2
        stringBuilder = new StringBuilder();
        stringBuilder.append(ByteUtilities.asHex(byArray));
        stringBuilder.append(':').append(StringUtilities.getDirectiveValue(hashMap, "nonce", true));
        stringBuilder.append(":00000001:");
        stringBuilder.append(StringUtilities.getDirectiveValue(hashMap, "cnonce", true));
        stringBuilder.append(':').append(string5).append(':');
        stringBuilder.append(ByteUtilities.asHex((byte[])object));
        messageDigest = md5;
        // MONITORENTER : messageDigest
        md5.reset();
        object2 = md5.digest(stringBuilder.toString().getBytes(string3));
        // MONITOREXIT : messageDigest
        return ByteUtilities.asHex((byte[])object2);
    }

    static {
        try {
            md5 = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new RuntimeException(noSuchAlgorithmException);
        }
        SUPPORTED_QOPS = new String[]{"auth", "auth-int"};
    }
}

