/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.util;

import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.mina.util.ExpirationListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExpiringMap<K, V>
implements Map<K, V> {
    private static volatile int expirerCount = 1;
    private final ConcurrentHashMap<K, ExpiringObject> delegate;
    private final CopyOnWriteArrayList<ExpirationListener<V>> expirationListeners;
    private final Expirer expirer;

    public ExpiringMap(int n, int n2) {
        this(new ConcurrentHashMap(), new CopyOnWriteArrayList<ExpirationListener<V>>(), n, n2);
    }

    private ExpiringMap(ConcurrentHashMap<K, ExpiringObject> concurrentHashMap, CopyOnWriteArrayList<ExpirationListener<V>> copyOnWriteArrayList, int n, int n2) {
        this.delegate = concurrentHashMap;
        this.expirationListeners = copyOnWriteArrayList;
        this.expirer = new Expirer();
        this.expirer.setTimeToLive(n);
        this.expirer.setExpirationInterval(n2);
    }

    @Override
    public V put(K k, V v) {
        ExpiringObject expiringObject = this.delegate.put(k, new ExpiringObject(k, v, System.currentTimeMillis()));
        if (expiringObject == null) {
            return null;
        }
        return expiringObject.getValue();
    }

    @Override
    public V get(Object object) {
        ExpiringObject expiringObject = this.delegate.get(object);
        if (expiringObject != null) {
            expiringObject.setLastAccessTime(System.currentTimeMillis());
            return expiringObject.getValue();
        }
        return null;
    }

    @Override
    public V remove(Object object) {
        ExpiringObject expiringObject = this.delegate.remove(object);
        if (expiringObject == null) {
            return null;
        }
        return expiringObject.getValue();
    }

    @Override
    public boolean containsKey(Object object) {
        return this.delegate.containsKey(object);
    }

    @Override
    public boolean containsValue(Object object) {
        return this.delegate.containsValue(object);
    }

    @Override
    public int size() {
        return this.delegate.size();
    }

    @Override
    public boolean isEmpty() {
        return this.delegate.isEmpty();
    }

    @Override
    public void clear() {
        this.delegate.clear();
    }

    @Override
    public int hashCode() {
        return this.delegate.hashCode();
    }

    @Override
    public Set<K> keySet() {
        return this.delegate.keySet();
    }

    @Override
    public boolean equals(Object object) {
        return this.delegate.equals(object);
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> map) {
        for (Map.Entry<K, V> entry : map.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public Collection<V> values() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        throw new UnsupportedOperationException();
    }

    public void addExpirationListener(ExpirationListener<V> expirationListener) {
        this.expirationListeners.add(expirationListener);
    }

    public Expirer getExpirer() {
        return this.expirer;
    }

    static /* synthetic */ int access$008() {
        return expirerCount++;
    }

    public class Expirer
    implements Runnable {
        private final ReadWriteLock stateLock = new ReentrantReadWriteLock();
        private long timeToLiveMillis;
        private long expirationIntervalMillis;
        private boolean running = false;
        private final Thread expirerThread = new Thread((Runnable)this, "ExpiringMapExpirer-" + ExpiringMap.access$008());

        public Expirer() {
            this.expirerThread.setDaemon(true);
        }

        public void run() {
            while (this.running) {
                this.processExpires();
                try {
                    Thread.sleep(this.expirationIntervalMillis);
                }
                catch (InterruptedException interruptedException) {}
            }
        }

        private void processExpires() {
            long l = System.currentTimeMillis();
            for (ExpiringObject expiringObject : ExpiringMap.this.delegate.values()) {
                long l2;
                if (this.timeToLiveMillis <= 0L || (l2 = l - expiringObject.getLastAccessTime()) < this.timeToLiveMillis) continue;
                ExpiringMap.this.delegate.remove(expiringObject.getKey());
                for (ExpirationListener expirationListener : ExpiringMap.this.expirationListeners) {
                    expirationListener.expired(expiringObject.getValue());
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setTimeToLive(long l) {
            this.stateLock.writeLock().lock();
            try {
                this.timeToLiveMillis = l * 1000L;
            }
            finally {
                this.stateLock.writeLock().unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setExpirationInterval(long l) {
            this.stateLock.writeLock().lock();
            try {
                this.expirationIntervalMillis = l * 1000L;
            }
            finally {
                this.stateLock.writeLock().unlock();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ExpiringObject {
        private K key;
        private V value;
        private long lastAccessTime;
        private final ReadWriteLock lastAccessTimeLock = new ReentrantReadWriteLock();

        ExpiringObject(K k, V v, long l) {
            if (v == null) {
                throw new IllegalArgumentException("An expiring object cannot be null.");
            }
            this.key = k;
            this.value = v;
            this.lastAccessTime = l;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public long getLastAccessTime() {
            this.lastAccessTimeLock.readLock().lock();
            try {
                long l = this.lastAccessTime;
                return l;
            }
            finally {
                this.lastAccessTimeLock.readLock().unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setLastAccessTime(long l) {
            this.lastAccessTimeLock.writeLock().lock();
            try {
                this.lastAccessTime = l;
            }
            finally {
                this.lastAccessTimeLock.writeLock().unlock();
            }
        }

        public K getKey() {
            return this.key;
        }

        public V getValue() {
            return this.value;
        }

        public boolean equals(Object object) {
            return this.value.equals(object);
        }

        public int hashCode() {
            return this.value.hashCode();
        }
    }
}

