/*
 * Decompiled with CFR 0.152.
 */
package cz.vity.freerapid.core;

import cz.vity.freerapid.core.AppPrefs;
import cz.vity.freerapid.core.CmdLine;
import cz.vity.freerapid.core.Lng;
import cz.vity.freerapid.core.OneInstanceClient;
import cz.vity.freerapid.core.UIStringsManager;
import cz.vity.freerapid.core.application.GlobalEDTExceptionHandler;
import cz.vity.freerapid.core.application.ListItemsConvertor;
import cz.vity.freerapid.core.tasks.CheckForNewVersionTask;
import cz.vity.freerapid.gui.managers.ManagerDirector;
import cz.vity.freerapid.swing.LookAndFeels;
import cz.vity.freerapid.swing.Swinger;
import cz.vity.freerapid.swing.TrayIconSupport;
import cz.vity.freerapid.utilities.Browser;
import cz.vity.freerapid.utilities.LogUtils;
import cz.vity.freerapid.utilities.Utils;
import cz.vity.freerapid.utilities.os.SystemCommanderFactory;
import java.awt.ComponentOrientation;
import java.awt.Dimension;
import java.awt.SplashScreen;
import java.awt.event.WindowEvent;
import java.io.File;
import java.net.ProxySelector;
import java.util.EventObject;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import org.jdesktop.appframework.swingx.SingleXFrameApplication;
import org.jdesktop.application.Application;
import org.jdesktop.application.ApplicationContext;
import org.jdesktop.application.ResourceConverter;

public class MainApp
extends SingleXFrameApplication {
    public static final int BUILD_REQUEST = 14;
    public static final int PLUGINS_VERSION = 12;
    static boolean debug = false;
    private ManagerDirector director;
    private TrayIconSupport trayIconSupport = null;
    private AppPrefs appPrefs;
    private boolean minimizeOnStart = false;

    @Override
    protected void initialize(String[] args) {
        if (this.checkInvalidPath()) {
            return;
        }
        CmdLine line = new CmdLine(this);
        List<String> fileList = line.processCommandLine(args);
        try {
            SplashScreen splash = SplashScreen.getSplashScreen();
            if (splash != null && line.isNosplash()) {
                splash.close();
            }
        }
        catch (IllegalStateException e) {
            e.printStackTrace();
        }
        try {
            LogUtils.initLogging(debug ? "logdebug.properties" : "logdefault.properties");
        }
        catch (Exception e) {
            this.getLogger().log(Level.SEVERE, e.getMessage());
        }
        this.minimizeOnStart = line.isMinimize();
        String vm = System.getProperty("java.vm.vendor", "");
        if (vm.toLowerCase(Locale.ENGLISH).contains("gcj")) {
            this.getLogger().log(Level.SEVERE, "Not using Sun Java" + vm);
            this.exitWithErrorMessage(String.format("You are not using Sun Java, but %s. See readme.txt for minimal requirements to run FreeRapid Downloader.", vm), new Object[0]);
        }
        Map<String, String> map = line.getProperties();
        if (Utils.isWindows() && (new File("C:/Program files/Eset").exists() || new File("D:/Program files/Eset").exists()) && !map.containsKey("oneinstance")) {
            this.getLogger().warning("Detected ESET - disabling OneInstance functionality");
            map.put("oneinstance", "false");
        }
        try {
            this.appPrefs = new AppPrefs(this.getContext(), map, line.isResetOptions());
        }
        catch (IllegalStateException e) {
            this.getLogger().log(Level.SEVERE, e.getMessage());
            this.exitWithErrorMessage("Fatal Error - not all required libraries are available.\nYou probably didn't extract the zip file properly.\nYou have to have /lib directory with all libraries in the FreeRapid directory.\nExiting.", new Object[0]);
        }
        this.checkBugs();
        System.getProperties().put("arguments", args);
        System.setProperty("apple.laf.useScreenMenuBar", String.valueOf(AppPrefs.getProperty("apple.laf.useScreenMenuBar", true)));
        System.setProperty("objectdb.conf", new File(Utils.getAppPath(), "objectdb.conf").getAbsolutePath());
        SystemCommanderFactory.getInstance().getSystemCommanderInstance(this.getContext());
        if (OneInstanceClient.checkInstance(fileList, this.appPrefs, this.getContext())) {
            this.exit();
            return;
        }
        Lng.loadLangProperties();
        this.getContext().getResourceMap();
        ResourceConverter.register(new ListItemsConvertor());
        this.getContext().getTaskMonitor().setAutoUpdateForegroundTask(false);
        LookAndFeels.getInstance().loadLookAndFeelSettings();
        super.initialize(args);
    }

    @Override
    protected void ready() {
        this.director.guiIsReady();
    }

    private boolean checkInvalidPath() {
        String path = Utils.getAppPath();
        int index = path.indexOf(43);
        if (index == -1) {
            index = path.indexOf("!/");
        }
        if (index == -1) {
            index = path.indexOf("!\\");
        }
        if (index > 0 || path.endsWith("!")) {
            String msg = String.format("This application cannot be started on the path containing '+' or '!' characters ('%s'...)\nPlease move FRD's folder to another place.\nSorry for inconvenience. Exiting.", path.substring(0, index + 1));
            JOptionPane.showMessageDialog(null, msg, "Error", 0);
            this.getLogger().severe(msg);
            System.exit(1);
            return true;
        }
        return false;
    }

    private Logger getLogger() {
        return Logger.getLogger(MainApp.class.getName());
    }

    private void checkBugs() {
        String jvm = System.getProperty("java.version");
        this.getLogger().info("You are running FRD with JVM version = " + System.getProperty("java.home") + "  " + System.getProperty("java.version") + " - (min 1.6.0_07 is required)");
        if ("1.6.0_0".equals(jvm) || "1.6.0-beta".equals(System.getProperty("java.version"))) {
            this.exitWithErrorMessage("errorInvalidJRE", new Object[0]);
        }
    }

    private void exitWithErrorMessage(String s, Object ... args) {
        this.getLogger().severe(s);
        Swinger.showErrorMessage(this.getContext().getResourceMap(), s, args);
        System.exit(1);
    }

    @Override
    protected void startup() {
        super.startup();
        this.director = new ManagerDirector(this.getContext());
        this.director.initComponents();
        UIStringsManager.load(this.getContext().getResourceManager());
        this.initMainFrame();
        this.addExitListener(new MainAppExitListener());
        JFrame mainFrame = this.getMainFrame();
        this.show(mainFrame);
        this.getTrayIconSupport().setVisibleByDefault();
        this.setGlobalEDTExceptionHandler();
        if (this.minimizeOnStart) {
            Swinger.minimize(mainFrame);
        }
        this.showDelayedRequestPaypalDialog();
    }

    private void showDelayedRequestPaypalDialog() {
        Thread appThread = new Thread(){

            @Override
            public void run() {
                try {
                    Thread.sleep(20000L);
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            MainApp.this.paypalRequest();
                        }
                    });
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        };
        appThread.setPriority(1);
        appThread.start();
    }

    private void paypalRequest() {
        if (AppPrefs.getProperty("showPaypalRequest", 13) != 14) {
            AppPrefs.storeProperty("showPaypalRequest", 14);
            int res = Swinger.getChoiceYesNo(this.getContext().getResourceMap().getString("paypalSupportAction.Action.shortDescription", new Object[0]));
            if (res == 0) {
                Browser.openBrowser(AppPrefs.getProperty("paypal", "http://vity.cz/freerapid/paypal"));
            }
        }
    }

    private void initMainFrame() {
        ProxySelector.setDefault(null);
        JFrame frame = this.getMainFrame();
        frame.setVisible(false);
        if (AppPrefs.getProperty("decoratedFrames", false)) {
            JFrame.setDefaultLookAndFeelDecorated(true);
            frame.setUndecorated(true);
            frame.getRootPane().setWindowDecorationStyle(1);
            LookAndFeels.updateWindowUI(frame);
            JDialog.setDefaultLookAndFeelDecorated(true);
        }
        frame.setJMenuBar(this.director.getMenuManager().getMenuBar());
        frame.setContentPane(this.director.getComponent());
        ComponentOrientation componentOrientation = ComponentOrientation.getOrientation(Locale.getDefault());
        frame.getJMenuBar().applyComponentOrientation(componentOrientation);
        frame.getContentPane().applyComponentOrientation(componentOrientation);
        frame.setMinimumSize(new Dimension(30, 30));
        frame.pack();
        if (AppPrefs.getProperty("checkForNewVersionAuto", true)) {
            this.startCheckNewVersion();
        }
    }

    private void setGlobalEDTExceptionHandler() {
        GlobalEDTExceptionHandler eh = new GlobalEDTExceptionHandler();
        Thread.setDefaultUncaughtExceptionHandler(eh);
        Thread.currentThread().setUncaughtExceptionHandler(eh);
    }

    public ManagerDirector getManagerDirector() {
        assert (this.director != null);
        return this.director;
    }

    public static void main(String[] args) {
        System.setProperty("com.apple.mrj.application.apple.menu.about.name", "FreeRapid Downloader");
        Application.launch(MainApp.class, args);
    }

    public static ApplicationContext getAContext() {
        return Application.getInstance(MainApp.class).getContext();
    }

    private void startCheckNewVersion() {
        Thread appThread = new Thread(){

            @Override
            public void run() {
                try {
                    Thread.sleep(30000L);
                    MainApp.this.getContext().getTaskService().execute(new CheckForNewVersionTask(false));
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        };
        appThread.setPriority(1);
        appThread.start();
    }

    public TrayIconSupport getTrayIconSupport() {
        if (this.trayIconSupport == null) {
            this.trayIconSupport = new TrayIconSupport();
        }
        return this.trayIconSupport;
    }

    public AppPrefs getAppPrefs() {
        return this.appPrefs;
    }

    private class MainAppExitListener
    implements Application.ExitListener {
        private MainAppExitListener() {
        }

        @Override
        public boolean canExit(EventObject event) {
            if (AppPrefs.getProperty("minimizeOnClose", false) && event instanceof WindowEvent) {
                MainApp.this.getMainFrame().setVisible(false);
                return false;
            }
            return true;
        }

        @Override
        public void willExit(EventObject event) {
            MainApp.this.appPrefs.store();
        }
    }
}

