/*
 * Decompiled with CFR 0.152.
 */
package cz.vity.freerapid.core.tasks;

import cz.vity.freerapid.core.tasks.DownloadTask;
import cz.vity.freerapid.core.tasks.ScreenInputBlocker;
import cz.vity.freerapid.core.tasks.exceptions.NoAvailableConnection;
import cz.vity.freerapid.core.tasks.exceptions.UpdateFailedException;
import cz.vity.freerapid.gui.dialogs.WrappedPluginData;
import cz.vity.freerapid.gui.managers.ClientManager;
import cz.vity.freerapid.gui.managers.ManagerDirector;
import cz.vity.freerapid.gui.managers.PluginsManager;
import cz.vity.freerapid.model.DownloadFile;
import cz.vity.freerapid.plugins.webclient.ConnectionSettings;
import cz.vity.freerapid.plugins.webclient.DownloadClient;
import cz.vity.freerapid.plugins.webclient.DownloadState;
import cz.vity.freerapid.swing.Swinger;
import cz.vity.freerapid.utilities.LogUtils;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.UnknownHostException;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Logger;
import org.apache.commons.httpclient.methods.GetMethod;
import org.java.plugin.JpfException;
import org.jdesktop.application.ApplicationContext;
import org.jdesktop.application.Task;

public class DownloadNewPluginsTask
extends DownloadTask {
    private static final Logger logger = Logger.getLogger(DownloadNewPluginsTask.class.getName());
    private final ManagerDirector director;
    private final List<WrappedPluginData> fileList;
    private final boolean beQuiet;
    private Collection<WrappedPluginData> updatedPlugins = new LinkedList<WrappedPluginData>();

    public DownloadNewPluginsTask(ManagerDirector director, ApplicationContext context, List<WrappedPluginData> fileList, boolean beQuiet) {
        super(context.getApplication());
        this.director = director;
        this.fileList = fileList;
        this.beQuiet = beQuiet;
        ScreenInputBlocker blocker = new ScreenInputBlocker(this, Task.BlockingScope.APPLICATION, Swinger.getActiveFrame(), null);
        this.setInputBlocker(blocker);
        this.setUseRelativeStoreFileIfPossible(false);
    }

    @Override
    protected Void doInBackground() throws Exception {
        this.message("downloadNewPluginsTask", new Object[0]);
        ClientManager clientManager = this.director.getClientManager();
        List<ConnectionSettings> connectionSettingses = clientManager.getEnabledConnections();
        if (connectionSettingses.isEmpty()) {
            throw new NoAvailableConnection(this.getResourceMap().getString("noAvailableConnection", new Object[0]));
        }
        this.client = new DownloadClient();
        this.client.initClient(connectionSettingses.get(0));
        this.initDownloadThread();
        File dir = this.director.getPluginsManager().getPluginsDir();
        if (!dir.canWrite()) {
            throw new IOException(this.getResourceMap().getString("pluginsDirectoryIsNotWriteable", new Object[0]));
        }
        try {
            File tempFile = File.createTempFile("detect", "writeableplugins", dir);
            boolean b = tempFile.delete();
            if (!b) {
                tempFile.deleteOnExit();
            }
        }
        catch (Exception e) {
            throw new IOException(this.getResourceMap().getString("pluginsDirectoryIsNotWriteable", new Object[0]));
        }
        boolean success = false;
        int counter = 0;
        for (WrappedPluginData data : this.fileList) {
            this.setProgress(counter++, 0, this.fileList.size());
            if (this.isCancelled()) break;
            DownloadFile file = data.getHttpFile();
            if (data.isToBeDeleted()) {
                file.setState(DownloadState.COMPLETED);
                file.setFileSize(10L);
                file.setDownloaded(10L);
                this.updatedPlugins.add(data);
                success = true;
                continue;
            }
            try {
                this.setDownloadFile(file);
                this.downloadFile.setSaveToDirectory(dir);
                this.processFile(file);
                this.updatedPlugins.add(data);
                success = true;
            }
            catch (Exception e) {
                file.setState(DownloadState.ERROR);
                this.setFileErrorMessage(e);
                LogUtils.processException(logger, e);
            }
        }
        this.message("DownloadNewPluginsTask.reloadingPlugins", new Object[0]);
        this.updatePlugins();
        if (!success) {
            throw new UpdateFailedException("UpdateFailed");
        }
        return null;
    }

    private void processFile(DownloadFile file) throws Exception {
        GetMethod getMethod = this.client.getGetMethod(file.getFileUrl().toExternalForm());
        InputStream inputStream = this.client.makeRequestForFile(getMethod);
        if (this.isCancelled()) {
            return;
        }
        if (inputStream != null) {
            this.saveToFile(inputStream);
            this.checkRewrite(file);
            if (this.isCancelled()) {
                return;
            }
        } else {
            throw new IOException("FileWasNotFoundOnServer");
        }
        file.setState(DownloadState.COMPLETED);
    }

    private void updatePlugins() throws JpfException {
        PluginsManager pluginsManager = this.director.getPluginsManager();
        pluginsManager.updateNewPlugins(this.updatedPlugins);
    }

    @Override
    protected void cancelled() {
        super.cancelled();
        for (WrappedPluginData data : this.fileList) {
            DownloadFile file = data.getHttpFile();
            if (file.getState() == DownloadState.COMPLETED) continue;
            file.setState(DownloadState.CANCELLED);
        }
        try {
            this.updatePlugins();
        }
        catch (JpfException e) {
            LogUtils.processException(logger, e);
        }
    }

    private void checkRewrite(DownloadFile downloadFile) throws IOException {
        boolean b;
        File storeFile;
        File out = downloadFile.getOutputFile();
        if (out.exists()) {
            out.delete();
        }
        if ((storeFile = downloadFile.getStoreFile()) != null && !(b = storeFile.renameTo(out))) {
            throw new IOException("Renaming target file failed " + downloadFile.getStoreFile() + " -> " + out);
        }
    }

    @Override
    protected int checkExists() throws InvocationTargetException, InterruptedException {
        return -2;
    }

    @Override
    protected boolean useTemporaryFiles() {
        return true;
    }

    @Override
    protected void failed(Throwable cause) {
        LogUtils.processException(logger, cause);
        if (this.handleRuntimeException(cause)) {
            return;
        }
        this.error(cause);
        if (cause instanceof UnknownHostException) {
            Swinger.showErrorMessage(this.getResourceMap(), "errormessage_check_inet_settings", new Object[0]);
        } else {
            Swinger.showErrorMessage(this.getResourceMap(), cause);
        }
    }

    @Override
    protected void succeeded(Void result) {
        if (!this.beQuiet && !this.updatedPlugins.isEmpty()) {
            Swinger.showInformationDialog(this.getResourceMap().getString("installedSuccessFully", new Object[0]));
        }
    }
}

