/*
 * Decompiled with CFR 0.152.
 */
package cz.vity.freerapid.gui.content;

import cz.vity.freerapid.model.DownloadFile;
import java.awt.Component;
import javax.swing.Icon;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import org.jdesktop.application.ApplicationContext;
import org.jdesktop.application.ResourceMap;

final class CheckedCellRenderer
extends DefaultTableCellRenderer {
    private final Icon notFound;
    private final Icon checked;
    private final Icon unknown;
    private final ApplicationContext context;

    CheckedCellRenderer(ApplicationContext context) {
        this.context = context;
        ResourceMap map = context.getResourceMap();
        this.notFound = map.getIcon("notFoundIcon");
        this.checked = map.getIcon("checkedIcon");
        this.unknown = map.getIcon("unknownIcon");
    }

    @Override
    public final Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        if (value == null) {
            value = table.getValueAt(row, column);
        }
        DownloadFile downloadFile = (DownloadFile)value;
        assert (downloadFile != null);
        this.setIconTextGap(2);
        this.setHorizontalAlignment(0);
        Component rendererComponent = super.getTableCellRendererComponent(table, null, isSelected, hasFocus, row, column);
        switch (downloadFile.getFileState()) {
            case FILE_NOT_FOUND: {
                this.setIcon(this.notFound);
                this.setToolTipText(this.context.getResourceMap().getString("checked_fileNotFound", new Object[0]));
                break;
            }
            case CHECKED_AND_EXISTING: {
                this.setIcon(this.checked);
                this.setToolTipText(this.context.getResourceMap().getString("checked_success", new Object[0]));
                break;
            }
            default: {
                this.setToolTipText(this.context.getResourceMap().getString("checked_unknown", new Object[0]));
                this.setIcon(this.unknown);
            }
        }
        this.getAccessibleContext().setAccessibleName(table.getColumnName(column) + "   " + this.getToolTipText());
        return rendererComponent;
    }
}

