/*
 * Decompiled with CFR 0.152.
 */
package cz.vity.freerapid.plugins.webclient.utils;

import cz.vity.freerapid.plugins.exceptions.PluginImplementationException;
import cz.vity.freerapid.plugins.webclient.utils.PlugUtils;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.codehaus.jackson.map.DeserializationConfig;
import org.codehaus.jackson.map.ObjectMapper;

public class JsonMapper {
    private final ObjectMapper objectMapper = new ObjectMapper();
    private static final Logger logger = Logger.getLogger(PlugUtils.class.getName());

    public JsonMapper() {
        this.objectMapper.configure(DeserializationConfig.Feature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    }

    public <T> T deserialize(String contentAsString, Class<T> objectClass) throws PluginImplementationException {
        try {
            return this.objectMapper.readValue(contentAsString, objectClass);
        }
        catch (IOException e) {
            logger.log(Level.SEVERE, "cannot parse json", e);
            throw new PluginImplementationException("Cannot parse JSON for class" + objectClass.getName());
        }
    }

    public ObjectMapper getObjectMapper() {
        return this.objectMapper;
    }
}

