/*
 * Decompiled with CFR 0.152.
 */
package cz.vity.freerapid.swing.components;

import cz.vity.freerapid.swing.components.FindOnDemandAction;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.text.Position;
import org.jdesktop.application.ResourceMap;

public abstract class FindTableAction
extends FindOnDemandAction {
    private final int searchColumn;

    public FindTableAction(ResourceMap map, int searchColumn) {
        super(map);
        this.searchColumn = searchColumn;
    }

    @Override
    protected boolean changed(JComponent comp, String searchString, Position.Bias bias) {
        int index;
        int startingRow;
        JTable table = (JTable)comp;
        boolean startingFromSelection = true;
        int max = table.getRowCount();
        if (max == 0) {
            return false;
        }
        int increment = 0;
        if (bias != null) {
            int n = increment = bias == Position.Bias.Forward ? 1 : -1;
        }
        if ((startingRow = (table.getSelectionModel().getLeadSelectionIndex() + increment + max) % max) < 0 || startingRow >= table.getRowCount()) {
            startingFromSelection = false;
            startingRow = 0;
        }
        if ((index = this.getNextMatch(table, searchString, startingRow, bias)) != -1) {
            this.changeSelection(table, index);
            return true;
        }
        if (startingFromSelection && (index = this.getNextMatch(table, searchString, 0, bias)) != -1) {
            this.changeSelection(table, index);
            return true;
        }
        return false;
    }

    protected void changeSelection(JTable table, int index) {
        if (this.controlDown) {
            table.addRowSelectionInterval(index, index);
        } else {
            table.setRowSelectionInterval(index, index);
        }
        int column = this.searchColumn;
        if (column == -1) {
            column = 0;
        }
        table.scrollRectToVisible(table.getCellRect(index, column, true));
    }

    public int getNextMatch(JTable table, String prefix, int startIndex, Position.Bias bias) {
        int max;
        int column = this.searchColumn;
        if (column == -1) {
            column = 0;
        }
        if ((max = table.getRowCount()) == 0) {
            return -1;
        }
        if (prefix == null) {
            throw new IllegalArgumentException();
        }
        if (startIndex < 0 || startIndex >= max) {
            throw new IllegalArgumentException();
        }
        if (this.ignoreCase) {
            prefix = prefix.toUpperCase();
        }
        int increment = bias == null || bias == Position.Bias.Forward ? 1 : -1;
        int index = startIndex;
        do {
            Object item;
            if ((item = this.getObject(table.convertRowIndexToModel(index), column)) == null) continue;
            String text = item.toString();
            if (this.ignoreCase) {
                text = text.toUpperCase();
            }
            if (text == null || text.indexOf(prefix) < 0) continue;
            return index;
        } while ((index = (index + increment + max) % max) != startIndex);
        return -1;
    }

    protected abstract Object getObject(int var1, int var2);
}

