/*
 * Decompiled with CFR 0.152.
 */
package cz.vity.freerapid.swing.models;

import cz.vity.freerapid.core.AppPrefs;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Stack;
import javax.swing.DefaultComboBoxModel;

public final class SimplePreferencesComboModel
extends DefaultComboBoxModel {
    private final Stack<String> stack;
    private String keyProperties = null;
    private boolean autosave;
    private int maxRecentPhrasesCount;

    public SimplePreferencesComboModel(String propertyKey, boolean autosave) {
        this(AppPrefs.getProperty("maxRecentPhrasesCount", 6), propertyKey, autosave);
    }

    public SimplePreferencesComboModel(int maxRecentPhrasesCount, String keyProperties, boolean autosave) {
        this(new Stack<String>());
        String[] values;
        this.maxRecentPhrasesCount = maxRecentPhrasesCount;
        this.keyProperties = keyProperties;
        this.autosave = autosave;
        for (String value : values = AppPrefs.getProperty(keyProperties, "").split("\\|")) {
            if (value.length() <= 0) continue;
            this.stack.add(0, value);
        }
    }

    private SimplePreferencesComboModel(Stack<String> v) {
        super(v);
        this.stack = v;
        this.autosave = false;
    }

    @Override
    public void setSelectedItem(Object anObject) {
        super.setSelectedItem(anObject);
        this.addElement(anObject);
    }

    @Override
    public final void addElement(Object anObject) {
        if (anObject == null) {
            return;
        }
        int index = this.getIndexOf(anObject);
        if (index < 0) {
            String s = anObject.toString().trim();
            if (!"".equals(s) && !"?".equals(s)) {
                super.insertElementAt(anObject, 0);
                if (this.stack.size() > this.maxRecentPhrasesCount) {
                    this.remove(this.maxRecentPhrasesCount - 1);
                    if (this.autosave) {
                        this.store();
                    }
                }
            }
            if (this.autosave) {
                this.store();
            }
        }
    }

    private void remove(int index) {
        this.setSelectedItem(this.getElementAt(0));
        this.stack.removeElementAt(index);
        this.fireIntervalRemoved(this, index, index);
    }

    public final Collection<String> getList() {
        return this.stack;
    }

    public void removeAllProperties() {
        AppPrefs.removeProperty(this.keyProperties);
    }

    public void store() {
        StringBuilder builder = new StringBuilder();
        HashSet<String> set = new HashSet<String>(this.stack);
        Iterator it = set.iterator();
        while (it.hasNext()) {
            String str = (String)it.next();
            builder.append(str);
            if (!it.hasNext()) continue;
            builder.append("|");
        }
        AppPrefs.storeProperty(this.keyProperties, builder.toString());
    }
}

