/*
 * Decompiled with CFR 0.152.
 */
package cz.vity.freerapid.utilities;

import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;

public final class Hq2x {
    private static final int Ymask = 0xFF0000;
    private static final int Umask = 65280;
    private static final int Vmask = 255;
    private static final int Mask4 = -16777216;
    private static final int Mask2 = 65280;
    private static final int Mask13 = 0xFF00FF;

    public static BufferedImage zoom(BufferedImage image) {
        if (image.getType() != 2 && image.getType() != 3) {
            BufferedImage temp = new BufferedImage(image.getWidth(), image.getHeight(), 2);
            temp.getGraphics().drawImage(image, 0, 0, null);
            image = temp;
        }
        int[] data = ((DataBufferInt)image.getRaster().getDataBuffer()).getData();
        BufferedImage result = new BufferedImage(image.getWidth() * 2, image.getHeight() * 2, 2);
        int[] dataResult = ((DataBufferInt)result.getRaster().getDataBuffer()).getData();
        Hq2x.hq2x_32_rb(data, dataResult, image.getWidth(), image.getHeight());
        return result;
    }

    private static void hq2x_32_rb(int[] sp, int[] dp, int Xres, int Yres) {
        Hq2x.hq2x_32_rb(sp, dp, Xres, Yres, 48, 7, 6, 0, false, false);
    }

    /*
     * Opcode count of 13775 triggered aggressive code reduction.  Override with --aggressivesizethreshold.
     */
    private static void hq2x_32_rb(int[] sp, int[] dp, int Xres, int Yres, int trY, int trU, int trV, int trA, boolean wrapX, boolean wrapY) {
        int spIdx = 0;
        int dpIdx = 0;
        trY <<= 16;
        trU <<= 8;
        int dpL = Xres * 2;
        int[] w = new int[9];
        for (int j = 0; j < Yres; ++j) {
            int prevline;
            int n = j > 0 ? -Xres : (prevline = wrapY ? Xres * (Yres - 1) : 0);
            int nextline = j < Yres - 1 ? Xres : (wrapY ? -(Xres * (Yres - 1)) : 0);
            for (int i = 0; i < Xres; ++i) {
                w[1] = sp[spIdx + prevline];
                w[4] = sp[spIdx];
                w[7] = sp[spIdx + nextline];
                if (i > 0) {
                    w[0] = sp[spIdx + prevline - 1];
                    w[3] = sp[spIdx - 1];
                    w[6] = sp[spIdx + nextline - 1];
                } else if (wrapX) {
                    w[0] = sp[spIdx + prevline + Xres - 1];
                    w[3] = sp[spIdx + Xres - 1];
                    w[6] = sp[spIdx + nextline + Xres - 1];
                } else {
                    w[0] = w[1];
                    w[3] = w[4];
                    w[6] = w[7];
                }
                if (i < Xres - 1) {
                    w[2] = sp[spIdx + prevline + 1];
                    w[5] = sp[spIdx + 1];
                    w[8] = sp[spIdx + nextline + 1];
                } else if (wrapX) {
                    w[2] = sp[spIdx + prevline - Xres + 1];
                    w[5] = sp[spIdx - Xres + 1];
                    w[8] = sp[spIdx + nextline - Xres + 1];
                } else {
                    w[2] = w[1];
                    w[5] = w[4];
                    w[8] = w[7];
                }
                int pattern = 0;
                int flag = 1;
                for (int k = 0; k < 9; ++k) {
                    if (k == 4) continue;
                    if (w[k] != w[4] && Hq2x.diff(w[4], w[k], trY, trU, trV, trA)) {
                        pattern |= flag;
                    }
                    flag <<= 1;
                }
                switch (pattern) {
                    case 0: 
                    case 1: 
                    case 4: 
                    case 5: 
                    case 32: 
                    case 33: 
                    case 36: 
                    case 37: 
                    case 128: 
                    case 129: 
                    case 132: 
                    case 133: 
                    case 160: 
                    case 161: 
                    case 164: 
                    case 165: {
                        dp[dpIdx] = Hq2x.Mix2To1To1(w[4], w[3], w[1]);
                        dp[dpIdx + 1] = Hq2x.Mix2To1To1(w[4], w[1], w[5]);
                        dp[dpIdx + dpL] = Hq2x.Mix2To1To1(w[4], w[7], w[3]);
                        dp[dpIdx + dpL + 1] = Hq2x.Mix2To1To1(w[4], w[5], w[7]);
                        break;
                    }
                    case 2: 
                    case 34: 
                    case 130: 
                    case 162: {
                        dp[dpIdx] = Hq2x.Mix2To1To1(w[4], w[0], w[3]);
                        dp[dpIdx + 1] = Hq2x.Mix2To1To1(w[4], w[2], w[5]);
                        dp[dpIdx + dpL] = Hq2x.Mix2To1To1(w[4], w[7], w[3]);
                        dp[dpIdx + dpL + 1] = Hq2x.Mix2To1To1(w[4], w[5], w[7]);
                        break;
                    }
                    case 16: 
                    case 17: 
                    case 48: 
                    case 49: {
                        dp[dpIdx] = Hq2x.Mix2To1To1(w[4], w[3], w[1]);
                        dp[dpIdx + 1] = Hq2x.Mix2To1To1(w[4], w[2], w[1]);
                        dp[dpIdx + dpL] = Hq2x.Mix2To1To1(w[4], w[7], w[3]);
                        dp[dpIdx + dpL + 1] = Hq2x.Mix2To1To1(w[4], w[8], w[7]);
                        break;
                    }
                    case 64: 
                    case 65: 
                    case 68: 
                    case 69: {
                        dp[dpIdx] = Hq2x.Mix2To1To1(w[4], w[3], w[1]);
                        dp[dpIdx + 1] = Hq2x.Mix2To1To1(w[4], w[1], w[5]);
                        dp[dpIdx + dpL] = Hq2x.Mix2To1To1(w[4], w[6], w[3]);
                        dp[dpIdx + dpL + 1] = Hq2x.Mix2To1To1(w[4], w[8], w[5]);
                        break;
                    }
                    case 8: 
                    case 12: 
                    case 136: 
                    case 140: {
                        dp[dpIdx] = Hq2x.Mix2To1To1(w[4], w[0], w[1]);
                        dp[dpIdx + 1] = Hq2x.Mix2To1To1(w[4], w[1], w[5]);
                        dp[dpIdx + dpL] = Hq2x.Mix2To1To1(w[4], w[6], w[7]);
                        dp[dpIdx + dpL + 1] = Hq2x.Mix2To1To1(w[4], w[5], w[7]);
                        break;
                    }
                    case 3: 
                    case 35: 
                    case 131: 
                    case 163: {
                        dp[dpIdx] = Hq2x.Mix3To1(w[4], w[3]);
                        dp[dpIdx + 1] = Hq2x.Mix2To1To1(w[4], w[2], w[5]);
                        dp[dpIdx + dpL] = Hq2x.Mix2To1To1(w[4], w[7], w[3]);
                        dp[dpIdx + dpL + 1] = Hq2x.Mix2To1To1(w[4], w[5], w[7]);
                        break;
                    }
                    case 6: 
                    case 38: 
                    case 134: 
                    case 166: {
                        dp[dpIdx] = Hq2x.Mix2To1To1(w[4], w[0], w[3]);
                        dp[dpIdx + 1] = Hq2x.Mix3To1(w[4], w[5]);
                        dp[dpIdx + dpL] = Hq2x.Mix2To1To1(w[4], w[7], w[3]);
                        dp[dpIdx + dpL + 1] = Hq2x.Mix2To1To1(w[4], w[5], w[7]);
                        break;
                    }
                    case 20: 
                    case 21: 
                    case 52: 
                    case 53: {
                        dp[dpIdx] = Hq2x.Mix2To1To1(w[4], w[3], w[1]);
                        dp[dpIdx + 1] = Hq2x.Mix3To1(w[4], w[1]);
                        dp[dpIdx + dpL] = Hq2x.Mix2To1To1(w[4], w[7], w[3]);
                        dp[dpIdx + dpL + 1] = Hq2x.Mix2To1To1(w[4], w[8], w[7]);
                        break;
                    }
                    case 144: 
                    case 145: 
                    case 176: 
                    case 177: {
                        dp[dpIdx] = Hq2x.Mix2To1To1(w[4], w[3], w[1]);
                        dp[dpIdx + 1] = Hq2x.Mix2To1To1(w[4], w[2], w[1]);
                        dp[dpIdx + dpL] = Hq2x.Mix2To1To1(w[4], w[7], w[3]);
                        dp[dpIdx + dpL + 1] = Hq2x.Mix3To1(w[4], w[7]);
                        break;
                    }
                    case 192: 
                    case 193: 
                    case 196: 
                    case 197: {
                        dp[dpIdx] = Hq2x.Mix2To1To1(w[4], w[3], w[1]);
                        dp[dpIdx + 1] = Hq2x.Mix2To1To1(w[4], w[1], w[5]);
                        dp[dpIdx + dpL] = Hq2x.Mix2To1To1(w[4], w[6], w[3]);
                        dp[dpIdx + dpL + 1] = Hq2x.Mix3To1(w[4], w[5]);
                        break;
                    }
                    case 96: 
                    case 97: 
                    case 100: 
                    case 101: {
                        dp[dpIdx] = Hq2x.Mix2To1To1(w[4], w[3], w[1]);
                        dp[dpIdx + 1] = Hq2x.Mix2To1To1(w[4], w[1], w[5]);
                        dp[dpIdx + dpL] = Hq2x.Mix3To1(w[4], w[3]);
                        dp[dpIdx + dpL + 1] = Hq2x.Mix2To1To1(w[4], w[8], w[5]);
                        break;
                    }
                    case 40: 
                    case 44: 
                    case 168: 
                    case 172: {
                        dp[dpIdx] = Hq2x.Mix2To1To1(w[4], w[0], w[1]);
                        dp[dpIdx + 1] = Hq2x.Mix2To1To1(w[4], w[1], w[5]);
                        dp[dpIdx + dpL] = Hq2x.Mix3To1(w[4], w[7]);
                        dp[dpIdx + dpL + 1] = Hq2x.Mix2To1To1(w[4], w[5], w[7]);
                        break;
                    }
                    case 9: 
                    case 13: 
                    case 137: 
                    case 141: {
                        dp[dpIdx] = Hq2x.Mix3To1(w[4], w[1]);
                        dp[dpIdx + 1] = Hq2x.Mix2To1To1(w[4], w[1], w[5]);
                        dp[dpIdx + dpL] = Hq2x.Mix2To1To1(w[4], w[6], w[7]);
                        dp[dpIdx + dpL + 1] = Hq2x.Mix2To1To1(w[4], w[5], w[7]);
                        break;
                    }
                    case 18: 
                    case 50: {
                        dp[dpIdx] = Hq2x.Mix2To1To1(w[4], w[0], w[3]);
                        dp[dpIdx + 1] = Hq2x.diff(w[1], w[5], trY, trU, trV, trA) ? Hq2x.Mix3To1(w[4], w[2]) : Hq2x.Mix2To1To1(w[4], w[1], w[5]);
                        dp[dpIdx + dpL] = Hq2x.Mix2To1To1(w[4], w[7], w[3]);
                        dp[dpIdx + dpL + 1] = Hq2x.Mix2To1To1(w[4], w[8], w[7]);
                        break;
                    }
                    case 80: 
                    case 81: {
                        dp[dpIdx] = Hq2x.Mix2To1To1(w[4], w[3], w[1]);
                        dp[dpIdx + 1] = Hq2x.Mix2To1To1(w[4], w[2], w[1]);
                        dp[dpIdx + dpL] = Hq2x.Mix2To1To1(w[4], w[6], w[3]);
                        if (Hq2x.diff(w[5], w[7], trY, trU, trV, trA)) {
                            dp[dpIdx + dpL + 1] = Hq2x.Mix3To1(w[4], w[8]);
                            break;
                        }
                        dp[dpIdx + dpL + 1] = Hq2x.Mix2To1To1(w[4], w[5], w[7]);
                        break;
                    }
                    case 72: 
                    case 76: {
                        dp[dpIdx] = Hq2x.Mix2To1To1(w[4], w[0], w[1]);
                        dp[dpIdx + 1] = Hq2x.Mix2To1To1(w[4], w[1], w[5]);
                        dp[dpIdx + dpL] = Hq2x.diff(w[7], w[3], trY, trU, trV, trA) ? Hq2x.Mix3To1(w[4], w[6]) : Hq2x.Mix2To1To1(w[4], w[7], w[3]);
                        dp[dpIdx + dpL + 1] = Hq2x.Mix2To1To1(w[4], w[8], w[5]);
                        break;
                    }
                    case 10: 
                    case 138: {
                        dp[dpIdx] = Hq2x.diff(w[3], w[1], trY, trU, trV, trA) ? Hq2x.Mix3To1(w[4], w[0]) : Hq2x.Mix2To1To1(w[4], w[3], w[1]);
                        dp[dpIdx + 1] = Hq2x.Mix2To1To1(w[4], w[2], w[5]);
                        dp[dpIdx + dpL] = Hq2x.Mix2To1To1(w[4], w[6], w[7]);
                        dp[dpIdx + dpL + 1] = Hq2x.Mix2To1To1(w[4], w[5], w[7]);
                        break;
                    }
                    case 66: {
                        dp[dpIdx] = Hq2x.Mix2To1To1(w[4], w[0], w[3]);
                        dp[dpIdx + 1] = Hq2x.Mix2To1To1(w[4], w[2], w[5]);
                        dp[dpIdx + dpL] = Hq2x.Mix2To1To1(w[4], w[6], w[3]);
                        dp[dpIdx + dpL + 1] = Hq2x.Mix2To1To1(w[4], w[8], w[5]);
                        break;
                    }
                    case 24: {
                        dp[dpIdx] = Hq2x.Mix2To1To1(w[4], w[0], w[1]);
                        dp[dpIdx + 1] = Hq2x.Mix2To1To1(w[4], w[2], w[1]);
                        dp[dpIdx + dpL] = Hq2x.Mix2To1To1(w[4], w[6], w[7]);
                        dp[dpIdx + dpL + 1] = Hq2x.Mix2To1To1(w[4], w[8], w[7]);
                        break;
                    }
                    case 7: 
                    case 39: 
                    case 135: {
                        dp[dpIdx] = Hq2x.Mix3To1(w[4], w[3]);
                        dp[dpIdx + 1] = Hq2x.Mix3To1(w[4], w[5]);
                        dp[dpIdx + dpL] = Hq2x.Mix2To1To1(w[4], w[7], w[3]);
                        dp[dpIdx + dpL + 1] = Hq2x.Mix2To1To1(w[4], w[5], w[7]);
                        break;
                    }
                    case 148: 
                    case 149: 
                    case 180: {
                        dp[dpIdx] = Hq2x.Mix2To1To1(w[4], w[3], w[1]);
                        dp[dpIdx + 1] = Hq2x.Mix3To1(w[4], w[1]);
                        dp[dpIdx + dpL] = Hq2x.Mix2To1To1(w[4], w[7], w[3]);
                        dp[dpIdx + dpL + 1] = Hq2x.Mix3To1(w[4], w[7]);
                        break;
                    }
                    case 224: 
                    case 225: 
                    case 228: {
                        dp[dpIdx] = Hq2x.Mix2To1To1(w[4], w[3], w[1]);
                        dp[dpIdx + 1] = Hq2x.Mix2To1To1(w[4], w[1], w[5]);
                        dp[dpIdx + dpL] = Hq2x.Mix3To1(w[4], w[3]);
                        dp[dpIdx + dpL + 1] = Hq2x.Mix3To1(w[4], w[5]);
                        break;
                    }
                    case 41: 
                    case 45: 
                    case 169: {
                        dp[dpIdx] = Hq2x.Mix3To1(w[4], w[1]);
                        dp[dpIdx + 1] = Hq2x.Mix2To1To1(w[4], w[1], w[5]);
                        dp[dpIdx + dpL] = Hq2x.Mix3To1(w[4], w[7]);
                        dp[dpIdx + dpL + 1] = Hq2x.Mix2To1To1(w[4], w[5], w[7]);
                        break;
                    }
                    case 22: 
                    case 54: {
                        dp[dpIdx] = Hq2x.Mix2To1To1(w[4], w[0], w[3]);
                        dp[dpIdx + 1] = Hq2x.diff(w[1], w[5], trY, trU, trV, trA) ? w[4] : Hq2x.Mix2To1To1(w[4], w[1], w[5]);
                        dp[dpIdx + dpL] = Hq2x.Mix2To1To1(w[4], w[7], w[3]);
                        dp[dpIdx + dpL + 1] = Hq2x.Mix2To1To1(w[4], w[8], w[7]);
                        break;
                    }
                    case 208: 
                    case 209: {
                        dp[dpIdx] = Hq2x.Mix2To1To1(w[4], w[3], w[1]);
                        dp[dpIdx + 1] = Hq2x.Mix2To1To1(w[4], w[2], w[1]);
                        dp[dpIdx + dpL] = Hq2x.Mix2To1To1(w[4], w[6], w[3]);
                        if (Hq2x.diff(w[5], w[7], trY, trU, trV, trA)) {
                            dp[dpIdx + dpL + 1] = w[4];
                            break;
                        }
                        dp[dpIdx + dpL + 1] = Hq2x.Mix2To1To1(w[4], w[5], w[7]);
                        break;
                    }
                    case 104: 
                    case 108: {
                        dp[dpIdx] = Hq2x.Mix2To1To1(w[4], w[0], w[1]);
                        dp[dpIdx + 1] = Hq2x.Mix2To1To1(w[4], w[1], w[5]);
                        dp[dpIdx + dpL] = Hq2x.diff(w[7], w[3], trY, trU, trV, trA) ? w[4] : Hq2x.Mix2To1To1(w[4], w[7], w[3]);
                        dp[dpIdx + dpL + 1] = Hq2x.Mix2To1To1(w[4], w[8], w[5]);
                        break;
                    }
                    case 11: 
                    case 139: {
                        dp[dpIdx] = Hq2x.diff(w[3], w[1], trY, trU, trV, trA) ? w[4] : Hq2x.Mix2To1To1(w[4], w[3], w[1]);
                        dp[dpIdx + 1] = Hq2x.Mix2To1To1(w[4], w[2], w[5]);
                        dp[dpIdx + dpL] = Hq2x.Mix2To1To1(w[4], w[6], w[7]);
                        dp[dpIdx + dpL + 1] = Hq2x.Mix2To1To1(w[4], w[5], w[7]);
                        break;
                    }
                    case 19: 
                    case 51: {
                        if (Hq2x.diff(w[1], w[5], trY, trU, trV, trA)) {
                            dp[dpIdx] = Hq2x.Mix3To1(w[4], w[3]);
                            dp[dpIdx + 1] = Hq2x.Mix3To1(w[4], w[2]);
                        } else {
                            dp[dpIdx] = Hq2x.Mix4To2To1(w[4], w[1], w[3]);
                            dp[dpIdx + 1] = Hq2x.Mix2To3To3(w[4], w[1], w[5]);
                        }
                        dp[dpIdx + dpL] = Hq2x.Mix2To1To1(w[4], w[7], w[3]);
                        dp[dpIdx + dpL + 1] = Hq2x.Mix2To1To1(w[4], w[8], w[7]);
                        break;
                    }
                    case 146: 
                    case 178: {
                        dp[dpIdx] = Hq2x.Mix2To1To1(w[4], w[0], w[3]);
                        if (Hq2x.diff(w[1], w[5], trY, trU, trV, trA)) {
                            dp[dpIdx + 1] = Hq2x.Mix3To1(w[4], w[2]);
                            dp[dpIdx + dpL + 1] = Hq2x.Mix3To1(w[4], w[7]);
                        } else {
                            dp[dpIdx + 1] = Hq2x.Mix2To3To3(w[4], w[1], w[5]);
                            dp[dpIdx + dpL + 1] = Hq2x.Mix4To2To1(w[4], w[5], w[7]);
                        }
                        dp[dpIdx + dpL] = Hq2x.Mix2To1To1(w[4], w[7], w[3]);
                        break;
                    }
                    case 84: 
                    case 85: {
                        dp[dpIdx] = Hq2x.Mix2To1To1(w[4], w[3], w[1]);
                        if (Hq2x.diff(w[5], w[7], trY, trU, trV, trA)) {
                            dp[dpIdx + 1] = Hq2x.Mix3To1(w[4], w[1]);
                            dp[dpIdx + dpL + 1] = Hq2x.Mix3To1(w[4], w[8]);
                        } else {
                            dp[dpIdx + 1] = Hq2x.Mix4To2To1(w[4], w[5], w[1]);
                            dp[dpIdx + dpL + 1] = Hq2x.Mix2To3To3(w[4], w[5], w[7]);
                        }
                        dp[dpIdx + dpL] = Hq2x.Mix2To1To1(w[4], w[6], w[3]);
                        break;
                    }
                    case 112: 
                    case 113: {
                        dp[dpIdx] = Hq2x.Mix2To1To1(w[4], w[3], w[1]);
                        dp[dpIdx + 1] = Hq2x.Mix2To1To1(w[4], w[2], w[1]);
                        if (Hq2x.diff(w[5], w[7], trY, trU, trV, trA)) {
                            dp[dpIdx + dpL] = Hq2x.Mix3To1(w[4], w[3]);
                            dp[dpIdx + dpL + 1] = Hq2x.Mix3To1(w[4], w[8]);
                            break;
                        }
                        dp[dpIdx + dpL] = Hq2x.Mix4To2To1(w[4], w[7], w[3]);
                        dp[dpIdx + dpL + 1] = Hq2x.Mix2To3To3(w[4], w[5], w[7]);
                        break;
                    }
                    case 200: 
                    case 204: {
                        dp[dpIdx] = Hq2x.Mix2To1To1(w[4], w[0], w[1]);
                        dp[dpIdx + 1] = Hq2x.Mix2To1To1(w[4], w[1], w[5]);
                        if (Hq2x.diff(w[7], w[3], trY, trU, trV, trA)) {
                            dp[dpIdx + dpL] = Hq2x.Mix3To1(w[4], w[6]);
                            dp[dpIdx + dpL + 1] = Hq2x.Mix3To1(w[4], w[5]);
                            break;
                        }
                        dp[dpIdx + dpL] = Hq2x.Mix2To3To3(w[4], w[7], w[3]);
                        dp[dpIdx + dpL + 1] = Hq2x.Mix4To2To1(w[4], w[7], w[5]);
                        break;
                    }
                    case 73: 
                    case 77: {
                        if (Hq2x.diff(w[7], w[3], trY, trU, trV, trA)) {
                            dp[dpIdx] = Hq2x.Mix3To1(w[4], w[1]);
                            dp[dpIdx + dpL] = Hq2x.Mix3To1(w[4], w[6]);
                        } else {
                            dp[dpIdx] = Hq2x.Mix4To2To1(w[4], w[3], w[1]);
                            dp[dpIdx + dpL] = Hq2x.Mix2To3To3(w[4], w[7], w[3]);
                        }
                        dp[dpIdx + 1] = Hq2x.Mix2To1To1(w[4], w[1], w[5]);
                        dp[dpIdx + dpL + 1] = Hq2x.Mix2To1To1(w[4], w[8], w[5]);
                        break;
                    }
                    case 42: 
                    case 170: {
                        if (Hq2x.diff(w[3], w[1], trY, trU, trV, trA)) {
                            dp[dpIdx] = Hq2x.Mix3To1(w[4], w[0]);
                            dp[dpIdx + dpL] = Hq2x.Mix3To1(w[4], w[7]);
                        } else {
                            dp[dpIdx] = Hq2x.Mix2To3To3(w[4], w[3], w[1]);
                            dp[dpIdx + dpL] = Hq2x.Mix4To2To1(w[4], w[3], w[7]);
                        }
                        dp[dpIdx + 1] = Hq2x.Mix2To1To1(w[4], w[2], w[5]);
                        dp[dpIdx + dpL + 1] = Hq2x.Mix2To1To1(w[4], w[5], w[7]);
                        break;
                    }
                    case 14: 
                    case 142: {
                        if (Hq2x.diff(w[3], w[1], trY, trU, trV, trA)) {
                            dp[dpIdx] = Hq2x.Mix3To1(w[4], w[0]);
                            dp[dpIdx + 1] = Hq2x.Mix3To1(w[4], w[5]);
                        } else {
                            dp[dpIdx] = Hq2x.Mix2To3To3(w[4], w[3], w[1]);
                            dp[dpIdx + 1] = Hq2x.Mix4To2To1(w[4], w[1], w[5]);
                        }
                        dp[dpIdx + dpL] = Hq2x.Mix2To1To1(w[4], w[6], w[7]);
                        dp[dpIdx + dpL + 1] = Hq2x.Mix2To1To1(w[4], w[5], w[7]);
                        break;
                    }
                    case 67: {
                        dp[dpIdx] = Hq2x.Mix3To1(w[4], w[3]);
                        dp[dpIdx + 1] = Hq2x.Mix2To1To1(w[4], w[2], w[5]);
                        dp[dpIdx + dpL] = Hq2x.Mix2To1To1(w[4], w[6], w[3]);
                        dp[dpIdx + dpL + 1] = Hq2x.Mix2To1To1(w[4], w[8], w[5]);
                        break;
                    }
                    case 70: {
                        dp[dpIdx] = Hq2x.Mix2To1To1(w[4], w[0], w[3]);
                        dp[dpIdx + 1] = Hq2x.Mix3To1(w[4], w[5]);
                        dp[dpIdx + dpL] = Hq2x.Mix2To1To1(w[4], w[6], w[3]);
                        dp[dpIdx + dpL + 1] = Hq2x.Mix2To1To1(w[4], w[8], w[5]);
                        break;
                    }
                    case 28: {
                        dp[dpIdx] = Hq2x.Mix2To1To1(w[4], w[0], w[1]);
                        dp[dpIdx + 1] = Hq2x.Mix3To1(w[4], w[1]);
                        dp[dpIdx + dpL] = Hq2x.Mix2To1To1(w[4], w[6], w[7]);
                        dp[dpIdx + dpL + 1] = Hq2x.Mix2To1To1(w[4], w[8], w[7]);
                        break;
                    }
                    case 152: {
                        dp[dpIdx] = Hq2x.Mix2To1To1(w[4], w[0], w[1]);
                        dp[dpIdx + 1] = Hq2x.Mix2To1To1(w[4], w[2], w[1]);
                        dp[dpIdx + dpL] = Hq2x.Mix2To1To1(w[4], w[6], w[7]);
                        dp[dpIdx + dpL + 1] = Hq2x.Mix3To1(w[4], w[7]);
                        break;
                    }
                    case 194: {
                        dp[dpIdx] = Hq2x.Mix2To1To1(w[4], w[0], w[3]);
                        dp[dpIdx + 1] = Hq2x.Mix2To1To1(w[4], w[2], w[5]);
                        dp[dpIdx + dpL] = Hq2x.Mix2To1To1(w[4], w[6], w[3]);
                        dp[dpIdx + dpL + 1] = Hq2x.Mix3To1(w[4], w[5]);
                        break;
                    }
                    case 98: {
                        dp[dpIdx] = Hq2x.Mix2To1To1(w[4], w[0], w[3]);
                        dp[dpIdx + 1] = Hq2x.Mix2To1To1(w[4], w[2], w[5]);
                        dp[dpIdx + dpL] = Hq2x.Mix3To1(w[4], w[3]);
                        dp[dpIdx + dpL + 1] = Hq2x.Mix2To1To1(w[4], w[8], w[5]);
                        break;
                    }
                    case 56: {
                        dp[dpIdx] = Hq2x.Mix2To1To1(w[4], w[0], w[1]);
                        dp[dpIdx + 1] = Hq2x.Mix2To1To1(w[4], w[2], w[1]);
                        dp[dpIdx + dpL] = Hq2x.Mix3To1(w[4], w[7]);
                        dp[dpIdx + dpL + 1] = Hq2x.Mix2To1To1(w[4], w[8], w[7]);
                        break;
                    }
                    case 25: {
                        dp[dpIdx] = Hq2x.Mix3To1(w[4], w[1]);
                        dp[dpIdx + 1] = Hq2x.Mix2To1To1(w[4], w[2], w[1]);
                        dp[dpIdx + dpL] = Hq2x.Mix2To1To1(w[4], w[6], w[7]);
                        dp[dpIdx + dpL + 1] = Hq2x.Mix2To1To1(w[4], w[8], w[7]);
                        break;
                    }
                    case 26: 
                    case 31: {
                        dp[dpIdx] = Hq2x.diff(w[3], w[1], trY, trU, trV, trA) ? w[4] : Hq2x.Mix2To1To1(w[4], w[3], w[1]);
                        dp[dpIdx + 1] = Hq2x.diff(w[1], w[5], trY, trU, trV, trA) ? w[4] : Hq2x.Mix2To1To1(w[4], w[1], w[5]);
                        dp[dpIdx + dpL] = Hq2x.Mix2To1To1(w[4], w[6], w[7]);
                        dp[dpIdx + dpL + 1] = Hq2x.Mix2To1To1(w[4], w[8], w[7]);
                        break;
                    }
                    case 82: 
                    case 214: {
                        dp[dpIdx] = Hq2x.Mix2To1To1(w[4], w[0], w[3]);
                        dp[dpIdx + 1] = Hq2x.diff(w[1], w[5], trY, trU, trV, trA) ? w[4] : Hq2x.Mix2To1To1(w[4], w[1], w[5]);
                        dp[dpIdx + dpL] = Hq2x.Mix2To1To1(w[4], w[6], w[3]);
                        if (Hq2x.diff(w[5], w[7], trY, trU, trV, trA)) {
                            dp[dpIdx + dpL + 1] = w[4];
                            break;
                        }
                        dp[dpIdx + dpL + 1] = Hq2x.Mix2To1To1(w[4], w[5], w[7]);
                        break;
                    }
                    case 88: 
                    case 248: {
                        dp[dpIdx] = Hq2x.Mix2To1To1(w[4], w[0], w[1]);
                        dp[dpIdx + 1] = Hq2x.Mix2To1To1(w[4], w[2], w[1]);
                        dp[dpIdx + dpL] = Hq2x.diff(w[7], w[3], trY, trU, trV, trA) ? w[4] : Hq2x.Mix2To1To1(w[4], w[7], w[3]);
                        if (Hq2x.diff(w[5], w[7], trY, trU, trV, trA)) {
                            dp[dpIdx + dpL + 1] = w[4];
                            break;
                        }
                        dp[dpIdx + dpL + 1] = Hq2x.Mix2To1To1(w[4], w[5], w[7]);
                        break;
                    }
                    case 74: 
                    case 107: {
                        dp[dpIdx] = Hq2x.diff(w[3], w[1], trY, trU, trV, trA) ? w[4] : Hq2x.Mix2To1To1(w[4], w[3], w[1]);
                        dp[dpIdx + 1] = Hq2x.Mix2To1To1(w[4], w[2], w[5]);
                        dp[dpIdx + dpL] = Hq2x.diff(w[7], w[3], trY, trU, trV, trA) ? w[4] : Hq2x.Mix2To1To1(w[4], w[7], w[3]);
                        dp[dpIdx + dpL + 1] = Hq2x.Mix2To1To1(w[4], w[8], w[5]);
                        break;
                    }
                    case 27: {
                        dp[dpIdx] = Hq2x.diff(w[3], w[1], trY, trU, trV, trA) ? w[4] : Hq2x.Mix2To1To1(w[4], w[3], w[1]);
                        dp[dpIdx + 1] = Hq2x.Mix3To1(w[4], w[2]);
                        dp[dpIdx + dpL] = Hq2x.Mix2To1To1(w[4], w[6], w[7]);
                        dp[dpIdx + dpL + 1] = Hq2x.Mix2To1To1(w[4], w[8], w[7]);
                        break;
                    }
                    case 86: {
                        dp[dpIdx] = Hq2x.Mix2To1To1(w[4], w[0], w[3]);
                        dp[dpIdx + 1] = Hq2x.diff(w[1], w[5], trY, trU, trV, trA) ? w[4] : Hq2x.Mix2To1To1(w[4], w[1], w[5]);
                        dp[dpIdx + dpL] = Hq2x.Mix2To1To1(w[4], w[6], w[3]);
                        dp[dpIdx + dpL + 1] = Hq2x.Mix3To1(w[4], w[8]);
                        break;
                    }
                    case 216: {
                        dp[dpIdx] = Hq2x.Mix2To1To1(w[4], w[0], w[1]);
                        dp[dpIdx + 1] = Hq2x.Mix2To1To1(w[4], w[2], w[1]);
                        dp[dpIdx + dpL] = Hq2x.Mix3To1(w[4], w[6]);
                        if (Hq2x.diff(w[5], w[7], trY, trU, trV, trA)) {
                            dp[dpIdx + dpL + 1] = w[4];
                            break;
                        }
                        dp[dpIdx + dpL + 1] = Hq2x.Mix2To1To1(w[4], w[5], w[7]);
                        break;
                    }
                    case 106: {
                        dp[dpIdx] = Hq2x.Mix3To1(w[4], w[0]);
                        dp[dpIdx + 1] = Hq2x.Mix2To1To1(w[4], w[2], w[5]);
                        dp[dpIdx + dpL] = Hq2x.diff(w[7], w[3], trY, trU, trV, trA) ? w[4] : Hq2x.Mix2To1To1(w[4], w[7], w[3]);
                        dp[dpIdx + dpL + 1] = Hq2x.Mix2To1To1(w[4], w[8], w[5]);
                        break;
                    }
                    case 30: {
                        dp[dpIdx] = Hq2x.Mix3To1(w[4], w[0]);
                        dp[dpIdx + 1] = Hq2x.diff(w[1], w[5], trY, trU, trV, trA) ? w[4] : Hq2x.Mix2To1To1(w[4], w[1], w[5]);
                        dp[dpIdx + dpL] = Hq2x.Mix2To1To1(w[4], w[6], w[7]);
                        dp[dpIdx + dpL + 1] = Hq2x.Mix2To1To1(w[4], w[8], w[7]);
                        break;
                    }
                    case 210: {
                        dp[dpIdx] = Hq2x.Mix2To1To1(w[4], w[0], w[3]);
                        dp[dpIdx + 1] = Hq2x.Mix3To1(w[4], w[2]);
                        dp[dpIdx + dpL] = Hq2x.Mix2To1To1(w[4], w[6], w[3]);
                        if (Hq2x.diff(w[5], w[7], trY, trU, trV, trA)) {
                            dp[dpIdx + dpL + 1] = w[4];
                            break;
                        }
                        dp[dpIdx + dpL + 1] = Hq2x.Mix2To1To1(w[4], w[5], w[7]);
                        break;
                    }
                    case 120: {
                        dp[dpIdx] = Hq2x.Mix2To1To1(w[4], w[0], w[1]);
                        dp[dpIdx + 1] = Hq2x.Mix2To1To1(w[4], w[2], w[1]);
                        dp[dpIdx + dpL] = Hq2x.diff(w[7], w[3], trY, trU, trV, trA) ? w[4] : Hq2x.Mix2To1To1(w[4], w[7], w[3]);
                        dp[dpIdx + dpL + 1] = Hq2x.Mix3To1(w[4], w[8]);
                        break;
                    }
                    case 75: {
                        dp[dpIdx] = Hq2x.diff(w[3], w[1], trY, trU, trV, trA) ? w[4] : Hq2x.Mix2To1To1(w[4], w[3], w[1]);
                        dp[dpIdx + 1] = Hq2x.Mix2To1To1(w[4], w[2], w[5]);
                        dp[dpIdx + dpL] = Hq2x.Mix3To1(w[4], w[6]);
                        dp[dpIdx + dpL + 1] = Hq2x.Mix2To1To1(w[4], w[8], w[5]);
                        break;
                    }
                    case 29: {
                        dp[dpIdx] = Hq2x.Mix3To1(w[4], w[1]);
                        dp[dpIdx + 1] = Hq2x.Mix3To1(w[4], w[1]);
                        dp[dpIdx + dpL] = Hq2x.Mix2To1To1(w[4], w[6], w[7]);
                        dp[dpIdx + dpL + 1] = Hq2x.Mix2To1To1(w[4], w[8], w[7]);
                        break;
                    }
                    case 198: {
                        dp[dpIdx] = Hq2x.Mix2To1To1(w[4], w[0], w[3]);
                        dp[dpIdx + 1] = Hq2x.Mix3To1(w[4], w[5]);
                        dp[dpIdx + dpL] = Hq2x.Mix2To1To1(w[4], w[6], w[3]);
                        dp[dpIdx + dpL + 1] = Hq2x.Mix3To1(w[4], w[5]);
                        break;
                    }
                    case 184: {
                        dp[dpIdx] = Hq2x.Mix2To1To1(w[4], w[0], w[1]);
                        dp[dpIdx + 1] = Hq2x.Mix2To1To1(w[4], w[2], w[1]);
                        dp[dpIdx + dpL] = Hq2x.Mix3To1(w[4], w[7]);
                        dp[dpIdx + dpL + 1] = Hq2x.Mix3To1(w[4], w[7]);
                        break;
                    }
                    case 99: {
                        dp[dpIdx] = Hq2x.Mix3To1(w[4], w[3]);
                        dp[dpIdx + 1] = Hq2x.Mix2To1To1(w[4], w[2], w[5]);
                        dp[dpIdx + dpL] = Hq2x.Mix3To1(w[4], w[3]);
                        dp[dpIdx + dpL + 1] = Hq2x.Mix2To1To1(w[4], w[8], w[5]);
                        break;
                    }
                    case 57: {
                        dp[dpIdx] = Hq2x.Mix3To1(w[4], w[1]);
                        dp[dpIdx + 1] = Hq2x.Mix2To1To1(w[4], w[2], w[1]);
                        dp[dpIdx + dpL] = Hq2x.Mix3To1(w[4], w[7]);
                        dp[dpIdx + dpL + 1] = Hq2x.Mix2To1To1(w[4], w[8], w[7]);
                        break;
                    }
                    case 71: {
                        dp[dpIdx] = Hq2x.Mix3To1(w[4], w[3]);
                        dp[dpIdx + 1] = Hq2x.Mix3To1(w[4], w[5]);
                        dp[dpIdx + dpL] = Hq2x.Mix2To1To1(w[4], w[6], w[3]);
                        dp[dpIdx + dpL + 1] = Hq2x.Mix2To1To1(w[4], w[8], w[5]);
                        break;
                    }
                    case 156: {
                        dp[dpIdx] = Hq2x.Mix2To1To1(w[4], w[0], w[1]);
                        dp[dpIdx + 1] = Hq2x.Mix3To1(w[4], w[1]);
                        dp[dpIdx + dpL] = Hq2x.Mix2To1To1(w[4], w[6], w[7]);
                        dp[dpIdx + dpL + 1] = Hq2x.Mix3To1(w[4], w[7]);
                        break;
                    }
                    case 226: {
                        dp[dpIdx] = Hq2x.Mix2To1To1(w[4], w[0], w[3]);
                        dp[dpIdx + 1] = Hq2x.Mix2To1To1(w[4], w[2], w[5]);
                        dp[dpIdx + dpL] = Hq2x.Mix3To1(w[4], w[3]);
                        dp[dpIdx + dpL + 1] = Hq2x.Mix3To1(w[4], w[5]);
                        break;
                    }
                    case 60: {
                        dp[dpIdx] = Hq2x.Mix2To1To1(w[4], w[0], w[1]);
                        dp[dpIdx + 1] = Hq2x.Mix3To1(w[4], w[1]);
                        dp[dpIdx + dpL] = Hq2x.Mix3To1(w[4], w[7]);
                        dp[dpIdx + dpL + 1] = Hq2x.Mix2To1To1(w[4], w[8], w[7]);
                        break;
                    }
                    case 195: {
                        dp[dpIdx] = Hq2x.Mix3To1(w[4], w[3]);
                        dp[dpIdx + 1] = Hq2x.Mix2To1To1(w[4], w[2], w[5]);
                        dp[dpIdx + dpL] = Hq2x.Mix2To1To1(w[4], w[6], w[3]);
                        dp[dpIdx + dpL + 1] = Hq2x.Mix3To1(w[4], w[5]);
                        break;
                    }
                    case 102: {
                        dp[dpIdx] = Hq2x.Mix2To1To1(w[4], w[0], w[3]);
                        dp[dpIdx + 1] = Hq2x.Mix3To1(w[4], w[5]);
                        dp[dpIdx + dpL] = Hq2x.Mix3To1(w[4], w[3]);
                        dp[dpIdx + dpL + 1] = Hq2x.Mix2To1To1(w[4], w[8], w[5]);
                        break;
                    }
                    case 153: {
                        dp[dpIdx] = Hq2x.Mix3To1(w[4], w[1]);
                        dp[dpIdx + 1] = Hq2x.Mix2To1To1(w[4], w[2], w[1]);
                        dp[dpIdx + dpL] = Hq2x.Mix2To1To1(w[4], w[6], w[7]);
                        dp[dpIdx + dpL + 1] = Hq2x.Mix3To1(w[4], w[7]);
                        break;
                    }
                    case 58: {
                        dp[dpIdx] = Hq2x.diff(w[3], w[1], trY, trU, trV, trA) ? Hq2x.Mix3To1(w[4], w[0]) : Hq2x.Mix6To1To1(w[4], w[3], w[1]);
                        dp[dpIdx + 1] = Hq2x.diff(w[1], w[5], trY, trU, trV, trA) ? Hq2x.Mix3To1(w[4], w[2]) : Hq2x.Mix6To1To1(w[4], w[1], w[5]);
                        dp[dpIdx + dpL] = Hq2x.Mix3To1(w[4], w[7]);
                        dp[dpIdx + dpL + 1] = Hq2x.Mix2To1To1(w[4], w[8], w[7]);
                        break;
                    }
                    case 83: {
                        dp[dpIdx] = Hq2x.Mix3To1(w[4], w[3]);
                        dp[dpIdx + 1] = Hq2x.diff(w[1], w[5], trY, trU, trV, trA) ? Hq2x.Mix3To1(w[4], w[2]) : Hq2x.Mix6To1To1(w[4], w[1], w[5]);
                        dp[dpIdx + dpL] = Hq2x.Mix2To1To1(w[4], w[6], w[3]);
                        if (Hq2x.diff(w[5], w[7], trY, trU, trV, trA)) {
                            dp[dpIdx + dpL + 1] = Hq2x.Mix3To1(w[4], w[8]);
                            break;
                        }
                        dp[dpIdx + dpL + 1] = Hq2x.Mix6To1To1(w[4], w[5], w[7]);
                        break;
                    }
                    case 92: {
                        dp[dpIdx] = Hq2x.Mix2To1To1(w[4], w[0], w[1]);
                        dp[dpIdx + 1] = Hq2x.Mix3To1(w[4], w[1]);
                        dp[dpIdx + dpL] = Hq2x.diff(w[7], w[3], trY, trU, trV, trA) ? Hq2x.Mix3To1(w[4], w[6]) : Hq2x.Mix6To1To1(w[4], w[7], w[3]);
                        if (Hq2x.diff(w[5], w[7], trY, trU, trV, trA)) {
                            dp[dpIdx + dpL + 1] = Hq2x.Mix3To1(w[4], w[8]);
                            break;
                        }
                        dp[dpIdx + dpL + 1] = Hq2x.Mix6To1To1(w[4], w[5], w[7]);
                        break;
                    }
                    case 202: {
                        dp[dpIdx] = Hq2x.diff(w[3], w[1], trY, trU, trV, trA) ? Hq2x.Mix3To1(w[4], w[0]) : Hq2x.Mix6To1To1(w[4], w[3], w[1]);
                        dp[dpIdx + 1] = Hq2x.Mix2To1To1(w[4], w[2], w[5]);
                        dp[dpIdx + dpL] = Hq2x.diff(w[7], w[3], trY, trU, trV, trA) ? Hq2x.Mix3To1(w[4], w[6]) : Hq2x.Mix6To1To1(w[4], w[7], w[3]);
                        dp[dpIdx + dpL + 1] = Hq2x.Mix3To1(w[4], w[5]);
                        break;
                    }
                    case 78: {
                        dp[dpIdx] = Hq2x.diff(w[3], w[1], trY, trU, trV, trA) ? Hq2x.Mix3To1(w[4], w[0]) : Hq2x.Mix6To1To1(w[4], w[3], w[1]);
                        dp[dpIdx + 1] = Hq2x.Mix3To1(w[4], w[5]);
                        dp[dpIdx + dpL] = Hq2x.diff(w[7], w[3], trY, trU, trV, trA) ? Hq2x.Mix3To1(w[4], w[6]) : Hq2x.Mix6To1To1(w[4], w[7], w[3]);
                        dp[dpIdx + dpL + 1] = Hq2x.Mix2To1To1(w[4], w[8], w[5]);
                        break;
                    }
                    case 154: {
                        dp[dpIdx] = Hq2x.diff(w[3], w[1], trY, trU, trV, trA) ? Hq2x.Mix3To1(w[4], w[0]) : Hq2x.Mix6To1To1(w[4], w[3], w[1]);
                        dp[dpIdx + 1] = Hq2x.diff(w[1], w[5], trY, trU, trV, trA) ? Hq2x.Mix3To1(w[4], w[2]) : Hq2x.Mix6To1To1(w[4], w[1], w[5]);
                        dp[dpIdx + dpL] = Hq2x.Mix2To1To1(w[4], w[6], w[7]);
                        dp[dpIdx + dpL + 1] = Hq2x.Mix3To1(w[4], w[7]);
                        break;
                    }
                    case 114: {
                        dp[dpIdx] = Hq2x.Mix2To1To1(w[4], w[0], w[3]);
                        dp[dpIdx + 1] = Hq2x.diff(w[1], w[5], trY, trU, trV, trA) ? Hq2x.Mix3To1(w[4], w[2]) : Hq2x.Mix6To1To1(w[4], w[1], w[5]);
                        dp[dpIdx + dpL] = Hq2x.Mix3To1(w[4], w[3]);
                        if (Hq2x.diff(w[5], w[7], trY, trU, trV, trA)) {
                            dp[dpIdx + dpL + 1] = Hq2x.Mix3To1(w[4], w[8]);
                            break;
                        }
                        dp[dpIdx + dpL + 1] = Hq2x.Mix6To1To1(w[4], w[5], w[7]);
                        break;
                    }
                    case 89: {
                        dp[dpIdx] = Hq2x.Mix3To1(w[4], w[1]);
                        dp[dpIdx + 1] = Hq2x.Mix2To1To1(w[4], w[2], w[1]);
                        dp[dpIdx + dpL] = Hq2x.diff(w[7], w[3], trY, trU, trV, trA) ? Hq2x.Mix3To1(w[4], w[6]) : Hq2x.Mix6To1To1(w[4], w[7], w[3]);
                        if (Hq2x.diff(w[5], w[7], trY, trU, trV, trA)) {
                            dp[dpIdx + dpL + 1] = Hq2x.Mix3To1(w[4], w[8]);
                            break;
                        }
                        dp[dpIdx + dpL + 1] = Hq2x.Mix6To1To1(w[4], w[5], w[7]);
                        break;
                    }
                    case 90: {
                        dp[dpIdx] = Hq2x.diff(w[3], w[1], trY, trU, trV, trA) ? Hq2x.Mix3To1(w[4], w[0]) : Hq2x.Mix6To1To1(w[4], w[3], w[1]);
                        dp[dpIdx + 1] = Hq2x.diff(w[1], w[5], trY, trU, trV, trA) ? Hq2x.Mix3To1(w[4], w[2]) : Hq2x.Mix6To1To1(w[4], w[1], w[5]);
                        dp[dpIdx + dpL] = Hq2x.diff(w[7], w[3], trY, trU, trV, trA) ? Hq2x.Mix3To1(w[4], w[6]) : Hq2x.Mix6To1To1(w[4], w[7], w[3]);
                        if (Hq2x.diff(w[5], w[7], trY, trU, trV, trA)) {
                            dp[dpIdx + dpL + 1] = Hq2x.Mix3To1(w[4], w[8]);
                            break;
                        }
                        dp[dpIdx + dpL + 1] = Hq2x.Mix6To1To1(w[4], w[5], w[7]);
                        break;
                    }
                    case 23: 
                    case 55: {
                        if (Hq2x.diff(w[1], w[5], trY, trU, trV, trA)) {
                            dp[dpIdx] = Hq2x.Mix3To1(w[4], w[3]);
                            dp[dpIdx + 1] = w[4];
                        } else {
                            dp[dpIdx] = Hq2x.Mix4To2To1(w[4], w[1], w[3]);
                            dp[dpIdx + 1] = Hq2x.Mix2To3To3(w[4], w[1], w[5]);
                        }
                        dp[dpIdx + dpL] = Hq2x.Mix2To1To1(w[4], w[7], w[3]);
                        dp[dpIdx + dpL + 1] = Hq2x.Mix2To1To1(w[4], w[8], w[7]);
                        break;
                    }
                    case 150: 
                    case 182: {
                        dp[dpIdx] = Hq2x.Mix2To1To1(w[4], w[0], w[3]);
                        if (Hq2x.diff(w[1], w[5], trY, trU, trV, trA)) {
                            dp[dpIdx + 1] = w[4];
                            dp[dpIdx + dpL + 1] = Hq2x.Mix3To1(w[4], w[7]);
                        } else {
                            dp[dpIdx + 1] = Hq2x.Mix2To3To3(w[4], w[1], w[5]);
                            dp[dpIdx + dpL + 1] = Hq2x.Mix4To2To1(w[4], w[5], w[7]);
                        }
                        dp[dpIdx + dpL] = Hq2x.Mix2To1To1(w[4], w[7], w[3]);
                        break;
                    }
                    case 212: 
                    case 213: {
                        dp[dpIdx] = Hq2x.Mix2To1To1(w[4], w[3], w[1]);
                        if (Hq2x.diff(w[5], w[7], trY, trU, trV, trA)) {
                            dp[dpIdx + 1] = Hq2x.Mix3To1(w[4], w[1]);
                            dp[dpIdx + dpL + 1] = w[4];
                        } else {
                            dp[dpIdx + 1] = Hq2x.Mix4To2To1(w[4], w[5], w[1]);
                            dp[dpIdx + dpL + 1] = Hq2x.Mix2To3To3(w[4], w[5], w[7]);
                        }
                        dp[dpIdx + dpL] = Hq2x.Mix2To1To1(w[4], w[6], w[3]);
                        break;
                    }
                    case 240: 
                    case 241: {
                        dp[dpIdx] = Hq2x.Mix2To1To1(w[4], w[3], w[1]);
                        dp[dpIdx + 1] = Hq2x.Mix2To1To1(w[4], w[2], w[1]);
                        if (Hq2x.diff(w[5], w[7], trY, trU, trV, trA)) {
                            dp[dpIdx + dpL] = Hq2x.Mix3To1(w[4], w[3]);
                            dp[dpIdx + dpL + 1] = w[4];
                            break;
                        }
                        dp[dpIdx + dpL] = Hq2x.Mix4To2To1(w[4], w[7], w[3]);
                        dp[dpIdx + dpL + 1] = Hq2x.Mix2To3To3(w[4], w[5], w[7]);
                        break;
                    }
                    case 232: 
                    case 236: {
                        dp[dpIdx] = Hq2x.Mix2To1To1(w[4], w[0], w[1]);
                        dp[dpIdx + 1] = Hq2x.Mix2To1To1(w[4], w[1], w[5]);
                        if (Hq2x.diff(w[7], w[3], trY, trU, trV, trA)) {
                            dp[dpIdx + dpL] = w[4];
                            dp[dpIdx + dpL + 1] = Hq2x.Mix3To1(w[4], w[5]);
                            break;
                        }
                        dp[dpIdx + dpL] = Hq2x.Mix2To3To3(w[4], w[7], w[3]);
                        dp[dpIdx + dpL + 1] = Hq2x.Mix4To2To1(w[4], w[7], w[5]);
                        break;
                    }
                    case 105: 
                    case 109: {
                        if (Hq2x.diff(w[7], w[3], trY, trU, trV, trA)) {
                            dp[dpIdx] = Hq2x.Mix3To1(w[4], w[1]);
                            dp[dpIdx + dpL] = w[4];
                        } else {
                            dp[dpIdx] = Hq2x.Mix4To2To1(w[4], w[3], w[1]);
                            dp[dpIdx + dpL] = Hq2x.Mix2To3To3(w[4], w[7], w[3]);
                        }
                        dp[dpIdx + 1] = Hq2x.Mix2To1To1(w[4], w[1], w[5]);
                        dp[dpIdx + dpL + 1] = Hq2x.Mix2To1To1(w[4], w[8], w[5]);
                        break;
                    }
                    case 43: 
                    case 171: {
                        if (Hq2x.diff(w[3], w[1], trY, trU, trV, trA)) {
                            dp[dpIdx] = w[4];
                            dp[dpIdx + dpL] = Hq2x.Mix3To1(w[4], w[7]);
                        } else {
                            dp[dpIdx] = Hq2x.Mix2To3To3(w[4], w[3], w[1]);
                            dp[dpIdx + dpL] = Hq2x.Mix4To2To1(w[4], w[3], w[7]);
                        }
                        dp[dpIdx + 1] = Hq2x.Mix2To1To1(w[4], w[2], w[5]);
                        dp[dpIdx + dpL + 1] = Hq2x.Mix2To1To1(w[4], w[5], w[7]);
                        break;
                    }
                    case 15: 
                    case 143: {
                        if (Hq2x.diff(w[3], w[1], trY, trU, trV, trA)) {
                            dp[dpIdx] = w[4];
                            dp[dpIdx + 1] = Hq2x.Mix3To1(w[4], w[5]);
                        } else {
                            dp[dpIdx] = Hq2x.Mix2To3To3(w[4], w[3], w[1]);
                            dp[dpIdx + 1] = Hq2x.Mix4To2To1(w[4], w[1], w[5]);
                        }
                        dp[dpIdx + dpL] = Hq2x.Mix2To1To1(w[4], w[6], w[7]);
                        dp[dpIdx + dpL + 1] = Hq2x.Mix2To1To1(w[4], w[5], w[7]);
                        break;
                    }
                    case 124: {
                        dp[dpIdx] = Hq2x.Mix2To1To1(w[4], w[0], w[1]);
                        dp[dpIdx + 1] = Hq2x.Mix3To1(w[4], w[1]);
                        dp[dpIdx + dpL] = Hq2x.diff(w[7], w[3], trY, trU, trV, trA) ? w[4] : Hq2x.Mix2To1To1(w[4], w[7], w[3]);
                        dp[dpIdx + dpL + 1] = Hq2x.Mix3To1(w[4], w[8]);
                        break;
                    }
                    case 203: {
                        dp[dpIdx] = Hq2x.diff(w[3], w[1], trY, trU, trV, trA) ? w[4] : Hq2x.Mix2To1To1(w[4], w[3], w[1]);
                        dp[dpIdx + 1] = Hq2x.Mix2To1To1(w[4], w[2], w[5]);
                        dp[dpIdx + dpL] = Hq2x.Mix3To1(w[4], w[6]);
                        dp[dpIdx + dpL + 1] = Hq2x.Mix3To1(w[4], w[5]);
                        break;
                    }
                    case 62: {
                        dp[dpIdx] = Hq2x.Mix3To1(w[4], w[0]);
                        dp[dpIdx + 1] = Hq2x.diff(w[1], w[5], trY, trU, trV, trA) ? w[4] : Hq2x.Mix2To1To1(w[4], w[1], w[5]);
                        dp[dpIdx + dpL] = Hq2x.Mix3To1(w[4], w[7]);
                        dp[dpIdx + dpL + 1] = Hq2x.Mix2To1To1(w[4], w[8], w[7]);
                        break;
                    }
                    case 211: {
                        dp[dpIdx] = Hq2x.Mix3To1(w[4], w[3]);
                        dp[dpIdx + 1] = Hq2x.Mix3To1(w[4], w[2]);
                        dp[dpIdx + dpL] = Hq2x.Mix2To1To1(w[4], w[6], w[3]);
                        if (Hq2x.diff(w[5], w[7], trY, trU, trV, trA)) {
                            dp[dpIdx + dpL + 1] = w[4];
                            break;
                        }
                        dp[dpIdx + dpL + 1] = Hq2x.Mix2To1To1(w[4], w[5], w[7]);
                        break;
                    }
                    case 118: {
                        dp[dpIdx] = Hq2x.Mix2To1To1(w[4], w[0], w[3]);
                        dp[dpIdx + 1] = Hq2x.diff(w[1], w[5], trY, trU, trV, trA) ? w[4] : Hq2x.Mix2To1To1(w[4], w[1], w[5]);
                        dp[dpIdx + dpL] = Hq2x.Mix3To1(w[4], w[3]);
                        dp[dpIdx + dpL + 1] = Hq2x.Mix3To1(w[4], w[8]);
                        break;
                    }
                    case 217: {
                        dp[dpIdx] = Hq2x.Mix3To1(w[4], w[1]);
                        dp[dpIdx + 1] = Hq2x.Mix2To1To1(w[4], w[2], w[1]);
                        dp[dpIdx + dpL] = Hq2x.Mix3To1(w[4], w[6]);
                        if (Hq2x.diff(w[5], w[7], trY, trU, trV, trA)) {
                            dp[dpIdx + dpL + 1] = w[4];
                            break;
                        }
                        dp[dpIdx + dpL + 1] = Hq2x.Mix2To1To1(w[4], w[5], w[7]);
                        break;
                    }
                    case 110: {
                        dp[dpIdx] = Hq2x.Mix3To1(w[4], w[0]);
                        dp[dpIdx + 1] = Hq2x.Mix3To1(w[4], w[5]);
                        dp[dpIdx + dpL] = Hq2x.diff(w[7], w[3], trY, trU, trV, trA) ? w[4] : Hq2x.Mix2To1To1(w[4], w[7], w[3]);
                        dp[dpIdx + dpL + 1] = Hq2x.Mix2To1To1(w[4], w[8], w[5]);
                        break;
                    }
                    case 155: {
                        dp[dpIdx] = Hq2x.diff(w[3], w[1], trY, trU, trV, trA) ? w[4] : Hq2x.Mix2To1To1(w[4], w[3], w[1]);
                        dp[dpIdx + 1] = Hq2x.Mix3To1(w[4], w[2]);
                        dp[dpIdx + dpL] = Hq2x.Mix2To1To1(w[4], w[6], w[7]);
                        dp[dpIdx + dpL + 1] = Hq2x.Mix3To1(w[4], w[7]);
                        break;
                    }
                    case 188: {
                        dp[dpIdx] = Hq2x.Mix2To1To1(w[4], w[0], w[1]);
                        dp[dpIdx + 1] = Hq2x.Mix3To1(w[4], w[1]);
                        dp[dpIdx + dpL] = Hq2x.Mix3To1(w[4], w[7]);
                        dp[dpIdx + dpL + 1] = Hq2x.Mix3To1(w[4], w[7]);
                        break;
                    }
                    case 185: {
                        dp[dpIdx] = Hq2x.Mix3To1(w[4], w[1]);
                        dp[dpIdx + 1] = Hq2x.Mix2To1To1(w[4], w[2], w[1]);
                        dp[dpIdx + dpL] = Hq2x.Mix3To1(w[4], w[7]);
                        dp[dpIdx + dpL + 1] = Hq2x.Mix3To1(w[4], w[7]);
                        break;
                    }
                    case 61: {
                        dp[dpIdx] = Hq2x.Mix3To1(w[4], w[1]);
                        dp[dpIdx + 1] = Hq2x.Mix3To1(w[4], w[1]);
                        dp[dpIdx + dpL] = Hq2x.Mix3To1(w[4], w[7]);
                        dp[dpIdx + dpL + 1] = Hq2x.Mix2To1To1(w[4], w[8], w[7]);
                        break;
                    }
                    case 157: {
                        dp[dpIdx] = Hq2x.Mix3To1(w[4], w[1]);
                        dp[dpIdx + 1] = Hq2x.Mix3To1(w[4], w[1]);
                        dp[dpIdx + dpL] = Hq2x.Mix2To1To1(w[4], w[6], w[7]);
                        dp[dpIdx + dpL + 1] = Hq2x.Mix3To1(w[4], w[7]);
                        break;
                    }
                    case 103: {
                        dp[dpIdx] = Hq2x.Mix3To1(w[4], w[3]);
                        dp[dpIdx + 1] = Hq2x.Mix3To1(w[4], w[5]);
                        dp[dpIdx + dpL] = Hq2x.Mix3To1(w[4], w[3]);
                        dp[dpIdx + dpL + 1] = Hq2x.Mix2To1To1(w[4], w[8], w[5]);
                        break;
                    }
                    case 227: {
                        dp[dpIdx] = Hq2x.Mix3To1(w[4], w[3]);
                        dp[dpIdx + 1] = Hq2x.Mix2To1To1(w[4], w[2], w[5]);
                        dp[dpIdx + dpL] = Hq2x.Mix3To1(w[4], w[3]);
                        dp[dpIdx + dpL + 1] = Hq2x.Mix3To1(w[4], w[5]);
                        break;
                    }
                    case 230: {
                        dp[dpIdx] = Hq2x.Mix2To1To1(w[4], w[0], w[3]);
                        dp[dpIdx + 1] = Hq2x.Mix3To1(w[4], w[5]);
                        dp[dpIdx + dpL] = Hq2x.Mix3To1(w[4], w[3]);
                        dp[dpIdx + dpL + 1] = Hq2x.Mix3To1(w[4], w[5]);
                        break;
                    }
                    case 199: {
                        dp[dpIdx] = Hq2x.Mix3To1(w[4], w[3]);
                        dp[dpIdx + 1] = Hq2x.Mix3To1(w[4], w[5]);
                        dp[dpIdx + dpL] = Hq2x.Mix2To1To1(w[4], w[6], w[3]);
                        dp[dpIdx + dpL + 1] = Hq2x.Mix3To1(w[4], w[5]);
                        break;
                    }
                    case 220: {
                        dp[dpIdx] = Hq2x.Mix2To1To1(w[4], w[0], w[1]);
                        dp[dpIdx + 1] = Hq2x.Mix3To1(w[4], w[1]);
                        dp[dpIdx + dpL] = Hq2x.diff(w[7], w[3], trY, trU, trV, trA) ? Hq2x.Mix3To1(w[4], w[6]) : Hq2x.Mix6To1To1(w[4], w[7], w[3]);
                        if (Hq2x.diff(w[5], w[7], trY, trU, trV, trA)) {
                            dp[dpIdx + dpL + 1] = w[4];
                            break;
                        }
                        dp[dpIdx + dpL + 1] = Hq2x.Mix2To1To1(w[4], w[5], w[7]);
                        break;
                    }
                    case 158: {
                        dp[dpIdx] = Hq2x.diff(w[3], w[1], trY, trU, trV, trA) ? Hq2x.Mix3To1(w[4], w[0]) : Hq2x.Mix6To1To1(w[4], w[3], w[1]);
                        dp[dpIdx + 1] = Hq2x.diff(w[1], w[5], trY, trU, trV, trA) ? w[4] : Hq2x.Mix2To1To1(w[4], w[1], w[5]);
                        dp[dpIdx + dpL] = Hq2x.Mix2To1To1(w[4], w[6], w[7]);
                        dp[dpIdx + dpL + 1] = Hq2x.Mix3To1(w[4], w[7]);
                        break;
                    }
                    case 234: {
                        dp[dpIdx] = Hq2x.diff(w[3], w[1], trY, trU, trV, trA) ? Hq2x.Mix3To1(w[4], w[0]) : Hq2x.Mix6To1To1(w[4], w[3], w[1]);
                        dp[dpIdx + 1] = Hq2x.Mix2To1To1(w[4], w[2], w[5]);
                        dp[dpIdx + dpL] = Hq2x.diff(w[7], w[3], trY, trU, trV, trA) ? w[4] : Hq2x.Mix2To1To1(w[4], w[7], w[3]);
                        dp[dpIdx + dpL + 1] = Hq2x.Mix3To1(w[4], w[5]);
                        break;
                    }
                    case 242: {
                        dp[dpIdx] = Hq2x.Mix2To1To1(w[4], w[0], w[3]);
                        dp[dpIdx + 1] = Hq2x.diff(w[1], w[5], trY, trU, trV, trA) ? Hq2x.Mix3To1(w[4], w[2]) : Hq2x.Mix6To1To1(w[4], w[1], w[5]);
                        dp[dpIdx + dpL] = Hq2x.Mix3To1(w[4], w[3]);
                        if (Hq2x.diff(w[5], w[7], trY, trU, trV, trA)) {
                            dp[dpIdx + dpL + 1] = w[4];
                            break;
                        }
                        dp[dpIdx + dpL + 1] = Hq2x.Mix2To1To1(w[4], w[5], w[7]);
                        break;
                    }
                    case 59: {
                        dp[dpIdx] = Hq2x.diff(w[3], w[1], trY, trU, trV, trA) ? w[4] : Hq2x.Mix2To1To1(w[4], w[3], w[1]);
                        dp[dpIdx + 1] = Hq2x.diff(w[1], w[5], trY, trU, trV, trA) ? Hq2x.Mix3To1(w[4], w[2]) : Hq2x.Mix6To1To1(w[4], w[1], w[5]);
                        dp[dpIdx + dpL] = Hq2x.Mix3To1(w[4], w[7]);
                        dp[dpIdx + dpL + 1] = Hq2x.Mix2To1To1(w[4], w[8], w[7]);
                        break;
                    }
                    case 121: {
                        dp[dpIdx] = Hq2x.Mix3To1(w[4], w[1]);
                        dp[dpIdx + 1] = Hq2x.Mix2To1To1(w[4], w[2], w[1]);
                        dp[dpIdx + dpL] = Hq2x.diff(w[7], w[3], trY, trU, trV, trA) ? w[4] : Hq2x.Mix2To1To1(w[4], w[7], w[3]);
                        if (Hq2x.diff(w[5], w[7], trY, trU, trV, trA)) {
                            dp[dpIdx + dpL + 1] = Hq2x.Mix3To1(w[4], w[8]);
                            break;
                        }
                        dp[dpIdx + dpL + 1] = Hq2x.Mix6To1To1(w[4], w[5], w[7]);
                        break;
                    }
                    case 87: {
                        dp[dpIdx] = Hq2x.Mix3To1(w[4], w[3]);
                        dp[dpIdx + 1] = Hq2x.diff(w[1], w[5], trY, trU, trV, trA) ? w[4] : Hq2x.Mix2To1To1(w[4], w[1], w[5]);
                        dp[dpIdx + dpL] = Hq2x.Mix2To1To1(w[4], w[6], w[3]);
                        if (Hq2x.diff(w[5], w[7], trY, trU, trV, trA)) {
                            dp[dpIdx + dpL + 1] = Hq2x.Mix3To1(w[4], w[8]);
                            break;
                        }
                        dp[dpIdx + dpL + 1] = Hq2x.Mix6To1To1(w[4], w[5], w[7]);
                        break;
                    }
                    case 79: {
                        dp[dpIdx] = Hq2x.diff(w[3], w[1], trY, trU, trV, trA) ? w[4] : Hq2x.Mix2To1To1(w[4], w[3], w[1]);
                        dp[dpIdx + 1] = Hq2x.Mix3To1(w[4], w[5]);
                        dp[dpIdx + dpL] = Hq2x.diff(w[7], w[3], trY, trU, trV, trA) ? Hq2x.Mix3To1(w[4], w[6]) : Hq2x.Mix6To1To1(w[4], w[7], w[3]);
                        dp[dpIdx + dpL + 1] = Hq2x.Mix2To1To1(w[4], w[8], w[5]);
                        break;
                    }
                    case 122: {
                        dp[dpIdx] = Hq2x.diff(w[3], w[1], trY, trU, trV, trA) ? Hq2x.Mix3To1(w[4], w[0]) : Hq2x.Mix6To1To1(w[4], w[3], w[1]);
                        dp[dpIdx + 1] = Hq2x.diff(w[1], w[5], trY, trU, trV, trA) ? Hq2x.Mix3To1(w[4], w[2]) : Hq2x.Mix6To1To1(w[4], w[1], w[5]);
                        dp[dpIdx + dpL] = Hq2x.diff(w[7], w[3], trY, trU, trV, trA) ? w[4] : Hq2x.Mix2To1To1(w[4], w[7], w[3]);
                        if (Hq2x.diff(w[5], w[7], trY, trU, trV, trA)) {
                            dp[dpIdx + dpL + 1] = Hq2x.Mix3To1(w[4], w[8]);
                            break;
                        }
                        dp[dpIdx + dpL + 1] = Hq2x.Mix6To1To1(w[4], w[5], w[7]);
                        break;
                    }
                    case 94: {
                        dp[dpIdx] = Hq2x.diff(w[3], w[1], trY, trU, trV, trA) ? Hq2x.Mix3To1(w[4], w[0]) : Hq2x.Mix6To1To1(w[4], w[3], w[1]);
                        dp[dpIdx + 1] = Hq2x.diff(w[1], w[5], trY, trU, trV, trA) ? w[4] : Hq2x.Mix2To1To1(w[4], w[1], w[5]);
                        dp[dpIdx + dpL] = Hq2x.diff(w[7], w[3], trY, trU, trV, trA) ? Hq2x.Mix3To1(w[4], w[6]) : Hq2x.Mix6To1To1(w[4], w[7], w[3]);
                        if (Hq2x.diff(w[5], w[7], trY, trU, trV, trA)) {
                            dp[dpIdx + dpL + 1] = Hq2x.Mix3To1(w[4], w[8]);
                            break;
                        }
                        dp[dpIdx + dpL + 1] = Hq2x.Mix6To1To1(w[4], w[5], w[7]);
                        break;
                    }
                    case 218: {
                        dp[dpIdx] = Hq2x.diff(w[3], w[1], trY, trU, trV, trA) ? Hq2x.Mix3To1(w[4], w[0]) : Hq2x.Mix6To1To1(w[4], w[3], w[1]);
                        dp[dpIdx + 1] = Hq2x.diff(w[1], w[5], trY, trU, trV, trA) ? Hq2x.Mix3To1(w[4], w[2]) : Hq2x.Mix6To1To1(w[4], w[1], w[5]);
                        dp[dpIdx + dpL] = Hq2x.diff(w[7], w[3], trY, trU, trV, trA) ? Hq2x.Mix3To1(w[4], w[6]) : Hq2x.Mix6To1To1(w[4], w[7], w[3]);
                        if (Hq2x.diff(w[5], w[7], trY, trU, trV, trA)) {
                            dp[dpIdx + dpL + 1] = w[4];
                            break;
                        }
                        dp[dpIdx + dpL + 1] = Hq2x.Mix2To1To1(w[4], w[5], w[7]);
                        break;
                    }
                    case 91: {
                        dp[dpIdx] = Hq2x.diff(w[3], w[1], trY, trU, trV, trA) ? w[4] : Hq2x.Mix2To1To1(w[4], w[3], w[1]);
                        dp[dpIdx + 1] = Hq2x.diff(w[1], w[5], trY, trU, trV, trA) ? Hq2x.Mix3To1(w[4], w[2]) : Hq2x.Mix6To1To1(w[4], w[1], w[5]);
                        dp[dpIdx + dpL] = Hq2x.diff(w[7], w[3], trY, trU, trV, trA) ? Hq2x.Mix3To1(w[4], w[6]) : Hq2x.Mix6To1To1(w[4], w[7], w[3]);
                        if (Hq2x.diff(w[5], w[7], trY, trU, trV, trA)) {
                            dp[dpIdx + dpL + 1] = Hq2x.Mix3To1(w[4], w[8]);
                            break;
                        }
                        dp[dpIdx + dpL + 1] = Hq2x.Mix6To1To1(w[4], w[5], w[7]);
                        break;
                    }
                    case 229: {
                        dp[dpIdx] = Hq2x.Mix2To1To1(w[4], w[3], w[1]);
                        dp[dpIdx + 1] = Hq2x.Mix2To1To1(w[4], w[1], w[5]);
                        dp[dpIdx + dpL] = Hq2x.Mix3To1(w[4], w[3]);
                        dp[dpIdx + dpL + 1] = Hq2x.Mix3To1(w[4], w[5]);
                        break;
                    }
                    case 167: {
                        dp[dpIdx] = Hq2x.Mix3To1(w[4], w[3]);
                        dp[dpIdx + 1] = Hq2x.Mix3To1(w[4], w[5]);
                        dp[dpIdx + dpL] = Hq2x.Mix2To1To1(w[4], w[7], w[3]);
                        dp[dpIdx + dpL + 1] = Hq2x.Mix2To1To1(w[4], w[5], w[7]);
                        break;
                    }
                    case 173: {
                        dp[dpIdx] = Hq2x.Mix3To1(w[4], w[1]);
                        dp[dpIdx + 1] = Hq2x.Mix2To1To1(w[4], w[1], w[5]);
                        dp[dpIdx + dpL] = Hq2x.Mix3To1(w[4], w[7]);
                        dp[dpIdx + dpL + 1] = Hq2x.Mix2To1To1(w[4], w[5], w[7]);
                        break;
                    }
                    case 181: {
                        dp[dpIdx] = Hq2x.Mix2To1To1(w[4], w[3], w[1]);
                        dp[dpIdx + 1] = Hq2x.Mix3To1(w[4], w[1]);
                        dp[dpIdx + dpL] = Hq2x.Mix2To1To1(w[4], w[7], w[3]);
                        dp[dpIdx + dpL + 1] = Hq2x.Mix3To1(w[4], w[7]);
                        break;
                    }
                    case 186: {
                        dp[dpIdx] = Hq2x.diff(w[3], w[1], trY, trU, trV, trA) ? Hq2x.Mix3To1(w[4], w[0]) : Hq2x.Mix6To1To1(w[4], w[3], w[1]);
                        dp[dpIdx + 1] = Hq2x.diff(w[1], w[5], trY, trU, trV, trA) ? Hq2x.Mix3To1(w[4], w[2]) : Hq2x.Mix6To1To1(w[4], w[1], w[5]);
                        dp[dpIdx + dpL] = Hq2x.Mix3To1(w[4], w[7]);
                        dp[dpIdx + dpL + 1] = Hq2x.Mix3To1(w[4], w[7]);
                        break;
                    }
                    case 115: {
                        dp[dpIdx] = Hq2x.Mix3To1(w[4], w[3]);
                        dp[dpIdx + 1] = Hq2x.diff(w[1], w[5], trY, trU, trV, trA) ? Hq2x.Mix3To1(w[4], w[2]) : Hq2x.Mix6To1To1(w[4], w[1], w[5]);
                        dp[dpIdx + dpL] = Hq2x.Mix3To1(w[4], w[3]);
                        if (Hq2x.diff(w[5], w[7], trY, trU, trV, trA)) {
                            dp[dpIdx + dpL + 1] = Hq2x.Mix3To1(w[4], w[8]);
                            break;
                        }
                        dp[dpIdx + dpL + 1] = Hq2x.Mix6To1To1(w[4], w[5], w[7]);
                        break;
                    }
                    case 93: {
                        dp[dpIdx] = Hq2x.Mix3To1(w[4], w[1]);
                        dp[dpIdx + 1] = Hq2x.Mix3To1(w[4], w[1]);
                        dp[dpIdx + dpL] = Hq2x.diff(w[7], w[3], trY, trU, trV, trA) ? Hq2x.Mix3To1(w[4], w[6]) : Hq2x.Mix6To1To1(w[4], w[7], w[3]);
                        if (Hq2x.diff(w[5], w[7], trY, trU, trV, trA)) {
                            dp[dpIdx + dpL + 1] = Hq2x.Mix3To1(w[4], w[8]);
                            break;
                        }
                        dp[dpIdx + dpL + 1] = Hq2x.Mix6To1To1(w[4], w[5], w[7]);
                        break;
                    }
                    case 206: {
                        dp[dpIdx] = Hq2x.diff(w[3], w[1], trY, trU, trV, trA) ? Hq2x.Mix3To1(w[4], w[0]) : Hq2x.Mix6To1To1(w[4], w[3], w[1]);
                        dp[dpIdx + 1] = Hq2x.Mix3To1(w[4], w[5]);
                        dp[dpIdx + dpL] = Hq2x.diff(w[7], w[3], trY, trU, trV, trA) ? Hq2x.Mix3To1(w[4], w[6]) : Hq2x.Mix6To1To1(w[4], w[7], w[3]);
                        dp[dpIdx + dpL + 1] = Hq2x.Mix3To1(w[4], w[5]);
                        break;
                    }
                    case 201: 
                    case 205: {
                        dp[dpIdx] = Hq2x.Mix3To1(w[4], w[1]);
                        dp[dpIdx + 1] = Hq2x.Mix2To1To1(w[4], w[1], w[5]);
                        dp[dpIdx + dpL] = Hq2x.diff(w[7], w[3], trY, trU, trV, trA) ? Hq2x.Mix3To1(w[4], w[6]) : Hq2x.Mix6To1To1(w[4], w[7], w[3]);
                        dp[dpIdx + dpL + 1] = Hq2x.Mix3To1(w[4], w[5]);
                        break;
                    }
                    case 46: 
                    case 174: {
                        dp[dpIdx] = Hq2x.diff(w[3], w[1], trY, trU, trV, trA) ? Hq2x.Mix3To1(w[4], w[0]) : Hq2x.Mix6To1To1(w[4], w[3], w[1]);
                        dp[dpIdx + 1] = Hq2x.Mix3To1(w[4], w[5]);
                        dp[dpIdx + dpL] = Hq2x.Mix3To1(w[4], w[7]);
                        dp[dpIdx + dpL + 1] = Hq2x.Mix2To1To1(w[4], w[5], w[7]);
                        break;
                    }
                    case 147: 
                    case 179: {
                        dp[dpIdx] = Hq2x.Mix3To1(w[4], w[3]);
                        dp[dpIdx + 1] = Hq2x.diff(w[1], w[5], trY, trU, trV, trA) ? Hq2x.Mix3To1(w[4], w[2]) : Hq2x.Mix6To1To1(w[4], w[1], w[5]);
                        dp[dpIdx + dpL] = Hq2x.Mix2To1To1(w[4], w[7], w[3]);
                        dp[dpIdx + dpL + 1] = Hq2x.Mix3To1(w[4], w[7]);
                        break;
                    }
                    case 116: 
                    case 117: {
                        dp[dpIdx] = Hq2x.Mix2To1To1(w[4], w[3], w[1]);
                        dp[dpIdx + 1] = Hq2x.Mix3To1(w[4], w[1]);
                        dp[dpIdx + dpL] = Hq2x.Mix3To1(w[4], w[3]);
                        if (Hq2x.diff(w[5], w[7], trY, trU, trV, trA)) {
                            dp[dpIdx + dpL + 1] = Hq2x.Mix3To1(w[4], w[8]);
                            break;
                        }
                        dp[dpIdx + dpL + 1] = Hq2x.Mix6To1To1(w[4], w[5], w[7]);
                        break;
                    }
                    case 189: {
                        dp[dpIdx] = Hq2x.Mix3To1(w[4], w[1]);
                        dp[dpIdx + 1] = Hq2x.Mix3To1(w[4], w[1]);
                        dp[dpIdx + dpL] = Hq2x.Mix3To1(w[4], w[7]);
                        dp[dpIdx + dpL + 1] = Hq2x.Mix3To1(w[4], w[7]);
                        break;
                    }
                    case 231: {
                        dp[dpIdx] = Hq2x.Mix3To1(w[4], w[3]);
                        dp[dpIdx + 1] = Hq2x.Mix3To1(w[4], w[5]);
                        dp[dpIdx + dpL] = Hq2x.Mix3To1(w[4], w[3]);
                        dp[dpIdx + dpL + 1] = Hq2x.Mix3To1(w[4], w[5]);
                        break;
                    }
                    case 126: {
                        dp[dpIdx] = Hq2x.Mix3To1(w[4], w[0]);
                        dp[dpIdx + 1] = Hq2x.diff(w[1], w[5], trY, trU, trV, trA) ? w[4] : Hq2x.Mix2To1To1(w[4], w[1], w[5]);
                        dp[dpIdx + dpL] = Hq2x.diff(w[7], w[3], trY, trU, trV, trA) ? w[4] : Hq2x.Mix2To1To1(w[4], w[7], w[3]);
                        dp[dpIdx + dpL + 1] = Hq2x.Mix3To1(w[4], w[8]);
                        break;
                    }
                    case 219: {
                        dp[dpIdx] = Hq2x.diff(w[3], w[1], trY, trU, trV, trA) ? w[4] : Hq2x.Mix2To1To1(w[4], w[3], w[1]);
                        dp[dpIdx + 1] = Hq2x.Mix3To1(w[4], w[2]);
                        dp[dpIdx + dpL] = Hq2x.Mix3To1(w[4], w[6]);
                        if (Hq2x.diff(w[5], w[7], trY, trU, trV, trA)) {
                            dp[dpIdx + dpL + 1] = w[4];
                            break;
                        }
                        dp[dpIdx + dpL + 1] = Hq2x.Mix2To1To1(w[4], w[5], w[7]);
                        break;
                    }
                    case 125: {
                        if (Hq2x.diff(w[7], w[3], trY, trU, trV, trA)) {
                            dp[dpIdx] = Hq2x.Mix3To1(w[4], w[1]);
                            dp[dpIdx + dpL] = w[4];
                        } else {
                            dp[dpIdx] = Hq2x.Mix4To2To1(w[4], w[3], w[1]);
                            dp[dpIdx + dpL] = Hq2x.Mix2To3To3(w[4], w[7], w[3]);
                        }
                        dp[dpIdx + 1] = Hq2x.Mix3To1(w[4], w[1]);
                        dp[dpIdx + dpL + 1] = Hq2x.Mix3To1(w[4], w[8]);
                        break;
                    }
                    case 221: {
                        dp[dpIdx] = Hq2x.Mix3To1(w[4], w[1]);
                        if (Hq2x.diff(w[5], w[7], trY, trU, trV, trA)) {
                            dp[dpIdx + 1] = Hq2x.Mix3To1(w[4], w[1]);
                            dp[dpIdx + dpL + 1] = w[4];
                        } else {
                            dp[dpIdx + 1] = Hq2x.Mix4To2To1(w[4], w[5], w[1]);
                            dp[dpIdx + dpL + 1] = Hq2x.Mix2To3To3(w[4], w[5], w[7]);
                        }
                        dp[dpIdx + dpL] = Hq2x.Mix3To1(w[4], w[6]);
                        break;
                    }
                    case 207: {
                        if (Hq2x.diff(w[3], w[1], trY, trU, trV, trA)) {
                            dp[dpIdx] = w[4];
                            dp[dpIdx + 1] = Hq2x.Mix3To1(w[4], w[5]);
                        } else {
                            dp[dpIdx] = Hq2x.Mix2To3To3(w[4], w[3], w[1]);
                            dp[dpIdx + 1] = Hq2x.Mix4To2To1(w[4], w[1], w[5]);
                        }
                        dp[dpIdx + dpL] = Hq2x.Mix3To1(w[4], w[6]);
                        dp[dpIdx + dpL + 1] = Hq2x.Mix3To1(w[4], w[5]);
                        break;
                    }
                    case 238: {
                        dp[dpIdx] = Hq2x.Mix3To1(w[4], w[0]);
                        dp[dpIdx + 1] = Hq2x.Mix3To1(w[4], w[5]);
                        if (Hq2x.diff(w[7], w[3], trY, trU, trV, trA)) {
                            dp[dpIdx + dpL] = w[4];
                            dp[dpIdx + dpL + 1] = Hq2x.Mix3To1(w[4], w[5]);
                            break;
                        }
                        dp[dpIdx + dpL] = Hq2x.Mix2To3To3(w[4], w[7], w[3]);
                        dp[dpIdx + dpL + 1] = Hq2x.Mix4To2To1(w[4], w[7], w[5]);
                        break;
                    }
                    case 190: {
                        dp[dpIdx] = Hq2x.Mix3To1(w[4], w[0]);
                        if (Hq2x.diff(w[1], w[5], trY, trU, trV, trA)) {
                            dp[dpIdx + 1] = w[4];
                            dp[dpIdx + dpL + 1] = Hq2x.Mix3To1(w[4], w[7]);
                        } else {
                            dp[dpIdx + 1] = Hq2x.Mix2To3To3(w[4], w[1], w[5]);
                            dp[dpIdx + dpL + 1] = Hq2x.Mix4To2To1(w[4], w[5], w[7]);
                        }
                        dp[dpIdx + dpL] = Hq2x.Mix3To1(w[4], w[7]);
                        break;
                    }
                    case 187: {
                        if (Hq2x.diff(w[3], w[1], trY, trU, trV, trA)) {
                            dp[dpIdx] = w[4];
                            dp[dpIdx + dpL] = Hq2x.Mix3To1(w[4], w[7]);
                        } else {
                            dp[dpIdx] = Hq2x.Mix2To3To3(w[4], w[3], w[1]);
                            dp[dpIdx + dpL] = Hq2x.Mix4To2To1(w[4], w[3], w[7]);
                        }
                        dp[dpIdx + 1] = Hq2x.Mix3To1(w[4], w[2]);
                        dp[dpIdx + dpL + 1] = Hq2x.Mix3To1(w[4], w[7]);
                        break;
                    }
                    case 243: {
                        dp[dpIdx] = Hq2x.Mix3To1(w[4], w[3]);
                        dp[dpIdx + 1] = Hq2x.Mix3To1(w[4], w[2]);
                        if (Hq2x.diff(w[5], w[7], trY, trU, trV, trA)) {
                            dp[dpIdx + dpL] = Hq2x.Mix3To1(w[4], w[3]);
                            dp[dpIdx + dpL + 1] = w[4];
                            break;
                        }
                        dp[dpIdx + dpL] = Hq2x.Mix4To2To1(w[4], w[7], w[3]);
                        dp[dpIdx + dpL + 1] = Hq2x.Mix2To3To3(w[4], w[5], w[7]);
                        break;
                    }
                    case 119: {
                        if (Hq2x.diff(w[1], w[5], trY, trU, trV, trA)) {
                            dp[dpIdx] = Hq2x.Mix3To1(w[4], w[3]);
                            dp[dpIdx + 1] = w[4];
                        } else {
                            dp[dpIdx] = Hq2x.Mix4To2To1(w[4], w[1], w[3]);
                            dp[dpIdx + 1] = Hq2x.Mix2To3To3(w[4], w[1], w[5]);
                        }
                        dp[dpIdx + dpL] = Hq2x.Mix3To1(w[4], w[3]);
                        dp[dpIdx + dpL + 1] = Hq2x.Mix3To1(w[4], w[8]);
                        break;
                    }
                    case 233: 
                    case 237: {
                        dp[dpIdx] = Hq2x.Mix3To1(w[4], w[1]);
                        dp[dpIdx + 1] = Hq2x.Mix2To1To1(w[4], w[1], w[5]);
                        dp[dpIdx + dpL] = Hq2x.diff(w[7], w[3], trY, trU, trV, trA) ? w[4] : Hq2x.Mix14To1To1(w[4], w[7], w[3]);
                        dp[dpIdx + dpL + 1] = Hq2x.Mix3To1(w[4], w[5]);
                        break;
                    }
                    case 47: 
                    case 175: {
                        dp[dpIdx] = Hq2x.diff(w[3], w[1], trY, trU, trV, trA) ? w[4] : Hq2x.Mix14To1To1(w[4], w[3], w[1]);
                        dp[dpIdx + 1] = Hq2x.Mix3To1(w[4], w[5]);
                        dp[dpIdx + dpL] = Hq2x.Mix3To1(w[4], w[7]);
                        dp[dpIdx + dpL + 1] = Hq2x.Mix2To1To1(w[4], w[5], w[7]);
                        break;
                    }
                    case 151: 
                    case 183: {
                        dp[dpIdx] = Hq2x.Mix3To1(w[4], w[3]);
                        dp[dpIdx + 1] = Hq2x.diff(w[1], w[5], trY, trU, trV, trA) ? w[4] : Hq2x.Mix14To1To1(w[4], w[1], w[5]);
                        dp[dpIdx + dpL] = Hq2x.Mix2To1To1(w[4], w[7], w[3]);
                        dp[dpIdx + dpL + 1] = Hq2x.Mix3To1(w[4], w[7]);
                        break;
                    }
                    case 244: 
                    case 245: {
                        dp[dpIdx] = Hq2x.Mix2To1To1(w[4], w[3], w[1]);
                        dp[dpIdx + 1] = Hq2x.Mix3To1(w[4], w[1]);
                        dp[dpIdx + dpL] = Hq2x.Mix3To1(w[4], w[3]);
                        if (Hq2x.diff(w[5], w[7], trY, trU, trV, trA)) {
                            dp[dpIdx + dpL + 1] = w[4];
                            break;
                        }
                        dp[dpIdx + dpL + 1] = Hq2x.Mix14To1To1(w[4], w[5], w[7]);
                        break;
                    }
                    case 250: {
                        dp[dpIdx] = Hq2x.Mix3To1(w[4], w[0]);
                        dp[dpIdx + 1] = Hq2x.Mix3To1(w[4], w[2]);
                        dp[dpIdx + dpL] = Hq2x.diff(w[7], w[3], trY, trU, trV, trA) ? w[4] : Hq2x.Mix2To1To1(w[4], w[7], w[3]);
                        if (Hq2x.diff(w[5], w[7], trY, trU, trV, trA)) {
                            dp[dpIdx + dpL + 1] = w[4];
                            break;
                        }
                        dp[dpIdx + dpL + 1] = Hq2x.Mix2To1To1(w[4], w[5], w[7]);
                        break;
                    }
                    case 123: {
                        dp[dpIdx] = Hq2x.diff(w[3], w[1], trY, trU, trV, trA) ? w[4] : Hq2x.Mix2To1To1(w[4], w[3], w[1]);
                        dp[dpIdx + 1] = Hq2x.Mix3To1(w[4], w[2]);
                        dp[dpIdx + dpL] = Hq2x.diff(w[7], w[3], trY, trU, trV, trA) ? w[4] : Hq2x.Mix2To1To1(w[4], w[7], w[3]);
                        dp[dpIdx + dpL + 1] = Hq2x.Mix3To1(w[4], w[8]);
                        break;
                    }
                    case 95: {
                        dp[dpIdx] = Hq2x.diff(w[3], w[1], trY, trU, trV, trA) ? w[4] : Hq2x.Mix2To1To1(w[4], w[3], w[1]);
                        dp[dpIdx + 1] = Hq2x.diff(w[1], w[5], trY, trU, trV, trA) ? w[4] : Hq2x.Mix2To1To1(w[4], w[1], w[5]);
                        dp[dpIdx + dpL] = Hq2x.Mix3To1(w[4], w[6]);
                        dp[dpIdx + dpL + 1] = Hq2x.Mix3To1(w[4], w[8]);
                        break;
                    }
                    case 222: {
                        dp[dpIdx] = Hq2x.Mix3To1(w[4], w[0]);
                        dp[dpIdx + 1] = Hq2x.diff(w[1], w[5], trY, trU, trV, trA) ? w[4] : Hq2x.Mix2To1To1(w[4], w[1], w[5]);
                        dp[dpIdx + dpL] = Hq2x.Mix3To1(w[4], w[6]);
                        if (Hq2x.diff(w[5], w[7], trY, trU, trV, trA)) {
                            dp[dpIdx + dpL + 1] = w[4];
                            break;
                        }
                        dp[dpIdx + dpL + 1] = Hq2x.Mix2To1To1(w[4], w[5], w[7]);
                        break;
                    }
                    case 252: {
                        dp[dpIdx] = Hq2x.Mix2To1To1(w[4], w[0], w[1]);
                        dp[dpIdx + 1] = Hq2x.Mix3To1(w[4], w[1]);
                        dp[dpIdx + dpL] = Hq2x.diff(w[7], w[3], trY, trU, trV, trA) ? w[4] : Hq2x.Mix2To1To1(w[4], w[7], w[3]);
                        if (Hq2x.diff(w[5], w[7], trY, trU, trV, trA)) {
                            dp[dpIdx + dpL + 1] = w[4];
                            break;
                        }
                        dp[dpIdx + dpL + 1] = Hq2x.Mix14To1To1(w[4], w[5], w[7]);
                        break;
                    }
                    case 249: {
                        dp[dpIdx] = Hq2x.Mix3To1(w[4], w[1]);
                        dp[dpIdx + 1] = Hq2x.Mix2To1To1(w[4], w[2], w[1]);
                        dp[dpIdx + dpL] = Hq2x.diff(w[7], w[3], trY, trU, trV, trA) ? w[4] : Hq2x.Mix14To1To1(w[4], w[7], w[3]);
                        if (Hq2x.diff(w[5], w[7], trY, trU, trV, trA)) {
                            dp[dpIdx + dpL + 1] = w[4];
                            break;
                        }
                        dp[dpIdx + dpL + 1] = Hq2x.Mix2To1To1(w[4], w[5], w[7]);
                        break;
                    }
                    case 235: {
                        dp[dpIdx] = Hq2x.diff(w[3], w[1], trY, trU, trV, trA) ? w[4] : Hq2x.Mix2To1To1(w[4], w[3], w[1]);
                        dp[dpIdx + 1] = Hq2x.Mix2To1To1(w[4], w[2], w[5]);
                        dp[dpIdx + dpL] = Hq2x.diff(w[7], w[3], trY, trU, trV, trA) ? w[4] : Hq2x.Mix14To1To1(w[4], w[7], w[3]);
                        dp[dpIdx + dpL + 1] = Hq2x.Mix3To1(w[4], w[5]);
                        break;
                    }
                    case 111: {
                        dp[dpIdx] = Hq2x.diff(w[3], w[1], trY, trU, trV, trA) ? w[4] : Hq2x.Mix14To1To1(w[4], w[3], w[1]);
                        dp[dpIdx + 1] = Hq2x.Mix3To1(w[4], w[5]);
                        dp[dpIdx + dpL] = Hq2x.diff(w[7], w[3], trY, trU, trV, trA) ? w[4] : Hq2x.Mix2To1To1(w[4], w[7], w[3]);
                        dp[dpIdx + dpL + 1] = Hq2x.Mix2To1To1(w[4], w[8], w[5]);
                        break;
                    }
                    case 63: {
                        dp[dpIdx] = Hq2x.diff(w[3], w[1], trY, trU, trV, trA) ? w[4] : Hq2x.Mix14To1To1(w[4], w[3], w[1]);
                        dp[dpIdx + 1] = Hq2x.diff(w[1], w[5], trY, trU, trV, trA) ? w[4] : Hq2x.Mix2To1To1(w[4], w[1], w[5]);
                        dp[dpIdx + dpL] = Hq2x.Mix3To1(w[4], w[7]);
                        dp[dpIdx + dpL + 1] = Hq2x.Mix2To1To1(w[4], w[8], w[7]);
                        break;
                    }
                    case 159: {
                        dp[dpIdx] = Hq2x.diff(w[3], w[1], trY, trU, trV, trA) ? w[4] : Hq2x.Mix2To1To1(w[4], w[3], w[1]);
                        dp[dpIdx + 1] = Hq2x.diff(w[1], w[5], trY, trU, trV, trA) ? w[4] : Hq2x.Mix14To1To1(w[4], w[1], w[5]);
                        dp[dpIdx + dpL] = Hq2x.Mix2To1To1(w[4], w[6], w[7]);
                        dp[dpIdx + dpL + 1] = Hq2x.Mix3To1(w[4], w[7]);
                        break;
                    }
                    case 215: {
                        dp[dpIdx] = Hq2x.Mix3To1(w[4], w[3]);
                        dp[dpIdx + 1] = Hq2x.diff(w[1], w[5], trY, trU, trV, trA) ? w[4] : Hq2x.Mix14To1To1(w[4], w[1], w[5]);
                        dp[dpIdx + dpL] = Hq2x.Mix2To1To1(w[4], w[6], w[3]);
                        if (Hq2x.diff(w[5], w[7], trY, trU, trV, trA)) {
                            dp[dpIdx + dpL + 1] = w[4];
                            break;
                        }
                        dp[dpIdx + dpL + 1] = Hq2x.Mix2To1To1(w[4], w[5], w[7]);
                        break;
                    }
                    case 246: {
                        dp[dpIdx] = Hq2x.Mix2To1To1(w[4], w[0], w[3]);
                        dp[dpIdx + 1] = Hq2x.diff(w[1], w[5], trY, trU, trV, trA) ? w[4] : Hq2x.Mix2To1To1(w[4], w[1], w[5]);
                        dp[dpIdx + dpL] = Hq2x.Mix3To1(w[4], w[3]);
                        if (Hq2x.diff(w[5], w[7], trY, trU, trV, trA)) {
                            dp[dpIdx + dpL + 1] = w[4];
                            break;
                        }
                        dp[dpIdx + dpL + 1] = Hq2x.Mix14To1To1(w[4], w[5], w[7]);
                        break;
                    }
                    case 254: {
                        dp[dpIdx] = Hq2x.Mix3To1(w[4], w[0]);
                        dp[dpIdx + 1] = Hq2x.diff(w[1], w[5], trY, trU, trV, trA) ? w[4] : Hq2x.Mix2To1To1(w[4], w[1], w[5]);
                        dp[dpIdx + dpL] = Hq2x.diff(w[7], w[3], trY, trU, trV, trA) ? w[4] : Hq2x.Mix2To1To1(w[4], w[7], w[3]);
                        if (Hq2x.diff(w[5], w[7], trY, trU, trV, trA)) {
                            dp[dpIdx + dpL + 1] = w[4];
                            break;
                        }
                        dp[dpIdx + dpL + 1] = Hq2x.Mix14To1To1(w[4], w[5], w[7]);
                        break;
                    }
                    case 253: {
                        dp[dpIdx] = Hq2x.Mix3To1(w[4], w[1]);
                        dp[dpIdx + 1] = Hq2x.Mix3To1(w[4], w[1]);
                        dp[dpIdx + dpL] = Hq2x.diff(w[7], w[3], trY, trU, trV, trA) ? w[4] : Hq2x.Mix14To1To1(w[4], w[7], w[3]);
                        if (Hq2x.diff(w[5], w[7], trY, trU, trV, trA)) {
                            dp[dpIdx + dpL + 1] = w[4];
                            break;
                        }
                        dp[dpIdx + dpL + 1] = Hq2x.Mix14To1To1(w[4], w[5], w[7]);
                        break;
                    }
                    case 251: {
                        dp[dpIdx] = Hq2x.diff(w[3], w[1], trY, trU, trV, trA) ? w[4] : Hq2x.Mix2To1To1(w[4], w[3], w[1]);
                        dp[dpIdx + 1] = Hq2x.Mix3To1(w[4], w[2]);
                        dp[dpIdx + dpL] = Hq2x.diff(w[7], w[3], trY, trU, trV, trA) ? w[4] : Hq2x.Mix14To1To1(w[4], w[7], w[3]);
                        if (Hq2x.diff(w[5], w[7], trY, trU, trV, trA)) {
                            dp[dpIdx + dpL + 1] = w[4];
                            break;
                        }
                        dp[dpIdx + dpL + 1] = Hq2x.Mix2To1To1(w[4], w[5], w[7]);
                        break;
                    }
                    case 239: {
                        dp[dpIdx] = Hq2x.diff(w[3], w[1], trY, trU, trV, trA) ? w[4] : Hq2x.Mix14To1To1(w[4], w[3], w[1]);
                        dp[dpIdx + 1] = Hq2x.Mix3To1(w[4], w[5]);
                        dp[dpIdx + dpL] = Hq2x.diff(w[7], w[3], trY, trU, trV, trA) ? w[4] : Hq2x.Mix14To1To1(w[4], w[7], w[3]);
                        dp[dpIdx + dpL + 1] = Hq2x.Mix3To1(w[4], w[5]);
                        break;
                    }
                    case 127: {
                        dp[dpIdx] = Hq2x.diff(w[3], w[1], trY, trU, trV, trA) ? w[4] : Hq2x.Mix14To1To1(w[4], w[3], w[1]);
                        dp[dpIdx + 1] = Hq2x.diff(w[1], w[5], trY, trU, trV, trA) ? w[4] : Hq2x.Mix2To1To1(w[4], w[1], w[5]);
                        dp[dpIdx + dpL] = Hq2x.diff(w[7], w[3], trY, trU, trV, trA) ? w[4] : Hq2x.Mix2To1To1(w[4], w[7], w[3]);
                        dp[dpIdx + dpL + 1] = Hq2x.Mix3To1(w[4], w[8]);
                        break;
                    }
                    case 191: {
                        dp[dpIdx] = Hq2x.diff(w[3], w[1], trY, trU, trV, trA) ? w[4] : Hq2x.Mix14To1To1(w[4], w[3], w[1]);
                        dp[dpIdx + 1] = Hq2x.diff(w[1], w[5], trY, trU, trV, trA) ? w[4] : Hq2x.Mix14To1To1(w[4], w[1], w[5]);
                        dp[dpIdx + dpL] = Hq2x.Mix3To1(w[4], w[7]);
                        dp[dpIdx + dpL + 1] = Hq2x.Mix3To1(w[4], w[7]);
                        break;
                    }
                    case 223: {
                        dp[dpIdx] = Hq2x.diff(w[3], w[1], trY, trU, trV, trA) ? w[4] : Hq2x.Mix2To1To1(w[4], w[3], w[1]);
                        dp[dpIdx + 1] = Hq2x.diff(w[1], w[5], trY, trU, trV, trA) ? w[4] : Hq2x.Mix14To1To1(w[4], w[1], w[5]);
                        dp[dpIdx + dpL] = Hq2x.Mix3To1(w[4], w[6]);
                        if (Hq2x.diff(w[5], w[7], trY, trU, trV, trA)) {
                            dp[dpIdx + dpL + 1] = w[4];
                            break;
                        }
                        dp[dpIdx + dpL + 1] = Hq2x.Mix2To1To1(w[4], w[5], w[7]);
                        break;
                    }
                    case 247: {
                        dp[dpIdx] = Hq2x.Mix3To1(w[4], w[3]);
                        dp[dpIdx + 1] = Hq2x.diff(w[1], w[5], trY, trU, trV, trA) ? w[4] : Hq2x.Mix14To1To1(w[4], w[1], w[5]);
                        dp[dpIdx + dpL] = Hq2x.Mix3To1(w[4], w[3]);
                        if (Hq2x.diff(w[5], w[7], trY, trU, trV, trA)) {
                            dp[dpIdx + dpL + 1] = w[4];
                            break;
                        }
                        dp[dpIdx + dpL + 1] = Hq2x.Mix14To1To1(w[4], w[5], w[7]);
                        break;
                    }
                    case 255: {
                        dp[dpIdx] = Hq2x.diff(w[3], w[1], trY, trU, trV, trA) ? w[4] : Hq2x.Mix14To1To1(w[4], w[3], w[1]);
                        dp[dpIdx + 1] = Hq2x.diff(w[1], w[5], trY, trU, trV, trA) ? w[4] : Hq2x.Mix14To1To1(w[4], w[1], w[5]);
                        dp[dpIdx + dpL] = Hq2x.diff(w[7], w[3], trY, trU, trV, trA) ? w[4] : Hq2x.Mix14To1To1(w[4], w[7], w[3]);
                        dp[dpIdx + dpL + 1] = Hq2x.diff(w[5], w[7], trY, trU, trV, trA) ? w[4] : Hq2x.Mix14To1To1(w[4], w[5], w[7]);
                    }
                }
                ++spIdx;
                dpIdx += 2;
            }
            dpIdx += dpL;
        }
    }

    private static boolean diff(int c1, int c2, int trY, int trU, int trV, int trA) {
        int YUV2;
        int YUV1 = Hq2x.getYuv(c1);
        return Math.abs((YUV1 & 0xFF0000) - ((YUV2 = Hq2x.getYuv(c2)) & 0xFF0000)) > trY || Math.abs((YUV1 & 0xFF00) - (YUV2 & 0xFF00)) > trU || Math.abs((YUV1 & 0xFF) - (YUV2 & 0xFF)) > trV || Math.abs((c1 >> 24) - (c2 >> 24)) > trA;
    }

    private static int getYuv(int c) {
        int r = (c & 0xFF0000) >> 16;
        int g = (c & 0xFF00) >> 8;
        int b = c & 0xFF;
        int y = (int)(0.299 * (double)r + 0.587 * (double)g + 0.114 * (double)b);
        int u = (int)(-0.169 * (double)r - 0.331 * (double)g + 0.5 * (double)b) + 128;
        int v = (int)(0.5 * (double)r - 0.419 * (double)g - 0.081 * (double)b) + 128;
        return y << 16 | u << 8 | v;
    }

    private static int Mix3To1(int c1, int c2) {
        if (c1 == c2) {
            return c1;
        }
        return (c1 & 0xFF00) * 3 + (c2 & 0xFF00) >> 2 & 0xFF00 | (c1 & 0xFF00FF) * 3 + (c2 & 0xFF00FF) >> 2 & 0xFF00FF | ((c1 & 0xFF000000) >> 2) * 3 + ((c2 & 0xFF000000) >> 2) & 0xFF000000;
    }

    private static int Mix2To1To1(int c1, int c2, int c3) {
        return (c1 & 0xFF00) * 2 + (c2 & 0xFF00) + (c3 & 0xFF00) >> 2 & 0xFF00 | (c1 & 0xFF00FF) * 2 + (c2 & 0xFF00FF) + (c3 & 0xFF00FF) >> 2 & 0xFF00FF | ((c1 & 0xFF000000) >> 2) * 2 + ((c2 & 0xFF000000) >> 2) + ((c3 & 0xFF000000) >> 2) & 0xFF000000;
    }

    private static int Mix4To2To1(int c1, int c2, int c3) {
        return (c1 & 0xFF00) * 5 + (c2 & 0xFF00) * 2 + (c3 & 0xFF00) >> 3 & 0xFF00 | (c1 & 0xFF00FF) * 5 + (c2 & 0xFF00FF) * 2 + (c3 & 0xFF00FF) >> 3 & 0xFF00FF | ((c1 & 0xFF000000) >> 3) * 5 + ((c2 & 0xFF000000) >> 3) * 2 + ((c3 & 0xFF000000) >> 3) & 0xFF000000;
    }

    private static int Mix6To1To1(int c1, int c2, int c3) {
        return (c1 & 0xFF00) * 6 + (c2 & 0xFF00) + (c3 & 0xFF00) >> 3 & 0xFF00 | (c1 & 0xFF00FF) * 6 + (c2 & 0xFF00FF) + (c3 & 0xFF00FF) >> 3 & 0xFF00FF | ((c1 & 0xFF000000) >> 3) * 6 + ((c2 & 0xFF000000) >> 3) + ((c3 & 0xFF000000) >> 3) & 0xFF000000;
    }

    private static int Mix2To3To3(int c1, int c2, int c3) {
        return (c1 & 0xFF00) * 2 + (c2 & 0xFF00) * 3 + (c3 & 0xFF00) * 3 >> 3 & 0xFF00 | (c1 & 0xFF00FF) * 2 + (c2 & 0xFF00FF) * 3 + (c3 & 0xFF00FF) * 3 >> 3 & 0xFF00FF | ((c1 & 0xFF000000) >> 3) * 2 + ((c2 & 0xFF000000) >> 3) * 3 + ((c3 & 0xFF000000) >> 3) * 3 & 0xFF000000;
    }

    private static int Mix14To1To1(int c1, int c2, int c3) {
        return (c1 & 0xFF00) * 14 + (c2 & 0xFF00) + (c3 & 0xFF00) >> 4 & 0xFF00 | (c1 & 0xFF00FF) * 14 + (c2 & 0xFF00FF) + (c3 & 0xFF00FF) >> 4 & 0xFF00FF | ((c1 & 0xFF000000) >> 4) * 14 + ((c2 & 0xFF000000) >> 4) + ((c3 & 0xFF000000) >> 4) & 0xFF000000;
    }

    private Hq2x() {
    }
}

