/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.cli2.validation;

import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.commons.cli2.resource.ResourceHelper;
import org.apache.commons.cli2.validation.InvalidArgumentException;
import org.apache.commons.cli2.validation.Validator;

public class EnumValidator
implements Validator {
    private Set validValues;

    public EnumValidator(Set values) {
        this.setValidValues(values);
    }

    @Override
    public void validate(List values) throws InvalidArgumentException {
        for (String value : values) {
            if (this.validValues.contains(value)) continue;
            throw new InvalidArgumentException(ResourceHelper.getResourceHelper().getMessage("Enum.illegal.value", new Object[]{value, this.getValuesAsString()}));
        }
    }

    String getValuesAsString() {
        StringBuffer buff = new StringBuffer();
        buff.append("[");
        Iterator iter = this.validValues.iterator();
        while (iter.hasNext()) {
            buff.append("'").append(iter.next()).append("'");
            if (!iter.hasNext()) continue;
            buff.append(", ");
        }
        buff.append("]");
        return buff.toString();
    }

    public Set getValidValues() {
        return this.validValues;
    }

    protected void setValidValues(Set validValues) {
        this.validValues = validValues;
    }
}

