/*
 * Decompiled with CFR 0.152.
 */
package com.pagosoft.swing;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import javax.swing.ImageIcon;
import javax.swing.border.AbstractBorder;

public class ShadowBorder
extends AbstractBorder {
    private static ShadowBorder instance;
    private Insets borderInsets = new Insets(0, 0, 5, 5);
    private Image shadow = new ImageIcon(ShadowBorder.class.getResource("shadow.png")).getImage();

    public static ShadowBorder getInstance() {
        if (instance == null) {
            instance = new ShadowBorder();
        }
        return instance;
    }

    private ShadowBorder() {
    }

    @Override
    public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
        g.drawImage(this.shadow, x + 5, y + height - 5, x + 10, y + height, 0, 6, 5, 11, null, c);
        g.drawImage(this.shadow, x + 10, y + height - 5, x + width - 5, y + height, 5, 6, 6, 11, null, c);
        g.drawImage(this.shadow, x + width - 5, y + 5, x + width, y + 10, 6, 0, 11, 5, null, c);
        g.drawImage(this.shadow, x + width - 5, y + 10, x + width, y + height - 5, 6, 5, 11, 6, null, c);
        g.drawImage(this.shadow, x + width - 5, y + height - 5, x + width, y + height, 6, 6, 11, 11, null, c);
    }

    @Override
    public Insets getBorderInsets(Component c) {
        return this.borderInsets;
    }

    @Override
    public boolean isBorderOpaque() {
        return false;
    }
}

