/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.application.session;

import java.awt.Rectangle;

public class WindowState {
    private final Rectangle bounds;
    private Rectangle gcBounds = null;
    private int screenCount;
    private int frameState = 0;

    public WindowState() {
        this.bounds = new Rectangle();
    }

    public WindowState(Rectangle bounds, Rectangle gcBounds, int screenCount, int frameState) {
        if (bounds == null) {
            throw new IllegalArgumentException("null bounds");
        }
        if (screenCount < 1) {
            throw new IllegalArgumentException("invalid screenCount");
        }
        this.bounds = bounds;
        this.gcBounds = gcBounds;
        this.screenCount = screenCount;
        this.frameState = frameState;
    }

    public Rectangle getBounds() {
        return new Rectangle(this.bounds);
    }

    public void setBounds(Rectangle bounds) {
        this.bounds.setBounds(bounds);
    }

    public int getScreenCount() {
        return this.screenCount;
    }

    public void setScreenCount(int screenCount) {
        this.screenCount = screenCount;
    }

    public int getFrameState() {
        return this.frameState;
    }

    public void setFrameState(int frameState) {
        this.frameState = frameState;
    }

    public Rectangle getGraphicsConfigurationBounds() {
        return this.gcBounds == null ? null : new Rectangle(this.gcBounds);
    }

    public void setGraphicsConfigurationBounds(Rectangle gcBounds) {
        this.gcBounds = gcBounds == null ? null : new Rectangle(gcBounds);
    }
}

