/*
 * Decompiled with CFR 0.152.
 */
package com.jtattoo.plaf;

import com.jtattoo.plaf.AbstractLookAndFeel;
import com.jtattoo.plaf.ColorHelper;
import com.jtattoo.plaf.JTattooUtilities;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.MouseEvent;
import javax.swing.ButtonModel;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.UIManager;
import javax.swing.event.MouseInputListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicMenuUI;

public class BaseMenuUI
extends BasicMenuUI {
    public static ComponentUI createUI(JComponent jComponent) {
        return new BaseMenuUI();
    }

    public void installUI(JComponent jComponent) {
        super.installUI(jComponent);
        jComponent.setOpaque(false);
    }

    public void uninstallUI(JComponent jComponent) {
        jComponent.setOpaque(true);
        super.uninstallUI(jComponent);
    }

    public void update(Graphics graphics, JComponent jComponent) {
        this.paintBackground(graphics, jComponent, 0, 0, jComponent.getWidth(), jComponent.getHeight());
        this.paint(graphics, jComponent);
    }

    protected void installDefaults() {
        super.installDefaults();
        Boolean bl = (Boolean)UIManager.get("MenuBar.rolloverEnabled");
        if (bl.booleanValue()) {
            this.menuItem.setRolloverEnabled(true);
        }
    }

    protected void paintBackground(Graphics graphics, JMenuItem jMenuItem, Color color) {
        if (jMenuItem.isOpaque()) {
            int n = jMenuItem.getWidth();
            int n2 = jMenuItem.getHeight();
            this.paintBackground(graphics, jMenuItem, 0, 0, n, n2);
        }
    }

    protected void paintBackground(Graphics graphics, JComponent jComponent, int n, int n2, int n3, int n4) {
        JMenuItem jMenuItem = (JMenuItem)jComponent;
        ButtonModel buttonModel = jMenuItem.getModel();
        if (jComponent.getParent() instanceof JMenuBar) {
            if (buttonModel.isRollover() || buttonModel.isArmed() || jComponent instanceof JMenu && buttonModel.isSelected()) {
                Color color = AbstractLookAndFeel.getMenuSelectionBackgroundColor();
                if (buttonModel.isRollover()) {
                    color = ColorHelper.brighter(color, 10.0);
                }
                graphics.setColor(color);
                graphics.fillRect(n, n2, n3, n4);
                if (buttonModel.isRollover()) {
                    color = ColorHelper.darker(color, 20.0);
                    graphics.setColor(color);
                    graphics.drawRect(n, n2, n3 - 1, n4 - 1);
                }
            }
        } else if (buttonModel.isArmed() || jComponent instanceof JMenu && buttonModel.isSelected()) {
            graphics.setColor(AbstractLookAndFeel.getMenuSelectionBackgroundColor());
            graphics.fillRect(n, n2, n3, n4);
        } else if (!AbstractLookAndFeel.getTheme().isMenuOpaque()) {
            Graphics2D graphics2D = (Graphics2D)graphics;
            Composite composite = graphics2D.getComposite();
            AlphaComposite alphaComposite = AlphaComposite.getInstance(3, AbstractLookAndFeel.getTheme().getMenuAlpha());
            graphics2D.setComposite(alphaComposite);
            graphics.setColor(AbstractLookAndFeel.getMenuBackgroundColor());
            graphics.fillRect(n, n2, n3, n4);
            graphics2D.setComposite(composite);
        } else {
            graphics.setColor(AbstractLookAndFeel.getMenuBackgroundColor());
            graphics.fillRect(n, n2, n3, n4);
        }
        if (this.menuItem.isSelected() && this.menuItem.isArmed()) {
            graphics.setColor(AbstractLookAndFeel.getMenuSelectionForegroundColor());
        } else {
            graphics.setColor(AbstractLookAndFeel.getMenuForegroundColor());
        }
    }

    protected void paintText(Graphics graphics, JMenuItem jMenuItem, Rectangle rectangle, String string) {
        ButtonModel buttonModel = jMenuItem.getModel();
        Graphics2D graphics2D = (Graphics2D)graphics;
        Object object = null;
        if (AbstractLookAndFeel.getTheme().isTextAntiAliasingOn()) {
            object = graphics2D.getRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING);
            graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, AbstractLookAndFeel.getTheme().getTextAntiAliasingHint());
        }
        graphics.setColor(AbstractLookAndFeel.getMenuForegroundColor());
        if (jMenuItem.getParent() instanceof JMenuBar) {
            if (buttonModel.isRollover() || buttonModel.isArmed() || jMenuItem instanceof JMenu && buttonModel.isSelected()) {
                graphics.setColor(AbstractLookAndFeel.getMenuSelectionForegroundColor());
            }
        } else if (jMenuItem.isSelected() && jMenuItem.isArmed()) {
            graphics.setColor(AbstractLookAndFeel.getMenuSelectionForegroundColor());
        }
        super.paintText(graphics, jMenuItem, rectangle, string);
        if (AbstractLookAndFeel.getTheme().isTextAntiAliasingOn()) {
            graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, object);
        }
    }

    protected MouseInputListener createMouseInputListener(JComponent jComponent) {
        if (JTattooUtilities.getJavaVersion() >= 1.5) {
            return new MyMouseInputHandler();
        }
        return super.createMouseInputListener(jComponent);
    }

    protected class MyMouseInputHandler
    extends BasicMenuUI.MouseInputHandler {
        protected MyMouseInputHandler() {
            super(BaseMenuUI.this);
        }

        public void mouseEntered(MouseEvent mouseEvent) {
            super.mouseEntered(mouseEvent);
            JMenu jMenu = (JMenu)mouseEvent.getSource();
            if (jMenu.isTopLevelMenu() && jMenu.isRolloverEnabled()) {
                jMenu.getModel().setRollover(true);
                BaseMenuUI.this.menuItem.repaint();
            }
        }

        public void mouseExited(MouseEvent mouseEvent) {
            super.mouseExited(mouseEvent);
            JMenu jMenu = (JMenu)mouseEvent.getSource();
            ButtonModel buttonModel = jMenu.getModel();
            if (jMenu.isRolloverEnabled()) {
                buttonModel.setRollover(false);
                BaseMenuUI.this.menuItem.repaint();
            }
        }
    }
}

