/*
 * Decompiled with CFR 0.152.
 */
package chrriis.dj.sweet.components.win32;

import chrriis.common.WebServer;
import chrriis.dj.sweet.NSOption;
import chrriis.dj.sweet.components.OleAccess;
import chrriis.dj.sweet.components.win32.WMPControls;
import chrriis.dj.sweet.components.win32.WMPMedia;
import chrriis.dj.sweet.components.win32.WMPSettings;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.ole.win32.OleClientSite;
import org.eclipse.swt.ole.win32.OleFrame;
import org.eclipse.swt.widgets.Composite;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JWMediaPlayer
extends Composite {
    private OleAccess oleAccess;
    private WMPSettings wmpSettings;
    private WMPControls wmpControls;
    private WMPMedia wmpMedia;
    private List<ClassLoader> referenceClassLoaderList = new ArrayList<ClassLoader>(1);

    public JWMediaPlayer(Composite parent, NSOption ... options) {
        super(parent, 0);
        this.setLayout(new FillLayout());
        this.oleAccess = new OleAccess(this){

            protected OleClientSite createControl(Composite parent) {
                OleClientSite site;
                OleFrame frame = new OleFrame(parent, 0);
                try {
                    site = new OleClientSite((Composite)frame, 0, "WMPlayer.OCX");
                }
                catch (SWTException e) {
                    e.printStackTrace();
                    frame.dispose();
                    return null;
                }
                site.doVerb(-5);
                return site;
            }
        };
        this.wmpSettings = new WMPSettings(this);
        this.wmpControls = new WMPControls(this);
        this.wmpMedia = new WMPMedia(this);
        this.wmpSettings.setAutoStart(true);
        this.wmpSettings.setErrorDialogsEnabled(false);
        this.setControlBarVisible(true);
    }

    public WMPSettings getWMPSettings() {
        return this.wmpSettings;
    }

    public WMPControls getWMPControls() {
        return this.wmpControls;
    }

    public WMPMedia getWMPMedia() {
        return this.wmpMedia;
    }

    public void load(String resourcePath) {
        this.oleAccess.setOleProperty("url", resourcePath == null ? "" : resourcePath);
    }

    public void load(Class<?> clazz, String resourcePath) {
        this.addReferenceClassLoader(clazz.getClassLoader());
        this.load(WebServer.getDefaultWebServer().getClassPathResourceURL(clazz.getName(), resourcePath));
    }

    public void setControlBarVisible(boolean isControlBarVisible) {
        this.oleAccess.setOleProperty("uiMode", isControlBarVisible ? "full" : "none");
    }

    public boolean isControlBarVisible() {
        return Boolean.TRUE.equals("full".equals(this.oleAccess.getOleProperty("uiMode", new Object[0])));
    }

    public void setFullScreen(boolean isFullScreen) {
        this.oleAccess.setOleProperty("fullScreen", isFullScreen);
    }

    public boolean isFullScreen() {
        return Boolean.TRUE.equals(this.oleAccess.getOleProperty("fullScreen", new Object[0]));
    }

    public void setStretchToFit(boolean isStretchToFit) {
        this.oleAccess.setOleProperty("stretchToFit", isStretchToFit);
    }

    public boolean isStretchToFit() {
        return Boolean.TRUE.equals(this.oleAccess.getOleProperty("stretchToFit", new Object[0]));
    }

    public WMPMediaState getMediaState() {
        try {
            switch ((Integer)this.oleAccess.getOleProperty("playState", new Object[0])) {
                case 1: {
                    return WMPMediaState.STOPPED;
                }
                case 2: {
                    return WMPMediaState.PAUSED;
                }
                case 3: {
                    return WMPMediaState.PLAYING;
                }
                case 4: {
                    return WMPMediaState.SCAN_FORWARD;
                }
                case 5: {
                    return WMPMediaState.SCAN_REVERSE;
                }
                case 6: {
                    return WMPMediaState.BUFFERING;
                }
                case 7: {
                    return WMPMediaState.WAITING;
                }
                case 8: {
                    return WMPMediaState.MEDIA_ENDED;
                }
                case 9: {
                    return WMPMediaState.TRANSITIONING;
                }
                case 10: {
                    return WMPMediaState.READY;
                }
                case 11: {
                    return WMPMediaState.RECONNECTING;
                }
            }
        }
        catch (IllegalStateException e) {
            throw e;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return WMPMediaState.UNDEFINED;
    }

    private void addReferenceClassLoader(ClassLoader referenceClassLoader) {
        if (referenceClassLoader == null || referenceClassLoader == this.getClass().getClassLoader() || this.referenceClassLoaderList.contains(referenceClassLoader)) {
            return;
        }
        this.referenceClassLoaderList.add(referenceClassLoader);
        WebServer.getDefaultWebServer().addReferenceClassLoader(referenceClassLoader);
    }

    protected void finalize() throws Throwable {
        for (ClassLoader referenceClassLoader : this.referenceClassLoaderList) {
            WebServer.getDefaultWebServer().removeReferenceClassLoader(referenceClassLoader);
        }
        this.referenceClassLoaderList.clear();
        super.finalize();
    }

    OleAccess getOleAccess() {
        return this.oleAccess;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum WMPMediaState {
        UNDEFINED,
        STOPPED,
        PAUSED,
        PLAYING,
        SCAN_FORWARD,
        SCAN_REVERSE,
        BUFFERING,
        WAITING,
        MEDIA_ENDED,
        TRANSITIONING,
        READY,
        RECONNECTING;

    }
}

