/*
 * Decompiled with CFR 0.152.
 */
package com.sun.nfs;

import java.util.MissingResourceException;
import java.util.NoSuchElementException;
import java.util.ResourceBundle;
import java.util.StringTokenizer;

public final class NfsSecurity {
    static ResourceBundle props;
    static String secName;
    static String secMode;
    static String mech;
    static int service;
    static int qop;

    static {
        NfsSecurity.initialize();
    }

    public static String getDefault() {
        if (props == null) {
            return "1";
        }
        try {
            return props.getString("default");
        }
        catch (MissingResourceException missingResourceException) {
            return "1";
        }
    }

    public static String getMech(String string) {
        if (string.equals(secMode)) {
            return mech;
        }
        NfsSecurity.parseValue(props.getString(string));
        secMode = string;
        return mech;
    }

    public static String getName(String string) {
        if (string.equals(secMode)) {
            return secName;
        }
        NfsSecurity.parseValue(props.getString(string));
        secMode = string;
        return secName;
    }

    public static String getPrefer() {
        if (props == null) {
            return null;
        }
        try {
            return props.getString("prefer");
        }
        catch (MissingResourceException missingResourceException) {
            return null;
        }
    }

    public static int getQop(String string) {
        if (string.equals(secMode)) {
            return qop;
        }
        NfsSecurity.parseValue(props.getString(string));
        secMode = string;
        return qop;
    }

    public static int getService(String string) {
        if (string.equals(secMode)) {
            return service;
        }
        NfsSecurity.parseValue(props.getString(string));
        secMode = string;
        return service;
    }

    public static boolean hasValue(String string) {
        if (props == null) {
            return false;
        }
        try {
            props.getString(string);
            return true;
        }
        catch (MissingResourceException missingResourceException) {
            return false;
        }
    }

    private static void initialize() {
        try {
            props = ResourceBundle.getBundle("com.sun.nfs.nfssec");
        }
        catch (MissingResourceException missingResourceException) {
            props = null;
        }
    }

    private static void parseValue(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ":\n\r");
        secName = stringTokenizer.nextToken();
        try {
            mech = stringTokenizer.nextToken();
        }
        catch (NoSuchElementException noSuchElementException) {
            mech = null;
            service = 0;
            qop = 0;
            return;
        }
        String string2 = stringTokenizer.nextToken();
        service = string2.equals("none") ? 1 : (string2.equals("integrity") ? 2 : (string2.equals("privacy") ? 3 : 3));
        qop = Integer.parseInt(stringTokenizer.nextToken());
    }
}

