/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jftp.gui.base;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.PrintStream;
import java.lang.reflect.Array;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Date;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionListener;
import net.sf.jftp.JFtp;
import net.sf.jftp.config.SaveSet;
import net.sf.jftp.config.Settings;
import net.sf.jftp.gui.base.ResumeDialog;
import net.sf.jftp.gui.base.StatusPanel;
import net.sf.jftp.gui.base.UITool;
import net.sf.jftp.gui.base.dir.DirCanvas;
import net.sf.jftp.gui.base.dir.DirCellRenderer;
import net.sf.jftp.gui.base.dir.DirComponent;
import net.sf.jftp.gui.base.dir.DirEntry;
import net.sf.jftp.gui.base.dir.DirLister;
import net.sf.jftp.gui.base.dir.DirPanel;
import net.sf.jftp.gui.base.dir.TableUtils;
import net.sf.jftp.gui.framework.HFrame;
import net.sf.jftp.gui.framework.HImage;
import net.sf.jftp.gui.framework.HImageButton;
import net.sf.jftp.gui.tasks.Creator;
import net.sf.jftp.gui.tasks.Displayer;
import net.sf.jftp.gui.tasks.PathChanger;
import net.sf.jftp.gui.tasks.RemoteCommand;
import net.sf.jftp.net.BasicConnection;
import net.sf.jftp.net.ConnectionListener;
import net.sf.jftp.net.FilesystemConnection;
import net.sf.jftp.net.FtpConnection;
import net.sf.jftp.net.wrappers.Sftp2Connection;
import net.sf.jftp.net.wrappers.SmbConnection;
import net.sf.jftp.system.LocalIO;
import net.sf.jftp.system.StringUtils;
import net.sf.jftp.system.UpdateDaemon;
import net.sf.jftp.system.logging.Log;
import net.sf.jftp.tools.Shell;

public class RemoteDir
extends DirComponent
implements ListSelectionListener,
ActionListener,
ConnectionListener,
KeyListener {
    static final String deleteString = "rm";
    static final String mkdirString = "mkdir";
    static final String refreshString = "fresh";
    static final String cdString = "cd";
    static final String cmdString = "cmd";
    static final String downloadString = "<-";
    static final String uploadString = "->";
    static final String queueString = "que";
    static final String cdUpString = "cdUp";
    static final String rnString = "rn";
    HImageButton deleteButton;
    HImageButton mkdirButton;
    HImageButton cmdButton;
    HImageButton refreshButton;
    HImageButton cdButton;
    HImageButton uploadButton;
    HImageButton downloadButton;
    HImageButton queueButton;
    HImageButton cdUpButton;
    HImageButton rnButton;
    private DirCanvas label = new DirCanvas(this);
    private boolean pathChanged = true;
    private boolean firstGui = true;
    private int pos = 0;
    private JPanel p = new JPanel();
    private JToolBar buttonPanel = new JToolBar(){

        @Override
        public Insets getInsets() {
            return new Insets(0, 0, 0, 0);
        }
    };
    private JToolBar currDirPanel = new JToolBar(){

        @Override
        public Insets getInsets() {
            return new Insets(0, 0, 0, 0);
        }
    };
    private DefaultListModel jlm;
    private JScrollPane jsp = new JScrollPane(this.jl);
    private int tmpindex = -1;
    private HImageButton list = new HImageButton(Settings.listImage, "list", "Show remote listing...", this);
    private HImageButton transferType = new HImageButton(Settings.typeImage, "type", "Toggle transfer type...", this);
    private JPopupMenu popupMenu = new JPopupMenu();
    private JMenuItem props = new JMenuItem("Properties");
    private DirEntry currentPopup = null;
    private String sortMode = null;
    String[] sortTypes = new String[]{"Normal", "Reverse", "Size", "Size/Re"};
    private JComboBox sorter = new JComboBox<String>(this.sortTypes);
    private boolean dateEnabled = false;

    public RemoteDir() {
        this.type = "remote";
        this.con = new FilesystemConnection();
        this.con.addConnectionListener(this);
        if (!this.con.chdir("/")) {
            this.con.chdir("C:\\");
        }
        this.setDate();
    }

    public RemoteDir(String path) {
        this.type = "remote";
        this.path = path;
        this.con = new FilesystemConnection();
        this.con.addConnectionListener(this);
        this.con.chdir(path);
        this.setDate();
    }

    public void gui_init() {
        this.setLayout(new BorderLayout());
        this.currDirPanel.setFloatable(false);
        this.buttonPanel.setFloatable(false);
        FlowLayout f = new FlowLayout(0);
        f.setHgap(1);
        f.setVgap(2);
        this.buttonPanel.setLayout(f);
        this.buttonPanel.setMargin(new Insets(0, 0, 0, 0));
        this.props.addActionListener(this);
        this.popupMenu.add(this.props);
        this.rnButton = new HImageButton(Settings.textFileImage, rnString, "Rename selected file or directory", this);
        this.rnButton.setToolTipText("Rename selected");
        this.list.setToolTipText("Show remote listing...");
        this.transferType.setToolTipText("Toggle transfer type...");
        this.deleteButton = new HImageButton(Settings.deleteImage, deleteString, "Delete  selected", this);
        this.deleteButton.setToolTipText("Delete selected");
        this.mkdirButton = new HImageButton(Settings.mkdirImage, mkdirString, "Create a new directory", this);
        this.mkdirButton.setToolTipText("Create directory");
        this.refreshButton = new HImageButton(Settings.refreshImage, refreshString, "Refresh current directory", this);
        this.refreshButton.setToolTipText("Refresh directory");
        this.refreshButton.setRolloverIcon(new ImageIcon(HImage.getImage(this, Settings.refreshImage2)));
        this.refreshButton.setRolloverEnabled(true);
        this.cdButton = new HImageButton(Settings.cdImage, cdString, "Change directory", this);
        this.cdButton.setToolTipText("Change directory");
        this.cmdButton = new HImageButton(Settings.cmdImage, cmdString, "Execute remote command", this);
        this.cmdButton.setToolTipText("Execute remote command");
        this.downloadButton = new HImageButton(Settings.downloadImage, downloadString, "Download selected", this);
        this.downloadButton.setToolTipText("Download selected");
        this.queueButton = new HImageButton(Settings.queueImage, queueString, "Queue selected", this);
        this.queueButton.setToolTipText("Queue selected");
        this.cdUpButton = new HImageButton(Settings.cdUpImage, cdUpString, "Go to Parent Directory", this);
        this.cdUpButton.setToolTipText("Go to Parent Directory");
        this.setLabel();
        this.label.setSize(this.getSize().width - 10, 24);
        this.currDirPanel.add(this.label);
        this.currDirPanel.setSize(this.getSize().width - 10, 32);
        this.label.setSize(this.getSize().width - 20, 24);
        this.p.setLayout(new BorderLayout());
        this.p.add("North", this.currDirPanel);
        this.buttonPanel.add(new JLabel("           "));
        this.buttonPanel.add(this.queueButton);
        this.buttonPanel.add(new JLabel("    "));
        this.buttonPanel.add(this.refreshButton);
        this.buttonPanel.add(new JLabel("  "));
        this.buttonPanel.add(this.rnButton);
        this.buttonPanel.add(this.mkdirButton);
        this.buttonPanel.add(this.cdButton);
        this.buttonPanel.add(this.deleteButton);
        this.buttonPanel.add(this.cdUpButton);
        this.buttonPanel.add(new JLabel("  "));
        this.buttonPanel.add(this.cmdButton);
        this.buttonPanel.add(this.list);
        this.buttonPanel.add(this.transferType);
        this.buttonPanel.add(this.sorter);
        this.buttonPanel.setVisible(true);
        this.buttonPanel.setSize(this.getSize().width - 10, 32);
        this.p.add("South", this.buttonPanel);
        JPanel second = new JPanel();
        second.setLayout(new BorderLayout());
        second.add("Center", this.p);
        this.downloadButton.setMinimumSize(new Dimension(50, 50));
        this.downloadButton.setPreferredSize(new Dimension(50, 50));
        this.downloadButton.setMaximumSize(new Dimension(50, 50));
        second.add("West", this.downloadButton);
        this.add("North", second);
        this.sorter.addActionListener(this);
        this.jlm = new DefaultListModel();
        this.jl = new JList(this.jlm);
        this.jl.setCellRenderer(new DirCellRenderer());
        this.jl.setVisibleRowCount(15);
        this.jl.setDragEnabled(true);
        JFtp cfr_ignored_0 = JFtp.statusP.jftp;
        this.jl.setDropTarget(JFtp.dropTarget);
        MouseAdapter mouseListener = new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (JFtp.uiBlocked) {
                    return;
                }
                if (e.isPopupTrigger() || SwingUtilities.isRightMouseButton(e)) {
                    int index = RemoteDir.this.jl.getSelectedIndex() - 1;
                    if (index < -1) {
                        return;
                    }
                    String tgt = RemoteDir.this.jl.getSelectedValue().toString();
                    if (index >= 0) {
                        if (RemoteDir.this.dirEntry == null || RemoteDir.this.dirEntry.length < index || RemoteDir.this.dirEntry[index] == null) {
                            return;
                        }
                        RemoteDir.this.currentPopup = RemoteDir.this.dirEntry[index];
                        RemoteDir.this.popupMenu.show(e.getComponent(), e.getX(), e.getY());
                    }
                }
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                if (JFtp.uiBlocked) {
                    return;
                }
                TableUtils.copyTableSelectionsToJList(RemoteDir.this.jl, RemoteDir.this.table);
                if (e.getClickCount() == 2) {
                    int index = RemoteDir.this.jl.getSelectedIndex() - 1;
                    if (index < -1) {
                        return;
                    }
                    String tgt = RemoteDir.this.jl.getSelectedValue().toString();
                    if (index < 0) {
                        RemoteDir.this.doChdir(RemoteDir.this.path + tgt);
                    } else {
                        if (RemoteDir.this.dirEntry == null || RemoteDir.this.dirEntry.length < index || RemoteDir.this.dirEntry[index] == null) {
                            return;
                        }
                        if (RemoteDir.this.dirEntry[index].isDirectory()) {
                            RemoteDir.this.doChdir(RemoteDir.this.path + tgt);
                        } else if (RemoteDir.this.dirEntry[index].isLink()) {
                            if (!RemoteDir.this.con.chdir(RemoteDir.this.path + tgt)) {
                                RemoteDir.this.showContentWindow(RemoteDir.this.path + RemoteDir.this.dirEntry[index].toString(), RemoteDir.this.dirEntry[index]);
                            }
                        } else {
                            RemoteDir.this.showContentWindow(RemoteDir.this.path + RemoteDir.this.dirEntry[index].toString(), RemoteDir.this.dirEntry[index]);
                        }
                    }
                }
            }
        };
        this.jsp = new JScrollPane(this.table);
        this.table.getSelectionModel().addListSelectionListener(this);
        this.table.addMouseListener(mouseListener);
        AdjustmentListener adjustmentListener = new AdjustmentListener(){

            @Override
            public void adjustmentValueChanged(AdjustmentEvent e) {
                RemoteDir.this.jsp.repaint();
                RemoteDir.this.jsp.revalidate();
            }
        };
        this.jsp.getHorizontalScrollBar().addAdjustmentListener(adjustmentListener);
        this.jsp.getVerticalScrollBar().addAdjustmentListener(adjustmentListener);
        this.jsp.setSize(this.getSize().width - 20, this.getSize().height - 72);
        this.add("Center", this.jsp);
        this.jsp.setVisible(true);
        TableUtils.tryToEnableRowSorting(this.table);
        if (Settings.IS_JAVA_1_6) {
            this.buttonPanel.remove(this.sorter);
        }
        this.setVisible(true);
    }

    public void doChdir(String path) {
        JFtp.setAppCursor(Cursor.getPredefinedCursor(3));
        this.con.chdir(path);
        JFtp.setAppCursor(Cursor.getPredefinedCursor(0));
    }

    public void setViewPort() {
    }

    private void setLabel() {
        if (this.con instanceof FilesystemConnection) {
            this.label.setText("Filesystem: " + StringUtils.cutPath(this.path));
        } else if (this.con instanceof FtpConnection) {
            this.label.setText("Ftp: " + StringUtils.cutPath(this.path));
        } else if (this.con instanceof Sftp2Connection) {
            this.label.setText("Sftp: " + StringUtils.cutPath(this.path));
        } else {
            this.label.setText(StringUtils.cutPath(this.path));
        }
    }

    public void gui(boolean fakeInit) {
        if (this.firstGui) {
            this.gui_init();
            this.firstGui = false;
        }
        this.setLabel();
        if (this.con instanceof FtpConnection) {
            this.list.show();
            this.cmdButton.show();
            this.transferType.show();
        } else {
            this.list.hide();
            this.cmdButton.hide();
            this.transferType.hide();
        }
        if (!fakeInit) {
            this.setDirList(false);
        }
        this.invalidate();
        this.validate();
    }

    public void setDirList(boolean fakeInit) {
        this.jlm = new DefaultListModel();
        DirEntry dwn = new DirEntry("..", this);
        dwn.setDirectory();
        this.jlm.addElement(dwn);
        if (!fakeInit && this.pathChanged) {
            this.pathChanged = false;
            DirLister dir = new DirLister(this.con, this.sortMode);
            while (!dir.finished) {
                LocalIO.pause(10);
            }
            if (dir.isOk()) {
                this.length = dir.getLength();
                this.dirEntry = new DirEntry[this.length];
                this.files = dir.list();
                String[] fSize = dir.sList();
                int[] perms = dir.getPermissions();
                for (int i = 0; i < this.length; ++i) {
                    Date[] d;
                    if (this.files == null || this.files[i] == null) {
                        System.out.println("skipping setDirList, files or files[i] is null!");
                        return;
                    }
                    this.dirEntry[i] = new DirEntry(this.files[i], this);
                    if (this.dirEntry[i] == null) {
                        System.out.println("\nskipping setDirList, dirEntry[i] is null!");
                        return;
                    }
                    if (this.dirEntry[i].file == null) {
                        System.out.println("\nskipping setDirList, dirEntry[i].file is null!");
                        return;
                    }
                    if (perms != null) {
                        this.dirEntry[i].setPermission(perms[i]);
                    }
                    if (fSize[i].startsWith("@")) {
                        fSize[i] = fSize[i].substring(1);
                    }
                    this.dirEntry[i].setFileSize(Long.parseLong(fSize[i]));
                    if (this.dirEntry[i].file.endsWith("/")) {
                        this.dirEntry[i].setDirectory();
                    } else {
                        this.dirEntry[i].setFile();
                    }
                    if (this.dirEntry[i].file.endsWith("###")) {
                        this.dirEntry[i].setLink();
                    }
                    if ((d = dir.getDates()) != null) {
                        this.dirEntry[i].setDate(d[i]);
                    }
                    this.jlm.addElement(this.dirEntry[i]);
                }
            } else {
                Log.debug("Not a directory: " + this.path);
            }
        }
        this.jl.setModel(this.jlm);
        this.jl.grabFocus();
        this.jl.setSelectedIndex(0);
        this.update();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (JFtp.uiBlocked) {
            return;
        }
        if (e.getActionCommand().equals(deleteString)) {
            this.lock(false);
            if (Settings.getAskToDelete() && !UITool.askToDelete(this)) {
                this.unlock(false);
                return;
            }
            for (int i = 0; i < this.length; ++i) {
                if (!this.dirEntry[i].selected) continue;
                this.con.removeFileOrDir(this.dirEntry[i].file);
            }
            this.unlock(false);
            this.fresh();
        } else if (e.getActionCommand().equals(mkdirString)) {
            Creator c = new Creator("Create:", this.con);
        } else if (e.getActionCommand().equals(cmdString)) {
            if (!(this.con instanceof FtpConnection)) {
                Log.debug("This feature is for ftp only.");
                return;
            }
            int opt = JOptionPane.showOptionDialog(this, "Would you like to type one command or to open a shell?", "Question", -1, 3, new ImageIcon(HImage.getImage(this, Settings.helpImage)), new String[]{"Shell", "Command", "Cancel"}, "Command");
            if (opt == 1) {
                RemoteCommand rc = new RemoteCommand();
            } else if (opt == 0) {
                FtpConnection conn = (FtpConnection)this.con;
                Shell s = new Shell(conn.getCommandInputReader(), conn.getCommandOutputStream());
            }
        } else if (e.getActionCommand().equals(cdString)) {
            PathChanger pthc = new PathChanger("remote", this.path);
        } else if (e.getActionCommand().equals(refreshString)) {
            this.fresh();
        } else if (e.getActionCommand().equals(uploadString)) {
            this.blockedTransfer(-2);
        } else if (e.getActionCommand().equals(downloadString)) {
            this.blockedTransfer(-2);
        } else if (e.getActionCommand().equals("list")) {
            try {
                if (!(this.con instanceof FtpConnection)) {
                    Log.debug("Can only list FtpConnection output!");
                }
                PrintStream out = new PrintStream(Settings.ls_out);
                for (int i = 0; i < ((FtpConnection)this.con).currentListing.size(); ++i) {
                    out.println(((FtpConnection)this.con).currentListing.get(i));
                }
                out.flush();
                out.close();
                URL url = new File(Settings.ls_out).toURL();
                Displayer d = new Displayer(url, new Font("monospaced", 0, 11));
                JFtp.desktop.add((Component)d, new Integer(0x7FFFFFF2));
            }
            catch (MalformedURLException ex) {
                ex.printStackTrace();
                Log.debug("ERROR: Malformed URL!");
            }
            catch (FileNotFoundException ex2) {
                ex2.printStackTrace();
                Log.debug("ERROR: File not found!");
            }
        } else if (e.getActionCommand().equals("type") && !JFtp.uiBlocked) {
            if (!(this.con instanceof FtpConnection)) {
                Log.debug("You can only set the transfer type for ftp connections.");
                return;
            }
            FtpConnection c = (FtpConnection)this.con;
            String t = c.getTypeNow();
            boolean ret = false;
            if (t.equals("A")) {
                ret = c.type("I");
            } else if (t.equals("I")) {
                ret = c.type("E");
            }
            if (t.equals("E") || !ret && !t.equals("L 8")) {
                ret = c.type("L 8");
            }
            if (!ret) {
                c.type("A");
                Log.debug("Warning: type should be \"I\" if you want to transfer binary files!");
            }
            Log.debug("Type is now " + c.getTypeNow());
        } else if (e.getActionCommand().equals(queueString)) {
            if (!(this.con instanceof FtpConnection)) {
                Log.debug("Queue supported only for FTP");
                return;
            }
            Object[] o = this.jl.getSelectedValues();
            DirEntry[] tmp = new DirEntry[Array.getLength(o)];
            for (int i = 0; i < Array.getLength(o); ++i) {
                tmp[i] = (DirEntry)o[i];
                JFtp.dQueue.addFtp(tmp[i].toString());
            }
        } else if (e.getSource() == this.props) {
            StatusPanel statusPanel = JFtp.statusP;
            statusPanel.jftp.clearLog();
            int x = this.currentPopup.getPermission();
            String tmp = x == 23 ? "read only" : (x == 42 ? "read/write" : (x == -666 ? "denied" : "undefined"));
            String msg = "File: " + this.currentPopup.toString() + "\n" + " Size: " + this.currentPopup.getFileSize() + " raw size: " + this.currentPopup.getRawSize() + "\n" + " Symlink: " + this.currentPopup.isLink() + "\n" + " Directory: " + this.currentPopup.isDirectory() + "\n" + " Permission: " + tmp + "\n";
            Log.debug(msg);
        } else if (e.getSource() == this.sorter) {
            this.sortMode = (String)this.sorter.getSelectedItem();
            Settings.showDateNoSize = this.sortMode.equals("Date");
            this.fresh();
        } else if (e.getActionCommand().equals(cdUpString)) {
            JFtp.remoteDir.getCon().chdir("..");
        } else if (e.getActionCommand().equals(rnString)) {
            Object[] target = this.jl.getSelectedValues();
            if (target == null || target.length == 0) {
                Log.debug("No file selected");
                return;
            }
            if (target.length > 1) {
                Log.debug("Too many files selected");
                return;
            }
            String val = JOptionPane.showInternalInputDialog(this, "Choose a name...");
            if (val != null) {
                if (!this.con.rename(target[0].toString(), val)) {
                    Log.debug("Rename failed.");
                } else {
                    Log.debug("Successfully renamed.");
                    this.fresh();
                }
            }
        }
    }

    public synchronized void blockedTransfer(int index) {
        this.tmpindex = index;
        Runnable r = new Runnable(){

            @Override
            public void run() {
                boolean block;
                boolean bl = block = !Settings.getEnableMultiThreading();
                if (!(RemoteDir.this.con instanceof FtpConnection)) {
                    block = true;
                }
                if (block) {
                    RemoteDir.this.lock(false);
                }
                RemoteDir.this.transfer(RemoteDir.this.tmpindex);
                if (block) {
                    JFtp.localDir.fresh();
                    RemoteDir.this.unlock(false);
                }
            }
        };
        Thread t = new Thread(r);
        t.start();
    }

    @Override
    public void lock(boolean first) {
        JFtp.uiBlocked = true;
        this.jl.setEnabled(false);
        if (!first) {
            JFtp.localDir.lock(true);
        }
        Log.out("ui locked.");
    }

    @Override
    public void unlock(boolean first) {
        JFtp.uiBlocked = false;
        this.jl.setEnabled(true);
        if (!first) {
            JFtp.localDir.unlock(true);
        }
        Log.out("ui unlocked.");
    }

    @Override
    public void fresh() {
        Object o;
        Log.out("fresh() called.");
        Cursor x = null;
        if (JFtp.mainFrame != null) {
            x = JFtp.mainFrame.getCursor();
            JFtp.setAppCursor(Cursor.getPredefinedCursor(3));
        }
        String i = "";
        int idx = this.jl.getSelectedIndex();
        if (idx >= 0 && (o = this.jl.getSelectedValue()) != null) {
            i = o.toString();
        }
        this.con.chdir(this.path);
        if (idx >= 0 && idx < this.jl.getModel().getSize()) {
            if (this.jl.getModel().getElementAt(idx).toString().equals(i)) {
                this.jl.setSelectedIndex(idx);
            } else {
                this.jl.setSelectedIndex(0);
            }
        }
        this.update();
        if (JFtp.mainFrame != null && x.getType() != 3) {
            JFtp.setAppCursor(Cursor.getPredefinedCursor(0));
        }
    }

    @Override
    public void updateProgress(String file, String type, long bytes) {
        if (this.dList == null || this.dirEntry == null || file == null) {
            return;
        }
        boolean flag = false;
        if (file.endsWith("/") && file.length() > 1) {
            flag = true;
            file = file.substring(0, file.lastIndexOf("/"));
        }
        file = file.substring(file.lastIndexOf("/") + 1);
        if (flag) {
            file = file + "/";
        }
        long s = 0L;
        if (JFtp.dList.sizeCache.containsKey(file)) {
            s = (Long)JFtp.dList.sizeCache.get(file);
        } else {
            File f;
            for (int i = 0; i < this.dirEntry.length; ++i) {
                if (this.dirEntry[i] == null || !this.dirEntry[i].toString().equals(file)) continue;
                s = this.dirEntry[i].getRawSize();
                JFtp.dList.sizeCache.put(file, new Long(s));
                break;
            }
            if (s <= 0L && (f = new File(JFtp.localDir.getPath() + file)).exists()) {
                s = f.length();
            }
        }
        this.dList.updateList(file, type, bytes, s);
    }

    @Override
    public void connectionInitialized(BasicConnection con) {
        if (con == null) {
            return;
        }
        this.setDate();
        Log.out("remote connection initialized");
    }

    @Override
    public void connectionFailed(BasicConnection con, String reason) {
        Log.out("remote connection failed");
        if (Integer.parseInt(reason) == -7 && Settings.reconnect) {
            return;
        }
        HFrame h = new HFrame();
        h.getContentPane().setLayout(new BorderLayout(10, 10));
        h.setTitle("Connection failed!");
        h.setMinimumSize(new Dimension(400, 250));
        h.setLocation((int)JFtp.mainFrame.getLocation().getX() + 300, (int)JFtp.mainFrame.getLocation().getY() + 300);
        JTextArea text = new JTextArea();
        h.getContentPane().add("Center", text);
        text.setText(" ---------------- Output -----------------\n" + JFtp.log.getText());
        JFtp.log.setText("");
        text.setEditable(false);
        h.pack();
        h.show();
    }

    private void setDate() {
        if (!(this.con instanceof FtpConnection) && !(this.con instanceof FilesystemConnection)) {
            try {
                this.sorter.removeItem("Date");
            }
            catch (Exception ex) {
                // empty catch block
            }
            this.dateEnabled = false;
            return;
        }
        if (this.con instanceof FtpConnection && ((FtpConnection)this.con).dateVector.size() > 0) {
            if (!this.dateEnabled) {
                this.sorter.addItem("Date");
                this.dateEnabled = true;
                UpdateDaemon.updateRemoteDirGUI();
            }
        } else if (this.con instanceof FilesystemConnection && ((FilesystemConnection)this.con).dateVector.size() > 0) {
            if (!this.dateEnabled) {
                this.sorter.addItem("Date");
                this.dateEnabled = true;
                UpdateDaemon.updateRemoteDirGUI();
            }
        } else if (this.dateEnabled) {
            try {
                this.sorter.removeItem("Date");
                this.dateEnabled = false;
                Settings.showDateNoSize = false;
                UpdateDaemon.updateRemoteDirGUI();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    public void updateRemoteDirectory(BasicConnection c) {
        if (this.con == null) {
            return;
        }
        if (!(c == this.con || !(this.con instanceof FtpConnection) || c instanceof FtpConnection && ((FtpConnection)c).hasUploaded)) {
            return;
        }
        this.setDate();
        this.path = this.con instanceof FtpConnection ? ((FtpConnection)this.con).getCachedPWD() : (this.con instanceof SmbConnection && !this.path.startsWith("smb://") ? c.getPWD() : this.con.getPWD());
        if (c != null && c instanceof FtpConnection) {
            FtpConnection con = (FtpConnection)c;
            String tmp = con.getCachedPWD();
            SaveSet s = new SaveSet(Settings.login_def, con.getHost(), con.getUsername(), con.getPassword(), Integer.toString(con.getPort()), tmp, con.getLocalPath());
        } else if (c != null && c instanceof FilesystemConnection) {
            JFtp.localDir.getCon().setLocalPath(this.path);
        }
        this.pathChanged = true;
        this.gui(false);
        UpdateDaemon.updateLog();
    }

    public synchronized void transfer() {
        int i;
        boolean[] bFileSelected = new boolean[this.dirEntry.length + 1];
        DirEntry[] cacheEntry = new DirEntry[this.dirEntry.length];
        System.arraycopy(this.dirEntry, 0, cacheEntry, 0, cacheEntry.length);
        for (i = 0; i < this.dirEntry.length; ++i) {
            bFileSelected[i] = cacheEntry[i].selected;
            if (cacheEntry[i].equals(this.dirEntry[i])) continue;
            Log.out("mismatch");
        }
        for (i = 0; i < cacheEntry.length; ++i) {
            if (!bFileSelected[i]) continue;
            this.startTransfer(cacheEntry[i]);
        }
    }

    public void startTransfer(DirEntry entry) {
        if (this.con instanceof FtpConnection && JFtp.localDir.getCon() instanceof FtpConnection) {
            if (entry.isDirectory()) {
                Log.debug("Directory transfer between remote connections is not supported yet!");
                return;
            }
            Log.out("direct ftp transfer started (download)");
            ((FtpConnection)JFtp.localDir.getCon()).upload(entry.file, ((FtpConnection)JFtp.remoteDir.getCon()).getDownloadInputStream(this.path + entry.file));
        } else if (this.con instanceof FtpConnection && JFtp.localDir.getCon() instanceof FilesystemConnection) {
            int status = this.checkForExistingFile(entry);
            if (status >= 0) {
                long s = entry.getRawSize();
                JFtp.dList.sizeCache.put(entry.file, new Long(s));
                if (entry.getRawSize() < (long)Settings.smallSize && !entry.isDirectory()) {
                    this.con.download(entry.file);
                } else {
                    this.con.handleDownload(this.path + entry.file);
                }
            }
        } else if (this.con instanceof FilesystemConnection && JFtp.localDir.getCon() instanceof FtpConnection) {
            try {
                File f = new File(this.path + entry.file);
                FileInputStream in = new FileInputStream(f);
                JFtp.localDir.getCon().setLocalPath(this.path);
                Log.debug(JFtp.localDir.getCon().getPWD());
                ((FtpConnection)JFtp.localDir.getCon()).upload(entry.file, in);
            }
            catch (FileNotFoundException ex) {
                Log.debug("Error: File not found: " + this.path + entry.file);
            }
        } else if (this.con instanceof FilesystemConnection && JFtp.localDir.getCon() instanceof FilesystemConnection) {
            this.con.download(this.path + entry.file);
            JFtp.localDir.actionPerformed(this.con, "");
        } else if (JFtp.localDir.getCon() instanceof FilesystemConnection) {
            this.con.handleDownload(entry.file);
            JFtp.localDir.actionPerformed(this.con, "");
        } else {
            if (entry.isDirectory()) {
                Log.debug("Directory transfer between remote connections is not supported yet!");
                return;
            }
            Log.out("direct transfer started (download)");
            JFtp.localDir.getCon().upload(entry.file, JFtp.remoteDir.getCon().getDownloadInputStream(this.path + entry.file));
            JFtp.localDir.actionPerformed(this.con, "FRESH");
        }
    }

    public void transfer(int i) {
        if (i == -2) {
            this.transfer();
            return;
        }
        if (this.dirEntry[i].selected) {
            this.startTransfer(this.dirEntry[i]);
        }
    }

    private int checkForExistingFile(DirEntry dirEntry) {
        File f = new File(JFtp.localDir.getPath() + dirEntry.file);
        if (f.exists() && Settings.enableResuming && Settings.askToResume) {
            ResumeDialog r = new ResumeDialog(dirEntry);
            return -1;
        }
        return 1;
    }

    @Override
    public void actionFinished(BasicConnection c) {
        JFtp.localDir.actionPerformed(c, "LOWFRESH");
        if (c instanceof FtpConnection) {
            if (((FtpConnection)c).hasUploaded) {
                Log.out("actionFinished called by upload: " + c);
                UpdateDaemon.updateRemoteDir();
            }
            Log.out("actionFinished called by download: " + c);
        } else {
            Log.out("actionFinished called by: " + c);
            UpdateDaemon.updateRemoteDir();
        }
        UpdateDaemon.updateLog();
    }

    @Override
    public void actionPerformed(Object target, String msg) {
        if (msg.equals(this.type)) {
            UpdateDaemon.updateRemoteDirGUI();
        } else if (msg.equals("FRESH")) {
            UpdateDaemon.updateRemoteDir();
        }
        UpdateDaemon.updateLog();
    }

    public void showContentWindow(String url, DirEntry d) {
        try {
            if (d.getRawSize() > 200000L) {
                Log.debug("File is too big - 200kb is the maximum, sorry.");
                return;
            }
            String path = JFtp.localDir.getPath();
            if (!path.endsWith("/")) {
                path = path + "/";
            }
            File file = new File(path + StringUtils.getFile(url));
            if (!(this.con instanceof FilesystemConnection)) {
                if (file.exists()) {
                    Log.debug("\nRemote file must be downloaded to be viewed and\n you already have a local copy present, pleasen rename it\n and try again.");
                    return;
                }
                this.con.download(url);
                file = new File(JFtp.localDir.getPath() + StringUtils.getFile(url));
                if (!file.exists()) {
                    Log.debug("File not found: " + JFtp.localDir.getPath() + StringUtils.getFile(url));
                }
            } else {
                file = new File(this.getPath() + StringUtils.getFile(url));
            }
            HFrame f = new HFrame();
            f.setTitle(url);
            String fileUrl = "file://" + (file.getAbsolutePath().startsWith("/") ? file.getAbsolutePath() : "/" + file.getAbsolutePath());
            System.out.println(fileUrl);
            JEditorPane pane = new JEditorPane(fileUrl);
            if (!pane.getEditorKit().getContentType().equals("text/html") && !pane.getEditorKit().getContentType().equals("text/rtf")) {
                if (!pane.getEditorKit().getContentType().equals("text/plain")) {
                    Log.debug("Nothing to do with this filetype - use the buttons if you want to transfer files.");
                    return;
                }
                pane.setEditable(false);
            }
            JScrollPane jsp = new JScrollPane(pane);
            f.getContentPane().setLayout(new BorderLayout());
            f.getContentPane().add("Center", jsp);
            f.setModal(false);
            f.setLocation(100, 100);
            f.setSize(600, 400);
            f.show();
            this.dList.fresh();
            JFtp.localDir.getCon().removeFileOrDir(StringUtils.getFile(url));
            JFtp.localDir.fresh();
        }
        catch (Exception ex) {
            Log.debug("File error: " + ex);
        }
    }

    @Override
    public void keyPressed(KeyEvent e) {
        if (e.getKeyCode() == 10) {
            Object o = this.jl.getSelectedValue();
            if (o == null) {
                return;
            }
            String tmp = ((DirEntry)o).toString();
            if (tmp.endsWith("/")) {
                this.con.chdir(tmp);
            } else {
                this.showContentWindow(this.path + tmp, (DirEntry)o);
            }
        } else if (e.getKeyCode() == 32) {
            int x = ((DirPanel)JFtp.localDir).jl.getSelectedIndex();
            if (x == -1) {
                x = 0;
            }
            ((DirPanel)JFtp.localDir).jl.grabFocus();
            ((DirPanel)JFtp.localDir).jl.setSelectedIndex(x);
        }
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }
}

