/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jftp.gui.base;

import java.awt.BorderLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JTextArea;
import net.sf.jftp.JFtp;
import net.sf.jftp.config.Settings;
import net.sf.jftp.gui.base.dir.DirEntry;
import net.sf.jftp.gui.framework.HFrame;
import net.sf.jftp.gui.framework.HPanel;

public class ResumeDialog
extends HFrame
implements ActionListener {
    private JButton resume = new JButton("Resume");
    private JButton skip = new JButton("Skip");
    private JButton over = new JButton("Overwrite");
    private DirEntry dirEntry = null;

    public ResumeDialog(DirEntry dirEntry) {
        this.dirEntry = dirEntry;
        this.setLocation(150, 150);
        this.setTitle("Question");
        this.resume.setEnabled(false);
        JTextArea text = new JTextArea();
        text.append("A file named " + dirEntry.file + " already exists.                       \n\n");
        File f = new File(JFtp.localDir.getPath() + dirEntry.file);
        long diff = 0L;
        diff = dirEntry.getRawSize() - f.length();
        if (diff == 0L) {
            text.append("It has exactly the same size as the remote file.\n\n");
        } else if (diff < 0L) {
            text.append("It is bigger than the remote file.\n\n");
        } else {
            text.append("It is smaller than the remote file.\n\n");
            this.resume.setEnabled(true);
        }
        this.getContentPane().setLayout(new BorderLayout(5, 5));
        this.getContentPane().add("Center", text);
        HPanel p = new HPanel();
        p.add(this.resume);
        p.add(this.skip);
        p.add(this.over);
        this.getContentPane().add("South", p);
        this.resume.addActionListener(this);
        this.skip.addActionListener(this);
        this.over.addActionListener(this);
        this.pack();
        this.fixLocation();
        this.setVisible(true);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.resume) {
            this.dispose();
            this.transfer();
        } else if (e.getSource() == this.skip) {
            this.dispose();
        } else if (e.getSource() == this.over) {
            this.dispose();
            File f = new File(JFtp.localDir.getPath() + this.dirEntry.file);
            f.delete();
            this.transfer();
        }
    }

    private void transfer() {
        if (this.dirEntry.getRawSize() < (long)Settings.smallSize && !this.dirEntry.isDirectory()) {
            JFtp.remoteDir.getCon().download(this.dirEntry.file);
        } else {
            JFtp.remoteDir.getCon().handleDownload(this.dirEntry.file);
        }
    }
}

