/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jftp.gui.base;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import net.sf.jftp.JFtp;
import net.sf.jftp.config.Settings;
import net.sf.jftp.gui.base.StatusCanvas;
import net.sf.jftp.gui.base.dir.Dir;
import net.sf.jftp.gui.framework.GUIDefaults;
import net.sf.jftp.gui.framework.HImageButton;
import net.sf.jftp.gui.framework.HPanel;
import net.sf.jftp.gui.hostchooser.HostChooser;
import net.sf.jftp.gui.hostchooser.NfsHostChooser;
import net.sf.jftp.gui.hostchooser.SftpHostChooser;
import net.sf.jftp.gui.hostchooser.SmbHostChooser;
import net.sf.jftp.gui.hostchooser.WebdavHostChooser;
import net.sf.jftp.gui.tasks.HttpBrowser;
import net.sf.jftp.gui.tasks.NativeHttpBrowser;
import net.sf.jftp.net.ConnectionHandler;
import net.sf.jftp.net.wrappers.HttpTransfer;
import net.sf.jftp.system.logging.Log;

public class StatusPanel
extends HPanel
implements ActionListener {
    public static StatusCanvas status = new StatusCanvas();
    private HImageButton newcon = new HImageButton(Settings.hostImage, "newcon", "Add FTP Connection...", this);
    private HImageButton smbcon = new HImageButton(Settings.openImage, "smbcon", "Add SMB Connection...", this);
    private HImageButton sftpcon = new HImageButton(Settings.sftpImage, "sftpcon", "Add SFTP Connection...", this);
    private HImageButton nfscon = new HImageButton(Settings.nfsImage, "nfscon", "Add NFS Connection...", this);
    private HImageButton webdavcon = new HImageButton(Settings.webdavImage, "webdavcon", "Add WebDAV Connection...", this);
    public HImageButton close = new HImageButton(Settings.closeImage, "close", "Close active tab...", this);
    private HImageButton go = new HImageButton(Settings.refreshImage, "go", "Download URL now...", this);
    private JTextField address = new JTextField("http://www.xkcd.com", 30);
    public JFtp jftp;

    public StatusPanel(JFtp jftp) {
        this.jftp = jftp;
        this.setLayout(new BorderLayout());
        JToolBar bar = new JToolBar();
        Insets in = bar.getMargin();
        bar.setMargin(new Insets(in.top + 2, in.left + 4, in.bottom + 2, in.right + 4));
        bar.add(this.newcon);
        this.newcon.setSize(24, 24);
        this.newcon.setToolTipText("New FTP Connection...");
        bar.add(new JLabel(" "));
        bar.add(this.smbcon);
        this.smbcon.setSize(24, 24);
        this.smbcon.setToolTipText("New SMB Connection...");
        bar.add(new JLabel(" "));
        bar.add(this.sftpcon);
        this.sftpcon.setSize(24, 24);
        this.sftpcon.setToolTipText("New SFTP Connection...");
        bar.add(new JLabel(" "));
        bar.add(this.nfscon);
        this.nfscon.setSize(24, 24);
        this.nfscon.setToolTipText("New NFS Connection...");
        bar.add(new JLabel(" "));
        if (Settings.enableWebDav) {
            bar.add(this.webdavcon);
        }
        this.webdavcon.setSize(24, 24);
        this.webdavcon.setToolTipText("New WebDAV Connection...");
        bar.add(new JLabel("   "));
        bar.add(this.close);
        this.close.setSize(24, 24);
        this.close.setToolTipText("Close Active Remote tab...");
        bar.add(new JLabel("    "));
        this.address.addActionListener(this);
        bar.add(new JLabel("URL: "));
        bar.add(this.address);
        bar.add(new JLabel(" "));
        bar.add(this.go);
        this.go.setToolTipText("Download URL Now...");
        bar.add(new JLabel("    "));
        this.add("North", bar);
        this.validate();
        this.setFont(GUIDefaults.menuFont);
        this.setVisible(true);
    }

    public void status(String msg) {
        status.setText(msg);
    }

    public String getHost() {
        return status.getHost();
    }

    public void setHost(String host) {
        status.setHost(host);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand().equals("go") || e.getSource() == this.address) {
            Vector<Dir> listeners = new Vector<Dir>();
            listeners.add(JFtp.localDir);
            String url = this.address.getText().trim();
            this.startTransfer(url, JFtp.localDir.getPath(), listeners, JFtp.getConnectionHandler());
        } else if (e.getActionCommand().equals("smbcon")) {
            SmbHostChooser hc = new SmbHostChooser();
            hc.toFront();
            hc.update();
        } else if (e.getActionCommand().equals("sftpcon")) {
            SftpHostChooser hc = new SftpHostChooser();
            hc.toFront();
            hc.update();
        } else if (e.getActionCommand().equals("nfscon")) {
            NfsHostChooser hc = new NfsHostChooser();
            hc.toFront();
            hc.update();
        } else if (e.getActionCommand().equals("webdavcon")) {
            WebdavHostChooser hc = new WebdavHostChooser();
            hc.toFront();
            hc.update();
        } else if (e.getActionCommand().equals("close")) {
            this.jftp.closeCurrentTab();
        } else if (e.getActionCommand().equals("newcon")) {
            if (!JFtp.uiBlocked) {
                HostChooser hc = new HostChooser();
                hc.toFront();
                hc.update();
            }
        }
    }

    public void startTransfer(String url, String localPath, Vector listeners, ConnectionHandler handler) {
        if (url.startsWith("ftp://") && (url.endsWith("/") || url.lastIndexOf("/") < 10)) {
            StatusPanel statusPanel = this;
            statusPanel.jftp.safeDisconnect();
            HostChooser hc = new HostChooser();
            hc.update(url);
        } else if (url.startsWith("http://") && (url.endsWith("/") || url.lastIndexOf("/") < 10)) {
            try {
                NativeHttpBrowser.main(new String[]{url});
            }
            catch (Throwable ex) {
                ex.printStackTrace();
                Log.debug("Native browser intialization failed, using JContentPane...");
                HttpBrowser h = new HttpBrowser(url);
                JFtp.desktop.add((Component)h, new Integer(0x7FFFFFF5));
            }
        } else {
            HttpTransfer t = new HttpTransfer(url, localPath, listeners, handler);
        }
    }

    @Override
    public Insets getInsets() {
        Insets in = super.getInsets();
        return new Insets(in.top, in.left, in.bottom, in.right);
    }
}

